/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.JobConfigurationExtract;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.TableId;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class ExtractJobConfiguration
extends JobConfiguration {
    private static final long serialVersionUID = 4147749733166593761L;
    private final TableId sourceTable;
    private final List<String> destinationUris;
    private final Boolean printHeader;
    private final String fieldDelimiter;
    private final String format;
    private final String compression;
    private final Boolean useAvroLogicalTypes;
    private final Map<String, String> labels;
    private final Long jobTimeoutMs;

    private ExtractJobConfiguration(Builder builder) {
        super(builder);
        this.sourceTable = (TableId)Preconditions.checkNotNull((Object)builder.sourceTable);
        this.destinationUris = (List)Preconditions.checkNotNull((Object)builder.destinationUris);
        this.printHeader = builder.printHeader;
        this.fieldDelimiter = builder.fieldDelimiter;
        this.format = builder.format;
        this.compression = builder.compression;
        this.useAvroLogicalTypes = builder.useAvroLogicalTypes;
        this.labels = builder.labels;
        this.jobTimeoutMs = builder.jobTimeoutMs;
    }

    public TableId getSourceTable() {
        return this.sourceTable;
    }

    public List<String> getDestinationUris() {
        return this.destinationUris;
    }

    public Boolean printHeader() {
        return this.printHeader;
    }

    public String getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public String getFormat() {
        return this.format;
    }

    public String getCompression() {
        return this.compression;
    }

    public Boolean getUseAvroLogicalTypes() {
        return this.useAvroLogicalTypes;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Long getJobTimeoutMs() {
        return this.jobTimeoutMs;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("sourceTable", (Object)this.sourceTable).add("destinationUris", this.destinationUris).add("format", (Object)this.format).add("printHeader", (Object)this.printHeader).add("fieldDelimiter", (Object)this.fieldDelimiter).add("compression", (Object)this.compression).add("useAvroLogicalTypes", (Object)this.useAvroLogicalTypes).add("labels", this.labels).add("jobTimeoutMs", (Object)this.jobTimeoutMs);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof ExtractJobConfiguration && this.baseEquals((ExtractJobConfiguration)obj);
    }

    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.sourceTable, this.destinationUris, this.printHeader, this.fieldDelimiter, this.format, this.compression, this.useAvroLogicalTypes, this.labels, this.jobTimeoutMs);
    }

    @Override
    ExtractJobConfiguration setProjectId(String projectId) {
        if (Strings.isNullOrEmpty((String)this.getSourceTable().getProject())) {
            return this.toBuilder().setSourceTable(this.getSourceTable().setProjectId(projectId)).build();
        }
        return this;
    }

    @Override
    com.google.api.services.bigquery.model.JobConfiguration toPb() {
        JobConfigurationExtract extractConfigurationPb = new JobConfigurationExtract();
        com.google.api.services.bigquery.model.JobConfiguration jobConfiguration = new com.google.api.services.bigquery.model.JobConfiguration();
        extractConfigurationPb.setDestinationUris(this.destinationUris);
        extractConfigurationPb.setSourceTable(this.sourceTable.toPb());
        extractConfigurationPb.setPrintHeader(this.printHeader);
        extractConfigurationPb.setFieldDelimiter(this.fieldDelimiter);
        extractConfigurationPb.setDestinationFormat(this.format);
        extractConfigurationPb.setCompression(this.compression);
        extractConfigurationPb.setUseAvroLogicalTypes(this.useAvroLogicalTypes);
        if (this.labels != null) {
            jobConfiguration.setLabels(this.labels);
        }
        if (this.jobTimeoutMs != null) {
            jobConfiguration.setJobTimeoutMs(this.jobTimeoutMs);
        }
        jobConfiguration.setExtract(extractConfigurationPb);
        return jobConfiguration;
    }

    public static Builder newBuilder(TableId sourceTable, String destinationUri) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)destinationUri) ? 1 : 0) != 0, (Object)"Provided destinationUri is null or empty");
        return ExtractJobConfiguration.newBuilder(sourceTable, (List<String>)ImmutableList.of((Object)destinationUri));
    }

    public static Builder newBuilder(TableId sourceTable, List<String> destinationUris) {
        return new Builder().setSourceTable(sourceTable).setDestinationUris(destinationUris);
    }

    public static ExtractJobConfiguration of(TableId sourceTable, String destinationUri) {
        return ExtractJobConfiguration.newBuilder(sourceTable, destinationUri).build();
    }

    public static ExtractJobConfiguration of(TableId sourceTable, List<String> destinationUris) {
        return ExtractJobConfiguration.newBuilder(sourceTable, destinationUris).build();
    }

    public static ExtractJobConfiguration of(TableId sourceTable, String destinationUri, String format) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)format) ? 1 : 0) != 0, (Object)"Provided format is null or empty");
        return ExtractJobConfiguration.newBuilder(sourceTable, destinationUri).setFormat(format).build();
    }

    public static ExtractJobConfiguration of(TableId sourceTable, List<String> destinationUris, String format) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)format) ? 1 : 0) != 0, (Object)"Provided format is null or empty");
        return ExtractJobConfiguration.newBuilder(sourceTable, destinationUris).setFormat(format).build();
    }

    static ExtractJobConfiguration fromPb(com.google.api.services.bigquery.model.JobConfiguration confPb) {
        return new Builder(confPb).build();
    }

    public static final class Builder
    extends JobConfiguration.Builder<ExtractJobConfiguration, Builder> {
        private TableId sourceTable;
        private List<String> destinationUris;
        private Boolean printHeader;
        private String fieldDelimiter;
        private String format;
        private String compression;
        private Boolean useAvroLogicalTypes;
        private Map<String, String> labels;
        private Long jobTimeoutMs;

        private Builder() {
            super(JobConfiguration.Type.EXTRACT);
        }

        private Builder(ExtractJobConfiguration jobInfo) {
            this();
            this.sourceTable = jobInfo.sourceTable;
            this.destinationUris = jobInfo.destinationUris;
            this.printHeader = jobInfo.printHeader;
            this.fieldDelimiter = jobInfo.fieldDelimiter;
            this.format = jobInfo.format;
            this.compression = jobInfo.compression;
            this.useAvroLogicalTypes = jobInfo.useAvroLogicalTypes;
            this.labels = jobInfo.labels;
            this.jobTimeoutMs = jobInfo.jobTimeoutMs;
        }

        private Builder(com.google.api.services.bigquery.model.JobConfiguration configurationPb) {
            this();
            JobConfigurationExtract extractConfigurationPb = configurationPb.getExtract();
            this.sourceTable = TableId.fromPb(extractConfigurationPb.getSourceTable());
            this.destinationUris = extractConfigurationPb.getDestinationUris();
            this.printHeader = extractConfigurationPb.getPrintHeader();
            this.fieldDelimiter = extractConfigurationPb.getFieldDelimiter();
            this.format = extractConfigurationPb.getDestinationFormat();
            this.compression = extractConfigurationPb.getCompression();
            this.useAvroLogicalTypes = extractConfigurationPb.getUseAvroLogicalTypes();
            if (configurationPb.getLabels() != null) {
                this.labels = configurationPb.getLabels();
            }
            if (configurationPb.getJobTimeoutMs() != null) {
                this.jobTimeoutMs = configurationPb.getJobTimeoutMs();
            }
        }

        public Builder setSourceTable(TableId sourceTable) {
            this.sourceTable = sourceTable;
            return this;
        }

        public Builder setDestinationUris(List<String> destinationUris) {
            this.destinationUris = destinationUris != null ? ImmutableList.copyOf(destinationUris) : null;
            return this;
        }

        public Builder setPrintHeader(Boolean printHeader) {
            this.printHeader = printHeader;
            return this;
        }

        public Builder setFieldDelimiter(String fieldDelimiter) {
            this.fieldDelimiter = fieldDelimiter;
            return this;
        }

        public Builder setFormat(String format) {
            this.format = format;
            return this;
        }

        public Builder setCompression(String compression) {
            this.compression = compression;
            return this;
        }

        public Builder setUseAvroLogicalTypes(Boolean useAvroLogicalTypes) {
            this.useAvroLogicalTypes = useAvroLogicalTypes;
            return this;
        }

        public Builder setLabels(Map<String, String> labels) {
            this.labels = labels;
            return this;
        }

        public Builder setJobTimeoutMs(Long jobTimeoutMs) {
            this.jobTimeoutMs = jobTimeoutMs;
            return this;
        }

        @Override
        public ExtractJobConfiguration build() {
            return new ExtractJobConfiguration(this);
        }
    }
}

