package com.google.cloud.bigquery;

import com.google.common.collect.ImmutableList;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ViewDefinition extends ViewDefinition {

  private final TableDefinition.Type type;

  private final Schema schema;

  private final String query;

  private final ImmutableList<UserDefinedFunction> userDefinedFunctionsImmut;

  private final Boolean useLegacySql;

  private AutoValue_ViewDefinition(
      TableDefinition.Type type,
      @Nullable Schema schema,
      @Nullable String query,
      @Nullable ImmutableList<UserDefinedFunction> userDefinedFunctionsImmut,
      @Nullable Boolean useLegacySql) {
    this.type = type;
    this.schema = schema;
    this.query = query;
    this.userDefinedFunctionsImmut = userDefinedFunctionsImmut;
    this.useLegacySql = useLegacySql;
  }

  @Override
  public TableDefinition.Type getType() {
    return type;
  }

  @Nullable
  @Override
  public Schema getSchema() {
    return schema;
  }

  @Nullable
  @Override
  public String getQuery() {
    return query;
  }

  @Nullable
  @Override
  ImmutableList<UserDefinedFunction> getUserDefinedFunctionsImmut() {
    return userDefinedFunctionsImmut;
  }

  @Nullable
  @Override
  Boolean getUseLegacySql() {
    return useLegacySql;
  }

  @Override
  public String toString() {
    return "ViewDefinition{"
         + "type=" + type + ", "
         + "schema=" + schema + ", "
         + "query=" + query + ", "
         + "userDefinedFunctionsImmut=" + userDefinedFunctionsImmut + ", "
         + "useLegacySql=" + useLegacySql
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ViewDefinition) {
      ViewDefinition that = (ViewDefinition) o;
      return this.type.equals(that.getType())
          && (this.schema == null ? that.getSchema() == null : this.schema.equals(that.getSchema()))
          && (this.query == null ? that.getQuery() == null : this.query.equals(that.getQuery()))
          && (this.userDefinedFunctionsImmut == null ? that.getUserDefinedFunctionsImmut() == null : this.userDefinedFunctionsImmut.equals(that.getUserDefinedFunctionsImmut()))
          && (this.useLegacySql == null ? that.getUseLegacySql() == null : this.useLegacySql.equals(that.getUseLegacySql()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= (schema == null) ? 0 : schema.hashCode();
    h$ *= 1000003;
    h$ ^= (query == null) ? 0 : query.hashCode();
    h$ *= 1000003;
    h$ ^= (userDefinedFunctionsImmut == null) ? 0 : userDefinedFunctionsImmut.hashCode();
    h$ *= 1000003;
    h$ ^= (useLegacySql == null) ? 0 : useLegacySql.hashCode();
    return h$;
  }

  private static final long serialVersionUID = -8789311196910794545L;

  @Override
  public ViewDefinition.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends ViewDefinition.Builder {
    private TableDefinition.Type type;
    private Schema schema;
    private String query;
    private ImmutableList<UserDefinedFunction> userDefinedFunctionsImmut;
    private Boolean useLegacySql;
    Builder() {
    }
    private Builder(ViewDefinition source) {
      this.type = source.getType();
      this.schema = source.getSchema();
      this.query = source.getQuery();
      this.userDefinedFunctionsImmut = source.getUserDefinedFunctionsImmut();
      this.useLegacySql = source.getUseLegacySql();
    }
    @Override
    public ViewDefinition.Builder setType(TableDefinition.Type type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public ViewDefinition.Builder setSchema(Schema schema) {
      this.schema = schema;
      return this;
    }
    @Override
    public ViewDefinition.Builder setQuery(String query) {
      this.query = query;
      return this;
    }
    @Override
    ViewDefinition.Builder setUserDefinedFunctionsImmut(ImmutableList<UserDefinedFunction> userDefinedFunctionsImmut) {
      this.userDefinedFunctionsImmut = userDefinedFunctionsImmut;
      return this;
    }
    @Override
    public ViewDefinition.Builder setUseLegacySql(Boolean useLegacySql) {
      this.useLegacySql = useLegacySql;
      return this;
    }
    @Override
    public ViewDefinition build() {
      String missing = "";
      if (this.type == null) {
        missing += " type";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ViewDefinition(
          this.type,
          this.schema,
          this.query,
          this.userDefinedFunctionsImmut,
          this.useLegacySql);
    }
  }

}
