package com.google.cloud.bigquery;

import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_StandardSQLField extends StandardSQLField {

  private final String name;

  private final StandardSQLDataType dataType;

  private AutoValue_StandardSQLField(
      @Nullable String name,
      StandardSQLDataType dataType) {
    this.name = name;
    this.dataType = dataType;
  }

  @Nullable
  @Override
  public String getName() {
    return name;
  }

  @Override
  public StandardSQLDataType getDataType() {
    return dataType;
  }

  @Override
  public String toString() {
    return "StandardSQLField{"
         + "name=" + name + ", "
         + "dataType=" + dataType
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof StandardSQLField) {
      StandardSQLField that = (StandardSQLField) o;
      return (this.name == null ? that.getName() == null : this.name.equals(that.getName()))
          && this.dataType.equals(that.getDataType());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (name == null) ? 0 : name.hashCode();
    h$ *= 1000003;
    h$ ^= dataType.hashCode();
    return h$;
  }

  @Override
  public StandardSQLField.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends StandardSQLField.Builder {
    private String name;
    private StandardSQLDataType dataType;
    Builder() {
    }
    private Builder(StandardSQLField source) {
      this.name = source.getName();
      this.dataType = source.getDataType();
    }
    @Override
    public StandardSQLField.Builder setName(String name) {
      this.name = name;
      return this;
    }
    @Override
    public StandardSQLField.Builder setDataType(StandardSQLDataType dataType) {
      if (dataType == null) {
        throw new NullPointerException("Null dataType");
      }
      this.dataType = dataType;
      return this;
    }
    @Override
    public StandardSQLField build() {
      String missing = "";
      if (this.dataType == null) {
        missing += " dataType";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_StandardSQLField(
          this.name,
          this.dataType);
    }
  }

}
