/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.client.util.Data;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.BaseEncoding;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FieldValue
implements Serializable {
    static final Function<Object, FieldValue> FROM_PB_FUNCTION = new Function<Object, FieldValue>(){

        public FieldValue apply(Object pb) {
            return FieldValue.fromPb(pb);
        }
    };
    private static final int MICROSECONDS = 1000000;
    private static final long serialVersionUID = 469098630191710061L;
    private final Attribute attribute;
    private final Object value;

    FieldValue(Attribute attribute, Object value) {
        this.attribute = attribute;
        this.value = value;
    }

    @Deprecated
    public Attribute attribute() {
        return this.getAttribute();
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public boolean isNull() {
        return this.value == null;
    }

    @Deprecated
    public Object value() {
        return this.getValue();
    }

    public Object getValue() {
        return this.value;
    }

    @Deprecated
    public String stringValue() {
        return this.getStringValue();
    }

    public String getStringValue() {
        Preconditions.checkNotNull((Object)this.value);
        return (String)this.value;
    }

    @Deprecated
    public byte[] bytesValue() {
        return this.getBytesValue();
    }

    public byte[] getBytesValue() {
        try {
            return BaseEncoding.base64().decode((CharSequence)this.getStringValue());
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Deprecated
    public long longValue() {
        return this.getLongValue();
    }

    public long getLongValue() {
        return Long.parseLong(this.getStringValue());
    }

    @Deprecated
    public double doubleValue() {
        return this.getDoubleValue();
    }

    public double getDoubleValue() {
        return Double.parseDouble(this.getStringValue());
    }

    @Deprecated
    public boolean booleanValue() {
        return this.getBooleanValue();
    }

    public boolean getBooleanValue() {
        String stringValue = this.getStringValue();
        Preconditions.checkState((stringValue.equalsIgnoreCase("true") || stringValue.equalsIgnoreCase("false") ? 1 : 0) != 0, (Object)"Field value is not of boolean type");
        return Boolean.parseBoolean(stringValue);
    }

    @Deprecated
    public long timestampValue() {
        return this.getTimestampValue();
    }

    public long getTimestampValue() {
        return new Double(Double.valueOf(this.getStringValue()) * 1000000.0).longValue();
    }

    @Deprecated
    public List<FieldValue> repeatedValue() {
        return this.getRepeatedValue();
    }

    public List<FieldValue> getRepeatedValue() {
        Preconditions.checkNotNull((Object)this.value);
        return (List)this.value;
    }

    @Deprecated
    public List<FieldValue> recordValue() {
        return this.getRecordValue();
    }

    public List<FieldValue> getRecordValue() {
        Preconditions.checkNotNull((Object)this.value);
        return (List)this.value;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("attribute", (Object)this.attribute).add("value", this.value).toString();
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.attribute, this.value});
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(FieldValue.class)) {
            return false;
        }
        FieldValue other = (FieldValue)obj;
        return this.attribute == other.attribute && Objects.equals(this.value, other.value);
    }

    static FieldValue fromPb(Object cellPb) {
        if (Data.isNull((Object)cellPb)) {
            return new FieldValue(Attribute.PRIMITIVE, null);
        }
        if (cellPb instanceof String) {
            return new FieldValue(Attribute.PRIMITIVE, cellPb);
        }
        if (cellPb instanceof List) {
            List cellsListPb = (List)cellPb;
            ArrayList repeatedCells = Lists.newArrayListWithCapacity((int)cellsListPb.size());
            for (Object repeatedCellPb : cellsListPb) {
                repeatedCells.add(FieldValue.fromPb(repeatedCellPb));
            }
            return new FieldValue(Attribute.REPEATED, repeatedCells);
        }
        if (cellPb instanceof Map) {
            Map cellMapPb = (Map)cellPb;
            if (cellMapPb.containsKey("f")) {
                List cellsListPb = (List)cellMapPb.get("f");
                ArrayList recordCells = Lists.newArrayListWithCapacity((int)cellsListPb.size());
                for (Object repeatedCellPb : cellsListPb) {
                    recordCells.add(FieldValue.fromPb(repeatedCellPb));
                }
                return new FieldValue(Attribute.RECORD, recordCells);
            }
            if (cellMapPb.containsKey("v")) {
                return FieldValue.fromPb(cellMapPb.get("v"));
            }
        }
        throw new AssertionError((Object)"Unexpected table cell format");
    }

    public static enum Attribute {
        PRIMITIVE,
        REPEATED,
        RECORD;

    }
}

