/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.ExplainQueryStage;
import com.google.api.services.bigquery.model.ExplainQueryStep;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class QueryStage
implements Serializable {
    static final Function<ExplainQueryStage, QueryStage> FROM_PB_FUNCTION = new Function<ExplainQueryStage, QueryStage>(){

        public QueryStage apply(ExplainQueryStage pb) {
            return QueryStage.fromPb(pb);
        }
    };
    static final Function<QueryStage, ExplainQueryStage> TO_PB_FUNCTION = new Function<QueryStage, ExplainQueryStage>(){

        public ExplainQueryStage apply(QueryStage stage) {
            return stage.toPb();
        }
    };
    private static final long serialVersionUID = -472281297327952320L;
    private final double computeRatioAvg;
    private final double computeRatioMax;
    private final long generatedId;
    private final String name;
    private final double readRatioAvg;
    private final double readRatioMax;
    private final long recordsRead;
    private final long recordsWritten;
    private final List<QueryStep> steps;
    private final double waitRatioAvg;
    private final double waitRatioMax;
    private final double writeRatioAvg;
    private final double writeRatioMax;

    QueryStage(Builder builder) {
        this.computeRatioAvg = builder.computeRatioAvg;
        this.computeRatioMax = builder.computeRatioMax;
        this.generatedId = builder.generatedId;
        this.name = builder.name;
        this.readRatioAvg = builder.readRatioAvg;
        this.readRatioMax = builder.readRatioMax;
        this.recordsRead = builder.recordsRead;
        this.recordsWritten = builder.recordsWritten;
        this.steps = builder.steps;
        this.waitRatioAvg = builder.waitRatioAvg;
        this.waitRatioMax = builder.waitRatioMax;
        this.writeRatioAvg = builder.writeRatioAvg;
        this.writeRatioMax = builder.writeRatioMax;
    }

    @Deprecated
    public double computeRatioAvg() {
        return this.getComputeRatioAvg();
    }

    public double getComputeRatioAvg() {
        return this.computeRatioAvg;
    }

    @Deprecated
    public double computeRatioMax() {
        return this.getComputeRatioMax();
    }

    public double getComputeRatioMax() {
        return this.computeRatioMax;
    }

    @Deprecated
    public long generatedId() {
        return this.getGeneratedId();
    }

    public long getGeneratedId() {
        return this.generatedId;
    }

    @Deprecated
    public String name() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public double readRatioAvg() {
        return this.getReadRatioAvg();
    }

    public double getReadRatioAvg() {
        return this.readRatioAvg;
    }

    @Deprecated
    public double readRatioMax() {
        return this.getReadRatioMax();
    }

    public double getReadRatioMax() {
        return this.readRatioMax;
    }

    @Deprecated
    public long recordsRead() {
        return this.getRecordsRead();
    }

    public long getRecordsRead() {
        return this.recordsRead;
    }

    @Deprecated
    public long recordsWritten() {
        return this.getRecordsWritten();
    }

    public long getRecordsWritten() {
        return this.recordsWritten;
    }

    @Deprecated
    public List<QueryStep> steps() {
        return this.getSteps();
    }

    public List<QueryStep> getSteps() {
        return this.steps;
    }

    @Deprecated
    public double waitRatioAvg() {
        return this.getWaitRatioAvg();
    }

    public double getWaitRatioAvg() {
        return this.waitRatioAvg;
    }

    @Deprecated
    public double waitRatioMax() {
        return this.getWaitRatioMax();
    }

    public double getWaitRatioMax() {
        return this.waitRatioMax;
    }

    @Deprecated
    public double writeRatioAvg() {
        return this.getWriteRatioAvg();
    }

    public double getWriteRatioAvg() {
        return this.writeRatioAvg;
    }

    @Deprecated
    public double writeRatioMax() {
        return this.getWriteRatioMax();
    }

    public double getWriteRatioMax() {
        return this.writeRatioMax;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("computeRatioAvg", this.computeRatioAvg).add("computeRatioMax", this.computeRatioMax).add("generatedId", this.generatedId).add("name", (Object)this.name).add("readRatioAvg", this.readRatioAvg).add("readRatioMax", this.readRatioMax).add("recordsRead", this.recordsRead).add("recordsWritten", this.recordsWritten).add("steps", this.steps).add("waitRatioAvg", this.waitRatioAvg).add("waitRatioMax", this.waitRatioMax).add("writeRatioAvg", this.writeRatioAvg).add("writeRatioMax", this.writeRatioMax).toString();
    }

    public final int hashCode() {
        return Objects.hash(this.computeRatioAvg, this.computeRatioMax, this.generatedId, this.name, this.readRatioAvg, this.readRatioMax, this.recordsRead, this.recordsWritten, this.steps, this.waitRatioAvg, this.waitRatioMax, this.writeRatioAvg);
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(QueryStage.class)) {
            return false;
        }
        QueryStage other = (QueryStage)obj;
        return this.generatedId == other.generatedId && this.computeRatioAvg == other.computeRatioAvg && this.computeRatioMax == other.computeRatioMax && this.readRatioAvg == other.readRatioAvg && this.readRatioMax == other.readRatioMax && this.recordsRead == other.recordsRead && this.recordsWritten == other.recordsWritten && this.waitRatioAvg == other.waitRatioAvg && this.waitRatioMax == other.waitRatioMax && this.writeRatioAvg == other.writeRatioAvg && this.writeRatioMax == other.writeRatioMax && Objects.equals(this.steps, other.steps) && Objects.equals(this.name, other.name);
    }

    static Builder newBuilder() {
        return new Builder();
    }

    ExplainQueryStage toPb() {
        ExplainQueryStage stagePb = new ExplainQueryStage().setComputeRatioAvg(Double.valueOf(this.computeRatioAvg)).setComputeRatioMax(Double.valueOf(this.computeRatioMax)).setId(Long.valueOf(this.generatedId)).setName(this.name).setReadRatioAvg(Double.valueOf(this.readRatioAvg)).setReadRatioMax(Double.valueOf(this.readRatioMax)).setRecordsRead(Long.valueOf(this.recordsRead)).setRecordsWritten(Long.valueOf(this.recordsWritten)).setWaitRatioAvg(Double.valueOf(this.waitRatioAvg)).setWaitRatioMax(Double.valueOf(this.waitRatioMax)).setWriteRatioAvg(Double.valueOf(this.writeRatioAvg)).setWriteRatioMax(Double.valueOf(this.writeRatioMax));
        if (this.steps != null) {
            stagePb.setSteps(Lists.transform(this.steps, QueryStep.TO_PB_FUNCTION));
        }
        return stagePb;
    }

    static QueryStage fromPb(ExplainQueryStage stagePb) {
        Builder builder = new Builder();
        builder.setComputeRationAvg(stagePb.getComputeRatioAvg());
        builder.setComputeRatioMax(stagePb.getComputeRatioMax());
        builder.setGeneratedId(stagePb.getId());
        builder.setName(stagePb.getName());
        builder.setReadRatioAvg(stagePb.getReadRatioAvg());
        builder.setReadRatioMax(stagePb.getReadRatioMax());
        builder.setRecordsRead(stagePb.getRecordsRead());
        builder.setRecordsWritten(stagePb.getRecordsWritten());
        if (stagePb.getSteps() != null) {
            builder.setSteps(Lists.transform((List)stagePb.getSteps(), QueryStep.FROM_PB_FUNCTION));
        }
        builder.setWaitRatioAvg(stagePb.getWaitRatioAvg());
        builder.setWaitRatioMax(stagePb.getWaitRatioMax());
        builder.setWriteRatioAvg(stagePb.getWriteRatioAvg());
        builder.setWriteRatioMax(stagePb.getWriteRatioMax());
        return builder.build();
    }

    static final class Builder {
        private double computeRatioAvg;
        private double computeRatioMax;
        private long generatedId;
        private String name;
        private double readRatioAvg;
        private double readRatioMax;
        private long recordsRead;
        private long recordsWritten;
        private List<QueryStep> steps;
        private double waitRatioAvg;
        private double waitRatioMax;
        private double writeRatioAvg;
        private double writeRatioMax;

        private Builder() {
        }

        Builder setComputeRationAvg(double computeRatioAvg) {
            this.computeRatioAvg = computeRatioAvg;
            return this;
        }

        Builder setComputeRatioMax(double computeRatioMax) {
            this.computeRatioMax = computeRatioMax;
            return this;
        }

        Builder setGeneratedId(long generatedId) {
            this.generatedId = generatedId;
            return this;
        }

        Builder setName(String name) {
            this.name = name;
            return this;
        }

        Builder setReadRatioAvg(double readRatioAvg) {
            this.readRatioAvg = readRatioAvg;
            return this;
        }

        Builder setReadRatioMax(double readRatioMax) {
            this.readRatioMax = readRatioMax;
            return this;
        }

        Builder setRecordsRead(long recordsRead) {
            this.recordsRead = recordsRead;
            return this;
        }

        Builder setRecordsWritten(long recordsWritten) {
            this.recordsWritten = recordsWritten;
            return this;
        }

        Builder setSteps(List<QueryStep> steps) {
            this.steps = steps;
            return this;
        }

        Builder setWaitRatioAvg(double waitRatioAvg) {
            this.waitRatioAvg = waitRatioAvg;
            return this;
        }

        Builder setWaitRatioMax(double waitRatioMax) {
            this.waitRatioMax = waitRatioMax;
            return this;
        }

        Builder setWriteRatioAvg(double writeRatioAvg) {
            this.writeRatioAvg = writeRatioAvg;
            return this;
        }

        Builder setWriteRatioMax(double writeRatioMax) {
            this.writeRatioMax = writeRatioMax;
            return this;
        }

        QueryStage build() {
            return new QueryStage(this);
        }
    }

    public static class QueryStep
    implements Serializable {
        static final Function<ExplainQueryStep, QueryStep> FROM_PB_FUNCTION = new Function<ExplainQueryStep, QueryStep>(){

            public QueryStep apply(ExplainQueryStep pb) {
                return QueryStep.fromPb(pb);
            }
        };
        static final Function<QueryStep, ExplainQueryStep> TO_PB_FUNCTION = new Function<QueryStep, ExplainQueryStep>(){

            public ExplainQueryStep apply(QueryStep stage) {
                return stage.toPb();
            }
        };
        private static final long serialVersionUID = 8663444604771794411L;
        private final String name;
        private final List<String> substeps;

        QueryStep(String name, List<String> substeps) {
            this.name = name;
            this.substeps = substeps;
        }

        @Deprecated
        public String name() {
            return this.getName();
        }

        public String getName() {
            return this.name;
        }

        @Deprecated
        public List<String> substeps() {
            return this.getSubsteps();
        }

        public List<String> getSubsteps() {
            return this.substeps;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("substeps", this.substeps).toString();
        }

        public int hashCode() {
            return Objects.hash(this.name, this.substeps);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof QueryStep)) {
                return false;
            }
            QueryStep other = (QueryStep)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.substeps, other.substeps);
        }

        ExplainQueryStep toPb() {
            return new ExplainQueryStep().setKind(this.name).setSubsteps(this.substeps);
        }

        static QueryStep fromPb(ExplainQueryStep stepPb) {
            return new QueryStep(stepPb.getKind(), (List<String>)ImmutableList.copyOf((Collection)(stepPb.getSubsteps() != null ? stepPb.getSubsteps() : ImmutableList.of())));
        }
    }
}

