/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.BigQueryError;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.QueryResult;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class QueryResponse
implements Serializable {
    private static final long serialVersionUID = 3549226764825005655L;
    private final QueryResult result;
    private final String etag;
    private final JobId jobId;
    private final boolean jobCompleted;
    private final List<BigQueryError> executionErrors;

    private QueryResponse(Builder builder) {
        this.result = builder.result;
        this.etag = builder.etag;
        this.jobId = builder.jobId;
        this.jobCompleted = builder.jobCompleted;
        this.executionErrors = builder.executionErrors != null ? builder.executionErrors : ImmutableList.of();
    }

    @Deprecated
    public QueryResult result() {
        return this.getResult();
    }

    public QueryResult getResult() {
        return this.result;
    }

    @Deprecated
    public String etag() {
        return this.getEtag();
    }

    public String getEtag() {
        return this.etag;
    }

    @Deprecated
    public JobId jobId() {
        return this.getJobId();
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public boolean jobCompleted() {
        return this.jobCompleted;
    }

    public boolean hasErrors() {
        return !this.executionErrors.isEmpty();
    }

    @Deprecated
    public List<BigQueryError> executionErrors() {
        return this.getExecutionErrors();
    }

    public List<BigQueryError> getExecutionErrors() {
        return this.executionErrors;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("result", (Object)this.result).add("etag", (Object)this.etag).add("jobId", (Object)this.jobId).add("jobCompleted", this.jobCompleted).add("executionErrors", this.executionErrors).toString();
    }

    public final int hashCode() {
        return Objects.hash(this.jobId);
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(QueryResponse.class)) {
            return false;
        }
        QueryResponse response = (QueryResponse)obj;
        return this.jobCompleted == response.jobCompleted && Objects.equals(this.etag, response.etag) && Objects.equals((Object)this.result, (Object)response.result) && Objects.equals(this.jobId, response.jobId) && Objects.equals(this.executionErrors, response.executionErrors);
    }

    static Builder newBuilder() {
        return new Builder();
    }

    static final class Builder {
        private QueryResult result;
        private String etag;
        private JobId jobId;
        private boolean jobCompleted;
        private List<BigQueryError> executionErrors;

        private Builder() {
        }

        Builder setResult(QueryResult result) {
            this.result = result;
            return this;
        }

        Builder setEtag(String etag) {
            this.etag = etag;
            return this;
        }

        Builder setJobId(JobId jobId) {
            this.jobId = jobId;
            return this;
        }

        Builder setJobCompleted(boolean jobCompleted) {
            this.jobCompleted = jobCompleted;
            return this;
        }

        Builder setExecutionErrors(List<BigQueryError> executionErrors) {
            this.executionErrors = executionErrors;
            return this;
        }

        QueryResponse build() {
            return new QueryResponse(this);
        }
    }
}

