/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.Streamingbuffer;
import com.google.api.services.bigquery.model.Table;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;

public class StandardTableDefinition
extends TableDefinition {
    private static final long serialVersionUID = 2113445776046717900L;
    private final Long numBytes;
    private final Long numRows;
    private final String location;
    private final StreamingBuffer streamingBuffer;
    private final TimePartitioning timePartitioning;

    private StandardTableDefinition(Builder builder) {
        super(builder);
        this.numBytes = builder.numBytes;
        this.numRows = builder.numRows;
        this.location = builder.location;
        this.streamingBuffer = builder.streamingBuffer;
        this.timePartitioning = builder.timePartitioning;
    }

    public Long getNumBytes() {
        return this.numBytes;
    }

    public Long getNumRows() {
        return this.numRows;
    }

    public String getLocation() {
        return this.location;
    }

    public StreamingBuffer getStreamingBuffer() {
        return this.streamingBuffer;
    }

    public TimePartitioning getTimePartitioning() {
        return this.timePartitioning;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static StandardTableDefinition of(Schema schema) {
        return ((Builder)StandardTableDefinition.newBuilder().setSchema(schema)).build();
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("numBytes", (Object)this.numBytes).add("numRows", (Object)this.numRows).add("location", (Object)this.location).add("streamingBuffer", (Object)this.streamingBuffer).add("timePartitioning", (Object)this.timePartitioning);
    }

    public final boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(StandardTableDefinition.class) && this.baseEquals((StandardTableDefinition)obj);
    }

    public final int hashCode() {
        return Objects.hash(this.baseHashCode(), this.numBytes, this.numRows, this.location, this.streamingBuffer, this.timePartitioning);
    }

    @Override
    Table toPb() {
        Table tablePb = super.toPb();
        if (this.numRows != null) {
            tablePb.setNumRows(BigInteger.valueOf(this.numRows));
        }
        tablePb.setNumBytes(this.numBytes);
        tablePb.setLocation(this.location);
        if (this.streamingBuffer != null) {
            tablePb.setStreamingBuffer(this.streamingBuffer.toPb());
        }
        if (this.timePartitioning != null) {
            tablePb.setTimePartitioning(this.timePartitioning.toPb());
        }
        return tablePb;
    }

    static StandardTableDefinition fromPb(Table tablePb) {
        return new Builder(tablePb).build();
    }

    public static final class Builder
    extends TableDefinition.Builder<StandardTableDefinition, Builder> {
        private Long numBytes;
        private Long numRows;
        private String location;
        private StreamingBuffer streamingBuffer;
        private TimePartitioning timePartitioning;

        private Builder() {
            super(TableDefinition.Type.TABLE);
        }

        private Builder(StandardTableDefinition tableDefinition) {
            super(tableDefinition);
            this.numBytes = tableDefinition.numBytes;
            this.numRows = tableDefinition.numRows;
            this.location = tableDefinition.location;
            this.streamingBuffer = tableDefinition.streamingBuffer;
            this.timePartitioning = tableDefinition.timePartitioning;
        }

        private Builder(Table tablePb) {
            super(tablePb);
            if (tablePb.getNumRows() != null) {
                this.setNumRows(tablePb.getNumRows().longValue());
            }
            this.numBytes = tablePb.getNumBytes();
            this.location = tablePb.getLocation();
            if (tablePb.getStreamingBuffer() != null) {
                this.streamingBuffer = StreamingBuffer.fromPb(tablePb.getStreamingBuffer());
            }
            if (tablePb.getTimePartitioning() != null) {
                this.timePartitioning = TimePartitioning.fromPb(tablePb.getTimePartitioning());
            }
        }

        Builder setNumBytes(Long numBytes) {
            this.numBytes = numBytes;
            return (Builder)this.self();
        }

        Builder setNumRows(Long numRows) {
            this.numRows = numRows;
            return (Builder)this.self();
        }

        Builder setLocation(String location) {
            this.location = location;
            return (Builder)this.self();
        }

        Builder setStreamingBuffer(StreamingBuffer streamingBuffer) {
            this.streamingBuffer = streamingBuffer;
            return (Builder)this.self();
        }

        public Builder setTimePartitioning(TimePartitioning timePartitioning) {
            this.timePartitioning = timePartitioning;
            return this;
        }

        @Override
        public StandardTableDefinition build() {
            return new StandardTableDefinition(this);
        }
    }

    public static class StreamingBuffer
    implements Serializable {
        private static final long serialVersionUID = 822027055549277843L;
        private final long estimatedRows;
        private final long estimatedBytes;
        private final Long oldestEntryTime;

        StreamingBuffer(long estimatedRows, long estimatedBytes, Long oldestEntryTime) {
            this.estimatedRows = estimatedRows;
            this.estimatedBytes = estimatedBytes;
            this.oldestEntryTime = oldestEntryTime;
        }

        public long getEstimatedRows() {
            return this.estimatedRows;
        }

        public long getEstimatedBytes() {
            return this.estimatedBytes;
        }

        public Long getOldestEntryTime() {
            return this.oldestEntryTime;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("estimatedRows", this.estimatedRows).add("estimatedBytes", this.estimatedBytes).add("oldestEntryTime", (Object)this.oldestEntryTime).toString();
        }

        public int hashCode() {
            return Objects.hash(this.estimatedRows, this.estimatedBytes, this.oldestEntryTime);
        }

        public boolean equals(Object obj) {
            return obj instanceof StreamingBuffer && Objects.equals(this.toPb(), ((StreamingBuffer)obj).toPb());
        }

        Streamingbuffer toPb() {
            return new Streamingbuffer().setEstimatedBytes(BigInteger.valueOf(this.estimatedBytes)).setEstimatedRows(BigInteger.valueOf(this.estimatedRows)).setOldestEntryTime(BigInteger.valueOf(this.oldestEntryTime));
        }

        static StreamingBuffer fromPb(Streamingbuffer streamingBufferPb) {
            Long oldestEntryTime = null;
            if (streamingBufferPb.getOldestEntryTime() != null) {
                oldestEntryTime = streamingBufferPb.getOldestEntryTime().longValue();
            }
            return new StreamingBuffer(streamingBufferPb.getEstimatedRows().longValue(), streamingBufferPb.getEstimatedBytes().longValue(), oldestEntryTime);
        }
    }
}

