/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.PageImpl;
import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.Schema;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class QueryResult
extends PageImpl<List<FieldValue>> {
    private static final long serialVersionUID = -4831062717210349818L;
    private final boolean cacheHit;
    private final Schema schema;
    private final long totalRows;
    private final long totalBytesProcessed;

    private QueryResult(Builder builder) {
        super((PageImpl.NextPageFetcher)builder.pageFetcher, builder.cursor, builder.results != null ? builder.results : ImmutableList.of());
        this.cacheHit = builder.cacheHit;
        this.schema = builder.schema;
        this.totalBytesProcessed = builder.totalBytesProcessed;
        this.totalRows = builder.totalRows;
    }

    public boolean cacheHit() {
        return this.cacheHit;
    }

    public Schema schema() {
        return this.schema;
    }

    public long totalBytesProcessed() {
        return this.totalBytesProcessed;
    }

    public long totalRows() {
        return this.totalRows;
    }

    public QueryResult nextPage() {
        return (QueryResult)super.nextPage();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("rows", (Object)this.values()).add("cacheHit", this.cacheHit).add("schema", (Object)this.schema).add("totalBytesProcessed", this.totalBytesProcessed).add("totalRows", this.totalRows).add("cursor", (Object)this.nextPageCursor()).toString();
    }

    public final int hashCode() {
        return Objects.hash(super.hashCode(), this.cacheHit, this.schema, this.totalBytesProcessed, this.totalRows);
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(QueryResult.class)) {
            return false;
        }
        QueryResult response = (QueryResult)((Object)obj);
        return Objects.equals(this.nextPageCursor(), response.nextPageCursor()) && Objects.equals(this.values(), response.values()) && Objects.equals(this.schema, response.schema) && this.totalRows == response.totalRows && this.totalBytesProcessed == response.totalBytesProcessed && this.cacheHit == response.cacheHit;
    }

    static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private QueryResultsPageFetcher pageFetcher;
        private String cursor;
        private Iterable<List<FieldValue>> results;
        private boolean cacheHit;
        private Schema schema;
        private long totalRows;
        private long totalBytesProcessed;

        private Builder() {
        }

        Builder cacheHit(boolean cacheHit) {
            this.cacheHit = cacheHit;
            return this;
        }

        Builder schema(Schema schema) {
            this.schema = schema;
            return this;
        }

        Builder totalBytesProcessed(long totalBytesProcessed) {
            this.totalBytesProcessed = totalBytesProcessed;
            return this;
        }

        Builder totalRows(long totalRows) {
            this.totalRows = totalRows;
            return this;
        }

        Builder pageFetcher(QueryResultsPageFetcher pageFetcher) {
            this.pageFetcher = pageFetcher;
            return this;
        }

        Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        Builder results(Iterable<List<FieldValue>> results) {
            this.results = results;
            return this;
        }

        QueryResult build() {
            return new QueryResult(this);
        }
    }

    static interface QueryResultsPageFetcher
    extends PageImpl.NextPageFetcher<List<FieldValue>> {
        public QueryResult nextPage();
    }
}

