/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobStatistics;
import com.google.cloud.bigquery.JobStatus;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;

public class JobInfo
implements Serializable {
    static final Function<Job, JobInfo> FROM_PB_FUNCTION = new Function<Job, JobInfo>(){

        public JobInfo apply(Job pb) {
            return JobInfo.fromPb(pb);
        }
    };
    private static final long serialVersionUID = 2740548743267670124L;
    private final String etag;
    private final String generatedId;
    private final JobId jobId;
    private final String selfLink;
    private final JobStatus status;
    private final JobStatistics statistics;
    private final String userEmail;
    private final JobConfiguration configuration;

    JobInfo(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.etag = builder.etag;
        this.generatedId = builder.generatedId;
        this.selfLink = builder.selfLink;
        this.status = builder.status;
        this.statistics = builder.statistics;
        this.userEmail = builder.userEmail;
        this.configuration = builder.configuration;
    }

    public String etag() {
        return this.etag;
    }

    public String generatedId() {
        return this.generatedId;
    }

    public JobId jobId() {
        return this.jobId;
    }

    public String selfLink() {
        return this.selfLink;
    }

    public JobStatus status() {
        return this.status;
    }

    public <S extends JobStatistics> S statistics() {
        return (S)this.statistics;
    }

    public String userEmail() {
        return this.userEmail;
    }

    public <C extends JobConfiguration> C configuration() {
        return (C)this.configuration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("job", (Object)this.jobId).add("status", (Object)this.status).add("statistics", (Object)this.statistics).add("userEmail", (Object)this.userEmail).add("etag", (Object)this.etag).add("generatedId", (Object)this.generatedId).add("selfLink", (Object)this.selfLink).add("configuration", (Object)this.configuration).toString();
    }

    public int hashCode() {
        return Objects.hash(this.jobId);
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(JobInfo.class) && Objects.equals(this.toPb(), ((JobInfo)obj).toPb());
    }

    JobInfo setProjectId(String projectId) {
        return this.toBuilder().configuration(this.configuration.setProjectId(projectId)).build();
    }

    Job toPb() {
        Job jobPb = new Job();
        jobPb.setEtag(this.etag);
        jobPb.setId(this.generatedId);
        jobPb.setSelfLink(this.selfLink);
        jobPb.setUserEmail(this.userEmail);
        if (this.jobId != null) {
            jobPb.setJobReference(this.jobId.toPb());
        }
        if (this.status != null) {
            jobPb.setStatus(this.status.toPb());
        }
        if (this.statistics != null) {
            jobPb.setStatistics(this.statistics.toPb());
        }
        jobPb.setConfiguration(this.configuration.toPb());
        return jobPb;
    }

    public static Builder builder(JobConfiguration configuration) {
        return new BuilderImpl().configuration(configuration);
    }

    public static JobInfo of(JobConfiguration configuration) {
        return JobInfo.builder(configuration).build();
    }

    public static JobInfo of(JobId jobId, JobConfiguration configuration) {
        return JobInfo.builder(configuration).jobId(jobId).build();
    }

    static JobInfo fromPb(Job jobPb) {
        return new BuilderImpl(jobPb).build();
    }

    static final class BuilderImpl
    extends Builder {
        private String etag;
        private String generatedId;
        private JobId jobId;
        private String selfLink;
        private JobStatus status;
        private JobStatistics statistics;
        private String userEmail;
        private JobConfiguration configuration;

        BuilderImpl() {
        }

        BuilderImpl(JobInfo jobInfo) {
            this.etag = jobInfo.etag;
            this.generatedId = jobInfo.generatedId;
            this.jobId = jobInfo.jobId;
            this.selfLink = jobInfo.selfLink;
            this.status = jobInfo.status;
            this.statistics = jobInfo.statistics;
            this.userEmail = jobInfo.userEmail;
            this.configuration = jobInfo.configuration;
        }

        BuilderImpl(Job jobPb) {
            this.etag = jobPb.getEtag();
            this.generatedId = jobPb.getId();
            if (jobPb.getJobReference() != null) {
                this.jobId = JobId.fromPb(jobPb.getJobReference());
            }
            this.selfLink = jobPb.getSelfLink();
            if (jobPb.getStatus() != null) {
                this.status = JobStatus.fromPb(jobPb.getStatus());
            }
            if (jobPb.getStatistics() != null) {
                this.statistics = JobStatistics.fromPb(jobPb.getStatistics());
            }
            this.userEmail = jobPb.getUserEmail();
            this.configuration = JobConfiguration.fromPb(jobPb.getConfiguration());
        }

        @Override
        Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        @Override
        Builder generatedId(String generatedId) {
            this.generatedId = generatedId;
            return this;
        }

        @Override
        public Builder jobId(JobId jobId) {
            this.jobId = jobId;
            return this;
        }

        @Override
        Builder selfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        @Override
        Builder status(JobStatus status) {
            this.status = status;
            return this;
        }

        @Override
        Builder statistics(JobStatistics statistics) {
            this.statistics = statistics;
            return this;
        }

        @Override
        Builder userEmail(String userEmail) {
            this.userEmail = userEmail;
            return this;
        }

        @Override
        public Builder configuration(JobConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public JobInfo build() {
            return new JobInfo(this);
        }
    }

    public static abstract class Builder {
        abstract Builder etag(String var1);

        abstract Builder generatedId(String var1);

        public abstract Builder jobId(JobId var1);

        abstract Builder selfLink(String var1);

        abstract Builder status(JobStatus var1);

        abstract Builder statistics(JobStatistics var1);

        abstract Builder userEmail(String var1);

        public abstract Builder configuration(JobConfiguration var1);

        public abstract JobInfo build();
    }

    public static enum WriteDisposition {
        WRITE_TRUNCATE,
        WRITE_APPEND,
        WRITE_EMPTY;

    }

    public static enum CreateDisposition {
        CREATE_IF_NEEDED,
        CREATE_NEVER;

    }
}

