/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.api.services.bigquery.model.JobConfigurationLoad;
import com.google.cloud.bigquery.CsvOptions;
import com.google.cloud.bigquery.DatastoreBackupOptions;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.LoadConfiguration;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableId;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public final class WriteChannelConfiguration
implements LoadConfiguration,
Serializable {
    private static final long serialVersionUID = 470267591917413578L;
    private final TableId destinationTable;
    private final JobInfo.CreateDisposition createDisposition;
    private final JobInfo.WriteDisposition writeDisposition;
    private final FormatOptions formatOptions;
    private final String nullMarker;
    private final Integer maxBadRecords;
    private final Schema schema;
    private final Boolean ignoreUnknownValues;
    private final List<JobInfo.SchemaUpdateOption> schemaUpdateOptions;
    private final Boolean autodetect;

    protected WriteChannelConfiguration(Builder builder) {
        this.destinationTable = (TableId)Preconditions.checkNotNull((Object)builder.destinationTable);
        this.createDisposition = builder.createDisposition;
        this.writeDisposition = builder.writeDisposition;
        this.formatOptions = builder.formatOptions;
        this.nullMarker = builder.nullMarker;
        this.maxBadRecords = builder.maxBadRecords;
        this.schema = builder.schema;
        this.ignoreUnknownValues = builder.ignoreUnknownValues;
        this.schemaUpdateOptions = builder.schemaUpdateOptions;
        this.autodetect = builder.autodetect;
    }

    @Override
    public TableId getDestinationTable() {
        return this.destinationTable;
    }

    @Override
    public JobInfo.CreateDisposition getCreateDisposition() {
        return this.createDisposition;
    }

    @Override
    public JobInfo.WriteDisposition getWriteDisposition() {
        return this.writeDisposition;
    }

    @Override
    public String getNullMarker() {
        return this.nullMarker;
    }

    @Override
    public CsvOptions getCsvOptions() {
        return this.formatOptions instanceof CsvOptions ? (CsvOptions)this.formatOptions : null;
    }

    @Override
    public Integer getMaxBadRecords() {
        return this.maxBadRecords;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public String getFormat() {
        return this.formatOptions != null ? this.formatOptions.getType() : null;
    }

    @Override
    public Boolean ignoreUnknownValues() {
        return this.ignoreUnknownValues;
    }

    @Override
    public DatastoreBackupOptions getDatastoreBackupOptions() {
        return this.formatOptions instanceof DatastoreBackupOptions ? (DatastoreBackupOptions)this.formatOptions : null;
    }

    @Override
    public List<JobInfo.SchemaUpdateOption> getSchemaUpdateOptions() {
        return this.schemaUpdateOptions;
    }

    @Override
    public Boolean getAutodetect() {
        return this.autodetect;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper((Object)this).add("destinationTable", (Object)this.destinationTable).add("createDisposition", (Object)this.createDisposition).add("writeDisposition", (Object)this.writeDisposition).add("formatOptions", (Object)this.formatOptions).add("nullMarker", (Object)this.nullMarker).add("maxBadRecords", (Object)this.maxBadRecords).add("schema", (Object)this.schema).add("ignoreUnknownValue", (Object)this.ignoreUnknownValues).add("schemaUpdateOptions", this.schemaUpdateOptions).add("autodetect", (Object)this.autodetect);
    }

    public String toString() {
        return this.toStringHelper().toString();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof WriteChannelConfiguration && Objects.equals(this.toPb(), ((WriteChannelConfiguration)obj).toPb());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.destinationTable, this.createDisposition, this.writeDisposition, this.formatOptions, this.nullMarker, this.maxBadRecords, this.schema, this.ignoreUnknownValues, this.schemaUpdateOptions, this.autodetect});
    }

    WriteChannelConfiguration setProjectId(String projectId) {
        return this.toBuilder().setDestinationTable(this.getDestinationTable().setProjectId(projectId)).build();
    }

    JobConfiguration toPb() {
        JobConfigurationLoad loadConfigurationPb = new JobConfigurationLoad();
        loadConfigurationPb.setDestinationTable(this.destinationTable.toPb());
        if (this.createDisposition != null) {
            loadConfigurationPb.setCreateDisposition(this.createDisposition.toString());
        }
        if (this.writeDisposition != null) {
            loadConfigurationPb.setWriteDisposition(this.writeDisposition.toString());
        }
        if (this.nullMarker != null) {
            loadConfigurationPb.setNullMarker(this.nullMarker);
        }
        if (this.getCsvOptions() != null) {
            CsvOptions csvOptions = this.getCsvOptions();
            loadConfigurationPb.setFieldDelimiter(csvOptions.getFieldDelimiter()).setAllowJaggedRows(csvOptions.allowJaggedRows()).setAllowQuotedNewlines(csvOptions.allowQuotedNewLines()).setEncoding(csvOptions.getEncoding()).setQuote(csvOptions.getQuote());
            if (csvOptions.getSkipLeadingRows() != null) {
                loadConfigurationPb.setSkipLeadingRows(Integer.valueOf(Ints.checkedCast((long)csvOptions.getSkipLeadingRows())));
            }
        }
        if (this.schema != null) {
            loadConfigurationPb.setSchema(this.schema.toPb());
        }
        if (this.formatOptions != null) {
            loadConfigurationPb.setSourceFormat(this.formatOptions.getType());
        }
        loadConfigurationPb.setMaxBadRecords(this.maxBadRecords);
        loadConfigurationPb.setIgnoreUnknownValues(this.ignoreUnknownValues);
        if (this.getDatastoreBackupOptions() != null) {
            DatastoreBackupOptions backupOptions = this.getDatastoreBackupOptions();
            loadConfigurationPb.setProjectionFields(backupOptions.getProjectionFields());
        }
        if (this.schemaUpdateOptions != null) {
            ImmutableList.Builder schemaUpdateOptionsBuilder = new ImmutableList.Builder();
            for (JobInfo.SchemaUpdateOption schemaUpdateOption : this.schemaUpdateOptions) {
                schemaUpdateOptionsBuilder.add((Object)schemaUpdateOption.name());
            }
            loadConfigurationPb.setSchemaUpdateOptions((List)schemaUpdateOptionsBuilder.build());
        }
        loadConfigurationPb.setAutodetect(this.autodetect);
        return new JobConfiguration().setLoad(loadConfigurationPb);
    }

    static WriteChannelConfiguration fromPb(JobConfiguration configurationPb) {
        return new Builder(configurationPb).build();
    }

    public static Builder newBuilder(TableId destinationTable) {
        return new Builder().setDestinationTable(destinationTable);
    }

    public static Builder newBuilder(TableId destinationTable, FormatOptions format) {
        return WriteChannelConfiguration.newBuilder(destinationTable).setFormatOptions(format);
    }

    public static WriteChannelConfiguration of(TableId destinationTable) {
        return WriteChannelConfiguration.newBuilder(destinationTable).build();
    }

    public static WriteChannelConfiguration of(TableId destinationTable, FormatOptions format) {
        return WriteChannelConfiguration.newBuilder(destinationTable).setFormatOptions(format).build();
    }

    public static final class Builder
    implements LoadConfiguration.Builder {
        private TableId destinationTable;
        private JobInfo.CreateDisposition createDisposition;
        private JobInfo.WriteDisposition writeDisposition;
        private FormatOptions formatOptions;
        private String nullMarker;
        private Integer maxBadRecords;
        private Schema schema;
        private Boolean ignoreUnknownValues;
        private List<JobInfo.SchemaUpdateOption> schemaUpdateOptions;
        private Boolean autodetect;

        private Builder() {
        }

        private Builder(WriteChannelConfiguration writeChannelConfiguration) {
            this.destinationTable = writeChannelConfiguration.destinationTable;
            this.createDisposition = writeChannelConfiguration.createDisposition;
            this.writeDisposition = writeChannelConfiguration.writeDisposition;
            this.formatOptions = writeChannelConfiguration.formatOptions;
            this.nullMarker = writeChannelConfiguration.nullMarker;
            this.maxBadRecords = writeChannelConfiguration.maxBadRecords;
            this.schema = writeChannelConfiguration.schema;
            this.ignoreUnknownValues = writeChannelConfiguration.ignoreUnknownValues;
            this.schemaUpdateOptions = writeChannelConfiguration.schemaUpdateOptions;
            this.autodetect = writeChannelConfiguration.autodetect;
        }

        private Builder(JobConfiguration configurationPb) {
            JobConfigurationLoad loadConfigurationPb = configurationPb.getLoad();
            this.destinationTable = TableId.fromPb(loadConfigurationPb.getDestinationTable());
            if (loadConfigurationPb.getCreateDisposition() != null) {
                this.createDisposition = JobInfo.CreateDisposition.valueOf(loadConfigurationPb.getCreateDisposition());
            }
            if (loadConfigurationPb.getWriteDisposition() != null) {
                this.writeDisposition = JobInfo.WriteDisposition.valueOf(loadConfigurationPb.getWriteDisposition());
            }
            if (loadConfigurationPb.getSourceFormat() != null) {
                this.formatOptions = FormatOptions.of(loadConfigurationPb.getSourceFormat());
            }
            if (loadConfigurationPb.getNullMarker() != null) {
                this.nullMarker = loadConfigurationPb.getNullMarker();
            }
            if (loadConfigurationPb.getAllowJaggedRows() != null || loadConfigurationPb.getAllowQuotedNewlines() != null || loadConfigurationPb.getEncoding() != null || loadConfigurationPb.getFieldDelimiter() != null || loadConfigurationPb.getQuote() != null || loadConfigurationPb.getSkipLeadingRows() != null) {
                CsvOptions.Builder builder = CsvOptions.newBuilder().setEncoding(loadConfigurationPb.getEncoding()).setFieldDelimiter(loadConfigurationPb.getFieldDelimiter()).setQuote(loadConfigurationPb.getQuote());
                if (loadConfigurationPb.getAllowJaggedRows() != null) {
                    builder.setAllowJaggedRows(loadConfigurationPb.getAllowJaggedRows());
                }
                if (loadConfigurationPb.getAllowQuotedNewlines() != null) {
                    builder.setAllowQuotedNewLines(loadConfigurationPb.getAllowQuotedNewlines());
                }
                if (loadConfigurationPb.getSkipLeadingRows() != null) {
                    builder.setSkipLeadingRows(loadConfigurationPb.getSkipLeadingRows().intValue());
                }
                this.formatOptions = builder.build();
            }
            this.maxBadRecords = loadConfigurationPb.getMaxBadRecords();
            if (loadConfigurationPb.getSchema() != null) {
                this.schema = Schema.fromPb(loadConfigurationPb.getSchema());
            }
            this.ignoreUnknownValues = loadConfigurationPb.getIgnoreUnknownValues();
            if (loadConfigurationPb.getProjectionFields() != null) {
                this.formatOptions = DatastoreBackupOptions.newBuilder().setProjectionFields(loadConfigurationPb.getProjectionFields()).build();
            }
            if (loadConfigurationPb.getSchemaUpdateOptions() != null) {
                ImmutableList.Builder schemaUpdateOptionsBuilder = new ImmutableList.Builder();
                for (String rawSchemaUpdateOption : loadConfigurationPb.getSchemaUpdateOptions()) {
                    schemaUpdateOptionsBuilder.add((Object)JobInfo.SchemaUpdateOption.valueOf(rawSchemaUpdateOption));
                }
                this.schemaUpdateOptions = schemaUpdateOptionsBuilder.build();
            }
            this.autodetect = loadConfigurationPb.getAutodetect();
        }

        @Override
        public Builder setDestinationTable(TableId destinationTable) {
            this.destinationTable = destinationTable;
            return this;
        }

        @Override
        public Builder setCreateDisposition(JobInfo.CreateDisposition createDisposition) {
            this.createDisposition = createDisposition;
            return this;
        }

        @Override
        public Builder setWriteDisposition(JobInfo.WriteDisposition writeDisposition) {
            this.writeDisposition = writeDisposition;
            return this;
        }

        @Override
        public Builder setFormatOptions(FormatOptions formatOptions) {
            this.formatOptions = formatOptions;
            return this;
        }

        @Override
        public Builder setNullMarker(String nullMarker) {
            this.nullMarker = nullMarker;
            return this;
        }

        @Override
        public Builder setMaxBadRecords(Integer maxBadRecords) {
            this.maxBadRecords = maxBadRecords;
            return this;
        }

        @Override
        public Builder setSchema(Schema schema) {
            this.schema = schema;
            return this;
        }

        @Override
        public Builder setIgnoreUnknownValues(Boolean ignoreUnknownValues) {
            this.ignoreUnknownValues = ignoreUnknownValues;
            return this;
        }

        @Override
        public Builder setSchemaUpdateOptions(List<JobInfo.SchemaUpdateOption> schemaUpdateOptions) {
            this.schemaUpdateOptions = schemaUpdateOptions != null ? ImmutableList.copyOf(schemaUpdateOptions) : null;
            return this;
        }

        @Override
        public Builder setAutodetect(Boolean autodetect) {
            this.autodetect = autodetect;
            return this;
        }

        @Override
        public WriteChannelConfiguration build() {
            return new WriteChannelConfiguration(this);
        }
    }
}

