/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.core.ApiClock;
import com.google.api.gax.retrying.BasicResultRetryAlgorithm;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.cloud.RetryHelper;
import com.google.cloud.RetryOption;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.JobStatistics;
import com.google.cloud.bigquery.JobStatus;
import com.google.cloud.bigquery.QueryResponse;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.threeten.bp.Duration;

public class Job
extends JobInfo {
    private static final long serialVersionUID = -4324100991693024704L;
    private static final RetrySettings DEFAULT_JOB_WAIT_SETTINGS = RetrySettings.newBuilder().setTotalTimeout(Duration.ofHours((long)12L)).setInitialRetryDelay(Duration.ofSeconds((long)1L)).setRetryDelayMultiplier(2.0).setJittered(true).setMaxRetryDelay(Duration.ofMinutes((long)1L)).build();
    static final RetrySettings DEFAULT_QUERY_JOB_WAIT_SETTINGS = RetrySettings.newBuilder().setTotalTimeout(Duration.ofHours((long)12L)).setInitialRetryDelay(Duration.ofSeconds((long)3L)).setRetryDelayMultiplier(1.0).setJittered(true).setMaxRetryDelay(Duration.ofSeconds((long)3L)).build();
    static final BigQuery.QueryResultsOption[] DEFAULT_QUERY_WAIT_OPTIONS = new BigQuery.QueryResultsOption[]{BigQuery.QueryResultsOption.pageSize(0L), BigQuery.QueryResultsOption.maxWaitTime(Duration.ofMinutes((long)1L).toMillis())};
    private final BigQueryOptions options;
    private transient BigQuery bigquery;

    Job(BigQuery bigquery, JobInfo.BuilderImpl infoBuilder) {
        super(infoBuilder);
        this.bigquery = (BigQuery)Preconditions.checkNotNull((Object)bigquery);
        this.options = (BigQueryOptions)bigquery.getOptions();
    }

    public boolean exists() {
        return this.bigquery.getJob(this.getJobId(), BigQuery.JobOption.fields(new BigQuery.JobField[0])) != null;
    }

    public boolean isDone() {
        Job job = this.bigquery.getJob(this.getJobId(), BigQuery.JobOption.fields(BigQuery.JobField.STATUS));
        return job == null || job.getStatus().getState() == JobStatus.State.DONE;
    }

    public Job waitFor(RetryOption ... waitOptions) throws InterruptedException {
        Serializable completedJobResponse = ((JobConfiguration)this.getConfiguration()).getType() == JobConfiguration.Type.QUERY ? this.waitForQueryResults(RetryOption.mergeToSettings((RetrySettings)DEFAULT_JOB_WAIT_SETTINGS, (RetryOption[])waitOptions), DEFAULT_QUERY_WAIT_OPTIONS) : this.waitForJob(RetryOption.mergeToSettings((RetrySettings)DEFAULT_QUERY_JOB_WAIT_SETTINGS, (RetryOption[])waitOptions));
        return completedJobResponse == null ? null : this.reload(new BigQuery.JobOption[0]);
    }

    public QueryResponse getQueryResults(BigQuery.QueryResultsOption ... options) {
        if (((JobConfiguration)this.getConfiguration()).getType() != JobConfiguration.Type.QUERY) {
            throw new UnsupportedOperationException("Getting query results is supported only for " + (Object)((Object)JobConfiguration.Type.QUERY) + " jobs");
        }
        return this.bigquery.getQueryResults(this.getJobId(), options);
    }

    QueryResponse waitForQueryResults(RetrySettings waitSettings, final BigQuery.QueryResultsOption ... resultsOptions) throws InterruptedException {
        if (((JobConfiguration)this.getConfiguration()).getType() != JobConfiguration.Type.QUERY) {
            throw new UnsupportedOperationException("Waiting for query results is supported only for " + (Object)((Object)JobConfiguration.Type.QUERY) + " jobs");
        }
        try {
            return (QueryResponse)RetryHelper.poll((Callable)new Callable<QueryResponse>(){

                @Override
                public QueryResponse call() {
                    return Job.this.bigquery.getQueryResults(Job.this.getJobId(), resultsOptions);
                }
            }, (RetrySettings)waitSettings, (ResultRetryAlgorithm)new BasicResultRetryAlgorithm<QueryResponse>(){

                public boolean shouldRetry(Throwable prevThrowable, QueryResponse prevResponse) {
                    return prevResponse != null && !prevResponse.jobCompleted();
                }
            }, (ApiClock)this.options.getClock());
        }
        catch (ExecutionException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    private Job waitForJob(RetrySettings waitSettings) throws InterruptedException {
        try {
            return (Job)RetryHelper.poll((Callable)new Callable<Job>(){

                @Override
                public Job call() throws Exception {
                    return Job.this.bigquery.getJob(Job.this.getJobId(), BigQuery.JobOption.fields(BigQuery.JobField.STATUS));
                }
            }, (RetrySettings)waitSettings, (ResultRetryAlgorithm)new BasicResultRetryAlgorithm<Job>(){

                public TimedAttemptSettings createNextAttempt(Throwable prevThrowable, Job prevResponse, TimedAttemptSettings prevSettings) {
                    return null;
                }

                public boolean shouldRetry(Throwable prevThrowable, Job prevResponse) {
                    return prevResponse != null && prevResponse.getStatus().getState() != JobStatus.State.DONE;
                }
            }, (ApiClock)this.options.getClock());
        }
        catch (ExecutionException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    public Job reload(BigQuery.JobOption ... options) {
        return this.bigquery.getJob(this.getJobId(), options);
    }

    public boolean cancel() {
        return this.bigquery.cancel(this.getJobId());
    }

    public BigQuery getBigquery() {
        return this.bigquery;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Job.class)) {
            return false;
        }
        Job other = (Job)obj;
        return Objects.equals(this.toPb(), other.toPb()) && Objects.equals((Object)this.options, (Object)other.options);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.options});
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.bigquery = (BigQuery)this.options.getService();
    }

    static Job fromPb(BigQuery bigquery, com.google.api.services.bigquery.model.Job jobPb) {
        return new Job(bigquery, new JobInfo.BuilderImpl(jobPb));
    }

    public static final class Builder
    extends JobInfo.Builder {
        private final BigQuery bigquery;
        private final JobInfo.BuilderImpl infoBuilder;

        Builder(BigQuery bigquery, JobConfiguration configuration) {
            this.bigquery = bigquery;
            this.infoBuilder = new JobInfo.BuilderImpl();
            this.infoBuilder.setConfiguration(configuration);
        }

        Builder(Job job) {
            this.bigquery = job.bigquery;
            this.infoBuilder = new JobInfo.BuilderImpl(job);
        }

        @Override
        Builder setEtag(String etag) {
            this.infoBuilder.setEtag(etag);
            return this;
        }

        @Override
        Builder setGeneratedId(String generatedId) {
            this.infoBuilder.setGeneratedId(generatedId);
            return this;
        }

        @Override
        public Builder setJobId(JobId jobId) {
            this.infoBuilder.setJobId(jobId);
            return this;
        }

        @Override
        Builder setSelfLink(String selfLink) {
            this.infoBuilder.setSelfLink(selfLink);
            return this;
        }

        @Override
        Builder setStatus(JobStatus status) {
            this.infoBuilder.setStatus(status);
            return this;
        }

        @Override
        Builder setStatistics(JobStatistics statistics) {
            this.infoBuilder.setStatistics(statistics);
            return this;
        }

        @Override
        Builder setUserEmail(String userEmail) {
            this.infoBuilder.setUserEmail(userEmail);
            return this;
        }

        @Override
        public Builder setConfiguration(JobConfiguration configuration) {
            this.infoBuilder.setConfiguration(configuration);
            return this;
        }

        @Override
        public Job build() {
            return new Job(this.bigquery, this.infoBuilder);
        }
    }
}

