/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.BigQueryError;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.QueryResult;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class QueryResponse
implements Serializable {
    private static final long serialVersionUID = 3549226764825005655L;
    private final QueryResult result;
    private final String etag;
    private final JobId jobId;
    private final Long numDmlAffectedRows;
    private final boolean jobCompleted;
    private final List<BigQueryError> executionErrors;

    private QueryResponse(Builder builder) {
        this.result = builder.result;
        this.etag = builder.etag;
        this.jobId = builder.jobId;
        this.numDmlAffectedRows = builder.numDmlAffectedRows;
        this.jobCompleted = builder.jobCompleted;
        this.executionErrors = builder.executionErrors != null ? builder.executionErrors : ImmutableList.of();
    }

    public QueryResult getResult() {
        return this.result;
    }

    public String getEtag() {
        return this.etag;
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public Long getNumDmlAffectedRows() {
        return this.numDmlAffectedRows;
    }

    public boolean jobCompleted() {
        return this.jobCompleted;
    }

    public boolean hasErrors() {
        return !this.executionErrors.isEmpty();
    }

    public List<BigQueryError> getExecutionErrors() {
        return this.executionErrors;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("result", (Object)this.result).add("etag", (Object)this.etag).add("jobId", (Object)this.jobId).add("numDmlAffectedRows", (Object)this.numDmlAffectedRows).add("jobCompleted", this.jobCompleted).add("executionErrors", this.executionErrors).toString();
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.result, this.etag, this.jobId, this.numDmlAffectedRows, this.jobCompleted, this.executionErrors});
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(QueryResponse.class)) {
            return false;
        }
        QueryResponse response = (QueryResponse)obj;
        return this.jobCompleted == response.jobCompleted && Objects.equals(this.etag, response.etag) && Objects.equals((Object)this.result, (Object)response.result) && Objects.equals(this.jobId, response.jobId) && Objects.equals(this.numDmlAffectedRows, response.numDmlAffectedRows) && Objects.equals(this.executionErrors, response.executionErrors);
    }

    static Builder newBuilder() {
        return new Builder();
    }

    static final class Builder {
        private QueryResult result;
        private String etag;
        private JobId jobId;
        private Long numDmlAffectedRows;
        private boolean jobCompleted;
        private List<BigQueryError> executionErrors;

        private Builder() {
        }

        Builder setResult(QueryResult result) {
            this.result = result;
            return this;
        }

        Builder setEtag(String etag) {
            this.etag = etag;
            return this;
        }

        Builder setJobId(JobId jobId) {
            this.jobId = jobId;
            return this;
        }

        Builder setNumDmlAffectedRows(Long numDmlAffectedRows) {
            this.numDmlAffectedRows = numDmlAffectedRows;
            return this;
        }

        Builder setJobCompleted(boolean jobCompleted) {
            this.jobCompleted = jobCompleted;
            return this;
        }

        Builder setExecutionErrors(List<BigQueryError> executionErrors) {
            this.executionErrors = executionErrors;
            return this;
        }

        QueryResponse build() {
            return new QueryResponse(this);
        }
    }
}

