/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.api.services.bigquery.model.QueryParameter;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.ExternalTableDefinition;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.QueryParameterValue;
import com.google.cloud.bigquery.QueryRequest;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.UserDefinedFunction;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class QueryJobConfiguration
extends JobConfiguration {
    private static final long serialVersionUID = -1108948249081804890L;
    private final String query;
    private final ImmutableList<QueryParameterValue> positionalParameters;
    private final ImmutableMap<String, QueryParameterValue> namedParameters;
    private final TableId destinationTable;
    private final Map<String, ExternalTableDefinition> tableDefinitions;
    private final List<UserDefinedFunction> userDefinedFunctions;
    private final JobInfo.CreateDisposition createDisposition;
    private final JobInfo.WriteDisposition writeDisposition;
    private final DatasetId defaultDataset;
    private final Priority priority;
    private final Boolean allowLargeResults;
    private final Boolean useQueryCache;
    private final Boolean flattenResults;
    private final Boolean dryRun;
    private final Boolean useLegacySql;
    private final Integer maximumBillingTier;
    private final List<JobInfo.SchemaUpdateOption> schemaUpdateOptions;

    private QueryJobConfiguration(Builder builder) {
        super(builder);
        this.query = (String)Preconditions.checkNotNull((Object)builder.query);
        Preconditions.checkNotNull((Object)builder.positionalParameters);
        Preconditions.checkNotNull((Object)builder.namedParameters);
        if (!builder.positionalParameters.isEmpty()) {
            Preconditions.checkArgument((boolean)builder.namedParameters.isEmpty());
        }
        if (!builder.namedParameters.isEmpty()) {
            Preconditions.checkArgument((boolean)builder.positionalParameters.isEmpty());
        }
        this.positionalParameters = ImmutableList.copyOf((Collection)builder.positionalParameters);
        this.namedParameters = ImmutableMap.copyOf((Map)builder.namedParameters);
        this.allowLargeResults = builder.allowLargeResults;
        this.createDisposition = builder.createDisposition;
        this.defaultDataset = builder.defaultDataset;
        this.destinationTable = builder.destinationTable;
        this.flattenResults = builder.flattenResults;
        this.priority = builder.priority;
        this.useQueryCache = builder.useQueryCache;
        this.userDefinedFunctions = builder.userDefinedFunctions;
        this.writeDisposition = builder.writeDisposition;
        this.tableDefinitions = builder.tableDefinitions != null ? ImmutableMap.copyOf((Map)builder.tableDefinitions) : null;
        this.dryRun = builder.dryRun;
        this.useLegacySql = builder.useLegacySql;
        this.maximumBillingTier = builder.maximumBillingTier;
        this.schemaUpdateOptions = builder.schemaUpdateOptions;
    }

    public Boolean allowLargeResults() {
        return this.allowLargeResults;
    }

    public JobInfo.CreateDisposition getCreateDisposition() {
        return this.createDisposition;
    }

    public DatasetId getDefaultDataset() {
        return this.defaultDataset;
    }

    public TableId getDestinationTable() {
        return this.destinationTable;
    }

    public Boolean flattenResults() {
        return this.flattenResults;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public String getQuery() {
        return this.query;
    }

    public List<QueryParameterValue> getPositionalParameters() {
        return this.positionalParameters;
    }

    public Map<String, QueryParameterValue> getNamedParameters() {
        return this.namedParameters;
    }

    public Map<String, ExternalTableDefinition> getTableDefinitions() {
        return this.tableDefinitions;
    }

    public Boolean useQueryCache() {
        return this.useQueryCache;
    }

    public List<UserDefinedFunction> getUserDefinedFunctions() {
        return this.userDefinedFunctions;
    }

    public JobInfo.WriteDisposition getWriteDisposition() {
        return this.writeDisposition;
    }

    public Boolean dryRun() {
        return this.dryRun;
    }

    public Boolean useLegacySql() {
        return this.useLegacySql;
    }

    public Integer getMaximumBillingTier() {
        return this.maximumBillingTier;
    }

    public List<JobInfo.SchemaUpdateOption> getSchemaUpdateOptions() {
        return this.schemaUpdateOptions;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("query", (Object)this.query).add("positionalParameters", this.positionalParameters).add("namedParameters", this.namedParameters).add("destinationTable", (Object)this.destinationTable).add("defaultDataset", (Object)this.defaultDataset).add("allowLargeResults", (Object)this.allowLargeResults).add("flattenResults", (Object)this.flattenResults).add("priority", (Object)this.priority).add("tableDefinitions", this.tableDefinitions).add("userQueryCache", (Object)this.useQueryCache).add("userDefinedFunctions", this.userDefinedFunctions).add("createDisposition", (Object)this.createDisposition).add("writeDisposition", (Object)this.writeDisposition).add("dryRun", (Object)this.dryRun).add("useLegacySql", (Object)this.useLegacySql).add("maximumBillingTier", (Object)this.maximumBillingTier).add("schemaUpdateOptions", this.schemaUpdateOptions);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof QueryJobConfiguration && this.baseEquals((QueryJobConfiguration)obj);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.baseHashCode(), this.allowLargeResults, this.createDisposition, this.destinationTable, this.defaultDataset, this.flattenResults, this.priority, this.query, this.positionalParameters, this.namedParameters, this.tableDefinitions, this.useQueryCache, this.userDefinedFunctions, this.writeDisposition, this.dryRun, this.useLegacySql, this.maximumBillingTier, this.schemaUpdateOptions});
    }

    @Override
    QueryJobConfiguration setProjectId(String projectId) {
        Builder builder = this.toBuilder();
        if (this.getDestinationTable() != null) {
            builder.setDestinationTable(this.getDestinationTable().setProjectId(projectId));
        }
        if (this.getDefaultDataset() != null) {
            builder.setDefaultDataset(this.getDefaultDataset().setProjectId(projectId));
        }
        return builder.build();
    }

    @Override
    com.google.api.services.bigquery.model.JobConfiguration toPb() {
        List queryParametersPb;
        com.google.api.services.bigquery.model.JobConfiguration configurationPb = new com.google.api.services.bigquery.model.JobConfiguration();
        JobConfigurationQuery queryConfigurationPb = new JobConfigurationQuery();
        queryConfigurationPb.setQuery(this.query);
        if (!this.positionalParameters.isEmpty()) {
            queryParametersPb = Lists.transform(this.positionalParameters, QueryRequest.POSITIONAL_PARAMETER_TO_PB_FUNCTION);
            queryConfigurationPb.setQueryParameters(queryParametersPb);
        } else if (!this.namedParameters.isEmpty()) {
            queryParametersPb = Lists.transform((List)this.namedParameters.entrySet().asList(), QueryRequest.NAMED_PARAMETER_TO_PB_FUNCTION);
            queryConfigurationPb.setQueryParameters(queryParametersPb);
        }
        configurationPb.setDryRun(this.dryRun());
        if (this.allowLargeResults != null) {
            queryConfigurationPb.setAllowLargeResults(this.allowLargeResults);
        }
        if (this.createDisposition != null) {
            queryConfigurationPb.setCreateDisposition(this.createDisposition.toString());
        }
        if (this.destinationTable != null) {
            queryConfigurationPb.setDestinationTable(this.destinationTable.toPb());
        }
        if (this.defaultDataset != null) {
            queryConfigurationPb.setDefaultDataset(this.defaultDataset.toPb());
        }
        if (this.flattenResults != null) {
            queryConfigurationPb.setFlattenResults(this.flattenResults);
        }
        if (this.priority != null) {
            queryConfigurationPb.setPriority(this.priority.toString());
        }
        if (this.tableDefinitions != null) {
            queryConfigurationPb.setTableDefinitions(Maps.transformValues(this.tableDefinitions, ExternalTableDefinition.TO_EXTERNAL_DATA_FUNCTION));
        }
        if (this.useQueryCache != null) {
            queryConfigurationPb.setUseQueryCache(this.useQueryCache);
        }
        if (this.userDefinedFunctions != null) {
            queryConfigurationPb.setUserDefinedFunctionResources(Lists.transform(this.userDefinedFunctions, UserDefinedFunction.TO_PB_FUNCTION));
        }
        if (this.writeDisposition != null) {
            queryConfigurationPb.setWriteDisposition(this.writeDisposition.toString());
        }
        if (this.useLegacySql != null) {
            queryConfigurationPb.setUseLegacySql(this.useLegacySql);
        }
        if (this.maximumBillingTier != null) {
            queryConfigurationPb.setMaximumBillingTier(this.maximumBillingTier);
        }
        if (this.schemaUpdateOptions != null) {
            ImmutableList.Builder schemaUpdateOptionsBuilder = new ImmutableList.Builder();
            for (JobInfo.SchemaUpdateOption schemaUpdateOption : this.schemaUpdateOptions) {
                schemaUpdateOptionsBuilder.add((Object)schemaUpdateOption.name());
            }
            queryConfigurationPb.setSchemaUpdateOptions((List)schemaUpdateOptionsBuilder.build());
        }
        return configurationPb.setQuery(queryConfigurationPb);
    }

    public static Builder newBuilder(String query) {
        return new Builder().setQuery(query);
    }

    public static QueryJobConfiguration of(String query) {
        return QueryJobConfiguration.newBuilder(query).build();
    }

    static QueryJobConfiguration fromPb(com.google.api.services.bigquery.model.JobConfiguration jobPb) {
        return new Builder(jobPb).build();
    }

    public static final class Builder
    extends JobConfiguration.Builder<QueryJobConfiguration, Builder> {
        private String query;
        private List<QueryParameterValue> positionalParameters = Lists.newArrayList();
        private Map<String, QueryParameterValue> namedParameters = Maps.newHashMap();
        private TableId destinationTable;
        private Map<String, ExternalTableDefinition> tableDefinitions;
        private List<UserDefinedFunction> userDefinedFunctions;
        private JobInfo.CreateDisposition createDisposition;
        private JobInfo.WriteDisposition writeDisposition;
        private DatasetId defaultDataset;
        private Priority priority;
        private Boolean allowLargeResults;
        private Boolean useQueryCache;
        private Boolean flattenResults;
        private Boolean dryRun;
        private Boolean useLegacySql;
        private Integer maximumBillingTier;
        private List<JobInfo.SchemaUpdateOption> schemaUpdateOptions;

        private Builder() {
            super(JobConfiguration.Type.QUERY);
        }

        private Builder(QueryJobConfiguration jobConfiguration) {
            this();
            this.query = jobConfiguration.query;
            this.namedParameters = jobConfiguration.namedParameters;
            this.positionalParameters = jobConfiguration.positionalParameters;
            this.destinationTable = jobConfiguration.destinationTable;
            this.tableDefinitions = jobConfiguration.tableDefinitions;
            this.userDefinedFunctions = jobConfiguration.userDefinedFunctions;
            this.createDisposition = jobConfiguration.createDisposition;
            this.writeDisposition = jobConfiguration.writeDisposition;
            this.defaultDataset = jobConfiguration.defaultDataset;
            this.priority = jobConfiguration.priority;
            this.allowLargeResults = jobConfiguration.allowLargeResults;
            this.useQueryCache = jobConfiguration.useQueryCache;
            this.flattenResults = jobConfiguration.flattenResults;
            this.dryRun = jobConfiguration.dryRun;
            this.useLegacySql = jobConfiguration.useLegacySql;
            this.maximumBillingTier = jobConfiguration.maximumBillingTier;
            this.schemaUpdateOptions = jobConfiguration.schemaUpdateOptions;
        }

        private Builder(com.google.api.services.bigquery.model.JobConfiguration configurationPb) {
            this();
            JobConfigurationQuery queryConfigurationPb = configurationPb.getQuery();
            this.query = queryConfigurationPb.getQuery();
            if (queryConfigurationPb.getQueryParameters() != null && !queryConfigurationPb.getQueryParameters().isEmpty()) {
                if (((QueryParameter)queryConfigurationPb.getQueryParameters().get(0)).getName() == null) {
                    this.setPositionalParameters(Lists.transform((List)queryConfigurationPb.getQueryParameters(), QueryRequest.POSITIONAL_PARAMETER_FROM_PB_FUNCTION));
                } else {
                    HashMap values = Maps.newHashMap();
                    for (QueryParameter queryParameterPb : queryConfigurationPb.getQueryParameters()) {
                        Preconditions.checkNotNull((Object)queryParameterPb.getName());
                        QueryParameterValue value = QueryParameterValue.fromPb(queryParameterPb.getParameterValue(), queryParameterPb.getParameterType());
                        values.put(queryParameterPb.getName(), value);
                    }
                    this.setNamedParameters(values);
                }
            }
            this.allowLargeResults = queryConfigurationPb.getAllowLargeResults();
            this.useQueryCache = queryConfigurationPb.getUseQueryCache();
            this.flattenResults = queryConfigurationPb.getFlattenResults();
            this.useLegacySql = queryConfigurationPb.getUseLegacySql();
            if (queryConfigurationPb.getMaximumBillingTier() != null) {
                this.maximumBillingTier = queryConfigurationPb.getMaximumBillingTier();
            }
            this.dryRun = configurationPb.getDryRun();
            if (queryConfigurationPb.getDestinationTable() != null) {
                this.destinationTable = TableId.fromPb(queryConfigurationPb.getDestinationTable());
            }
            if (queryConfigurationPb.getDefaultDataset() != null) {
                this.defaultDataset = DatasetId.fromPb(queryConfigurationPb.getDefaultDataset());
            }
            if (queryConfigurationPb.getPriority() != null) {
                this.priority = Priority.valueOf(queryConfigurationPb.getPriority());
            }
            if (queryConfigurationPb.getTableDefinitions() != null) {
                this.tableDefinitions = Maps.transformValues((Map)queryConfigurationPb.getTableDefinitions(), ExternalTableDefinition.FROM_EXTERNAL_DATA_FUNCTION);
            }
            if (queryConfigurationPb.getUserDefinedFunctionResources() != null) {
                this.userDefinedFunctions = Lists.transform((List)queryConfigurationPb.getUserDefinedFunctionResources(), UserDefinedFunction.FROM_PB_FUNCTION);
            }
            if (queryConfigurationPb.getCreateDisposition() != null) {
                this.createDisposition = JobInfo.CreateDisposition.valueOf(queryConfigurationPb.getCreateDisposition());
            }
            if (queryConfigurationPb.getWriteDisposition() != null) {
                this.writeDisposition = JobInfo.WriteDisposition.valueOf(queryConfigurationPb.getWriteDisposition());
            }
            if (queryConfigurationPb.getSchemaUpdateOptions() != null) {
                ImmutableList.Builder schemaUpdateOptionsBuilder = new ImmutableList.Builder();
                for (String rawSchemaUpdateOption : queryConfigurationPb.getSchemaUpdateOptions()) {
                    schemaUpdateOptionsBuilder.add((Object)JobInfo.SchemaUpdateOption.valueOf(rawSchemaUpdateOption));
                }
                this.schemaUpdateOptions = schemaUpdateOptionsBuilder.build();
            }
        }

        public Builder setQuery(String query) {
            this.query = query;
            return this;
        }

        public Builder addPositionalParameter(QueryParameterValue value) {
            Preconditions.checkNotNull((Object)value);
            if (!this.namedParameters.isEmpty()) {
                throw new IllegalStateException("Positional parameters can't be combined with named parameters");
            }
            this.positionalParameters.add(value);
            return this;
        }

        public Builder setPositionalParameters(Iterable<QueryParameterValue> values) {
            if (values == null || Iterables.isEmpty(values)) {
                this.positionalParameters = Lists.newArrayList();
            } else {
                if (!this.namedParameters.isEmpty()) {
                    throw new IllegalStateException("Positional parameters can't be combined with named parameters");
                }
                this.positionalParameters = Lists.newArrayList(values);
            }
            return this;
        }

        public Builder addNamedParameter(String name, QueryParameterValue value) {
            Preconditions.checkNotNull((Object)value);
            if (!this.positionalParameters.isEmpty()) {
                throw new IllegalStateException("Named parameters can't be combined with positional parameters");
            }
            this.namedParameters.put(name, value);
            return this;
        }

        public Builder setNamedParameters(Map<String, QueryParameterValue> values) {
            if (values == null || values.isEmpty()) {
                this.namedParameters = Maps.newHashMap();
            } else {
                if (!this.positionalParameters.isEmpty()) {
                    throw new IllegalStateException("Named parameters can't be combined with positional parameters");
                }
                this.namedParameters = Maps.newHashMap(values);
            }
            return this;
        }

        public Builder setDestinationTable(TableId destinationTable) {
            this.destinationTable = destinationTable;
            return this;
        }

        public Builder setTableDefinitions(Map<String, ExternalTableDefinition> tableDefinitions) {
            this.tableDefinitions = tableDefinitions != null ? Maps.newHashMap(tableDefinitions) : null;
            return this;
        }

        public Builder addTableDefinition(String tableName, ExternalTableDefinition tableDefinition) {
            if (this.tableDefinitions == null) {
                this.tableDefinitions = Maps.newHashMap();
            }
            this.tableDefinitions.put((String)Preconditions.checkNotNull((Object)tableName), (ExternalTableDefinition)Preconditions.checkNotNull((Object)tableDefinition));
            return this;
        }

        public Builder setUserDefinedFunctions(List<UserDefinedFunction> userDefinedFunctions) {
            this.userDefinedFunctions = userDefinedFunctions != null ? ImmutableList.copyOf(userDefinedFunctions) : null;
            return this;
        }

        public Builder setCreateDisposition(JobInfo.CreateDisposition createDisposition) {
            this.createDisposition = createDisposition;
            return this;
        }

        public Builder setWriteDisposition(JobInfo.WriteDisposition writeDisposition) {
            this.writeDisposition = writeDisposition;
            return this;
        }

        public Builder setDefaultDataset(DatasetId defaultDataset) {
            this.defaultDataset = defaultDataset;
            return this;
        }

        public Builder setDefaultDataset(String defaultDataset) {
            return this.setDefaultDataset(DatasetId.of(defaultDataset));
        }

        public Builder setPriority(Priority priority) {
            this.priority = priority;
            return this;
        }

        public Builder setAllowLargeResults(Boolean allowLargeResults) {
            this.allowLargeResults = allowLargeResults;
            return this;
        }

        public Builder setUseQueryCache(Boolean useQueryCache) {
            this.useQueryCache = useQueryCache;
            return this;
        }

        public Builder setFlattenResults(Boolean flattenResults) {
            this.flattenResults = flattenResults;
            return this;
        }

        public Builder setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public Builder setUseLegacySql(Boolean useLegacySql) {
            this.useLegacySql = useLegacySql;
            return this;
        }

        public Builder setMaximumBillingTier(Integer maximumBillingTier) {
            this.maximumBillingTier = maximumBillingTier;
            return this;
        }

        public Builder setSchemaUpdateOptions(List<JobInfo.SchemaUpdateOption> schemaUpdateOptions) {
            this.schemaUpdateOptions = schemaUpdateOptions;
            return this;
        }

        @Override
        public QueryJobConfiguration build() {
            return new QueryJobConfiguration(this);
        }
    }

    public static enum Priority {
        INTERACTIVE,
        BATCH;

    }
}

