/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.UserDefinedFunction;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ViewDefinition
extends TableDefinition {
    private static final long serialVersionUID = -8789311196910794545L;
    private final String query;
    private final List<UserDefinedFunction> userDefinedFunctions;

    private ViewDefinition(Builder builder) {
        super(builder);
        this.query = builder.query;
        this.userDefinedFunctions = builder.userDefinedFunctions;
    }

    public String getQuery() {
        return this.query;
    }

    public List<UserDefinedFunction> getUserDefinedFunctions() {
        return this.userDefinedFunctions;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("query", (Object)this.query).add("userDefinedFunctions", this.userDefinedFunctions);
    }

    public final boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(ViewDefinition.class) && this.baseEquals((ViewDefinition)obj);
    }

    public final int hashCode() {
        return Objects.hash(this.baseHashCode(), this.query, this.userDefinedFunctions);
    }

    @Override
    Table toPb() {
        Table tablePb = super.toPb();
        com.google.api.services.bigquery.model.ViewDefinition viewDefinition = new com.google.api.services.bigquery.model.ViewDefinition().setQuery(this.query);
        if (this.userDefinedFunctions != null) {
            viewDefinition.setUserDefinedFunctionResources(Lists.transform(this.userDefinedFunctions, UserDefinedFunction.TO_PB_FUNCTION));
        }
        tablePb.setView(viewDefinition);
        return tablePb;
    }

    public static Builder newBuilder(String query) {
        return new Builder().setQuery(query);
    }

    public static Builder newBuilder(String query, List<UserDefinedFunction> functions) {
        return ViewDefinition.newBuilder(query).setUserDefinedFunctions(functions);
    }

    public static Builder newBuilder(String query, UserDefinedFunction ... functions) {
        return ViewDefinition.newBuilder(query).setUserDefinedFunctions(functions);
    }

    public static ViewDefinition of(String query) {
        return ViewDefinition.newBuilder(query).build();
    }

    public static ViewDefinition of(String query, List<UserDefinedFunction> functions) {
        return ViewDefinition.newBuilder(query, functions).build();
    }

    public static ViewDefinition of(String query, UserDefinedFunction ... functions) {
        return ViewDefinition.newBuilder(query, functions).build();
    }

    static ViewDefinition fromPb(Table tablePb) {
        return new Builder(tablePb).build();
    }

    public static final class Builder
    extends TableDefinition.Builder<ViewDefinition, Builder> {
        private String query;
        private List<UserDefinedFunction> userDefinedFunctions;

        private Builder() {
            super(TableDefinition.Type.VIEW);
        }

        private Builder(ViewDefinition viewDefinition) {
            super(viewDefinition);
            this.query = viewDefinition.query;
            this.userDefinedFunctions = viewDefinition.userDefinedFunctions;
        }

        private Builder(Table tablePb) {
            super(tablePb);
            com.google.api.services.bigquery.model.ViewDefinition viewPb = tablePb.getView();
            if (viewPb != null) {
                this.query = viewPb.getQuery();
                if (viewPb.getUserDefinedFunctionResources() != null) {
                    this.userDefinedFunctions = Lists.transform((List)viewPb.getUserDefinedFunctionResources(), UserDefinedFunction.FROM_PB_FUNCTION);
                }
            }
        }

        public Builder setQuery(String query) {
            this.query = (String)Preconditions.checkNotNull((Object)query);
            return (Builder)this.self();
        }

        public Builder setUserDefinedFunctions(List<UserDefinedFunction> userDefinedFunctions) {
            this.userDefinedFunctions = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(userDefinedFunctions)));
            return (Builder)this.self();
        }

        public Builder setUserDefinedFunctions(UserDefinedFunction ... userDefinedFunctions) {
            this.userDefinedFunctions = ImmutableList.copyOf((Object[])userDefinedFunctions);
            return (Builder)this.self();
        }

        @Override
        public ViewDefinition build() {
            return new ViewDefinition(this);
        }
    }
}

