/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.BaseServiceException;
import com.google.cloud.RetryHelper;
import com.google.cloud.bigquery.BigQueryError;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;

public final class BigQueryException
extends BaseServiceException {
    private static final Set<BaseServiceException.Error> RETRYABLE_ERRORS = ImmutableSet.of((Object)new BaseServiceException.Error(Integer.valueOf(500), null), (Object)new BaseServiceException.Error(Integer.valueOf(502), null), (Object)new BaseServiceException.Error(Integer.valueOf(503), null), (Object)new BaseServiceException.Error(Integer.valueOf(504), null));
    private static final long serialVersionUID = -5006625989225438209L;
    private final BigQueryError error;

    public BigQueryException(int code, String message) {
        this(code, message, (Throwable)null);
    }

    public BigQueryException(int code, String message, Throwable cause) {
        super(code, message, null, true, cause);
        this.error = null;
    }

    public BigQueryException(int code, String message, BigQueryError error) {
        super(code, message, error != null ? error.getReason() : null, true);
        this.error = error;
    }

    public BigQueryException(IOException exception) {
        super(exception, true);
        BigQueryError error = null;
        if (this.getReason() != null) {
            error = new BigQueryError(this.getReason(), this.getLocation(), this.getMessage(), this.getDebugInfo());
        }
        this.error = error;
    }

    public BigQueryError getError() {
        return this.error;
    }

    protected Set<BaseServiceException.Error> getRetryableErrors() {
        return RETRYABLE_ERRORS;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BigQueryException)) {
            return false;
        }
        BigQueryException other = (BigQueryException)((Object)obj);
        return super.equals((Object)other) && Objects.equals(this.error, other.error);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.error);
    }

    static BaseServiceException translateAndThrow(RetryHelper.RetryHelperException ex) {
        BaseServiceException.translate((RetryHelper.RetryHelperException)ex);
        throw new BigQueryException(0, ex.getMessage(), ex.getCause());
    }
}

