/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.dataexchange.v1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigquery.dataexchange.v1beta1.AnalyticsHubServiceSettings;
import com.google.cloud.bigquery.dataexchange.v1beta1.CreateDataExchangeRequest;
import com.google.cloud.bigquery.dataexchange.v1beta1.CreateListingRequest;
import com.google.cloud.bigquery.dataexchange.v1beta1.DataExchange;
import com.google.cloud.bigquery.dataexchange.v1beta1.DataExchangeName;
import com.google.cloud.bigquery.dataexchange.v1beta1.DeleteDataExchangeRequest;
import com.google.cloud.bigquery.dataexchange.v1beta1.DeleteListingRequest;
import com.google.cloud.bigquery.dataexchange.v1beta1.GetDataExchangeRequest;
import com.google.cloud.bigquery.dataexchange.v1beta1.GetListingRequest;
import com.google.cloud.bigquery.dataexchange.v1beta1.ListDataExchangesRequest;
import com.google.cloud.bigquery.dataexchange.v1beta1.ListDataExchangesResponse;
import com.google.cloud.bigquery.dataexchange.v1beta1.ListListingsRequest;
import com.google.cloud.bigquery.dataexchange.v1beta1.ListListingsResponse;
import com.google.cloud.bigquery.dataexchange.v1beta1.ListOrgDataExchangesRequest;
import com.google.cloud.bigquery.dataexchange.v1beta1.ListOrgDataExchangesResponse;
import com.google.cloud.bigquery.dataexchange.v1beta1.Listing;
import com.google.cloud.bigquery.dataexchange.v1beta1.ListingName;
import com.google.cloud.bigquery.dataexchange.v1beta1.LocationName;
import com.google.cloud.bigquery.dataexchange.v1beta1.SubscribeListingRequest;
import com.google.cloud.bigquery.dataexchange.v1beta1.SubscribeListingResponse;
import com.google.cloud.bigquery.dataexchange.v1beta1.UpdateDataExchangeRequest;
import com.google.cloud.bigquery.dataexchange.v1beta1.UpdateListingRequest;
import com.google.cloud.bigquery.dataexchange.v1beta1.stub.AnalyticsHubServiceStub;
import com.google.cloud.bigquery.dataexchange.v1beta1.stub.AnalyticsHubServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class AnalyticsHubServiceClient
implements BackgroundResource {
    private final AnalyticsHubServiceSettings settings;
    private final AnalyticsHubServiceStub stub;

    public static final AnalyticsHubServiceClient create() throws IOException {
        return AnalyticsHubServiceClient.create(AnalyticsHubServiceSettings.newBuilder().build());
    }

    public static final AnalyticsHubServiceClient create(AnalyticsHubServiceSettings settings) throws IOException {
        return new AnalyticsHubServiceClient(settings);
    }

    public static final AnalyticsHubServiceClient create(AnalyticsHubServiceStub stub) {
        return new AnalyticsHubServiceClient(stub);
    }

    protected AnalyticsHubServiceClient(AnalyticsHubServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AnalyticsHubServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected AnalyticsHubServiceClient(AnalyticsHubServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AnalyticsHubServiceSettings getSettings() {
        return this.settings;
    }

    public AnalyticsHubServiceStub getStub() {
        return this.stub;
    }

    public final ListDataExchangesPagedResponse listDataExchanges(LocationName parent) {
        ListDataExchangesRequest request = ListDataExchangesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDataExchanges(request);
    }

    public final ListDataExchangesPagedResponse listDataExchanges(String parent) {
        ListDataExchangesRequest request = ListDataExchangesRequest.newBuilder().setParent(parent).build();
        return this.listDataExchanges(request);
    }

    public final ListDataExchangesPagedResponse listDataExchanges(ListDataExchangesRequest request) {
        return (ListDataExchangesPagedResponse)((Object)this.listDataExchangesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDataExchangesRequest, ListDataExchangesPagedResponse> listDataExchangesPagedCallable() {
        return this.stub.listDataExchangesPagedCallable();
    }

    public final UnaryCallable<ListDataExchangesRequest, ListDataExchangesResponse> listDataExchangesCallable() {
        return this.stub.listDataExchangesCallable();
    }

    public final ListOrgDataExchangesPagedResponse listOrgDataExchanges(String organization) {
        ListOrgDataExchangesRequest request = ListOrgDataExchangesRequest.newBuilder().setOrganization(organization).build();
        return this.listOrgDataExchanges(request);
    }

    public final ListOrgDataExchangesPagedResponse listOrgDataExchanges(ListOrgDataExchangesRequest request) {
        return (ListOrgDataExchangesPagedResponse)((Object)this.listOrgDataExchangesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListOrgDataExchangesRequest, ListOrgDataExchangesPagedResponse> listOrgDataExchangesPagedCallable() {
        return this.stub.listOrgDataExchangesPagedCallable();
    }

    public final UnaryCallable<ListOrgDataExchangesRequest, ListOrgDataExchangesResponse> listOrgDataExchangesCallable() {
        return this.stub.listOrgDataExchangesCallable();
    }

    public final DataExchange getDataExchange(DataExchangeName name) {
        GetDataExchangeRequest request = GetDataExchangeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDataExchange(request);
    }

    public final DataExchange getDataExchange(String name) {
        GetDataExchangeRequest request = GetDataExchangeRequest.newBuilder().setName(name).build();
        return this.getDataExchange(request);
    }

    public final DataExchange getDataExchange(GetDataExchangeRequest request) {
        return (DataExchange)this.getDataExchangeCallable().call((Object)request);
    }

    public final UnaryCallable<GetDataExchangeRequest, DataExchange> getDataExchangeCallable() {
        return this.stub.getDataExchangeCallable();
    }

    public final DataExchange createDataExchange(LocationName parent, DataExchange dataExchange) {
        CreateDataExchangeRequest request = CreateDataExchangeRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDataExchange(dataExchange).build();
        return this.createDataExchange(request);
    }

    public final DataExchange createDataExchange(String parent, DataExchange dataExchange) {
        CreateDataExchangeRequest request = CreateDataExchangeRequest.newBuilder().setParent(parent).setDataExchange(dataExchange).build();
        return this.createDataExchange(request);
    }

    public final DataExchange createDataExchange(CreateDataExchangeRequest request) {
        return (DataExchange)this.createDataExchangeCallable().call((Object)request);
    }

    public final UnaryCallable<CreateDataExchangeRequest, DataExchange> createDataExchangeCallable() {
        return this.stub.createDataExchangeCallable();
    }

    public final DataExchange updateDataExchange(DataExchange dataExchange, FieldMask updateMask) {
        UpdateDataExchangeRequest request = UpdateDataExchangeRequest.newBuilder().setDataExchange(dataExchange).setUpdateMask(updateMask).build();
        return this.updateDataExchange(request);
    }

    public final DataExchange updateDataExchange(UpdateDataExchangeRequest request) {
        return (DataExchange)this.updateDataExchangeCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateDataExchangeRequest, DataExchange> updateDataExchangeCallable() {
        return this.stub.updateDataExchangeCallable();
    }

    public final void deleteDataExchange(DataExchangeName name) {
        DeleteDataExchangeRequest request = DeleteDataExchangeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteDataExchange(request);
    }

    public final void deleteDataExchange(String name) {
        DeleteDataExchangeRequest request = DeleteDataExchangeRequest.newBuilder().setName(name).build();
        this.deleteDataExchange(request);
    }

    public final void deleteDataExchange(DeleteDataExchangeRequest request) {
        this.deleteDataExchangeCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteDataExchangeRequest, Empty> deleteDataExchangeCallable() {
        return this.stub.deleteDataExchangeCallable();
    }

    public final ListListingsPagedResponse listListings(DataExchangeName parent) {
        ListListingsRequest request = ListListingsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listListings(request);
    }

    public final ListListingsPagedResponse listListings(String parent) {
        ListListingsRequest request = ListListingsRequest.newBuilder().setParent(parent).build();
        return this.listListings(request);
    }

    public final ListListingsPagedResponse listListings(ListListingsRequest request) {
        return (ListListingsPagedResponse)((Object)this.listListingsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListListingsRequest, ListListingsPagedResponse> listListingsPagedCallable() {
        return this.stub.listListingsPagedCallable();
    }

    public final UnaryCallable<ListListingsRequest, ListListingsResponse> listListingsCallable() {
        return this.stub.listListingsCallable();
    }

    public final Listing getListing(ListingName name) {
        GetListingRequest request = GetListingRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getListing(request);
    }

    public final Listing getListing(String name) {
        GetListingRequest request = GetListingRequest.newBuilder().setName(name).build();
        return this.getListing(request);
    }

    public final Listing getListing(GetListingRequest request) {
        return (Listing)this.getListingCallable().call((Object)request);
    }

    public final UnaryCallable<GetListingRequest, Listing> getListingCallable() {
        return this.stub.getListingCallable();
    }

    public final Listing createListing(DataExchangeName parent, Listing listing) {
        CreateListingRequest request = CreateListingRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setListing(listing).build();
        return this.createListing(request);
    }

    public final Listing createListing(String parent, Listing listing) {
        CreateListingRequest request = CreateListingRequest.newBuilder().setParent(parent).setListing(listing).build();
        return this.createListing(request);
    }

    public final Listing createListing(CreateListingRequest request) {
        return (Listing)this.createListingCallable().call((Object)request);
    }

    public final UnaryCallable<CreateListingRequest, Listing> createListingCallable() {
        return this.stub.createListingCallable();
    }

    public final Listing updateListing(Listing listing, FieldMask updateMask) {
        UpdateListingRequest request = UpdateListingRequest.newBuilder().setListing(listing).setUpdateMask(updateMask).build();
        return this.updateListing(request);
    }

    public final Listing updateListing(UpdateListingRequest request) {
        return (Listing)this.updateListingCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateListingRequest, Listing> updateListingCallable() {
        return this.stub.updateListingCallable();
    }

    public final void deleteListing(ListingName name) {
        DeleteListingRequest request = DeleteListingRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteListing(request);
    }

    public final void deleteListing(String name) {
        DeleteListingRequest request = DeleteListingRequest.newBuilder().setName(name).build();
        this.deleteListing(request);
    }

    public final void deleteListing(DeleteListingRequest request) {
        this.deleteListingCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteListingRequest, Empty> deleteListingCallable() {
        return this.stub.deleteListingCallable();
    }

    public final SubscribeListingResponse subscribeListing(ListingName name) {
        SubscribeListingRequest request = SubscribeListingRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.subscribeListing(request);
    }

    public final SubscribeListingResponse subscribeListing(String name) {
        SubscribeListingRequest request = SubscribeListingRequest.newBuilder().setName(name).build();
        return this.subscribeListing(request);
    }

    public final SubscribeListingResponse subscribeListing(SubscribeListingRequest request) {
        return (SubscribeListingResponse)this.subscribeListingCallable().call((Object)request);
    }

    public final UnaryCallable<SubscribeListingRequest, SubscribeListingResponse> subscribeListingCallable() {
        return this.stub.subscribeListingCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListListingsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListListingsRequest, ListListingsResponse, Listing, ListListingsPage, ListListingsFixedSizeCollection> {
        private ListListingsFixedSizeCollection(List<ListListingsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListListingsFixedSizeCollection createEmptyCollection() {
            return new ListListingsFixedSizeCollection(null, 0);
        }

        protected ListListingsFixedSizeCollection createCollection(List<ListListingsPage> pages, int collectionSize) {
            return new ListListingsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListListingsPage
    extends AbstractPage<ListListingsRequest, ListListingsResponse, Listing, ListListingsPage> {
        private ListListingsPage(PageContext<ListListingsRequest, ListListingsResponse, Listing> context, ListListingsResponse response) {
            super(context, (Object)response);
        }

        private static ListListingsPage createEmptyPage() {
            return new ListListingsPage(null, null);
        }

        protected ListListingsPage createPage(PageContext<ListListingsRequest, ListListingsResponse, Listing> context, ListListingsResponse response) {
            return new ListListingsPage(context, response);
        }

        public ApiFuture<ListListingsPage> createPageAsync(PageContext<ListListingsRequest, ListListingsResponse, Listing> context, ApiFuture<ListListingsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListListingsPagedResponse
    extends AbstractPagedListResponse<ListListingsRequest, ListListingsResponse, Listing, ListListingsPage, ListListingsFixedSizeCollection> {
        public static ApiFuture<ListListingsPagedResponse> createAsync(PageContext<ListListingsRequest, ListListingsResponse, Listing> context, ApiFuture<ListListingsResponse> futureResponse) {
            ApiFuture<ListListingsPage> futurePage = ListListingsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListListingsPagedResponse((ListListingsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListListingsPagedResponse(ListListingsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListListingsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListOrgDataExchangesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListOrgDataExchangesRequest, ListOrgDataExchangesResponse, DataExchange, ListOrgDataExchangesPage, ListOrgDataExchangesFixedSizeCollection> {
        private ListOrgDataExchangesFixedSizeCollection(List<ListOrgDataExchangesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListOrgDataExchangesFixedSizeCollection createEmptyCollection() {
            return new ListOrgDataExchangesFixedSizeCollection(null, 0);
        }

        protected ListOrgDataExchangesFixedSizeCollection createCollection(List<ListOrgDataExchangesPage> pages, int collectionSize) {
            return new ListOrgDataExchangesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListOrgDataExchangesPage
    extends AbstractPage<ListOrgDataExchangesRequest, ListOrgDataExchangesResponse, DataExchange, ListOrgDataExchangesPage> {
        private ListOrgDataExchangesPage(PageContext<ListOrgDataExchangesRequest, ListOrgDataExchangesResponse, DataExchange> context, ListOrgDataExchangesResponse response) {
            super(context, (Object)response);
        }

        private static ListOrgDataExchangesPage createEmptyPage() {
            return new ListOrgDataExchangesPage(null, null);
        }

        protected ListOrgDataExchangesPage createPage(PageContext<ListOrgDataExchangesRequest, ListOrgDataExchangesResponse, DataExchange> context, ListOrgDataExchangesResponse response) {
            return new ListOrgDataExchangesPage(context, response);
        }

        public ApiFuture<ListOrgDataExchangesPage> createPageAsync(PageContext<ListOrgDataExchangesRequest, ListOrgDataExchangesResponse, DataExchange> context, ApiFuture<ListOrgDataExchangesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListOrgDataExchangesPagedResponse
    extends AbstractPagedListResponse<ListOrgDataExchangesRequest, ListOrgDataExchangesResponse, DataExchange, ListOrgDataExchangesPage, ListOrgDataExchangesFixedSizeCollection> {
        public static ApiFuture<ListOrgDataExchangesPagedResponse> createAsync(PageContext<ListOrgDataExchangesRequest, ListOrgDataExchangesResponse, DataExchange> context, ApiFuture<ListOrgDataExchangesResponse> futureResponse) {
            ApiFuture<ListOrgDataExchangesPage> futurePage = ListOrgDataExchangesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListOrgDataExchangesPagedResponse((ListOrgDataExchangesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListOrgDataExchangesPagedResponse(ListOrgDataExchangesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListOrgDataExchangesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDataExchangesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDataExchangesRequest, ListDataExchangesResponse, DataExchange, ListDataExchangesPage, ListDataExchangesFixedSizeCollection> {
        private ListDataExchangesFixedSizeCollection(List<ListDataExchangesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDataExchangesFixedSizeCollection createEmptyCollection() {
            return new ListDataExchangesFixedSizeCollection(null, 0);
        }

        protected ListDataExchangesFixedSizeCollection createCollection(List<ListDataExchangesPage> pages, int collectionSize) {
            return new ListDataExchangesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDataExchangesPage
    extends AbstractPage<ListDataExchangesRequest, ListDataExchangesResponse, DataExchange, ListDataExchangesPage> {
        private ListDataExchangesPage(PageContext<ListDataExchangesRequest, ListDataExchangesResponse, DataExchange> context, ListDataExchangesResponse response) {
            super(context, (Object)response);
        }

        private static ListDataExchangesPage createEmptyPage() {
            return new ListDataExchangesPage(null, null);
        }

        protected ListDataExchangesPage createPage(PageContext<ListDataExchangesRequest, ListDataExchangesResponse, DataExchange> context, ListDataExchangesResponse response) {
            return new ListDataExchangesPage(context, response);
        }

        public ApiFuture<ListDataExchangesPage> createPageAsync(PageContext<ListDataExchangesRequest, ListDataExchangesResponse, DataExchange> context, ApiFuture<ListDataExchangesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDataExchangesPagedResponse
    extends AbstractPagedListResponse<ListDataExchangesRequest, ListDataExchangesResponse, DataExchange, ListDataExchangesPage, ListDataExchangesFixedSizeCollection> {
        public static ApiFuture<ListDataExchangesPagedResponse> createAsync(PageContext<ListDataExchangesRequest, ListDataExchangesResponse, DataExchange> context, ApiFuture<ListDataExchangesResponse> futureResponse) {
            ApiFuture<ListDataExchangesPage> futurePage = ListDataExchangesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDataExchangesPagedResponse((ListDataExchangesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDataExchangesPagedResponse(ListDataExchangesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDataExchangesFixedSizeCollection.createEmptyCollection());
        }
    }
}

