/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.batch.v1alpha.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.batch.v1alpha.BatchServiceClient;
import com.google.cloud.batch.v1alpha.CreateJobRequest;
import com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest;
import com.google.cloud.batch.v1alpha.DeleteJobRequest;
import com.google.cloud.batch.v1alpha.DeleteResourceAllowanceRequest;
import com.google.cloud.batch.v1alpha.GetJobRequest;
import com.google.cloud.batch.v1alpha.GetResourceAllowanceRequest;
import com.google.cloud.batch.v1alpha.GetTaskRequest;
import com.google.cloud.batch.v1alpha.Job;
import com.google.cloud.batch.v1alpha.ListJobsRequest;
import com.google.cloud.batch.v1alpha.ListJobsResponse;
import com.google.cloud.batch.v1alpha.ListResourceAllowancesRequest;
import com.google.cloud.batch.v1alpha.ListResourceAllowancesResponse;
import com.google.cloud.batch.v1alpha.ListTasksRequest;
import com.google.cloud.batch.v1alpha.ListTasksResponse;
import com.google.cloud.batch.v1alpha.OperationMetadata;
import com.google.cloud.batch.v1alpha.ResourceAllowance;
import com.google.cloud.batch.v1alpha.Task;
import com.google.cloud.batch.v1alpha.UpdateJobRequest;
import com.google.cloud.batch.v1alpha.UpdateResourceAllowanceRequest;
import com.google.cloud.batch.v1alpha.stub.BatchServiceStub;
import com.google.cloud.batch.v1alpha.stub.GrpcBatchServiceStub;
import com.google.cloud.batch.v1alpha.stub.HttpJsonBatchServiceStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class BatchServiceStubSettings
extends StubSettings<BatchServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateJobRequest, Job> createJobSettings;
    private final UnaryCallSettings<GetJobRequest, Job> getJobSettings;
    private final UnaryCallSettings<DeleteJobRequest, Operation> deleteJobSettings;
    private final OperationCallSettings<DeleteJobRequest, Empty, OperationMetadata> deleteJobOperationSettings;
    private final UnaryCallSettings<UpdateJobRequest, Job> updateJobSettings;
    private final PagedCallSettings<ListJobsRequest, ListJobsResponse, BatchServiceClient.ListJobsPagedResponse> listJobsSettings;
    private final UnaryCallSettings<GetTaskRequest, Task> getTaskSettings;
    private final PagedCallSettings<ListTasksRequest, ListTasksResponse, BatchServiceClient.ListTasksPagedResponse> listTasksSettings;
    private final UnaryCallSettings<CreateResourceAllowanceRequest, ResourceAllowance> createResourceAllowanceSettings;
    private final UnaryCallSettings<GetResourceAllowanceRequest, ResourceAllowance> getResourceAllowanceSettings;
    private final UnaryCallSettings<DeleteResourceAllowanceRequest, Operation> deleteResourceAllowanceSettings;
    private final OperationCallSettings<DeleteResourceAllowanceRequest, Empty, OperationMetadata> deleteResourceAllowanceOperationSettings;
    private final PagedCallSettings<ListResourceAllowancesRequest, ListResourceAllowancesResponse, BatchServiceClient.ListResourceAllowancesPagedResponse> listResourceAllowancesSettings;
    private final UnaryCallSettings<UpdateResourceAllowanceRequest, ResourceAllowance> updateResourceAllowanceSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, BatchServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListJobsRequest, ListJobsResponse, Job> LIST_JOBS_PAGE_STR_DESC = new PagedListDescriptor<ListJobsRequest, ListJobsResponse, Job>(){

        public String emptyToken() {
            return "";
        }

        public ListJobsRequest injectToken(ListJobsRequest payload, String token) {
            return ListJobsRequest.newBuilder((ListJobsRequest)payload).setPageToken(token).build();
        }

        public ListJobsRequest injectPageSize(ListJobsRequest payload, int pageSize) {
            return ListJobsRequest.newBuilder((ListJobsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListJobsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListJobsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Job> extractResources(ListJobsResponse payload) {
            return payload.getJobsList() == null ? ImmutableList.of() : payload.getJobsList();
        }
    };
    private static final PagedListDescriptor<ListTasksRequest, ListTasksResponse, Task> LIST_TASKS_PAGE_STR_DESC = new PagedListDescriptor<ListTasksRequest, ListTasksResponse, Task>(){

        public String emptyToken() {
            return "";
        }

        public ListTasksRequest injectToken(ListTasksRequest payload, String token) {
            return ListTasksRequest.newBuilder((ListTasksRequest)payload).setPageToken(token).build();
        }

        public ListTasksRequest injectPageSize(ListTasksRequest payload, int pageSize) {
            return ListTasksRequest.newBuilder((ListTasksRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTasksRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTasksResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Task> extractResources(ListTasksResponse payload) {
            return payload.getTasksList() == null ? ImmutableList.of() : payload.getTasksList();
        }
    };
    private static final PagedListDescriptor<ListResourceAllowancesRequest, ListResourceAllowancesResponse, ResourceAllowance> LIST_RESOURCE_ALLOWANCES_PAGE_STR_DESC = new PagedListDescriptor<ListResourceAllowancesRequest, ListResourceAllowancesResponse, ResourceAllowance>(){

        public String emptyToken() {
            return "";
        }

        public ListResourceAllowancesRequest injectToken(ListResourceAllowancesRequest payload, String token) {
            return ListResourceAllowancesRequest.newBuilder((ListResourceAllowancesRequest)payload).setPageToken(token).build();
        }

        public ListResourceAllowancesRequest injectPageSize(ListResourceAllowancesRequest payload, int pageSize) {
            return ListResourceAllowancesRequest.newBuilder((ListResourceAllowancesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListResourceAllowancesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListResourceAllowancesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ResourceAllowance> extractResources(ListResourceAllowancesResponse payload) {
            return payload.getResourceAllowancesList() == null ? ImmutableList.of() : payload.getResourceAllowancesList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListJobsRequest, ListJobsResponse, BatchServiceClient.ListJobsPagedResponse> LIST_JOBS_PAGE_STR_FACT = new PagedListResponseFactory<ListJobsRequest, ListJobsResponse, BatchServiceClient.ListJobsPagedResponse>(){

        public ApiFuture<BatchServiceClient.ListJobsPagedResponse> getFuturePagedResponse(UnaryCallable<ListJobsRequest, ListJobsResponse> callable, ListJobsRequest request, ApiCallContext context, ApiFuture<ListJobsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_JOBS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BatchServiceClient.ListJobsPagedResponse.createAsync((PageContext<ListJobsRequest, ListJobsResponse, Job>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListTasksRequest, ListTasksResponse, BatchServiceClient.ListTasksPagedResponse> LIST_TASKS_PAGE_STR_FACT = new PagedListResponseFactory<ListTasksRequest, ListTasksResponse, BatchServiceClient.ListTasksPagedResponse>(){

        public ApiFuture<BatchServiceClient.ListTasksPagedResponse> getFuturePagedResponse(UnaryCallable<ListTasksRequest, ListTasksResponse> callable, ListTasksRequest request, ApiCallContext context, ApiFuture<ListTasksResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TASKS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BatchServiceClient.ListTasksPagedResponse.createAsync((PageContext<ListTasksRequest, ListTasksResponse, Task>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListResourceAllowancesRequest, ListResourceAllowancesResponse, BatchServiceClient.ListResourceAllowancesPagedResponse> LIST_RESOURCE_ALLOWANCES_PAGE_STR_FACT = new PagedListResponseFactory<ListResourceAllowancesRequest, ListResourceAllowancesResponse, BatchServiceClient.ListResourceAllowancesPagedResponse>(){

        public ApiFuture<BatchServiceClient.ListResourceAllowancesPagedResponse> getFuturePagedResponse(UnaryCallable<ListResourceAllowancesRequest, ListResourceAllowancesResponse> callable, ListResourceAllowancesRequest request, ApiCallContext context, ApiFuture<ListResourceAllowancesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_RESOURCE_ALLOWANCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BatchServiceClient.ListResourceAllowancesPagedResponse.createAsync((PageContext<ListResourceAllowancesRequest, ListResourceAllowancesResponse, ResourceAllowance>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, BatchServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, BatchServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<BatchServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BatchServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateJobRequest, Job> createJobSettings() {
        return this.createJobSettings;
    }

    public UnaryCallSettings<GetJobRequest, Job> getJobSettings() {
        return this.getJobSettings;
    }

    public UnaryCallSettings<DeleteJobRequest, Operation> deleteJobSettings() {
        return this.deleteJobSettings;
    }

    public OperationCallSettings<DeleteJobRequest, Empty, OperationMetadata> deleteJobOperationSettings() {
        return this.deleteJobOperationSettings;
    }

    public UnaryCallSettings<UpdateJobRequest, Job> updateJobSettings() {
        return this.updateJobSettings;
    }

    public PagedCallSettings<ListJobsRequest, ListJobsResponse, BatchServiceClient.ListJobsPagedResponse> listJobsSettings() {
        return this.listJobsSettings;
    }

    public UnaryCallSettings<GetTaskRequest, Task> getTaskSettings() {
        return this.getTaskSettings;
    }

    public PagedCallSettings<ListTasksRequest, ListTasksResponse, BatchServiceClient.ListTasksPagedResponse> listTasksSettings() {
        return this.listTasksSettings;
    }

    public UnaryCallSettings<CreateResourceAllowanceRequest, ResourceAllowance> createResourceAllowanceSettings() {
        return this.createResourceAllowanceSettings;
    }

    public UnaryCallSettings<GetResourceAllowanceRequest, ResourceAllowance> getResourceAllowanceSettings() {
        return this.getResourceAllowanceSettings;
    }

    public UnaryCallSettings<DeleteResourceAllowanceRequest, Operation> deleteResourceAllowanceSettings() {
        return this.deleteResourceAllowanceSettings;
    }

    public OperationCallSettings<DeleteResourceAllowanceRequest, Empty, OperationMetadata> deleteResourceAllowanceOperationSettings() {
        return this.deleteResourceAllowanceOperationSettings;
    }

    public PagedCallSettings<ListResourceAllowancesRequest, ListResourceAllowancesResponse, BatchServiceClient.ListResourceAllowancesPagedResponse> listResourceAllowancesSettings() {
        return this.listResourceAllowancesSettings;
    }

    public UnaryCallSettings<UpdateResourceAllowanceRequest, ResourceAllowance> updateResourceAllowanceSettings() {
        return this.updateResourceAllowanceSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, BatchServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public BatchServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcBatchServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonBatchServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "batch";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "batch.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "batch.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return BatchServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(BatchServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(BatchServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return BatchServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected BatchServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createJobSettings = settingsBuilder.createJobSettings().build();
        this.getJobSettings = settingsBuilder.getJobSettings().build();
        this.deleteJobSettings = settingsBuilder.deleteJobSettings().build();
        this.deleteJobOperationSettings = settingsBuilder.deleteJobOperationSettings().build();
        this.updateJobSettings = settingsBuilder.updateJobSettings().build();
        this.listJobsSettings = settingsBuilder.listJobsSettings().build();
        this.getTaskSettings = settingsBuilder.getTaskSettings().build();
        this.listTasksSettings = settingsBuilder.listTasksSettings().build();
        this.createResourceAllowanceSettings = settingsBuilder.createResourceAllowanceSettings().build();
        this.getResourceAllowanceSettings = settingsBuilder.getResourceAllowanceSettings().build();
        this.deleteResourceAllowanceSettings = settingsBuilder.deleteResourceAllowanceSettings().build();
        this.deleteResourceAllowanceOperationSettings = settingsBuilder.deleteResourceAllowanceOperationSettings().build();
        this.listResourceAllowancesSettings = settingsBuilder.listResourceAllowancesSettings().build();
        this.updateResourceAllowanceSettings = settingsBuilder.updateResourceAllowanceSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<BatchServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateJobRequest, Job> createJobSettings;
        private final UnaryCallSettings.Builder<GetJobRequest, Job> getJobSettings;
        private final UnaryCallSettings.Builder<DeleteJobRequest, Operation> deleteJobSettings;
        private final OperationCallSettings.Builder<DeleteJobRequest, Empty, OperationMetadata> deleteJobOperationSettings;
        private final UnaryCallSettings.Builder<UpdateJobRequest, Job> updateJobSettings;
        private final PagedCallSettings.Builder<ListJobsRequest, ListJobsResponse, BatchServiceClient.ListJobsPagedResponse> listJobsSettings;
        private final UnaryCallSettings.Builder<GetTaskRequest, Task> getTaskSettings;
        private final PagedCallSettings.Builder<ListTasksRequest, ListTasksResponse, BatchServiceClient.ListTasksPagedResponse> listTasksSettings;
        private final UnaryCallSettings.Builder<CreateResourceAllowanceRequest, ResourceAllowance> createResourceAllowanceSettings;
        private final UnaryCallSettings.Builder<GetResourceAllowanceRequest, ResourceAllowance> getResourceAllowanceSettings;
        private final UnaryCallSettings.Builder<DeleteResourceAllowanceRequest, Operation> deleteResourceAllowanceSettings;
        private final OperationCallSettings.Builder<DeleteResourceAllowanceRequest, Empty, OperationMetadata> deleteResourceAllowanceOperationSettings;
        private final PagedCallSettings.Builder<ListResourceAllowancesRequest, ListResourceAllowancesResponse, BatchServiceClient.ListResourceAllowancesPagedResponse> listResourceAllowancesSettings;
        private final UnaryCallSettings.Builder<UpdateResourceAllowanceRequest, ResourceAllowance> updateResourceAllowanceSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, BatchServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteJobOperationSettings = OperationCallSettings.newBuilder();
            this.updateJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listJobsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_JOBS_PAGE_STR_FACT);
            this.getTaskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTasksSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TASKS_PAGE_STR_FACT);
            this.createResourceAllowanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getResourceAllowanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteResourceAllowanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteResourceAllowanceOperationSettings = OperationCallSettings.newBuilder();
            this.listResourceAllowancesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_RESOURCE_ALLOWANCES_PAGE_STR_FACT);
            this.updateResourceAllowanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createJobSettings, this.getJobSettings, this.deleteJobSettings, this.updateJobSettings, this.listJobsSettings, this.getTaskSettings, this.listTasksSettings, this.createResourceAllowanceSettings, this.getResourceAllowanceSettings, this.deleteResourceAllowanceSettings, this.listResourceAllowancesSettings, this.updateResourceAllowanceSettings, (Object[])new UnaryCallSettings.Builder[]{this.listLocationsSettings, this.getLocationSettings});
            Builder.initDefaults(this);
        }

        protected Builder(BatchServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createJobSettings = settings.createJobSettings.toBuilder();
            this.getJobSettings = settings.getJobSettings.toBuilder();
            this.deleteJobSettings = settings.deleteJobSettings.toBuilder();
            this.deleteJobOperationSettings = settings.deleteJobOperationSettings.toBuilder();
            this.updateJobSettings = settings.updateJobSettings.toBuilder();
            this.listJobsSettings = settings.listJobsSettings.toBuilder();
            this.getTaskSettings = settings.getTaskSettings.toBuilder();
            this.listTasksSettings = settings.listTasksSettings.toBuilder();
            this.createResourceAllowanceSettings = settings.createResourceAllowanceSettings.toBuilder();
            this.getResourceAllowanceSettings = settings.getResourceAllowanceSettings.toBuilder();
            this.deleteResourceAllowanceSettings = settings.deleteResourceAllowanceSettings.toBuilder();
            this.deleteResourceAllowanceOperationSettings = settings.deleteResourceAllowanceOperationSettings.toBuilder();
            this.listResourceAllowancesSettings = settings.listResourceAllowancesSettings.toBuilder();
            this.updateResourceAllowanceSettings = settings.updateResourceAllowanceSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createJobSettings, this.getJobSettings, this.deleteJobSettings, this.updateJobSettings, this.listJobsSettings, this.getTaskSettings, this.listTasksSettings, this.createResourceAllowanceSettings, this.getResourceAllowanceSettings, this.deleteResourceAllowanceSettings, this.listResourceAllowancesSettings, this.updateResourceAllowanceSettings, (Object[])new UnaryCallSettings.Builder[]{this.listLocationsSettings, this.getLocationSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(BatchServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)BatchServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)BatchServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(BatchServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)BatchServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)BatchServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)BatchServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(BatchServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listJobsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getTaskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listTasksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createResourceAllowanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getResourceAllowanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteResourceAllowanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listResourceAllowancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateResourceAllowanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteJobOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteResourceAllowanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateJobRequest, Job> createJobSettings() {
            return this.createJobSettings;
        }

        public UnaryCallSettings.Builder<GetJobRequest, Job> getJobSettings() {
            return this.getJobSettings;
        }

        public UnaryCallSettings.Builder<DeleteJobRequest, Operation> deleteJobSettings() {
            return this.deleteJobSettings;
        }

        public OperationCallSettings.Builder<DeleteJobRequest, Empty, OperationMetadata> deleteJobOperationSettings() {
            return this.deleteJobOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateJobRequest, Job> updateJobSettings() {
            return this.updateJobSettings;
        }

        public PagedCallSettings.Builder<ListJobsRequest, ListJobsResponse, BatchServiceClient.ListJobsPagedResponse> listJobsSettings() {
            return this.listJobsSettings;
        }

        public UnaryCallSettings.Builder<GetTaskRequest, Task> getTaskSettings() {
            return this.getTaskSettings;
        }

        public PagedCallSettings.Builder<ListTasksRequest, ListTasksResponse, BatchServiceClient.ListTasksPagedResponse> listTasksSettings() {
            return this.listTasksSettings;
        }

        public UnaryCallSettings.Builder<CreateResourceAllowanceRequest, ResourceAllowance> createResourceAllowanceSettings() {
            return this.createResourceAllowanceSettings;
        }

        public UnaryCallSettings.Builder<GetResourceAllowanceRequest, ResourceAllowance> getResourceAllowanceSettings() {
            return this.getResourceAllowanceSettings;
        }

        public UnaryCallSettings.Builder<DeleteResourceAllowanceRequest, Operation> deleteResourceAllowanceSettings() {
            return this.deleteResourceAllowanceSettings;
        }

        public OperationCallSettings.Builder<DeleteResourceAllowanceRequest, Empty, OperationMetadata> deleteResourceAllowanceOperationSettings() {
            return this.deleteResourceAllowanceOperationSettings;
        }

        public PagedCallSettings.Builder<ListResourceAllowancesRequest, ListResourceAllowancesResponse, BatchServiceClient.ListResourceAllowancesPagedResponse> listResourceAllowancesSettings() {
            return this.listResourceAllowancesSettings;
        }

        public UnaryCallSettings.Builder<UpdateResourceAllowanceRequest, ResourceAllowance> updateResourceAllowanceSettings() {
            return this.updateResourceAllowanceSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, BatchServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public BatchServiceStubSettings build() throws IOException {
            return new BatchServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

