/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.baremetalsolution.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.baremetalsolution.v2.BareMetalSolutionClient;
import com.google.cloud.baremetalsolution.v2.DetachLunRequest;
import com.google.cloud.baremetalsolution.v2.GetInstanceRequest;
import com.google.cloud.baremetalsolution.v2.GetLunRequest;
import com.google.cloud.baremetalsolution.v2.GetNetworkRequest;
import com.google.cloud.baremetalsolution.v2.GetNfsShareRequest;
import com.google.cloud.baremetalsolution.v2.GetVolumeRequest;
import com.google.cloud.baremetalsolution.v2.Instance;
import com.google.cloud.baremetalsolution.v2.ListInstancesRequest;
import com.google.cloud.baremetalsolution.v2.ListInstancesResponse;
import com.google.cloud.baremetalsolution.v2.ListLunsRequest;
import com.google.cloud.baremetalsolution.v2.ListLunsResponse;
import com.google.cloud.baremetalsolution.v2.ListNetworkUsageRequest;
import com.google.cloud.baremetalsolution.v2.ListNetworkUsageResponse;
import com.google.cloud.baremetalsolution.v2.ListNetworksRequest;
import com.google.cloud.baremetalsolution.v2.ListNetworksResponse;
import com.google.cloud.baremetalsolution.v2.ListNfsSharesRequest;
import com.google.cloud.baremetalsolution.v2.ListNfsSharesResponse;
import com.google.cloud.baremetalsolution.v2.ListVolumesRequest;
import com.google.cloud.baremetalsolution.v2.ListVolumesResponse;
import com.google.cloud.baremetalsolution.v2.Lun;
import com.google.cloud.baremetalsolution.v2.Network;
import com.google.cloud.baremetalsolution.v2.NfsShare;
import com.google.cloud.baremetalsolution.v2.OperationMetadata;
import com.google.cloud.baremetalsolution.v2.ResetInstanceRequest;
import com.google.cloud.baremetalsolution.v2.ResetInstanceResponse;
import com.google.cloud.baremetalsolution.v2.ResizeVolumeRequest;
import com.google.cloud.baremetalsolution.v2.StartInstanceRequest;
import com.google.cloud.baremetalsolution.v2.StartInstanceResponse;
import com.google.cloud.baremetalsolution.v2.StopInstanceRequest;
import com.google.cloud.baremetalsolution.v2.StopInstanceResponse;
import com.google.cloud.baremetalsolution.v2.UpdateInstanceRequest;
import com.google.cloud.baremetalsolution.v2.UpdateNetworkRequest;
import com.google.cloud.baremetalsolution.v2.UpdateNfsShareRequest;
import com.google.cloud.baremetalsolution.v2.UpdateVolumeRequest;
import com.google.cloud.baremetalsolution.v2.Volume;
import com.google.cloud.baremetalsolution.v2.stub.BareMetalSolutionStub;
import com.google.cloud.baremetalsolution.v2.stub.GrpcBareMetalSolutionStub;
import com.google.cloud.baremetalsolution.v2.stub.HttpJsonBareMetalSolutionStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class BareMetalSolutionStubSettings
extends StubSettings<BareMetalSolutionStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListInstancesRequest, ListInstancesResponse, BareMetalSolutionClient.ListInstancesPagedResponse> listInstancesSettings;
    private final UnaryCallSettings<GetInstanceRequest, Instance> getInstanceSettings;
    private final UnaryCallSettings<UpdateInstanceRequest, Operation> updateInstanceSettings;
    private final OperationCallSettings<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationSettings;
    private final UnaryCallSettings<ResetInstanceRequest, Operation> resetInstanceSettings;
    private final OperationCallSettings<ResetInstanceRequest, ResetInstanceResponse, OperationMetadata> resetInstanceOperationSettings;
    private final UnaryCallSettings<StartInstanceRequest, Operation> startInstanceSettings;
    private final OperationCallSettings<StartInstanceRequest, StartInstanceResponse, OperationMetadata> startInstanceOperationSettings;
    private final UnaryCallSettings<StopInstanceRequest, Operation> stopInstanceSettings;
    private final OperationCallSettings<StopInstanceRequest, StopInstanceResponse, OperationMetadata> stopInstanceOperationSettings;
    private final UnaryCallSettings<DetachLunRequest, Operation> detachLunSettings;
    private final OperationCallSettings<DetachLunRequest, Instance, OperationMetadata> detachLunOperationSettings;
    private final PagedCallSettings<ListVolumesRequest, ListVolumesResponse, BareMetalSolutionClient.ListVolumesPagedResponse> listVolumesSettings;
    private final UnaryCallSettings<GetVolumeRequest, Volume> getVolumeSettings;
    private final UnaryCallSettings<UpdateVolumeRequest, Operation> updateVolumeSettings;
    private final OperationCallSettings<UpdateVolumeRequest, Volume, OperationMetadata> updateVolumeOperationSettings;
    private final UnaryCallSettings<ResizeVolumeRequest, Operation> resizeVolumeSettings;
    private final OperationCallSettings<ResizeVolumeRequest, Volume, OperationMetadata> resizeVolumeOperationSettings;
    private final PagedCallSettings<ListNetworksRequest, ListNetworksResponse, BareMetalSolutionClient.ListNetworksPagedResponse> listNetworksSettings;
    private final UnaryCallSettings<ListNetworkUsageRequest, ListNetworkUsageResponse> listNetworkUsageSettings;
    private final UnaryCallSettings<GetNetworkRequest, Network> getNetworkSettings;
    private final UnaryCallSettings<UpdateNetworkRequest, Operation> updateNetworkSettings;
    private final OperationCallSettings<UpdateNetworkRequest, Network, OperationMetadata> updateNetworkOperationSettings;
    private final UnaryCallSettings<GetLunRequest, Lun> getLunSettings;
    private final PagedCallSettings<ListLunsRequest, ListLunsResponse, BareMetalSolutionClient.ListLunsPagedResponse> listLunsSettings;
    private final UnaryCallSettings<GetNfsShareRequest, NfsShare> getNfsShareSettings;
    private final PagedCallSettings<ListNfsSharesRequest, ListNfsSharesResponse, BareMetalSolutionClient.ListNfsSharesPagedResponse> listNfsSharesSettings;
    private final UnaryCallSettings<UpdateNfsShareRequest, Operation> updateNfsShareSettings;
    private final OperationCallSettings<UpdateNfsShareRequest, NfsShare, OperationMetadata> updateNfsShareOperationSettings;
    private static final PagedListDescriptor<ListInstancesRequest, ListInstancesResponse, Instance> LIST_INSTANCES_PAGE_STR_DESC = new PagedListDescriptor<ListInstancesRequest, ListInstancesResponse, Instance>(){

        public String emptyToken() {
            return "";
        }

        public ListInstancesRequest injectToken(ListInstancesRequest payload, String token) {
            return ListInstancesRequest.newBuilder((ListInstancesRequest)payload).setPageToken(token).build();
        }

        public ListInstancesRequest injectPageSize(ListInstancesRequest payload, int pageSize) {
            return ListInstancesRequest.newBuilder((ListInstancesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListInstancesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListInstancesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Instance> extractResources(ListInstancesResponse payload) {
            return payload.getInstancesList() == null ? ImmutableList.of() : payload.getInstancesList();
        }
    };
    private static final PagedListDescriptor<ListVolumesRequest, ListVolumesResponse, Volume> LIST_VOLUMES_PAGE_STR_DESC = new PagedListDescriptor<ListVolumesRequest, ListVolumesResponse, Volume>(){

        public String emptyToken() {
            return "";
        }

        public ListVolumesRequest injectToken(ListVolumesRequest payload, String token) {
            return ListVolumesRequest.newBuilder((ListVolumesRequest)payload).setPageToken(token).build();
        }

        public ListVolumesRequest injectPageSize(ListVolumesRequest payload, int pageSize) {
            return ListVolumesRequest.newBuilder((ListVolumesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListVolumesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListVolumesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Volume> extractResources(ListVolumesResponse payload) {
            return payload.getVolumesList() == null ? ImmutableList.of() : payload.getVolumesList();
        }
    };
    private static final PagedListDescriptor<ListNetworksRequest, ListNetworksResponse, Network> LIST_NETWORKS_PAGE_STR_DESC = new PagedListDescriptor<ListNetworksRequest, ListNetworksResponse, Network>(){

        public String emptyToken() {
            return "";
        }

        public ListNetworksRequest injectToken(ListNetworksRequest payload, String token) {
            return ListNetworksRequest.newBuilder((ListNetworksRequest)payload).setPageToken(token).build();
        }

        public ListNetworksRequest injectPageSize(ListNetworksRequest payload, int pageSize) {
            return ListNetworksRequest.newBuilder((ListNetworksRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListNetworksRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListNetworksResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Network> extractResources(ListNetworksResponse payload) {
            return payload.getNetworksList() == null ? ImmutableList.of() : payload.getNetworksList();
        }
    };
    private static final PagedListDescriptor<ListLunsRequest, ListLunsResponse, Lun> LIST_LUNS_PAGE_STR_DESC = new PagedListDescriptor<ListLunsRequest, ListLunsResponse, Lun>(){

        public String emptyToken() {
            return "";
        }

        public ListLunsRequest injectToken(ListLunsRequest payload, String token) {
            return ListLunsRequest.newBuilder((ListLunsRequest)payload).setPageToken(token).build();
        }

        public ListLunsRequest injectPageSize(ListLunsRequest payload, int pageSize) {
            return ListLunsRequest.newBuilder((ListLunsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLunsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLunsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Lun> extractResources(ListLunsResponse payload) {
            return payload.getLunsList() == null ? ImmutableList.of() : payload.getLunsList();
        }
    };
    private static final PagedListDescriptor<ListNfsSharesRequest, ListNfsSharesResponse, NfsShare> LIST_NFS_SHARES_PAGE_STR_DESC = new PagedListDescriptor<ListNfsSharesRequest, ListNfsSharesResponse, NfsShare>(){

        public String emptyToken() {
            return "";
        }

        public ListNfsSharesRequest injectToken(ListNfsSharesRequest payload, String token) {
            return ListNfsSharesRequest.newBuilder((ListNfsSharesRequest)payload).setPageToken(token).build();
        }

        public ListNfsSharesRequest injectPageSize(ListNfsSharesRequest payload, int pageSize) {
            return ListNfsSharesRequest.newBuilder((ListNfsSharesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListNfsSharesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListNfsSharesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<NfsShare> extractResources(ListNfsSharesResponse payload) {
            return payload.getNfsSharesList() == null ? ImmutableList.of() : payload.getNfsSharesList();
        }
    };
    private static final PagedListResponseFactory<ListInstancesRequest, ListInstancesResponse, BareMetalSolutionClient.ListInstancesPagedResponse> LIST_INSTANCES_PAGE_STR_FACT = new PagedListResponseFactory<ListInstancesRequest, ListInstancesResponse, BareMetalSolutionClient.ListInstancesPagedResponse>(){

        public ApiFuture<BareMetalSolutionClient.ListInstancesPagedResponse> getFuturePagedResponse(UnaryCallable<ListInstancesRequest, ListInstancesResponse> callable, ListInstancesRequest request, ApiCallContext context, ApiFuture<ListInstancesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INSTANCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BareMetalSolutionClient.ListInstancesPagedResponse.createAsync((PageContext<ListInstancesRequest, ListInstancesResponse, Instance>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListVolumesRequest, ListVolumesResponse, BareMetalSolutionClient.ListVolumesPagedResponse> LIST_VOLUMES_PAGE_STR_FACT = new PagedListResponseFactory<ListVolumesRequest, ListVolumesResponse, BareMetalSolutionClient.ListVolumesPagedResponse>(){

        public ApiFuture<BareMetalSolutionClient.ListVolumesPagedResponse> getFuturePagedResponse(UnaryCallable<ListVolumesRequest, ListVolumesResponse> callable, ListVolumesRequest request, ApiCallContext context, ApiFuture<ListVolumesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_VOLUMES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BareMetalSolutionClient.ListVolumesPagedResponse.createAsync((PageContext<ListVolumesRequest, ListVolumesResponse, Volume>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListNetworksRequest, ListNetworksResponse, BareMetalSolutionClient.ListNetworksPagedResponse> LIST_NETWORKS_PAGE_STR_FACT = new PagedListResponseFactory<ListNetworksRequest, ListNetworksResponse, BareMetalSolutionClient.ListNetworksPagedResponse>(){

        public ApiFuture<BareMetalSolutionClient.ListNetworksPagedResponse> getFuturePagedResponse(UnaryCallable<ListNetworksRequest, ListNetworksResponse> callable, ListNetworksRequest request, ApiCallContext context, ApiFuture<ListNetworksResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_NETWORKS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BareMetalSolutionClient.ListNetworksPagedResponse.createAsync((PageContext<ListNetworksRequest, ListNetworksResponse, Network>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLunsRequest, ListLunsResponse, BareMetalSolutionClient.ListLunsPagedResponse> LIST_LUNS_PAGE_STR_FACT = new PagedListResponseFactory<ListLunsRequest, ListLunsResponse, BareMetalSolutionClient.ListLunsPagedResponse>(){

        public ApiFuture<BareMetalSolutionClient.ListLunsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLunsRequest, ListLunsResponse> callable, ListLunsRequest request, ApiCallContext context, ApiFuture<ListLunsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LUNS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BareMetalSolutionClient.ListLunsPagedResponse.createAsync((PageContext<ListLunsRequest, ListLunsResponse, Lun>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListNfsSharesRequest, ListNfsSharesResponse, BareMetalSolutionClient.ListNfsSharesPagedResponse> LIST_NFS_SHARES_PAGE_STR_FACT = new PagedListResponseFactory<ListNfsSharesRequest, ListNfsSharesResponse, BareMetalSolutionClient.ListNfsSharesPagedResponse>(){

        public ApiFuture<BareMetalSolutionClient.ListNfsSharesPagedResponse> getFuturePagedResponse(UnaryCallable<ListNfsSharesRequest, ListNfsSharesResponse> callable, ListNfsSharesRequest request, ApiCallContext context, ApiFuture<ListNfsSharesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_NFS_SHARES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BareMetalSolutionClient.ListNfsSharesPagedResponse.createAsync((PageContext<ListNfsSharesRequest, ListNfsSharesResponse, NfsShare>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListInstancesRequest, ListInstancesResponse, BareMetalSolutionClient.ListInstancesPagedResponse> listInstancesSettings() {
        return this.listInstancesSettings;
    }

    public UnaryCallSettings<GetInstanceRequest, Instance> getInstanceSettings() {
        return this.getInstanceSettings;
    }

    public UnaryCallSettings<UpdateInstanceRequest, Operation> updateInstanceSettings() {
        return this.updateInstanceSettings;
    }

    public OperationCallSettings<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationSettings() {
        return this.updateInstanceOperationSettings;
    }

    public UnaryCallSettings<ResetInstanceRequest, Operation> resetInstanceSettings() {
        return this.resetInstanceSettings;
    }

    public OperationCallSettings<ResetInstanceRequest, ResetInstanceResponse, OperationMetadata> resetInstanceOperationSettings() {
        return this.resetInstanceOperationSettings;
    }

    public UnaryCallSettings<StartInstanceRequest, Operation> startInstanceSettings() {
        return this.startInstanceSettings;
    }

    public OperationCallSettings<StartInstanceRequest, StartInstanceResponse, OperationMetadata> startInstanceOperationSettings() {
        return this.startInstanceOperationSettings;
    }

    public UnaryCallSettings<StopInstanceRequest, Operation> stopInstanceSettings() {
        return this.stopInstanceSettings;
    }

    public OperationCallSettings<StopInstanceRequest, StopInstanceResponse, OperationMetadata> stopInstanceOperationSettings() {
        return this.stopInstanceOperationSettings;
    }

    public UnaryCallSettings<DetachLunRequest, Operation> detachLunSettings() {
        return this.detachLunSettings;
    }

    public OperationCallSettings<DetachLunRequest, Instance, OperationMetadata> detachLunOperationSettings() {
        return this.detachLunOperationSettings;
    }

    public PagedCallSettings<ListVolumesRequest, ListVolumesResponse, BareMetalSolutionClient.ListVolumesPagedResponse> listVolumesSettings() {
        return this.listVolumesSettings;
    }

    public UnaryCallSettings<GetVolumeRequest, Volume> getVolumeSettings() {
        return this.getVolumeSettings;
    }

    public UnaryCallSettings<UpdateVolumeRequest, Operation> updateVolumeSettings() {
        return this.updateVolumeSettings;
    }

    public OperationCallSettings<UpdateVolumeRequest, Volume, OperationMetadata> updateVolumeOperationSettings() {
        return this.updateVolumeOperationSettings;
    }

    public UnaryCallSettings<ResizeVolumeRequest, Operation> resizeVolumeSettings() {
        return this.resizeVolumeSettings;
    }

    public OperationCallSettings<ResizeVolumeRequest, Volume, OperationMetadata> resizeVolumeOperationSettings() {
        return this.resizeVolumeOperationSettings;
    }

    public PagedCallSettings<ListNetworksRequest, ListNetworksResponse, BareMetalSolutionClient.ListNetworksPagedResponse> listNetworksSettings() {
        return this.listNetworksSettings;
    }

    public UnaryCallSettings<ListNetworkUsageRequest, ListNetworkUsageResponse> listNetworkUsageSettings() {
        return this.listNetworkUsageSettings;
    }

    public UnaryCallSettings<GetNetworkRequest, Network> getNetworkSettings() {
        return this.getNetworkSettings;
    }

    public UnaryCallSettings<UpdateNetworkRequest, Operation> updateNetworkSettings() {
        return this.updateNetworkSettings;
    }

    public OperationCallSettings<UpdateNetworkRequest, Network, OperationMetadata> updateNetworkOperationSettings() {
        return this.updateNetworkOperationSettings;
    }

    public UnaryCallSettings<GetLunRequest, Lun> getLunSettings() {
        return this.getLunSettings;
    }

    public PagedCallSettings<ListLunsRequest, ListLunsResponse, BareMetalSolutionClient.ListLunsPagedResponse> listLunsSettings() {
        return this.listLunsSettings;
    }

    public UnaryCallSettings<GetNfsShareRequest, NfsShare> getNfsShareSettings() {
        return this.getNfsShareSettings;
    }

    public PagedCallSettings<ListNfsSharesRequest, ListNfsSharesResponse, BareMetalSolutionClient.ListNfsSharesPagedResponse> listNfsSharesSettings() {
        return this.listNfsSharesSettings;
    }

    public UnaryCallSettings<UpdateNfsShareRequest, Operation> updateNfsShareSettings() {
        return this.updateNfsShareSettings;
    }

    public OperationCallSettings<UpdateNfsShareRequest, NfsShare, OperationMetadata> updateNfsShareOperationSettings() {
        return this.updateNfsShareOperationSettings;
    }

    public BareMetalSolutionStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcBareMetalSolutionStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonBareMetalSolutionStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "baremetalsolution.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "baremetalsolution.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return BareMetalSolutionStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(BareMetalSolutionStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(BareMetalSolutionStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return BareMetalSolutionStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected BareMetalSolutionStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listInstancesSettings = settingsBuilder.listInstancesSettings().build();
        this.getInstanceSettings = settingsBuilder.getInstanceSettings().build();
        this.updateInstanceSettings = settingsBuilder.updateInstanceSettings().build();
        this.updateInstanceOperationSettings = settingsBuilder.updateInstanceOperationSettings().build();
        this.resetInstanceSettings = settingsBuilder.resetInstanceSettings().build();
        this.resetInstanceOperationSettings = settingsBuilder.resetInstanceOperationSettings().build();
        this.startInstanceSettings = settingsBuilder.startInstanceSettings().build();
        this.startInstanceOperationSettings = settingsBuilder.startInstanceOperationSettings().build();
        this.stopInstanceSettings = settingsBuilder.stopInstanceSettings().build();
        this.stopInstanceOperationSettings = settingsBuilder.stopInstanceOperationSettings().build();
        this.detachLunSettings = settingsBuilder.detachLunSettings().build();
        this.detachLunOperationSettings = settingsBuilder.detachLunOperationSettings().build();
        this.listVolumesSettings = settingsBuilder.listVolumesSettings().build();
        this.getVolumeSettings = settingsBuilder.getVolumeSettings().build();
        this.updateVolumeSettings = settingsBuilder.updateVolumeSettings().build();
        this.updateVolumeOperationSettings = settingsBuilder.updateVolumeOperationSettings().build();
        this.resizeVolumeSettings = settingsBuilder.resizeVolumeSettings().build();
        this.resizeVolumeOperationSettings = settingsBuilder.resizeVolumeOperationSettings().build();
        this.listNetworksSettings = settingsBuilder.listNetworksSettings().build();
        this.listNetworkUsageSettings = settingsBuilder.listNetworkUsageSettings().build();
        this.getNetworkSettings = settingsBuilder.getNetworkSettings().build();
        this.updateNetworkSettings = settingsBuilder.updateNetworkSettings().build();
        this.updateNetworkOperationSettings = settingsBuilder.updateNetworkOperationSettings().build();
        this.getLunSettings = settingsBuilder.getLunSettings().build();
        this.listLunsSettings = settingsBuilder.listLunsSettings().build();
        this.getNfsShareSettings = settingsBuilder.getNfsShareSettings().build();
        this.listNfsSharesSettings = settingsBuilder.listNfsSharesSettings().build();
        this.updateNfsShareSettings = settingsBuilder.updateNfsShareSettings().build();
        this.updateNfsShareOperationSettings = settingsBuilder.updateNfsShareOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<BareMetalSolutionStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListInstancesRequest, ListInstancesResponse, BareMetalSolutionClient.ListInstancesPagedResponse> listInstancesSettings;
        private final UnaryCallSettings.Builder<GetInstanceRequest, Instance> getInstanceSettings;
        private final UnaryCallSettings.Builder<UpdateInstanceRequest, Operation> updateInstanceSettings;
        private final OperationCallSettings.Builder<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationSettings;
        private final UnaryCallSettings.Builder<ResetInstanceRequest, Operation> resetInstanceSettings;
        private final OperationCallSettings.Builder<ResetInstanceRequest, ResetInstanceResponse, OperationMetadata> resetInstanceOperationSettings;
        private final UnaryCallSettings.Builder<StartInstanceRequest, Operation> startInstanceSettings;
        private final OperationCallSettings.Builder<StartInstanceRequest, StartInstanceResponse, OperationMetadata> startInstanceOperationSettings;
        private final UnaryCallSettings.Builder<StopInstanceRequest, Operation> stopInstanceSettings;
        private final OperationCallSettings.Builder<StopInstanceRequest, StopInstanceResponse, OperationMetadata> stopInstanceOperationSettings;
        private final UnaryCallSettings.Builder<DetachLunRequest, Operation> detachLunSettings;
        private final OperationCallSettings.Builder<DetachLunRequest, Instance, OperationMetadata> detachLunOperationSettings;
        private final PagedCallSettings.Builder<ListVolumesRequest, ListVolumesResponse, BareMetalSolutionClient.ListVolumesPagedResponse> listVolumesSettings;
        private final UnaryCallSettings.Builder<GetVolumeRequest, Volume> getVolumeSettings;
        private final UnaryCallSettings.Builder<UpdateVolumeRequest, Operation> updateVolumeSettings;
        private final OperationCallSettings.Builder<UpdateVolumeRequest, Volume, OperationMetadata> updateVolumeOperationSettings;
        private final UnaryCallSettings.Builder<ResizeVolumeRequest, Operation> resizeVolumeSettings;
        private final OperationCallSettings.Builder<ResizeVolumeRequest, Volume, OperationMetadata> resizeVolumeOperationSettings;
        private final PagedCallSettings.Builder<ListNetworksRequest, ListNetworksResponse, BareMetalSolutionClient.ListNetworksPagedResponse> listNetworksSettings;
        private final UnaryCallSettings.Builder<ListNetworkUsageRequest, ListNetworkUsageResponse> listNetworkUsageSettings;
        private final UnaryCallSettings.Builder<GetNetworkRequest, Network> getNetworkSettings;
        private final UnaryCallSettings.Builder<UpdateNetworkRequest, Operation> updateNetworkSettings;
        private final OperationCallSettings.Builder<UpdateNetworkRequest, Network, OperationMetadata> updateNetworkOperationSettings;
        private final UnaryCallSettings.Builder<GetLunRequest, Lun> getLunSettings;
        private final PagedCallSettings.Builder<ListLunsRequest, ListLunsResponse, BareMetalSolutionClient.ListLunsPagedResponse> listLunsSettings;
        private final UnaryCallSettings.Builder<GetNfsShareRequest, NfsShare> getNfsShareSettings;
        private final PagedCallSettings.Builder<ListNfsSharesRequest, ListNfsSharesResponse, BareMetalSolutionClient.ListNfsSharesPagedResponse> listNfsSharesSettings;
        private final UnaryCallSettings.Builder<UpdateNfsShareRequest, Operation> updateNfsShareSettings;
        private final OperationCallSettings.Builder<UpdateNfsShareRequest, NfsShare, OperationMetadata> updateNfsShareOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listInstancesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INSTANCES_PAGE_STR_FACT);
            this.getInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.resetInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.resetInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.startInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.startInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.stopInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.stopInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.detachLunSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.detachLunOperationSettings = OperationCallSettings.newBuilder();
            this.listVolumesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_VOLUMES_PAGE_STR_FACT);
            this.getVolumeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateVolumeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateVolumeOperationSettings = OperationCallSettings.newBuilder();
            this.resizeVolumeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.resizeVolumeOperationSettings = OperationCallSettings.newBuilder();
            this.listNetworksSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_NETWORKS_PAGE_STR_FACT);
            this.listNetworkUsageSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getNetworkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateNetworkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateNetworkOperationSettings = OperationCallSettings.newBuilder();
            this.getLunSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLunsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LUNS_PAGE_STR_FACT);
            this.getNfsShareSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listNfsSharesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_NFS_SHARES_PAGE_STR_FACT);
            this.updateNfsShareSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateNfsShareOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listInstancesSettings, this.getInstanceSettings, this.updateInstanceSettings, this.resetInstanceSettings, this.startInstanceSettings, this.stopInstanceSettings, this.detachLunSettings, this.listVolumesSettings, this.getVolumeSettings, this.updateVolumeSettings, this.resizeVolumeSettings, this.listNetworksSettings, (Object[])new UnaryCallSettings.Builder[]{this.listNetworkUsageSettings, this.getNetworkSettings, this.updateNetworkSettings, this.getLunSettings, this.listLunsSettings, this.getNfsShareSettings, this.listNfsSharesSettings, this.updateNfsShareSettings});
            Builder.initDefaults(this);
        }

        protected Builder(BareMetalSolutionStubSettings settings) {
            super((StubSettings)settings);
            this.listInstancesSettings = settings.listInstancesSettings.toBuilder();
            this.getInstanceSettings = settings.getInstanceSettings.toBuilder();
            this.updateInstanceSettings = settings.updateInstanceSettings.toBuilder();
            this.updateInstanceOperationSettings = settings.updateInstanceOperationSettings.toBuilder();
            this.resetInstanceSettings = settings.resetInstanceSettings.toBuilder();
            this.resetInstanceOperationSettings = settings.resetInstanceOperationSettings.toBuilder();
            this.startInstanceSettings = settings.startInstanceSettings.toBuilder();
            this.startInstanceOperationSettings = settings.startInstanceOperationSettings.toBuilder();
            this.stopInstanceSettings = settings.stopInstanceSettings.toBuilder();
            this.stopInstanceOperationSettings = settings.stopInstanceOperationSettings.toBuilder();
            this.detachLunSettings = settings.detachLunSettings.toBuilder();
            this.detachLunOperationSettings = settings.detachLunOperationSettings.toBuilder();
            this.listVolumesSettings = settings.listVolumesSettings.toBuilder();
            this.getVolumeSettings = settings.getVolumeSettings.toBuilder();
            this.updateVolumeSettings = settings.updateVolumeSettings.toBuilder();
            this.updateVolumeOperationSettings = settings.updateVolumeOperationSettings.toBuilder();
            this.resizeVolumeSettings = settings.resizeVolumeSettings.toBuilder();
            this.resizeVolumeOperationSettings = settings.resizeVolumeOperationSettings.toBuilder();
            this.listNetworksSettings = settings.listNetworksSettings.toBuilder();
            this.listNetworkUsageSettings = settings.listNetworkUsageSettings.toBuilder();
            this.getNetworkSettings = settings.getNetworkSettings.toBuilder();
            this.updateNetworkSettings = settings.updateNetworkSettings.toBuilder();
            this.updateNetworkOperationSettings = settings.updateNetworkOperationSettings.toBuilder();
            this.getLunSettings = settings.getLunSettings.toBuilder();
            this.listLunsSettings = settings.listLunsSettings.toBuilder();
            this.getNfsShareSettings = settings.getNfsShareSettings.toBuilder();
            this.listNfsSharesSettings = settings.listNfsSharesSettings.toBuilder();
            this.updateNfsShareSettings = settings.updateNfsShareSettings.toBuilder();
            this.updateNfsShareOperationSettings = settings.updateNfsShareOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listInstancesSettings, this.getInstanceSettings, this.updateInstanceSettings, this.resetInstanceSettings, this.startInstanceSettings, this.stopInstanceSettings, this.detachLunSettings, this.listVolumesSettings, this.getVolumeSettings, this.updateVolumeSettings, this.resizeVolumeSettings, this.listNetworksSettings, (Object[])new UnaryCallSettings.Builder[]{this.listNetworkUsageSettings, this.getNetworkSettings, this.updateNetworkSettings, this.getLunSettings, this.listLunsSettings, this.getNfsShareSettings, this.listNfsSharesSettings, this.updateNfsShareSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(BareMetalSolutionStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)BareMetalSolutionStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)BareMetalSolutionStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(BareMetalSolutionStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(BareMetalSolutionStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)BareMetalSolutionStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)BareMetalSolutionStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)BareMetalSolutionStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(BareMetalSolutionStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(BareMetalSolutionStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.resetInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.startInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.stopInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.detachLunSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listVolumesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getVolumeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateVolumeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.resizeVolumeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listNetworksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listNetworkUsageSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getNetworkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateNetworkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getLunSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listLunsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getNfsShareSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listNfsSharesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateNfsShareSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.resetInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ResetInstanceResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.startInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(StartInstanceResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.stopInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(StopInstanceResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.detachLunOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateVolumeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Volume.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.resizeVolumeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Volume.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateNetworkOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Network.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateNfsShareOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(NfsShare.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListInstancesRequest, ListInstancesResponse, BareMetalSolutionClient.ListInstancesPagedResponse> listInstancesSettings() {
            return this.listInstancesSettings;
        }

        public UnaryCallSettings.Builder<GetInstanceRequest, Instance> getInstanceSettings() {
            return this.getInstanceSettings;
        }

        public UnaryCallSettings.Builder<UpdateInstanceRequest, Operation> updateInstanceSettings() {
            return this.updateInstanceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationSettings() {
            return this.updateInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<ResetInstanceRequest, Operation> resetInstanceSettings() {
            return this.resetInstanceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ResetInstanceRequest, ResetInstanceResponse, OperationMetadata> resetInstanceOperationSettings() {
            return this.resetInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<StartInstanceRequest, Operation> startInstanceSettings() {
            return this.startInstanceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<StartInstanceRequest, StartInstanceResponse, OperationMetadata> startInstanceOperationSettings() {
            return this.startInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<StopInstanceRequest, Operation> stopInstanceSettings() {
            return this.stopInstanceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<StopInstanceRequest, StopInstanceResponse, OperationMetadata> stopInstanceOperationSettings() {
            return this.stopInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<DetachLunRequest, Operation> detachLunSettings() {
            return this.detachLunSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DetachLunRequest, Instance, OperationMetadata> detachLunOperationSettings() {
            return this.detachLunOperationSettings;
        }

        public PagedCallSettings.Builder<ListVolumesRequest, ListVolumesResponse, BareMetalSolutionClient.ListVolumesPagedResponse> listVolumesSettings() {
            return this.listVolumesSettings;
        }

        public UnaryCallSettings.Builder<GetVolumeRequest, Volume> getVolumeSettings() {
            return this.getVolumeSettings;
        }

        public UnaryCallSettings.Builder<UpdateVolumeRequest, Operation> updateVolumeSettings() {
            return this.updateVolumeSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateVolumeRequest, Volume, OperationMetadata> updateVolumeOperationSettings() {
            return this.updateVolumeOperationSettings;
        }

        public UnaryCallSettings.Builder<ResizeVolumeRequest, Operation> resizeVolumeSettings() {
            return this.resizeVolumeSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ResizeVolumeRequest, Volume, OperationMetadata> resizeVolumeOperationSettings() {
            return this.resizeVolumeOperationSettings;
        }

        public PagedCallSettings.Builder<ListNetworksRequest, ListNetworksResponse, BareMetalSolutionClient.ListNetworksPagedResponse> listNetworksSettings() {
            return this.listNetworksSettings;
        }

        public UnaryCallSettings.Builder<ListNetworkUsageRequest, ListNetworkUsageResponse> listNetworkUsageSettings() {
            return this.listNetworkUsageSettings;
        }

        public UnaryCallSettings.Builder<GetNetworkRequest, Network> getNetworkSettings() {
            return this.getNetworkSettings;
        }

        public UnaryCallSettings.Builder<UpdateNetworkRequest, Operation> updateNetworkSettings() {
            return this.updateNetworkSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateNetworkRequest, Network, OperationMetadata> updateNetworkOperationSettings() {
            return this.updateNetworkOperationSettings;
        }

        public UnaryCallSettings.Builder<GetLunRequest, Lun> getLunSettings() {
            return this.getLunSettings;
        }

        public PagedCallSettings.Builder<ListLunsRequest, ListLunsResponse, BareMetalSolutionClient.ListLunsPagedResponse> listLunsSettings() {
            return this.listLunsSettings;
        }

        public UnaryCallSettings.Builder<GetNfsShareRequest, NfsShare> getNfsShareSettings() {
            return this.getNfsShareSettings;
        }

        public PagedCallSettings.Builder<ListNfsSharesRequest, ListNfsSharesResponse, BareMetalSolutionClient.ListNfsSharesPagedResponse> listNfsSharesSettings() {
            return this.listNfsSharesSettings;
        }

        public UnaryCallSettings.Builder<UpdateNfsShareRequest, Operation> updateNfsShareSettings() {
            return this.updateNfsShareSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateNfsShareRequest, NfsShare, OperationMetadata> updateNfsShareOperationSettings() {
            return this.updateNfsShareOperationSettings;
        }

        public BareMetalSolutionStubSettings build() throws IOException {
            return new BareMetalSolutionStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

