/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.backupdr.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.backupdr.v1.BackupDRSettings;
import com.google.cloud.backupdr.v1.CreateManagementServerRequest;
import com.google.cloud.backupdr.v1.DeleteManagementServerRequest;
import com.google.cloud.backupdr.v1.GetManagementServerRequest;
import com.google.cloud.backupdr.v1.ListManagementServersRequest;
import com.google.cloud.backupdr.v1.ListManagementServersResponse;
import com.google.cloud.backupdr.v1.LocationName;
import com.google.cloud.backupdr.v1.ManagementServer;
import com.google.cloud.backupdr.v1.ManagementServerName;
import com.google.cloud.backupdr.v1.OperationMetadata;
import com.google.cloud.backupdr.v1.stub.BackupDRStub;
import com.google.cloud.backupdr.v1.stub.BackupDRStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class BackupDRClient
implements BackgroundResource {
    private final BackupDRSettings settings;
    private final BackupDRStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final BackupDRClient create() throws IOException {
        return BackupDRClient.create(BackupDRSettings.newBuilder().build());
    }

    public static final BackupDRClient create(BackupDRSettings settings) throws IOException {
        return new BackupDRClient(settings);
    }

    public static final BackupDRClient create(BackupDRStub stub) {
        return new BackupDRClient(stub);
    }

    protected BackupDRClient(BackupDRSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((BackupDRStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected BackupDRClient(BackupDRStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final BackupDRSettings getSettings() {
        return this.settings;
    }

    public BackupDRStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListManagementServersPagedResponse listManagementServers(LocationName parent) {
        ListManagementServersRequest request = ListManagementServersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listManagementServers(request);
    }

    public final ListManagementServersPagedResponse listManagementServers(String parent) {
        ListManagementServersRequest request = ListManagementServersRequest.newBuilder().setParent(parent).build();
        return this.listManagementServers(request);
    }

    public final ListManagementServersPagedResponse listManagementServers(ListManagementServersRequest request) {
        return (ListManagementServersPagedResponse)((Object)this.listManagementServersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListManagementServersRequest, ListManagementServersPagedResponse> listManagementServersPagedCallable() {
        return this.stub.listManagementServersPagedCallable();
    }

    public final UnaryCallable<ListManagementServersRequest, ListManagementServersResponse> listManagementServersCallable() {
        return this.stub.listManagementServersCallable();
    }

    public final ManagementServer getManagementServer(ManagementServerName name) {
        GetManagementServerRequest request = GetManagementServerRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getManagementServer(request);
    }

    public final ManagementServer getManagementServer(String name) {
        GetManagementServerRequest request = GetManagementServerRequest.newBuilder().setName(name).build();
        return this.getManagementServer(request);
    }

    public final ManagementServer getManagementServer(GetManagementServerRequest request) {
        return (ManagementServer)this.getManagementServerCallable().call((Object)request);
    }

    public final UnaryCallable<GetManagementServerRequest, ManagementServer> getManagementServerCallable() {
        return this.stub.getManagementServerCallable();
    }

    public final OperationFuture<ManagementServer, OperationMetadata> createManagementServerAsync(LocationName parent, ManagementServer managementServer, String managementServerId) {
        CreateManagementServerRequest request = CreateManagementServerRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setManagementServer(managementServer).setManagementServerId(managementServerId).build();
        return this.createManagementServerAsync(request);
    }

    public final OperationFuture<ManagementServer, OperationMetadata> createManagementServerAsync(String parent, ManagementServer managementServer, String managementServerId) {
        CreateManagementServerRequest request = CreateManagementServerRequest.newBuilder().setParent(parent).setManagementServer(managementServer).setManagementServerId(managementServerId).build();
        return this.createManagementServerAsync(request);
    }

    public final OperationFuture<ManagementServer, OperationMetadata> createManagementServerAsync(CreateManagementServerRequest request) {
        return this.createManagementServerOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateManagementServerRequest, ManagementServer, OperationMetadata> createManagementServerOperationCallable() {
        return this.stub.createManagementServerOperationCallable();
    }

    public final UnaryCallable<CreateManagementServerRequest, Operation> createManagementServerCallable() {
        return this.stub.createManagementServerCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteManagementServerAsync(ManagementServerName name) {
        DeleteManagementServerRequest request = DeleteManagementServerRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteManagementServerAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteManagementServerAsync(String name) {
        DeleteManagementServerRequest request = DeleteManagementServerRequest.newBuilder().setName(name).build();
        return this.deleteManagementServerAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteManagementServerAsync(DeleteManagementServerRequest request) {
        return this.deleteManagementServerOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteManagementServerRequest, Empty, OperationMetadata> deleteManagementServerOperationCallable() {
        return this.stub.deleteManagementServerOperationCallable();
    }

    public final UnaryCallable<DeleteManagementServerRequest, Operation> deleteManagementServerCallable() {
        return this.stub.deleteManagementServerCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListManagementServersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListManagementServersRequest, ListManagementServersResponse, ManagementServer, ListManagementServersPage, ListManagementServersFixedSizeCollection> {
        private ListManagementServersFixedSizeCollection(List<ListManagementServersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListManagementServersFixedSizeCollection createEmptyCollection() {
            return new ListManagementServersFixedSizeCollection(null, 0);
        }

        protected ListManagementServersFixedSizeCollection createCollection(List<ListManagementServersPage> pages, int collectionSize) {
            return new ListManagementServersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListManagementServersPage
    extends AbstractPage<ListManagementServersRequest, ListManagementServersResponse, ManagementServer, ListManagementServersPage> {
        private ListManagementServersPage(PageContext<ListManagementServersRequest, ListManagementServersResponse, ManagementServer> context, ListManagementServersResponse response) {
            super(context, (Object)response);
        }

        private static ListManagementServersPage createEmptyPage() {
            return new ListManagementServersPage(null, null);
        }

        protected ListManagementServersPage createPage(PageContext<ListManagementServersRequest, ListManagementServersResponse, ManagementServer> context, ListManagementServersResponse response) {
            return new ListManagementServersPage(context, response);
        }

        public ApiFuture<ListManagementServersPage> createPageAsync(PageContext<ListManagementServersRequest, ListManagementServersResponse, ManagementServer> context, ApiFuture<ListManagementServersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListManagementServersPagedResponse
    extends AbstractPagedListResponse<ListManagementServersRequest, ListManagementServersResponse, ManagementServer, ListManagementServersPage, ListManagementServersFixedSizeCollection> {
        public static ApiFuture<ListManagementServersPagedResponse> createAsync(PageContext<ListManagementServersRequest, ListManagementServersResponse, ManagementServer> context, ApiFuture<ListManagementServersResponse> futureResponse) {
            ApiFuture<ListManagementServersPage> futurePage = ListManagementServersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListManagementServersPagedResponse((ListManagementServersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListManagementServersPagedResponse(ListManagementServersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListManagementServersFixedSizeCollection.createEmptyCollection());
        }
    }
}

