/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.automl.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.automl.v1.AnnotationSpec;
import com.google.cloud.automl.v1.AutoMlClient;
import com.google.cloud.automl.v1.CreateDatasetRequest;
import com.google.cloud.automl.v1.CreateModelRequest;
import com.google.cloud.automl.v1.Dataset;
import com.google.cloud.automl.v1.DeleteDatasetRequest;
import com.google.cloud.automl.v1.DeleteModelRequest;
import com.google.cloud.automl.v1.DeployModelRequest;
import com.google.cloud.automl.v1.ExportDataRequest;
import com.google.cloud.automl.v1.ExportModelRequest;
import com.google.cloud.automl.v1.GetAnnotationSpecRequest;
import com.google.cloud.automl.v1.GetDatasetRequest;
import com.google.cloud.automl.v1.GetModelEvaluationRequest;
import com.google.cloud.automl.v1.GetModelRequest;
import com.google.cloud.automl.v1.ImportDataRequest;
import com.google.cloud.automl.v1.ListDatasetsRequest;
import com.google.cloud.automl.v1.ListDatasetsResponse;
import com.google.cloud.automl.v1.ListModelEvaluationsRequest;
import com.google.cloud.automl.v1.ListModelEvaluationsResponse;
import com.google.cloud.automl.v1.ListModelsRequest;
import com.google.cloud.automl.v1.ListModelsResponse;
import com.google.cloud.automl.v1.Model;
import com.google.cloud.automl.v1.ModelEvaluation;
import com.google.cloud.automl.v1.OperationMetadata;
import com.google.cloud.automl.v1.UndeployModelRequest;
import com.google.cloud.automl.v1.UpdateDatasetRequest;
import com.google.cloud.automl.v1.UpdateModelRequest;
import com.google.cloud.automl.v1.stub.AutoMlStub;
import com.google.cloud.automl.v1.stub.AutoMlStubSettings;
import com.google.cloud.automl.v1.stub.GrpcAutoMlCallableFactory;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcAutoMlStub
extends AutoMlStub {
    private static final MethodDescriptor<CreateDatasetRequest, Operation> createDatasetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.automl.v1.AutoMl/CreateDataset").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateDatasetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetDatasetRequest, Dataset> getDatasetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.automl.v1.AutoMl/GetDataset").setRequestMarshaller(ProtoUtils.marshaller((Message)GetDatasetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Dataset.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListDatasetsRequest, ListDatasetsResponse> listDatasetsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.automl.v1.AutoMl/ListDatasets").setRequestMarshaller(ProtoUtils.marshaller((Message)ListDatasetsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListDatasetsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateDatasetRequest, Dataset> updateDatasetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.automl.v1.AutoMl/UpdateDataset").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateDatasetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Dataset.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteDatasetRequest, Operation> deleteDatasetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.automl.v1.AutoMl/DeleteDataset").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteDatasetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ImportDataRequest, Operation> importDataMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.automl.v1.AutoMl/ImportData").setRequestMarshaller(ProtoUtils.marshaller((Message)ImportDataRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ExportDataRequest, Operation> exportDataMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.automl.v1.AutoMl/ExportData").setRequestMarshaller(ProtoUtils.marshaller((Message)ExportDataRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetAnnotationSpecRequest, AnnotationSpec> getAnnotationSpecMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.automl.v1.AutoMl/GetAnnotationSpec").setRequestMarshaller(ProtoUtils.marshaller((Message)GetAnnotationSpecRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AnnotationSpec.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateModelRequest, Operation> createModelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.automl.v1.AutoMl/CreateModel").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateModelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetModelRequest, Model> getModelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.automl.v1.AutoMl/GetModel").setRequestMarshaller(ProtoUtils.marshaller((Message)GetModelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Model.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListModelsRequest, ListModelsResponse> listModelsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.automl.v1.AutoMl/ListModels").setRequestMarshaller(ProtoUtils.marshaller((Message)ListModelsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListModelsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteModelRequest, Operation> deleteModelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.automl.v1.AutoMl/DeleteModel").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteModelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateModelRequest, Model> updateModelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.automl.v1.AutoMl/UpdateModel").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateModelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Model.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeployModelRequest, Operation> deployModelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.automl.v1.AutoMl/DeployModel").setRequestMarshaller(ProtoUtils.marshaller((Message)DeployModelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UndeployModelRequest, Operation> undeployModelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.automl.v1.AutoMl/UndeployModel").setRequestMarshaller(ProtoUtils.marshaller((Message)UndeployModelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ExportModelRequest, Operation> exportModelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.automl.v1.AutoMl/ExportModel").setRequestMarshaller(ProtoUtils.marshaller((Message)ExportModelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetModelEvaluationRequest, ModelEvaluation> getModelEvaluationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.automl.v1.AutoMl/GetModelEvaluation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetModelEvaluationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ModelEvaluation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListModelEvaluationsRequest, ListModelEvaluationsResponse> listModelEvaluationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.automl.v1.AutoMl/ListModelEvaluations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListModelEvaluationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListModelEvaluationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<CreateDatasetRequest, Operation> createDatasetCallable;
    private final OperationCallable<CreateDatasetRequest, Dataset, OperationMetadata> createDatasetOperationCallable;
    private final UnaryCallable<GetDatasetRequest, Dataset> getDatasetCallable;
    private final UnaryCallable<ListDatasetsRequest, ListDatasetsResponse> listDatasetsCallable;
    private final UnaryCallable<ListDatasetsRequest, AutoMlClient.ListDatasetsPagedResponse> listDatasetsPagedCallable;
    private final UnaryCallable<UpdateDatasetRequest, Dataset> updateDatasetCallable;
    private final UnaryCallable<DeleteDatasetRequest, Operation> deleteDatasetCallable;
    private final OperationCallable<DeleteDatasetRequest, Empty, OperationMetadata> deleteDatasetOperationCallable;
    private final UnaryCallable<ImportDataRequest, Operation> importDataCallable;
    private final OperationCallable<ImportDataRequest, Empty, OperationMetadata> importDataOperationCallable;
    private final UnaryCallable<ExportDataRequest, Operation> exportDataCallable;
    private final OperationCallable<ExportDataRequest, Empty, OperationMetadata> exportDataOperationCallable;
    private final UnaryCallable<GetAnnotationSpecRequest, AnnotationSpec> getAnnotationSpecCallable;
    private final UnaryCallable<CreateModelRequest, Operation> createModelCallable;
    private final OperationCallable<CreateModelRequest, Model, OperationMetadata> createModelOperationCallable;
    private final UnaryCallable<GetModelRequest, Model> getModelCallable;
    private final UnaryCallable<ListModelsRequest, ListModelsResponse> listModelsCallable;
    private final UnaryCallable<ListModelsRequest, AutoMlClient.ListModelsPagedResponse> listModelsPagedCallable;
    private final UnaryCallable<DeleteModelRequest, Operation> deleteModelCallable;
    private final OperationCallable<DeleteModelRequest, Empty, OperationMetadata> deleteModelOperationCallable;
    private final UnaryCallable<UpdateModelRequest, Model> updateModelCallable;
    private final UnaryCallable<DeployModelRequest, Operation> deployModelCallable;
    private final OperationCallable<DeployModelRequest, Empty, OperationMetadata> deployModelOperationCallable;
    private final UnaryCallable<UndeployModelRequest, Operation> undeployModelCallable;
    private final OperationCallable<UndeployModelRequest, Empty, OperationMetadata> undeployModelOperationCallable;
    private final UnaryCallable<ExportModelRequest, Operation> exportModelCallable;
    private final OperationCallable<ExportModelRequest, Empty, OperationMetadata> exportModelOperationCallable;
    private final UnaryCallable<GetModelEvaluationRequest, ModelEvaluation> getModelEvaluationCallable;
    private final UnaryCallable<ListModelEvaluationsRequest, ListModelEvaluationsResponse> listModelEvaluationsCallable;
    private final UnaryCallable<ListModelEvaluationsRequest, AutoMlClient.ListModelEvaluationsPagedResponse> listModelEvaluationsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcAutoMlStub create(AutoMlStubSettings settings) throws IOException {
        return new GrpcAutoMlStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcAutoMlStub create(ClientContext clientContext) throws IOException {
        return new GrpcAutoMlStub(AutoMlStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcAutoMlStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcAutoMlStub(AutoMlStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcAutoMlStub(AutoMlStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcAutoMlCallableFactory());
    }

    protected GrpcAutoMlStub(AutoMlStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createDatasetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createDatasetMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getDatasetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getDatasetMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listDatasetsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listDatasetsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateDatasetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateDatasetMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("dataset.name", String.valueOf(request.getDataset().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteDatasetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteDatasetMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings importDataTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(importDataMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings exportDataTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(exportDataMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getAnnotationSpecTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getAnnotationSpecMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createModelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createModelMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getModelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getModelMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listModelsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listModelsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteModelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteModelMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateModelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateModelMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("model.name", String.valueOf(request.getModel().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deployModelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deployModelMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings undeployModelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(undeployModelMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings exportModelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(exportModelMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getModelEvaluationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getModelEvaluationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listModelEvaluationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listModelEvaluationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.createDatasetCallable = callableFactory.createUnaryCallable(createDatasetTransportSettings, settings.createDatasetSettings(), clientContext);
        this.createDatasetOperationCallable = callableFactory.createOperationCallable(createDatasetTransportSettings, settings.createDatasetOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getDatasetCallable = callableFactory.createUnaryCallable(getDatasetTransportSettings, settings.getDatasetSettings(), clientContext);
        this.listDatasetsCallable = callableFactory.createUnaryCallable(listDatasetsTransportSettings, settings.listDatasetsSettings(), clientContext);
        this.listDatasetsPagedCallable = callableFactory.createPagedCallable(listDatasetsTransportSettings, settings.listDatasetsSettings(), clientContext);
        this.updateDatasetCallable = callableFactory.createUnaryCallable(updateDatasetTransportSettings, settings.updateDatasetSettings(), clientContext);
        this.deleteDatasetCallable = callableFactory.createUnaryCallable(deleteDatasetTransportSettings, settings.deleteDatasetSettings(), clientContext);
        this.deleteDatasetOperationCallable = callableFactory.createOperationCallable(deleteDatasetTransportSettings, settings.deleteDatasetOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.importDataCallable = callableFactory.createUnaryCallable(importDataTransportSettings, settings.importDataSettings(), clientContext);
        this.importDataOperationCallable = callableFactory.createOperationCallable(importDataTransportSettings, settings.importDataOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.exportDataCallable = callableFactory.createUnaryCallable(exportDataTransportSettings, settings.exportDataSettings(), clientContext);
        this.exportDataOperationCallable = callableFactory.createOperationCallable(exportDataTransportSettings, settings.exportDataOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getAnnotationSpecCallable = callableFactory.createUnaryCallable(getAnnotationSpecTransportSettings, settings.getAnnotationSpecSettings(), clientContext);
        this.createModelCallable = callableFactory.createUnaryCallable(createModelTransportSettings, settings.createModelSettings(), clientContext);
        this.createModelOperationCallable = callableFactory.createOperationCallable(createModelTransportSettings, settings.createModelOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getModelCallable = callableFactory.createUnaryCallable(getModelTransportSettings, settings.getModelSettings(), clientContext);
        this.listModelsCallable = callableFactory.createUnaryCallable(listModelsTransportSettings, settings.listModelsSettings(), clientContext);
        this.listModelsPagedCallable = callableFactory.createPagedCallable(listModelsTransportSettings, settings.listModelsSettings(), clientContext);
        this.deleteModelCallable = callableFactory.createUnaryCallable(deleteModelTransportSettings, settings.deleteModelSettings(), clientContext);
        this.deleteModelOperationCallable = callableFactory.createOperationCallable(deleteModelTransportSettings, settings.deleteModelOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateModelCallable = callableFactory.createUnaryCallable(updateModelTransportSettings, settings.updateModelSettings(), clientContext);
        this.deployModelCallable = callableFactory.createUnaryCallable(deployModelTransportSettings, settings.deployModelSettings(), clientContext);
        this.deployModelOperationCallable = callableFactory.createOperationCallable(deployModelTransportSettings, settings.deployModelOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.undeployModelCallable = callableFactory.createUnaryCallable(undeployModelTransportSettings, settings.undeployModelSettings(), clientContext);
        this.undeployModelOperationCallable = callableFactory.createOperationCallable(undeployModelTransportSettings, settings.undeployModelOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.exportModelCallable = callableFactory.createUnaryCallable(exportModelTransportSettings, settings.exportModelSettings(), clientContext);
        this.exportModelOperationCallable = callableFactory.createOperationCallable(exportModelTransportSettings, settings.exportModelOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getModelEvaluationCallable = callableFactory.createUnaryCallable(getModelEvaluationTransportSettings, settings.getModelEvaluationSettings(), clientContext);
        this.listModelEvaluationsCallable = callableFactory.createUnaryCallable(listModelEvaluationsTransportSettings, settings.listModelEvaluationsSettings(), clientContext);
        this.listModelEvaluationsPagedCallable = callableFactory.createPagedCallable(listModelEvaluationsTransportSettings, settings.listModelEvaluationsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateDatasetRequest, Operation> createDatasetCallable() {
        return this.createDatasetCallable;
    }

    @Override
    public OperationCallable<CreateDatasetRequest, Dataset, OperationMetadata> createDatasetOperationCallable() {
        return this.createDatasetOperationCallable;
    }

    @Override
    public UnaryCallable<GetDatasetRequest, Dataset> getDatasetCallable() {
        return this.getDatasetCallable;
    }

    @Override
    public UnaryCallable<ListDatasetsRequest, ListDatasetsResponse> listDatasetsCallable() {
        return this.listDatasetsCallable;
    }

    @Override
    public UnaryCallable<ListDatasetsRequest, AutoMlClient.ListDatasetsPagedResponse> listDatasetsPagedCallable() {
        return this.listDatasetsPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateDatasetRequest, Dataset> updateDatasetCallable() {
        return this.updateDatasetCallable;
    }

    @Override
    public UnaryCallable<DeleteDatasetRequest, Operation> deleteDatasetCallable() {
        return this.deleteDatasetCallable;
    }

    @Override
    public OperationCallable<DeleteDatasetRequest, Empty, OperationMetadata> deleteDatasetOperationCallable() {
        return this.deleteDatasetOperationCallable;
    }

    @Override
    public UnaryCallable<ImportDataRequest, Operation> importDataCallable() {
        return this.importDataCallable;
    }

    @Override
    public OperationCallable<ImportDataRequest, Empty, OperationMetadata> importDataOperationCallable() {
        return this.importDataOperationCallable;
    }

    @Override
    public UnaryCallable<ExportDataRequest, Operation> exportDataCallable() {
        return this.exportDataCallable;
    }

    @Override
    public OperationCallable<ExportDataRequest, Empty, OperationMetadata> exportDataOperationCallable() {
        return this.exportDataOperationCallable;
    }

    @Override
    public UnaryCallable<GetAnnotationSpecRequest, AnnotationSpec> getAnnotationSpecCallable() {
        return this.getAnnotationSpecCallable;
    }

    @Override
    public UnaryCallable<CreateModelRequest, Operation> createModelCallable() {
        return this.createModelCallable;
    }

    @Override
    public OperationCallable<CreateModelRequest, Model, OperationMetadata> createModelOperationCallable() {
        return this.createModelOperationCallable;
    }

    @Override
    public UnaryCallable<GetModelRequest, Model> getModelCallable() {
        return this.getModelCallable;
    }

    @Override
    public UnaryCallable<ListModelsRequest, ListModelsResponse> listModelsCallable() {
        return this.listModelsCallable;
    }

    @Override
    public UnaryCallable<ListModelsRequest, AutoMlClient.ListModelsPagedResponse> listModelsPagedCallable() {
        return this.listModelsPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteModelRequest, Operation> deleteModelCallable() {
        return this.deleteModelCallable;
    }

    @Override
    public OperationCallable<DeleteModelRequest, Empty, OperationMetadata> deleteModelOperationCallable() {
        return this.deleteModelOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateModelRequest, Model> updateModelCallable() {
        return this.updateModelCallable;
    }

    @Override
    public UnaryCallable<DeployModelRequest, Operation> deployModelCallable() {
        return this.deployModelCallable;
    }

    @Override
    public OperationCallable<DeployModelRequest, Empty, OperationMetadata> deployModelOperationCallable() {
        return this.deployModelOperationCallable;
    }

    @Override
    public UnaryCallable<UndeployModelRequest, Operation> undeployModelCallable() {
        return this.undeployModelCallable;
    }

    @Override
    public OperationCallable<UndeployModelRequest, Empty, OperationMetadata> undeployModelOperationCallable() {
        return this.undeployModelOperationCallable;
    }

    @Override
    public UnaryCallable<ExportModelRequest, Operation> exportModelCallable() {
        return this.exportModelCallable;
    }

    @Override
    public OperationCallable<ExportModelRequest, Empty, OperationMetadata> exportModelOperationCallable() {
        return this.exportModelOperationCallable;
    }

    @Override
    public UnaryCallable<GetModelEvaluationRequest, ModelEvaluation> getModelEvaluationCallable() {
        return this.getModelEvaluationCallable;
    }

    @Override
    public UnaryCallable<ListModelEvaluationsRequest, ListModelEvaluationsResponse> listModelEvaluationsCallable() {
        return this.listModelEvaluationsCallable;
    }

    @Override
    public UnaryCallable<ListModelEvaluationsRequest, AutoMlClient.ListModelEvaluationsPagedResponse> listModelEvaluationsPagedCallable() {
        return this.listModelEvaluationsPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

