/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.automl.v1beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.automl.v1beta1.BatchPredictRequest;
import com.google.cloud.automl.v1beta1.BatchPredictResult;
import com.google.cloud.automl.v1beta1.OperationMetadata;
import com.google.cloud.automl.v1beta1.PredictRequest;
import com.google.cloud.automl.v1beta1.PredictResponse;
import com.google.cloud.automl.v1beta1.stub.GrpcPredictionServiceCallableFactory;
import com.google.cloud.automl.v1beta1.stub.PredictionServiceStub;
import com.google.cloud.automl.v1beta1.stub.PredictionServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcPredictionServiceStub
extends PredictionServiceStub {
    private static final MethodDescriptor<PredictRequest, PredictResponse> predictMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.automl.v1beta1.PredictionService/Predict").setRequestMarshaller(ProtoUtils.marshaller((Message)PredictRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)PredictResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<BatchPredictRequest, Operation> batchPredictMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.automl.v1beta1.PredictionService/BatchPredict").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchPredictRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<PredictRequest, PredictResponse> predictCallable;
    private final UnaryCallable<BatchPredictRequest, Operation> batchPredictCallable;
    private final OperationCallable<BatchPredictRequest, BatchPredictResult, OperationMetadata> batchPredictOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcPredictionServiceStub create(PredictionServiceStubSettings settings) throws IOException {
        return new GrpcPredictionServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcPredictionServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcPredictionServiceStub(PredictionServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcPredictionServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcPredictionServiceStub(PredictionServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcPredictionServiceStub(PredictionServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcPredictionServiceCallableFactory());
    }

    protected GrpcPredictionServiceStub(PredictionServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings predictTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(predictMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings batchPredictTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchPredictMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.predictCallable = callableFactory.createUnaryCallable(predictTransportSettings, settings.predictSettings(), clientContext);
        this.batchPredictCallable = callableFactory.createUnaryCallable(batchPredictTransportSettings, settings.batchPredictSettings(), clientContext);
        this.batchPredictOperationCallable = callableFactory.createOperationCallable(batchPredictTransportSettings, settings.batchPredictOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<PredictRequest, PredictResponse> predictCallable() {
        return this.predictCallable;
    }

    @Override
    public UnaryCallable<BatchPredictRequest, Operation> batchPredictCallable() {
        return this.batchPredictCallable;
    }

    @Override
    public OperationCallable<BatchPredictRequest, BatchPredictResult, OperationMetadata> batchPredictOperationCallable() {
        return this.batchPredictOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

