/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.automl.v1beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.automl.v1beta1.AnnotationSpec;
import com.google.cloud.automl.v1beta1.AutoMlClient;
import com.google.cloud.automl.v1beta1.ColumnSpec;
import com.google.cloud.automl.v1beta1.CreateDatasetRequest;
import com.google.cloud.automl.v1beta1.CreateModelRequest;
import com.google.cloud.automl.v1beta1.Dataset;
import com.google.cloud.automl.v1beta1.DeleteDatasetRequest;
import com.google.cloud.automl.v1beta1.DeleteModelRequest;
import com.google.cloud.automl.v1beta1.DeployModelRequest;
import com.google.cloud.automl.v1beta1.ExportDataRequest;
import com.google.cloud.automl.v1beta1.ExportEvaluatedExamplesRequest;
import com.google.cloud.automl.v1beta1.ExportModelRequest;
import com.google.cloud.automl.v1beta1.GetAnnotationSpecRequest;
import com.google.cloud.automl.v1beta1.GetColumnSpecRequest;
import com.google.cloud.automl.v1beta1.GetDatasetRequest;
import com.google.cloud.automl.v1beta1.GetModelEvaluationRequest;
import com.google.cloud.automl.v1beta1.GetModelRequest;
import com.google.cloud.automl.v1beta1.GetTableSpecRequest;
import com.google.cloud.automl.v1beta1.ImportDataRequest;
import com.google.cloud.automl.v1beta1.ListColumnSpecsRequest;
import com.google.cloud.automl.v1beta1.ListColumnSpecsResponse;
import com.google.cloud.automl.v1beta1.ListDatasetsRequest;
import com.google.cloud.automl.v1beta1.ListDatasetsResponse;
import com.google.cloud.automl.v1beta1.ListModelEvaluationsRequest;
import com.google.cloud.automl.v1beta1.ListModelEvaluationsResponse;
import com.google.cloud.automl.v1beta1.ListModelsRequest;
import com.google.cloud.automl.v1beta1.ListModelsResponse;
import com.google.cloud.automl.v1beta1.ListTableSpecsRequest;
import com.google.cloud.automl.v1beta1.ListTableSpecsResponse;
import com.google.cloud.automl.v1beta1.Model;
import com.google.cloud.automl.v1beta1.ModelEvaluation;
import com.google.cloud.automl.v1beta1.OperationMetadata;
import com.google.cloud.automl.v1beta1.TableSpec;
import com.google.cloud.automl.v1beta1.UndeployModelRequest;
import com.google.cloud.automl.v1beta1.UpdateColumnSpecRequest;
import com.google.cloud.automl.v1beta1.UpdateDatasetRequest;
import com.google.cloud.automl.v1beta1.UpdateTableSpecRequest;
import com.google.cloud.automl.v1beta1.stub.AutoMlStub;
import com.google.cloud.automl.v1beta1.stub.GrpcAutoMlStub;
import com.google.cloud.automl.v1beta1.stub.HttpJsonAutoMlStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class AutoMlStubSettings
extends StubSettings<AutoMlStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateDatasetRequest, Dataset> createDatasetSettings;
    private final UnaryCallSettings<GetDatasetRequest, Dataset> getDatasetSettings;
    private final PagedCallSettings<ListDatasetsRequest, ListDatasetsResponse, AutoMlClient.ListDatasetsPagedResponse> listDatasetsSettings;
    private final UnaryCallSettings<UpdateDatasetRequest, Dataset> updateDatasetSettings;
    private final UnaryCallSettings<DeleteDatasetRequest, Operation> deleteDatasetSettings;
    private final OperationCallSettings<DeleteDatasetRequest, Empty, OperationMetadata> deleteDatasetOperationSettings;
    private final UnaryCallSettings<ImportDataRequest, Operation> importDataSettings;
    private final OperationCallSettings<ImportDataRequest, Empty, OperationMetadata> importDataOperationSettings;
    private final UnaryCallSettings<ExportDataRequest, Operation> exportDataSettings;
    private final OperationCallSettings<ExportDataRequest, Empty, OperationMetadata> exportDataOperationSettings;
    private final UnaryCallSettings<GetAnnotationSpecRequest, AnnotationSpec> getAnnotationSpecSettings;
    private final UnaryCallSettings<GetTableSpecRequest, TableSpec> getTableSpecSettings;
    private final PagedCallSettings<ListTableSpecsRequest, ListTableSpecsResponse, AutoMlClient.ListTableSpecsPagedResponse> listTableSpecsSettings;
    private final UnaryCallSettings<UpdateTableSpecRequest, TableSpec> updateTableSpecSettings;
    private final UnaryCallSettings<GetColumnSpecRequest, ColumnSpec> getColumnSpecSettings;
    private final PagedCallSettings<ListColumnSpecsRequest, ListColumnSpecsResponse, AutoMlClient.ListColumnSpecsPagedResponse> listColumnSpecsSettings;
    private final UnaryCallSettings<UpdateColumnSpecRequest, ColumnSpec> updateColumnSpecSettings;
    private final UnaryCallSettings<CreateModelRequest, Operation> createModelSettings;
    private final OperationCallSettings<CreateModelRequest, Model, OperationMetadata> createModelOperationSettings;
    private final UnaryCallSettings<GetModelRequest, Model> getModelSettings;
    private final PagedCallSettings<ListModelsRequest, ListModelsResponse, AutoMlClient.ListModelsPagedResponse> listModelsSettings;
    private final UnaryCallSettings<DeleteModelRequest, Operation> deleteModelSettings;
    private final OperationCallSettings<DeleteModelRequest, Empty, OperationMetadata> deleteModelOperationSettings;
    private final UnaryCallSettings<DeployModelRequest, Operation> deployModelSettings;
    private final OperationCallSettings<DeployModelRequest, Empty, OperationMetadata> deployModelOperationSettings;
    private final UnaryCallSettings<UndeployModelRequest, Operation> undeployModelSettings;
    private final OperationCallSettings<UndeployModelRequest, Empty, OperationMetadata> undeployModelOperationSettings;
    private final UnaryCallSettings<ExportModelRequest, Operation> exportModelSettings;
    private final OperationCallSettings<ExportModelRequest, Empty, OperationMetadata> exportModelOperationSettings;
    private final UnaryCallSettings<ExportEvaluatedExamplesRequest, Operation> exportEvaluatedExamplesSettings;
    private final OperationCallSettings<ExportEvaluatedExamplesRequest, Empty, OperationMetadata> exportEvaluatedExamplesOperationSettings;
    private final UnaryCallSettings<GetModelEvaluationRequest, ModelEvaluation> getModelEvaluationSettings;
    private final PagedCallSettings<ListModelEvaluationsRequest, ListModelEvaluationsResponse, AutoMlClient.ListModelEvaluationsPagedResponse> listModelEvaluationsSettings;
    private static final PagedListDescriptor<ListDatasetsRequest, ListDatasetsResponse, Dataset> LIST_DATASETS_PAGE_STR_DESC = new PagedListDescriptor<ListDatasetsRequest, ListDatasetsResponse, Dataset>(){

        public String emptyToken() {
            return "";
        }

        public ListDatasetsRequest injectToken(ListDatasetsRequest payload, String token) {
            return ListDatasetsRequest.newBuilder((ListDatasetsRequest)payload).setPageToken(token).build();
        }

        public ListDatasetsRequest injectPageSize(ListDatasetsRequest payload, int pageSize) {
            return ListDatasetsRequest.newBuilder((ListDatasetsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDatasetsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDatasetsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Dataset> extractResources(ListDatasetsResponse payload) {
            return payload.getDatasetsList() == null ? ImmutableList.of() : payload.getDatasetsList();
        }
    };
    private static final PagedListDescriptor<ListTableSpecsRequest, ListTableSpecsResponse, TableSpec> LIST_TABLE_SPECS_PAGE_STR_DESC = new PagedListDescriptor<ListTableSpecsRequest, ListTableSpecsResponse, TableSpec>(){

        public String emptyToken() {
            return "";
        }

        public ListTableSpecsRequest injectToken(ListTableSpecsRequest payload, String token) {
            return ListTableSpecsRequest.newBuilder((ListTableSpecsRequest)payload).setPageToken(token).build();
        }

        public ListTableSpecsRequest injectPageSize(ListTableSpecsRequest payload, int pageSize) {
            return ListTableSpecsRequest.newBuilder((ListTableSpecsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTableSpecsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTableSpecsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TableSpec> extractResources(ListTableSpecsResponse payload) {
            return payload.getTableSpecsList() == null ? ImmutableList.of() : payload.getTableSpecsList();
        }
    };
    private static final PagedListDescriptor<ListColumnSpecsRequest, ListColumnSpecsResponse, ColumnSpec> LIST_COLUMN_SPECS_PAGE_STR_DESC = new PagedListDescriptor<ListColumnSpecsRequest, ListColumnSpecsResponse, ColumnSpec>(){

        public String emptyToken() {
            return "";
        }

        public ListColumnSpecsRequest injectToken(ListColumnSpecsRequest payload, String token) {
            return ListColumnSpecsRequest.newBuilder((ListColumnSpecsRequest)payload).setPageToken(token).build();
        }

        public ListColumnSpecsRequest injectPageSize(ListColumnSpecsRequest payload, int pageSize) {
            return ListColumnSpecsRequest.newBuilder((ListColumnSpecsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListColumnSpecsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListColumnSpecsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ColumnSpec> extractResources(ListColumnSpecsResponse payload) {
            return payload.getColumnSpecsList() == null ? ImmutableList.of() : payload.getColumnSpecsList();
        }
    };
    private static final PagedListDescriptor<ListModelsRequest, ListModelsResponse, Model> LIST_MODELS_PAGE_STR_DESC = new PagedListDescriptor<ListModelsRequest, ListModelsResponse, Model>(){

        public String emptyToken() {
            return "";
        }

        public ListModelsRequest injectToken(ListModelsRequest payload, String token) {
            return ListModelsRequest.newBuilder((ListModelsRequest)payload).setPageToken(token).build();
        }

        public ListModelsRequest injectPageSize(ListModelsRequest payload, int pageSize) {
            return ListModelsRequest.newBuilder((ListModelsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListModelsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListModelsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Model> extractResources(ListModelsResponse payload) {
            return payload.getModelList() == null ? ImmutableList.of() : payload.getModelList();
        }
    };
    private static final PagedListDescriptor<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelEvaluation> LIST_MODEL_EVALUATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelEvaluation>(){

        public String emptyToken() {
            return "";
        }

        public ListModelEvaluationsRequest injectToken(ListModelEvaluationsRequest payload, String token) {
            return ListModelEvaluationsRequest.newBuilder((ListModelEvaluationsRequest)payload).setPageToken(token).build();
        }

        public ListModelEvaluationsRequest injectPageSize(ListModelEvaluationsRequest payload, int pageSize) {
            return ListModelEvaluationsRequest.newBuilder((ListModelEvaluationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListModelEvaluationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListModelEvaluationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ModelEvaluation> extractResources(ListModelEvaluationsResponse payload) {
            return payload.getModelEvaluationList() == null ? ImmutableList.of() : payload.getModelEvaluationList();
        }
    };
    private static final PagedListResponseFactory<ListDatasetsRequest, ListDatasetsResponse, AutoMlClient.ListDatasetsPagedResponse> LIST_DATASETS_PAGE_STR_FACT = new PagedListResponseFactory<ListDatasetsRequest, ListDatasetsResponse, AutoMlClient.ListDatasetsPagedResponse>(){

        public ApiFuture<AutoMlClient.ListDatasetsPagedResponse> getFuturePagedResponse(UnaryCallable<ListDatasetsRequest, ListDatasetsResponse> callable, ListDatasetsRequest request, ApiCallContext context, ApiFuture<ListDatasetsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DATASETS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AutoMlClient.ListDatasetsPagedResponse.createAsync((PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListTableSpecsRequest, ListTableSpecsResponse, AutoMlClient.ListTableSpecsPagedResponse> LIST_TABLE_SPECS_PAGE_STR_FACT = new PagedListResponseFactory<ListTableSpecsRequest, ListTableSpecsResponse, AutoMlClient.ListTableSpecsPagedResponse>(){

        public ApiFuture<AutoMlClient.ListTableSpecsPagedResponse> getFuturePagedResponse(UnaryCallable<ListTableSpecsRequest, ListTableSpecsResponse> callable, ListTableSpecsRequest request, ApiCallContext context, ApiFuture<ListTableSpecsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TABLE_SPECS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AutoMlClient.ListTableSpecsPagedResponse.createAsync((PageContext<ListTableSpecsRequest, ListTableSpecsResponse, TableSpec>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListColumnSpecsRequest, ListColumnSpecsResponse, AutoMlClient.ListColumnSpecsPagedResponse> LIST_COLUMN_SPECS_PAGE_STR_FACT = new PagedListResponseFactory<ListColumnSpecsRequest, ListColumnSpecsResponse, AutoMlClient.ListColumnSpecsPagedResponse>(){

        public ApiFuture<AutoMlClient.ListColumnSpecsPagedResponse> getFuturePagedResponse(UnaryCallable<ListColumnSpecsRequest, ListColumnSpecsResponse> callable, ListColumnSpecsRequest request, ApiCallContext context, ApiFuture<ListColumnSpecsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_COLUMN_SPECS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AutoMlClient.ListColumnSpecsPagedResponse.createAsync((PageContext<ListColumnSpecsRequest, ListColumnSpecsResponse, ColumnSpec>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListModelsRequest, ListModelsResponse, AutoMlClient.ListModelsPagedResponse> LIST_MODELS_PAGE_STR_FACT = new PagedListResponseFactory<ListModelsRequest, ListModelsResponse, AutoMlClient.ListModelsPagedResponse>(){

        public ApiFuture<AutoMlClient.ListModelsPagedResponse> getFuturePagedResponse(UnaryCallable<ListModelsRequest, ListModelsResponse> callable, ListModelsRequest request, ApiCallContext context, ApiFuture<ListModelsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MODELS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AutoMlClient.ListModelsPagedResponse.createAsync((PageContext<ListModelsRequest, ListModelsResponse, Model>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListModelEvaluationsRequest, ListModelEvaluationsResponse, AutoMlClient.ListModelEvaluationsPagedResponse> LIST_MODEL_EVALUATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListModelEvaluationsRequest, ListModelEvaluationsResponse, AutoMlClient.ListModelEvaluationsPagedResponse>(){

        public ApiFuture<AutoMlClient.ListModelEvaluationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListModelEvaluationsRequest, ListModelEvaluationsResponse> callable, ListModelEvaluationsRequest request, ApiCallContext context, ApiFuture<ListModelEvaluationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MODEL_EVALUATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AutoMlClient.ListModelEvaluationsPagedResponse.createAsync((PageContext<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelEvaluation>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateDatasetRequest, Dataset> createDatasetSettings() {
        return this.createDatasetSettings;
    }

    public UnaryCallSettings<GetDatasetRequest, Dataset> getDatasetSettings() {
        return this.getDatasetSettings;
    }

    public PagedCallSettings<ListDatasetsRequest, ListDatasetsResponse, AutoMlClient.ListDatasetsPagedResponse> listDatasetsSettings() {
        return this.listDatasetsSettings;
    }

    public UnaryCallSettings<UpdateDatasetRequest, Dataset> updateDatasetSettings() {
        return this.updateDatasetSettings;
    }

    public UnaryCallSettings<DeleteDatasetRequest, Operation> deleteDatasetSettings() {
        return this.deleteDatasetSettings;
    }

    public OperationCallSettings<DeleteDatasetRequest, Empty, OperationMetadata> deleteDatasetOperationSettings() {
        return this.deleteDatasetOperationSettings;
    }

    public UnaryCallSettings<ImportDataRequest, Operation> importDataSettings() {
        return this.importDataSettings;
    }

    public OperationCallSettings<ImportDataRequest, Empty, OperationMetadata> importDataOperationSettings() {
        return this.importDataOperationSettings;
    }

    public UnaryCallSettings<ExportDataRequest, Operation> exportDataSettings() {
        return this.exportDataSettings;
    }

    public OperationCallSettings<ExportDataRequest, Empty, OperationMetadata> exportDataOperationSettings() {
        return this.exportDataOperationSettings;
    }

    public UnaryCallSettings<GetAnnotationSpecRequest, AnnotationSpec> getAnnotationSpecSettings() {
        return this.getAnnotationSpecSettings;
    }

    public UnaryCallSettings<GetTableSpecRequest, TableSpec> getTableSpecSettings() {
        return this.getTableSpecSettings;
    }

    public PagedCallSettings<ListTableSpecsRequest, ListTableSpecsResponse, AutoMlClient.ListTableSpecsPagedResponse> listTableSpecsSettings() {
        return this.listTableSpecsSettings;
    }

    public UnaryCallSettings<UpdateTableSpecRequest, TableSpec> updateTableSpecSettings() {
        return this.updateTableSpecSettings;
    }

    public UnaryCallSettings<GetColumnSpecRequest, ColumnSpec> getColumnSpecSettings() {
        return this.getColumnSpecSettings;
    }

    public PagedCallSettings<ListColumnSpecsRequest, ListColumnSpecsResponse, AutoMlClient.ListColumnSpecsPagedResponse> listColumnSpecsSettings() {
        return this.listColumnSpecsSettings;
    }

    public UnaryCallSettings<UpdateColumnSpecRequest, ColumnSpec> updateColumnSpecSettings() {
        return this.updateColumnSpecSettings;
    }

    public UnaryCallSettings<CreateModelRequest, Operation> createModelSettings() {
        return this.createModelSettings;
    }

    public OperationCallSettings<CreateModelRequest, Model, OperationMetadata> createModelOperationSettings() {
        return this.createModelOperationSettings;
    }

    public UnaryCallSettings<GetModelRequest, Model> getModelSettings() {
        return this.getModelSettings;
    }

    public PagedCallSettings<ListModelsRequest, ListModelsResponse, AutoMlClient.ListModelsPagedResponse> listModelsSettings() {
        return this.listModelsSettings;
    }

    public UnaryCallSettings<DeleteModelRequest, Operation> deleteModelSettings() {
        return this.deleteModelSettings;
    }

    public OperationCallSettings<DeleteModelRequest, Empty, OperationMetadata> deleteModelOperationSettings() {
        return this.deleteModelOperationSettings;
    }

    public UnaryCallSettings<DeployModelRequest, Operation> deployModelSettings() {
        return this.deployModelSettings;
    }

    public OperationCallSettings<DeployModelRequest, Empty, OperationMetadata> deployModelOperationSettings() {
        return this.deployModelOperationSettings;
    }

    public UnaryCallSettings<UndeployModelRequest, Operation> undeployModelSettings() {
        return this.undeployModelSettings;
    }

    public OperationCallSettings<UndeployModelRequest, Empty, OperationMetadata> undeployModelOperationSettings() {
        return this.undeployModelOperationSettings;
    }

    public UnaryCallSettings<ExportModelRequest, Operation> exportModelSettings() {
        return this.exportModelSettings;
    }

    public OperationCallSettings<ExportModelRequest, Empty, OperationMetadata> exportModelOperationSettings() {
        return this.exportModelOperationSettings;
    }

    public UnaryCallSettings<ExportEvaluatedExamplesRequest, Operation> exportEvaluatedExamplesSettings() {
        return this.exportEvaluatedExamplesSettings;
    }

    public OperationCallSettings<ExportEvaluatedExamplesRequest, Empty, OperationMetadata> exportEvaluatedExamplesOperationSettings() {
        return this.exportEvaluatedExamplesOperationSettings;
    }

    public UnaryCallSettings<GetModelEvaluationRequest, ModelEvaluation> getModelEvaluationSettings() {
        return this.getModelEvaluationSettings;
    }

    public PagedCallSettings<ListModelEvaluationsRequest, ListModelEvaluationsResponse, AutoMlClient.ListModelEvaluationsPagedResponse> listModelEvaluationsSettings() {
        return this.listModelEvaluationsSettings;
    }

    public AutoMlStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAutoMlStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonAutoMlStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return AutoMlStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "automl";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "automl.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "automl.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AutoMlStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AutoMlStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AutoMlStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return AutoMlStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AutoMlStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createDatasetSettings = settingsBuilder.createDatasetSettings().build();
        this.getDatasetSettings = settingsBuilder.getDatasetSettings().build();
        this.listDatasetsSettings = settingsBuilder.listDatasetsSettings().build();
        this.updateDatasetSettings = settingsBuilder.updateDatasetSettings().build();
        this.deleteDatasetSettings = settingsBuilder.deleteDatasetSettings().build();
        this.deleteDatasetOperationSettings = settingsBuilder.deleteDatasetOperationSettings().build();
        this.importDataSettings = settingsBuilder.importDataSettings().build();
        this.importDataOperationSettings = settingsBuilder.importDataOperationSettings().build();
        this.exportDataSettings = settingsBuilder.exportDataSettings().build();
        this.exportDataOperationSettings = settingsBuilder.exportDataOperationSettings().build();
        this.getAnnotationSpecSettings = settingsBuilder.getAnnotationSpecSettings().build();
        this.getTableSpecSettings = settingsBuilder.getTableSpecSettings().build();
        this.listTableSpecsSettings = settingsBuilder.listTableSpecsSettings().build();
        this.updateTableSpecSettings = settingsBuilder.updateTableSpecSettings().build();
        this.getColumnSpecSettings = settingsBuilder.getColumnSpecSettings().build();
        this.listColumnSpecsSettings = settingsBuilder.listColumnSpecsSettings().build();
        this.updateColumnSpecSettings = settingsBuilder.updateColumnSpecSettings().build();
        this.createModelSettings = settingsBuilder.createModelSettings().build();
        this.createModelOperationSettings = settingsBuilder.createModelOperationSettings().build();
        this.getModelSettings = settingsBuilder.getModelSettings().build();
        this.listModelsSettings = settingsBuilder.listModelsSettings().build();
        this.deleteModelSettings = settingsBuilder.deleteModelSettings().build();
        this.deleteModelOperationSettings = settingsBuilder.deleteModelOperationSettings().build();
        this.deployModelSettings = settingsBuilder.deployModelSettings().build();
        this.deployModelOperationSettings = settingsBuilder.deployModelOperationSettings().build();
        this.undeployModelSettings = settingsBuilder.undeployModelSettings().build();
        this.undeployModelOperationSettings = settingsBuilder.undeployModelOperationSettings().build();
        this.exportModelSettings = settingsBuilder.exportModelSettings().build();
        this.exportModelOperationSettings = settingsBuilder.exportModelOperationSettings().build();
        this.exportEvaluatedExamplesSettings = settingsBuilder.exportEvaluatedExamplesSettings().build();
        this.exportEvaluatedExamplesOperationSettings = settingsBuilder.exportEvaluatedExamplesOperationSettings().build();
        this.getModelEvaluationSettings = settingsBuilder.getModelEvaluationSettings().build();
        this.listModelEvaluationsSettings = settingsBuilder.listModelEvaluationsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AutoMlStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateDatasetRequest, Dataset> createDatasetSettings;
        private final UnaryCallSettings.Builder<GetDatasetRequest, Dataset> getDatasetSettings;
        private final PagedCallSettings.Builder<ListDatasetsRequest, ListDatasetsResponse, AutoMlClient.ListDatasetsPagedResponse> listDatasetsSettings;
        private final UnaryCallSettings.Builder<UpdateDatasetRequest, Dataset> updateDatasetSettings;
        private final UnaryCallSettings.Builder<DeleteDatasetRequest, Operation> deleteDatasetSettings;
        private final OperationCallSettings.Builder<DeleteDatasetRequest, Empty, OperationMetadata> deleteDatasetOperationSettings;
        private final UnaryCallSettings.Builder<ImportDataRequest, Operation> importDataSettings;
        private final OperationCallSettings.Builder<ImportDataRequest, Empty, OperationMetadata> importDataOperationSettings;
        private final UnaryCallSettings.Builder<ExportDataRequest, Operation> exportDataSettings;
        private final OperationCallSettings.Builder<ExportDataRequest, Empty, OperationMetadata> exportDataOperationSettings;
        private final UnaryCallSettings.Builder<GetAnnotationSpecRequest, AnnotationSpec> getAnnotationSpecSettings;
        private final UnaryCallSettings.Builder<GetTableSpecRequest, TableSpec> getTableSpecSettings;
        private final PagedCallSettings.Builder<ListTableSpecsRequest, ListTableSpecsResponse, AutoMlClient.ListTableSpecsPagedResponse> listTableSpecsSettings;
        private final UnaryCallSettings.Builder<UpdateTableSpecRequest, TableSpec> updateTableSpecSettings;
        private final UnaryCallSettings.Builder<GetColumnSpecRequest, ColumnSpec> getColumnSpecSettings;
        private final PagedCallSettings.Builder<ListColumnSpecsRequest, ListColumnSpecsResponse, AutoMlClient.ListColumnSpecsPagedResponse> listColumnSpecsSettings;
        private final UnaryCallSettings.Builder<UpdateColumnSpecRequest, ColumnSpec> updateColumnSpecSettings;
        private final UnaryCallSettings.Builder<CreateModelRequest, Operation> createModelSettings;
        private final OperationCallSettings.Builder<CreateModelRequest, Model, OperationMetadata> createModelOperationSettings;
        private final UnaryCallSettings.Builder<GetModelRequest, Model> getModelSettings;
        private final PagedCallSettings.Builder<ListModelsRequest, ListModelsResponse, AutoMlClient.ListModelsPagedResponse> listModelsSettings;
        private final UnaryCallSettings.Builder<DeleteModelRequest, Operation> deleteModelSettings;
        private final OperationCallSettings.Builder<DeleteModelRequest, Empty, OperationMetadata> deleteModelOperationSettings;
        private final UnaryCallSettings.Builder<DeployModelRequest, Operation> deployModelSettings;
        private final OperationCallSettings.Builder<DeployModelRequest, Empty, OperationMetadata> deployModelOperationSettings;
        private final UnaryCallSettings.Builder<UndeployModelRequest, Operation> undeployModelSettings;
        private final OperationCallSettings.Builder<UndeployModelRequest, Empty, OperationMetadata> undeployModelOperationSettings;
        private final UnaryCallSettings.Builder<ExportModelRequest, Operation> exportModelSettings;
        private final OperationCallSettings.Builder<ExportModelRequest, Empty, OperationMetadata> exportModelOperationSettings;
        private final UnaryCallSettings.Builder<ExportEvaluatedExamplesRequest, Operation> exportEvaluatedExamplesSettings;
        private final OperationCallSettings.Builder<ExportEvaluatedExamplesRequest, Empty, OperationMetadata> exportEvaluatedExamplesOperationSettings;
        private final UnaryCallSettings.Builder<GetModelEvaluationRequest, ModelEvaluation> getModelEvaluationSettings;
        private final PagedCallSettings.Builder<ListModelEvaluationsRequest, ListModelEvaluationsResponse, AutoMlClient.ListModelEvaluationsPagedResponse> listModelEvaluationsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createDatasetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getDatasetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDatasetsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DATASETS_PAGE_STR_FACT);
            this.updateDatasetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDatasetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDatasetOperationSettings = OperationCallSettings.newBuilder();
            this.importDataSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importDataOperationSettings = OperationCallSettings.newBuilder();
            this.exportDataSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.exportDataOperationSettings = OperationCallSettings.newBuilder();
            this.getAnnotationSpecSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getTableSpecSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTableSpecsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TABLE_SPECS_PAGE_STR_FACT);
            this.updateTableSpecSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getColumnSpecSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listColumnSpecsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_COLUMN_SPECS_PAGE_STR_FACT);
            this.updateColumnSpecSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createModelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createModelOperationSettings = OperationCallSettings.newBuilder();
            this.getModelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listModelsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_MODELS_PAGE_STR_FACT);
            this.deleteModelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteModelOperationSettings = OperationCallSettings.newBuilder();
            this.deployModelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deployModelOperationSettings = OperationCallSettings.newBuilder();
            this.undeployModelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.undeployModelOperationSettings = OperationCallSettings.newBuilder();
            this.exportModelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.exportModelOperationSettings = OperationCallSettings.newBuilder();
            this.exportEvaluatedExamplesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.exportEvaluatedExamplesOperationSettings = OperationCallSettings.newBuilder();
            this.getModelEvaluationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listModelEvaluationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_MODEL_EVALUATIONS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createDatasetSettings, this.getDatasetSettings, this.listDatasetsSettings, this.updateDatasetSettings, this.deleteDatasetSettings, this.importDataSettings, this.exportDataSettings, this.getAnnotationSpecSettings, this.getTableSpecSettings, this.listTableSpecsSettings, this.updateTableSpecSettings, this.getColumnSpecSettings, (Object[])new UnaryCallSettings.Builder[]{this.listColumnSpecsSettings, this.updateColumnSpecSettings, this.createModelSettings, this.getModelSettings, this.listModelsSettings, this.deleteModelSettings, this.deployModelSettings, this.undeployModelSettings, this.exportModelSettings, this.exportEvaluatedExamplesSettings, this.getModelEvaluationSettings, this.listModelEvaluationsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(AutoMlStubSettings settings) {
            super((StubSettings)settings);
            this.createDatasetSettings = settings.createDatasetSettings.toBuilder();
            this.getDatasetSettings = settings.getDatasetSettings.toBuilder();
            this.listDatasetsSettings = settings.listDatasetsSettings.toBuilder();
            this.updateDatasetSettings = settings.updateDatasetSettings.toBuilder();
            this.deleteDatasetSettings = settings.deleteDatasetSettings.toBuilder();
            this.deleteDatasetOperationSettings = settings.deleteDatasetOperationSettings.toBuilder();
            this.importDataSettings = settings.importDataSettings.toBuilder();
            this.importDataOperationSettings = settings.importDataOperationSettings.toBuilder();
            this.exportDataSettings = settings.exportDataSettings.toBuilder();
            this.exportDataOperationSettings = settings.exportDataOperationSettings.toBuilder();
            this.getAnnotationSpecSettings = settings.getAnnotationSpecSettings.toBuilder();
            this.getTableSpecSettings = settings.getTableSpecSettings.toBuilder();
            this.listTableSpecsSettings = settings.listTableSpecsSettings.toBuilder();
            this.updateTableSpecSettings = settings.updateTableSpecSettings.toBuilder();
            this.getColumnSpecSettings = settings.getColumnSpecSettings.toBuilder();
            this.listColumnSpecsSettings = settings.listColumnSpecsSettings.toBuilder();
            this.updateColumnSpecSettings = settings.updateColumnSpecSettings.toBuilder();
            this.createModelSettings = settings.createModelSettings.toBuilder();
            this.createModelOperationSettings = settings.createModelOperationSettings.toBuilder();
            this.getModelSettings = settings.getModelSettings.toBuilder();
            this.listModelsSettings = settings.listModelsSettings.toBuilder();
            this.deleteModelSettings = settings.deleteModelSettings.toBuilder();
            this.deleteModelOperationSettings = settings.deleteModelOperationSettings.toBuilder();
            this.deployModelSettings = settings.deployModelSettings.toBuilder();
            this.deployModelOperationSettings = settings.deployModelOperationSettings.toBuilder();
            this.undeployModelSettings = settings.undeployModelSettings.toBuilder();
            this.undeployModelOperationSettings = settings.undeployModelOperationSettings.toBuilder();
            this.exportModelSettings = settings.exportModelSettings.toBuilder();
            this.exportModelOperationSettings = settings.exportModelOperationSettings.toBuilder();
            this.exportEvaluatedExamplesSettings = settings.exportEvaluatedExamplesSettings.toBuilder();
            this.exportEvaluatedExamplesOperationSettings = settings.exportEvaluatedExamplesOperationSettings.toBuilder();
            this.getModelEvaluationSettings = settings.getModelEvaluationSettings.toBuilder();
            this.listModelEvaluationsSettings = settings.listModelEvaluationsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createDatasetSettings, this.getDatasetSettings, this.listDatasetsSettings, this.updateDatasetSettings, this.deleteDatasetSettings, this.importDataSettings, this.exportDataSettings, this.getAnnotationSpecSettings, this.getTableSpecSettings, this.listTableSpecsSettings, this.updateTableSpecSettings, this.getColumnSpecSettings, (Object[])new UnaryCallSettings.Builder[]{this.listColumnSpecsSettings, this.updateColumnSpecSettings, this.createModelSettings, this.getModelSettings, this.listModelsSettings, this.deleteModelSettings, this.deployModelSettings, this.undeployModelSettings, this.exportModelSettings, this.exportEvaluatedExamplesSettings, this.getModelEvaluationSettings, this.listModelEvaluationsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AutoMlStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AutoMlStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AutoMlStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AutoMlStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)AutoMlStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)AutoMlStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AutoMlStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AutoMlStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createDatasetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getDatasetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.listDatasetsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.updateDatasetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteDatasetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.importDataSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.exportDataSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getAnnotationSpecSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.getTableSpecSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.listTableSpecsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.updateTableSpecSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getColumnSpecSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.listColumnSpecsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.updateColumnSpecSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createModelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getModelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.listModelsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.deleteModelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.deployModelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.undeployModelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.exportModelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.exportEvaluatedExamplesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getModelEvaluationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.listModelEvaluationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteDatasetOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.importDataOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.exportDataOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createModelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Model.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteModelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deployModelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.undeployModelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.exportModelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.exportEvaluatedExamplesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateDatasetRequest, Dataset> createDatasetSettings() {
            return this.createDatasetSettings;
        }

        public UnaryCallSettings.Builder<GetDatasetRequest, Dataset> getDatasetSettings() {
            return this.getDatasetSettings;
        }

        public PagedCallSettings.Builder<ListDatasetsRequest, ListDatasetsResponse, AutoMlClient.ListDatasetsPagedResponse> listDatasetsSettings() {
            return this.listDatasetsSettings;
        }

        public UnaryCallSettings.Builder<UpdateDatasetRequest, Dataset> updateDatasetSettings() {
            return this.updateDatasetSettings;
        }

        public UnaryCallSettings.Builder<DeleteDatasetRequest, Operation> deleteDatasetSettings() {
            return this.deleteDatasetSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteDatasetRequest, Empty, OperationMetadata> deleteDatasetOperationSettings() {
            return this.deleteDatasetOperationSettings;
        }

        public UnaryCallSettings.Builder<ImportDataRequest, Operation> importDataSettings() {
            return this.importDataSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ImportDataRequest, Empty, OperationMetadata> importDataOperationSettings() {
            return this.importDataOperationSettings;
        }

        public UnaryCallSettings.Builder<ExportDataRequest, Operation> exportDataSettings() {
            return this.exportDataSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ExportDataRequest, Empty, OperationMetadata> exportDataOperationSettings() {
            return this.exportDataOperationSettings;
        }

        public UnaryCallSettings.Builder<GetAnnotationSpecRequest, AnnotationSpec> getAnnotationSpecSettings() {
            return this.getAnnotationSpecSettings;
        }

        public UnaryCallSettings.Builder<GetTableSpecRequest, TableSpec> getTableSpecSettings() {
            return this.getTableSpecSettings;
        }

        public PagedCallSettings.Builder<ListTableSpecsRequest, ListTableSpecsResponse, AutoMlClient.ListTableSpecsPagedResponse> listTableSpecsSettings() {
            return this.listTableSpecsSettings;
        }

        public UnaryCallSettings.Builder<UpdateTableSpecRequest, TableSpec> updateTableSpecSettings() {
            return this.updateTableSpecSettings;
        }

        public UnaryCallSettings.Builder<GetColumnSpecRequest, ColumnSpec> getColumnSpecSettings() {
            return this.getColumnSpecSettings;
        }

        public PagedCallSettings.Builder<ListColumnSpecsRequest, ListColumnSpecsResponse, AutoMlClient.ListColumnSpecsPagedResponse> listColumnSpecsSettings() {
            return this.listColumnSpecsSettings;
        }

        public UnaryCallSettings.Builder<UpdateColumnSpecRequest, ColumnSpec> updateColumnSpecSettings() {
            return this.updateColumnSpecSettings;
        }

        public UnaryCallSettings.Builder<CreateModelRequest, Operation> createModelSettings() {
            return this.createModelSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateModelRequest, Model, OperationMetadata> createModelOperationSettings() {
            return this.createModelOperationSettings;
        }

        public UnaryCallSettings.Builder<GetModelRequest, Model> getModelSettings() {
            return this.getModelSettings;
        }

        public PagedCallSettings.Builder<ListModelsRequest, ListModelsResponse, AutoMlClient.ListModelsPagedResponse> listModelsSettings() {
            return this.listModelsSettings;
        }

        public UnaryCallSettings.Builder<DeleteModelRequest, Operation> deleteModelSettings() {
            return this.deleteModelSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteModelRequest, Empty, OperationMetadata> deleteModelOperationSettings() {
            return this.deleteModelOperationSettings;
        }

        public UnaryCallSettings.Builder<DeployModelRequest, Operation> deployModelSettings() {
            return this.deployModelSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeployModelRequest, Empty, OperationMetadata> deployModelOperationSettings() {
            return this.deployModelOperationSettings;
        }

        public UnaryCallSettings.Builder<UndeployModelRequest, Operation> undeployModelSettings() {
            return this.undeployModelSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UndeployModelRequest, Empty, OperationMetadata> undeployModelOperationSettings() {
            return this.undeployModelOperationSettings;
        }

        public UnaryCallSettings.Builder<ExportModelRequest, Operation> exportModelSettings() {
            return this.exportModelSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ExportModelRequest, Empty, OperationMetadata> exportModelOperationSettings() {
            return this.exportModelOperationSettings;
        }

        public UnaryCallSettings.Builder<ExportEvaluatedExamplesRequest, Operation> exportEvaluatedExamplesSettings() {
            return this.exportEvaluatedExamplesSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ExportEvaluatedExamplesRequest, Empty, OperationMetadata> exportEvaluatedExamplesOperationSettings() {
            return this.exportEvaluatedExamplesOperationSettings;
        }

        public UnaryCallSettings.Builder<GetModelEvaluationRequest, ModelEvaluation> getModelEvaluationSettings() {
            return this.getModelEvaluationSettings;
        }

        public PagedCallSettings.Builder<ListModelEvaluationsRequest, ListModelEvaluationsResponse, AutoMlClient.ListModelEvaluationsPagedResponse> listModelEvaluationsSettings() {
            return this.listModelEvaluationsSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return AutoMlStubSettings.getDefaultEndpoint();
        }

        public AutoMlStubSettings build() throws IOException {
            return new AutoMlStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_2_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)5000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)5000L)).setTotalTimeout(Duration.ofMillis((long)5000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)5000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)5000L)).setTotalTimeout(Duration.ofMillis((long)5000L)).build();
            definitions.put((Object)"retry_policy_2_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

