/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.automl.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.automl.v1.AnnotationSpec;
import com.google.cloud.automl.v1.AnnotationSpecName;
import com.google.cloud.automl.v1.AutoMlSettings;
import com.google.cloud.automl.v1.CreateDatasetRequest;
import com.google.cloud.automl.v1.CreateModelRequest;
import com.google.cloud.automl.v1.Dataset;
import com.google.cloud.automl.v1.DatasetName;
import com.google.cloud.automl.v1.DeleteDatasetRequest;
import com.google.cloud.automl.v1.DeleteModelRequest;
import com.google.cloud.automl.v1.DeployModelRequest;
import com.google.cloud.automl.v1.ExportDataRequest;
import com.google.cloud.automl.v1.ExportModelRequest;
import com.google.cloud.automl.v1.GetAnnotationSpecRequest;
import com.google.cloud.automl.v1.GetDatasetRequest;
import com.google.cloud.automl.v1.GetModelEvaluationRequest;
import com.google.cloud.automl.v1.GetModelRequest;
import com.google.cloud.automl.v1.ImportDataRequest;
import com.google.cloud.automl.v1.InputConfig;
import com.google.cloud.automl.v1.ListDatasetsRequest;
import com.google.cloud.automl.v1.ListDatasetsResponse;
import com.google.cloud.automl.v1.ListModelEvaluationsRequest;
import com.google.cloud.automl.v1.ListModelEvaluationsResponse;
import com.google.cloud.automl.v1.ListModelsRequest;
import com.google.cloud.automl.v1.ListModelsResponse;
import com.google.cloud.automl.v1.LocationName;
import com.google.cloud.automl.v1.Model;
import com.google.cloud.automl.v1.ModelEvaluation;
import com.google.cloud.automl.v1.ModelEvaluationName;
import com.google.cloud.automl.v1.ModelExportOutputConfig;
import com.google.cloud.automl.v1.ModelName;
import com.google.cloud.automl.v1.OperationMetadata;
import com.google.cloud.automl.v1.OutputConfig;
import com.google.cloud.automl.v1.UndeployModelRequest;
import com.google.cloud.automl.v1.UpdateDatasetRequest;
import com.google.cloud.automl.v1.UpdateModelRequest;
import com.google.cloud.automl.v1.stub.AutoMlStub;
import com.google.cloud.automl.v1.stub.AutoMlStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class AutoMlClient
implements BackgroundResource {
    private final AutoMlSettings settings;
    private final AutoMlStub stub;
    private final OperationsClient operationsClient;

    public static final AutoMlClient create() throws IOException {
        return AutoMlClient.create(AutoMlSettings.newBuilder().build());
    }

    public static final AutoMlClient create(AutoMlSettings settings) throws IOException {
        return new AutoMlClient(settings);
    }

    public static final AutoMlClient create(AutoMlStub stub) {
        return new AutoMlClient(stub);
    }

    protected AutoMlClient(AutoMlSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AutoMlStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected AutoMlClient(AutoMlStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final AutoMlSettings getSettings() {
        return this.settings;
    }

    public AutoMlStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final OperationFuture<Dataset, OperationMetadata> createDatasetAsync(LocationName parent, Dataset dataset) {
        CreateDatasetRequest request = CreateDatasetRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDataset(dataset).build();
        return this.createDatasetAsync(request);
    }

    public final OperationFuture<Dataset, OperationMetadata> createDatasetAsync(String parent, Dataset dataset) {
        CreateDatasetRequest request = CreateDatasetRequest.newBuilder().setParent(parent).setDataset(dataset).build();
        return this.createDatasetAsync(request);
    }

    public final OperationFuture<Dataset, OperationMetadata> createDatasetAsync(CreateDatasetRequest request) {
        return this.createDatasetOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateDatasetRequest, Dataset, OperationMetadata> createDatasetOperationCallable() {
        return this.stub.createDatasetOperationCallable();
    }

    public final UnaryCallable<CreateDatasetRequest, Operation> createDatasetCallable() {
        return this.stub.createDatasetCallable();
    }

    public final Dataset getDataset(DatasetName name) {
        GetDatasetRequest request = GetDatasetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDataset(request);
    }

    public final Dataset getDataset(String name) {
        GetDatasetRequest request = GetDatasetRequest.newBuilder().setName(name).build();
        return this.getDataset(request);
    }

    public final Dataset getDataset(GetDatasetRequest request) {
        return (Dataset)this.getDatasetCallable().call((Object)request);
    }

    public final UnaryCallable<GetDatasetRequest, Dataset> getDatasetCallable() {
        return this.stub.getDatasetCallable();
    }

    public final ListDatasetsPagedResponse listDatasets(LocationName parent) {
        ListDatasetsRequest request = ListDatasetsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDatasets(request);
    }

    public final ListDatasetsPagedResponse listDatasets(String parent) {
        ListDatasetsRequest request = ListDatasetsRequest.newBuilder().setParent(parent).build();
        return this.listDatasets(request);
    }

    public final ListDatasetsPagedResponse listDatasets(ListDatasetsRequest request) {
        return (ListDatasetsPagedResponse)((Object)this.listDatasetsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDatasetsRequest, ListDatasetsPagedResponse> listDatasetsPagedCallable() {
        return this.stub.listDatasetsPagedCallable();
    }

    public final UnaryCallable<ListDatasetsRequest, ListDatasetsResponse> listDatasetsCallable() {
        return this.stub.listDatasetsCallable();
    }

    public final Dataset updateDataset(Dataset dataset, FieldMask updateMask) {
        UpdateDatasetRequest request = UpdateDatasetRequest.newBuilder().setDataset(dataset).setUpdateMask(updateMask).build();
        return this.updateDataset(request);
    }

    public final Dataset updateDataset(UpdateDatasetRequest request) {
        return (Dataset)this.updateDatasetCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateDatasetRequest, Dataset> updateDatasetCallable() {
        return this.stub.updateDatasetCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDatasetAsync(DatasetName name) {
        DeleteDatasetRequest request = DeleteDatasetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteDatasetAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDatasetAsync(String name) {
        DeleteDatasetRequest request = DeleteDatasetRequest.newBuilder().setName(name).build();
        return this.deleteDatasetAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDatasetAsync(DeleteDatasetRequest request) {
        return this.deleteDatasetOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteDatasetRequest, Empty, OperationMetadata> deleteDatasetOperationCallable() {
        return this.stub.deleteDatasetOperationCallable();
    }

    public final UnaryCallable<DeleteDatasetRequest, Operation> deleteDatasetCallable() {
        return this.stub.deleteDatasetCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> importDataAsync(DatasetName name, InputConfig inputConfig) {
        ImportDataRequest request = ImportDataRequest.newBuilder().setName(name == null ? null : name.toString()).setInputConfig(inputConfig).build();
        return this.importDataAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> importDataAsync(String name, InputConfig inputConfig) {
        ImportDataRequest request = ImportDataRequest.newBuilder().setName(name).setInputConfig(inputConfig).build();
        return this.importDataAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> importDataAsync(ImportDataRequest request) {
        return this.importDataOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ImportDataRequest, Empty, OperationMetadata> importDataOperationCallable() {
        return this.stub.importDataOperationCallable();
    }

    public final UnaryCallable<ImportDataRequest, Operation> importDataCallable() {
        return this.stub.importDataCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> exportDataAsync(DatasetName name, OutputConfig outputConfig) {
        ExportDataRequest request = ExportDataRequest.newBuilder().setName(name == null ? null : name.toString()).setOutputConfig(outputConfig).build();
        return this.exportDataAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> exportDataAsync(String name, OutputConfig outputConfig) {
        ExportDataRequest request = ExportDataRequest.newBuilder().setName(name).setOutputConfig(outputConfig).build();
        return this.exportDataAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> exportDataAsync(ExportDataRequest request) {
        return this.exportDataOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ExportDataRequest, Empty, OperationMetadata> exportDataOperationCallable() {
        return this.stub.exportDataOperationCallable();
    }

    public final UnaryCallable<ExportDataRequest, Operation> exportDataCallable() {
        return this.stub.exportDataCallable();
    }

    public final AnnotationSpec getAnnotationSpec(AnnotationSpecName name) {
        GetAnnotationSpecRequest request = GetAnnotationSpecRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAnnotationSpec(request);
    }

    public final AnnotationSpec getAnnotationSpec(String name) {
        GetAnnotationSpecRequest request = GetAnnotationSpecRequest.newBuilder().setName(name).build();
        return this.getAnnotationSpec(request);
    }

    public final AnnotationSpec getAnnotationSpec(GetAnnotationSpecRequest request) {
        return (AnnotationSpec)this.getAnnotationSpecCallable().call((Object)request);
    }

    public final UnaryCallable<GetAnnotationSpecRequest, AnnotationSpec> getAnnotationSpecCallable() {
        return this.stub.getAnnotationSpecCallable();
    }

    public final OperationFuture<Model, OperationMetadata> createModelAsync(LocationName parent, Model model) {
        CreateModelRequest request = CreateModelRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setModel(model).build();
        return this.createModelAsync(request);
    }

    public final OperationFuture<Model, OperationMetadata> createModelAsync(String parent, Model model) {
        CreateModelRequest request = CreateModelRequest.newBuilder().setParent(parent).setModel(model).build();
        return this.createModelAsync(request);
    }

    public final OperationFuture<Model, OperationMetadata> createModelAsync(CreateModelRequest request) {
        return this.createModelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateModelRequest, Model, OperationMetadata> createModelOperationCallable() {
        return this.stub.createModelOperationCallable();
    }

    public final UnaryCallable<CreateModelRequest, Operation> createModelCallable() {
        return this.stub.createModelCallable();
    }

    public final Model getModel(ModelName name) {
        GetModelRequest request = GetModelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getModel(request);
    }

    public final Model getModel(String name) {
        GetModelRequest request = GetModelRequest.newBuilder().setName(name).build();
        return this.getModel(request);
    }

    public final Model getModel(GetModelRequest request) {
        return (Model)this.getModelCallable().call((Object)request);
    }

    public final UnaryCallable<GetModelRequest, Model> getModelCallable() {
        return this.stub.getModelCallable();
    }

    public final ListModelsPagedResponse listModels(LocationName parent) {
        ListModelsRequest request = ListModelsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listModels(request);
    }

    public final ListModelsPagedResponse listModels(String parent) {
        ListModelsRequest request = ListModelsRequest.newBuilder().setParent(parent).build();
        return this.listModels(request);
    }

    public final ListModelsPagedResponse listModels(ListModelsRequest request) {
        return (ListModelsPagedResponse)((Object)this.listModelsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListModelsRequest, ListModelsPagedResponse> listModelsPagedCallable() {
        return this.stub.listModelsPagedCallable();
    }

    public final UnaryCallable<ListModelsRequest, ListModelsResponse> listModelsCallable() {
        return this.stub.listModelsCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteModelAsync(ModelName name) {
        DeleteModelRequest request = DeleteModelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteModelAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteModelAsync(String name) {
        DeleteModelRequest request = DeleteModelRequest.newBuilder().setName(name).build();
        return this.deleteModelAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteModelAsync(DeleteModelRequest request) {
        return this.deleteModelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteModelRequest, Empty, OperationMetadata> deleteModelOperationCallable() {
        return this.stub.deleteModelOperationCallable();
    }

    public final UnaryCallable<DeleteModelRequest, Operation> deleteModelCallable() {
        return this.stub.deleteModelCallable();
    }

    public final Model updateModel(Model model, FieldMask updateMask) {
        UpdateModelRequest request = UpdateModelRequest.newBuilder().setModel(model).setUpdateMask(updateMask).build();
        return this.updateModel(request);
    }

    public final Model updateModel(UpdateModelRequest request) {
        return (Model)this.updateModelCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateModelRequest, Model> updateModelCallable() {
        return this.stub.updateModelCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deployModelAsync(ModelName name) {
        DeployModelRequest request = DeployModelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deployModelAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deployModelAsync(String name) {
        DeployModelRequest request = DeployModelRequest.newBuilder().setName(name).build();
        return this.deployModelAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deployModelAsync(DeployModelRequest request) {
        return this.deployModelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeployModelRequest, Empty, OperationMetadata> deployModelOperationCallable() {
        return this.stub.deployModelOperationCallable();
    }

    public final UnaryCallable<DeployModelRequest, Operation> deployModelCallable() {
        return this.stub.deployModelCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> undeployModelAsync(ModelName name) {
        UndeployModelRequest request = UndeployModelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.undeployModelAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> undeployModelAsync(String name) {
        UndeployModelRequest request = UndeployModelRequest.newBuilder().setName(name).build();
        return this.undeployModelAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> undeployModelAsync(UndeployModelRequest request) {
        return this.undeployModelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UndeployModelRequest, Empty, OperationMetadata> undeployModelOperationCallable() {
        return this.stub.undeployModelOperationCallable();
    }

    public final UnaryCallable<UndeployModelRequest, Operation> undeployModelCallable() {
        return this.stub.undeployModelCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> exportModelAsync(ModelName name, ModelExportOutputConfig outputConfig) {
        ExportModelRequest request = ExportModelRequest.newBuilder().setName(name == null ? null : name.toString()).setOutputConfig(outputConfig).build();
        return this.exportModelAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> exportModelAsync(String name, ModelExportOutputConfig outputConfig) {
        ExportModelRequest request = ExportModelRequest.newBuilder().setName(name).setOutputConfig(outputConfig).build();
        return this.exportModelAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> exportModelAsync(ExportModelRequest request) {
        return this.exportModelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ExportModelRequest, Empty, OperationMetadata> exportModelOperationCallable() {
        return this.stub.exportModelOperationCallable();
    }

    public final UnaryCallable<ExportModelRequest, Operation> exportModelCallable() {
        return this.stub.exportModelCallable();
    }

    public final ModelEvaluation getModelEvaluation(ModelEvaluationName name) {
        GetModelEvaluationRequest request = GetModelEvaluationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getModelEvaluation(request);
    }

    public final ModelEvaluation getModelEvaluation(String name) {
        GetModelEvaluationRequest request = GetModelEvaluationRequest.newBuilder().setName(name).build();
        return this.getModelEvaluation(request);
    }

    public final ModelEvaluation getModelEvaluation(GetModelEvaluationRequest request) {
        return (ModelEvaluation)this.getModelEvaluationCallable().call((Object)request);
    }

    public final UnaryCallable<GetModelEvaluationRequest, ModelEvaluation> getModelEvaluationCallable() {
        return this.stub.getModelEvaluationCallable();
    }

    public final ListModelEvaluationsPagedResponse listModelEvaluations(ModelName parent, String filter) {
        ListModelEvaluationsRequest request = ListModelEvaluationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setFilter(filter).build();
        return this.listModelEvaluations(request);
    }

    public final ListModelEvaluationsPagedResponse listModelEvaluations(String parent, String filter) {
        ListModelEvaluationsRequest request = ListModelEvaluationsRequest.newBuilder().setParent(parent).setFilter(filter).build();
        return this.listModelEvaluations(request);
    }

    public final ListModelEvaluationsPagedResponse listModelEvaluations(ListModelEvaluationsRequest request) {
        return (ListModelEvaluationsPagedResponse)((Object)this.listModelEvaluationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListModelEvaluationsRequest, ListModelEvaluationsPagedResponse> listModelEvaluationsPagedCallable() {
        return this.stub.listModelEvaluationsPagedCallable();
    }

    public final UnaryCallable<ListModelEvaluationsRequest, ListModelEvaluationsResponse> listModelEvaluationsCallable() {
        return this.stub.listModelEvaluationsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListModelEvaluationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelEvaluation, ListModelEvaluationsPage, ListModelEvaluationsFixedSizeCollection> {
        private ListModelEvaluationsFixedSizeCollection(List<ListModelEvaluationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListModelEvaluationsFixedSizeCollection createEmptyCollection() {
            return new ListModelEvaluationsFixedSizeCollection(null, 0);
        }

        protected ListModelEvaluationsFixedSizeCollection createCollection(List<ListModelEvaluationsPage> pages, int collectionSize) {
            return new ListModelEvaluationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListModelEvaluationsPage
    extends AbstractPage<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelEvaluation, ListModelEvaluationsPage> {
        private ListModelEvaluationsPage(PageContext<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelEvaluation> context, ListModelEvaluationsResponse response) {
            super(context, (Object)response);
        }

        private static ListModelEvaluationsPage createEmptyPage() {
            return new ListModelEvaluationsPage(null, null);
        }

        protected ListModelEvaluationsPage createPage(PageContext<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelEvaluation> context, ListModelEvaluationsResponse response) {
            return new ListModelEvaluationsPage(context, response);
        }

        public ApiFuture<ListModelEvaluationsPage> createPageAsync(PageContext<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelEvaluation> context, ApiFuture<ListModelEvaluationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListModelEvaluationsPagedResponse
    extends AbstractPagedListResponse<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelEvaluation, ListModelEvaluationsPage, ListModelEvaluationsFixedSizeCollection> {
        public static ApiFuture<ListModelEvaluationsPagedResponse> createAsync(PageContext<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelEvaluation> context, ApiFuture<ListModelEvaluationsResponse> futureResponse) {
            ApiFuture<ListModelEvaluationsPage> futurePage = ListModelEvaluationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListModelEvaluationsPagedResponse((ListModelEvaluationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListModelEvaluationsPagedResponse(ListModelEvaluationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListModelEvaluationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListModelsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListModelsRequest, ListModelsResponse, Model, ListModelsPage, ListModelsFixedSizeCollection> {
        private ListModelsFixedSizeCollection(List<ListModelsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListModelsFixedSizeCollection createEmptyCollection() {
            return new ListModelsFixedSizeCollection(null, 0);
        }

        protected ListModelsFixedSizeCollection createCollection(List<ListModelsPage> pages, int collectionSize) {
            return new ListModelsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListModelsPage
    extends AbstractPage<ListModelsRequest, ListModelsResponse, Model, ListModelsPage> {
        private ListModelsPage(PageContext<ListModelsRequest, ListModelsResponse, Model> context, ListModelsResponse response) {
            super(context, (Object)response);
        }

        private static ListModelsPage createEmptyPage() {
            return new ListModelsPage(null, null);
        }

        protected ListModelsPage createPage(PageContext<ListModelsRequest, ListModelsResponse, Model> context, ListModelsResponse response) {
            return new ListModelsPage(context, response);
        }

        public ApiFuture<ListModelsPage> createPageAsync(PageContext<ListModelsRequest, ListModelsResponse, Model> context, ApiFuture<ListModelsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListModelsPagedResponse
    extends AbstractPagedListResponse<ListModelsRequest, ListModelsResponse, Model, ListModelsPage, ListModelsFixedSizeCollection> {
        public static ApiFuture<ListModelsPagedResponse> createAsync(PageContext<ListModelsRequest, ListModelsResponse, Model> context, ApiFuture<ListModelsResponse> futureResponse) {
            ApiFuture<ListModelsPage> futurePage = ListModelsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListModelsPagedResponse((ListModelsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListModelsPagedResponse(ListModelsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListModelsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDatasetsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDatasetsRequest, ListDatasetsResponse, Dataset, ListDatasetsPage, ListDatasetsFixedSizeCollection> {
        private ListDatasetsFixedSizeCollection(List<ListDatasetsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDatasetsFixedSizeCollection createEmptyCollection() {
            return new ListDatasetsFixedSizeCollection(null, 0);
        }

        protected ListDatasetsFixedSizeCollection createCollection(List<ListDatasetsPage> pages, int collectionSize) {
            return new ListDatasetsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDatasetsPage
    extends AbstractPage<ListDatasetsRequest, ListDatasetsResponse, Dataset, ListDatasetsPage> {
        private ListDatasetsPage(PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset> context, ListDatasetsResponse response) {
            super(context, (Object)response);
        }

        private static ListDatasetsPage createEmptyPage() {
            return new ListDatasetsPage(null, null);
        }

        protected ListDatasetsPage createPage(PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset> context, ListDatasetsResponse response) {
            return new ListDatasetsPage(context, response);
        }

        public ApiFuture<ListDatasetsPage> createPageAsync(PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset> context, ApiFuture<ListDatasetsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDatasetsPagedResponse
    extends AbstractPagedListResponse<ListDatasetsRequest, ListDatasetsResponse, Dataset, ListDatasetsPage, ListDatasetsFixedSizeCollection> {
        public static ApiFuture<ListDatasetsPagedResponse> createAsync(PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset> context, ApiFuture<ListDatasetsResponse> futureResponse) {
            ApiFuture<ListDatasetsPage> futurePage = ListDatasetsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDatasetsPagedResponse((ListDatasetsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDatasetsPagedResponse(ListDatasetsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDatasetsFixedSizeCollection.createEmptyCollection());
        }
    }
}

