/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.asset.v1p2beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.asset.v1p2beta1.CreateFeedRequest;
import com.google.cloud.asset.v1p2beta1.DeleteFeedRequest;
import com.google.cloud.asset.v1p2beta1.Feed;
import com.google.cloud.asset.v1p2beta1.GetFeedRequest;
import com.google.cloud.asset.v1p2beta1.ListFeedsRequest;
import com.google.cloud.asset.v1p2beta1.ListFeedsResponse;
import com.google.cloud.asset.v1p2beta1.UpdateFeedRequest;
import com.google.cloud.asset.v1p2beta1.stub.AssetServiceStub;
import com.google.cloud.asset.v1p2beta1.stub.GrpcAssetServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class AssetServiceStubSettings
extends StubSettings<AssetServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateFeedRequest, Feed> createFeedSettings;
    private final UnaryCallSettings<GetFeedRequest, Feed> getFeedSettings;
    private final UnaryCallSettings<ListFeedsRequest, ListFeedsResponse> listFeedsSettings;
    private final UnaryCallSettings<UpdateFeedRequest, Feed> updateFeedSettings;
    private final UnaryCallSettings<DeleteFeedRequest, Empty> deleteFeedSettings;

    public UnaryCallSettings<CreateFeedRequest, Feed> createFeedSettings() {
        return this.createFeedSettings;
    }

    public UnaryCallSettings<GetFeedRequest, Feed> getFeedSettings() {
        return this.getFeedSettings;
    }

    public UnaryCallSettings<ListFeedsRequest, ListFeedsResponse> listFeedsSettings() {
        return this.listFeedsSettings;
    }

    public UnaryCallSettings<UpdateFeedRequest, Feed> updateFeedSettings() {
        return this.updateFeedSettings;
    }

    public UnaryCallSettings<DeleteFeedRequest, Empty> deleteFeedSettings() {
        return this.deleteFeedSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AssetServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAssetServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "cloudasset.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AssetServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AssetServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AssetServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createFeedSettings = settingsBuilder.createFeedSettings().build();
        this.getFeedSettings = settingsBuilder.getFeedSettings().build();
        this.listFeedsSettings = settingsBuilder.listFeedsSettings().build();
        this.updateFeedSettings = settingsBuilder.updateFeedSettings().build();
        this.deleteFeedSettings = settingsBuilder.deleteFeedSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AssetServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateFeedRequest, Feed> createFeedSettings;
        private final UnaryCallSettings.Builder<GetFeedRequest, Feed> getFeedSettings;
        private final UnaryCallSettings.Builder<ListFeedsRequest, ListFeedsResponse> listFeedsSettings;
        private final UnaryCallSettings.Builder<UpdateFeedRequest, Feed> updateFeedSettings;
        private final UnaryCallSettings.Builder<DeleteFeedRequest, Empty> deleteFeedSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createFeedSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getFeedSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listFeedsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateFeedSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteFeedSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createFeedSettings, this.getFeedSettings, this.listFeedsSettings, this.updateFeedSettings, this.deleteFeedSettings);
            Builder.initDefaults(this);
        }

        protected Builder(AssetServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createFeedSettings = settings.createFeedSettings.toBuilder();
            this.getFeedSettings = settings.getFeedSettings.toBuilder();
            this.listFeedsSettings = settings.listFeedsSettings.toBuilder();
            this.updateFeedSettings = settings.updateFeedSettings.toBuilder();
            this.deleteFeedSettings = settings.deleteFeedSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createFeedSettings, this.getFeedSettings, this.listFeedsSettings, this.updateFeedSettings, this.deleteFeedSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AssetServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AssetServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AssetServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(AssetServiceStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createFeedSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getFeedSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listFeedsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.updateFeedSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteFeedSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateFeedRequest, Feed> createFeedSettings() {
            return this.createFeedSettings;
        }

        public UnaryCallSettings.Builder<GetFeedRequest, Feed> getFeedSettings() {
            return this.getFeedSettings;
        }

        public UnaryCallSettings.Builder<ListFeedsRequest, ListFeedsResponse> listFeedsSettings() {
            return this.listFeedsSettings;
        }

        public UnaryCallSettings.Builder<UpdateFeedRequest, Feed> updateFeedSettings() {
            return this.updateFeedSettings;
        }

        public UnaryCallSettings.Builder<DeleteFeedRequest, Empty> deleteFeedSettings() {
            return this.deleteFeedSettings;
        }

        public AssetServiceStubSettings build() throws IOException {
            return new AssetServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

