/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.asset.v1p2beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.asset.v1p2beta1.BatchGetAssetsHistoryRequest;
import com.google.cloud.asset.v1p2beta1.BatchGetAssetsHistoryResponse;
import com.google.cloud.asset.v1p2beta1.CreateFeedRequest;
import com.google.cloud.asset.v1p2beta1.DeleteFeedRequest;
import com.google.cloud.asset.v1p2beta1.ExportAssetsRequest;
import com.google.cloud.asset.v1p2beta1.ExportAssetsResponse;
import com.google.cloud.asset.v1p2beta1.Feed;
import com.google.cloud.asset.v1p2beta1.GetFeedRequest;
import com.google.cloud.asset.v1p2beta1.ListFeedsRequest;
import com.google.cloud.asset.v1p2beta1.ListFeedsResponse;
import com.google.cloud.asset.v1p2beta1.UpdateFeedRequest;
import com.google.cloud.asset.v1p2beta1.stub.AssetServiceStub;
import com.google.cloud.asset.v1p2beta1.stub.GrpcAssetServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class AssetServiceStubSettings
extends StubSettings<AssetServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<ExportAssetsRequest, Operation> exportAssetsSettings;
    private final OperationCallSettings<ExportAssetsRequest, ExportAssetsResponse, ExportAssetsRequest> exportAssetsOperationSettings;
    private final UnaryCallSettings<BatchGetAssetsHistoryRequest, BatchGetAssetsHistoryResponse> batchGetAssetsHistorySettings;
    private final UnaryCallSettings<CreateFeedRequest, Feed> createFeedSettings;
    private final UnaryCallSettings<GetFeedRequest, Feed> getFeedSettings;
    private final UnaryCallSettings<ListFeedsRequest, ListFeedsResponse> listFeedsSettings;
    private final UnaryCallSettings<UpdateFeedRequest, Feed> updateFeedSettings;
    private final UnaryCallSettings<DeleteFeedRequest, Empty> deleteFeedSettings;

    public UnaryCallSettings<ExportAssetsRequest, Operation> exportAssetsSettings() {
        return this.exportAssetsSettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<ExportAssetsRequest, ExportAssetsResponse, ExportAssetsRequest> exportAssetsOperationSettings() {
        return this.exportAssetsOperationSettings;
    }

    public UnaryCallSettings<BatchGetAssetsHistoryRequest, BatchGetAssetsHistoryResponse> batchGetAssetsHistorySettings() {
        return this.batchGetAssetsHistorySettings;
    }

    public UnaryCallSettings<CreateFeedRequest, Feed> createFeedSettings() {
        return this.createFeedSettings;
    }

    public UnaryCallSettings<GetFeedRequest, Feed> getFeedSettings() {
        return this.getFeedSettings;
    }

    public UnaryCallSettings<ListFeedsRequest, ListFeedsResponse> listFeedsSettings() {
        return this.listFeedsSettings;
    }

    public UnaryCallSettings<UpdateFeedRequest, Feed> updateFeedSettings() {
        return this.updateFeedSettings;
    }

    public UnaryCallSettings<DeleteFeedRequest, Empty> deleteFeedSettings() {
        return this.deleteFeedSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AssetServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAssetServiceStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "cloudasset.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AssetServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AssetServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AssetServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.exportAssetsSettings = settingsBuilder.exportAssetsSettings().build();
        this.exportAssetsOperationSettings = settingsBuilder.exportAssetsOperationSettings().build();
        this.batchGetAssetsHistorySettings = settingsBuilder.batchGetAssetsHistorySettings().build();
        this.createFeedSettings = settingsBuilder.createFeedSettings().build();
        this.getFeedSettings = settingsBuilder.getFeedSettings().build();
        this.listFeedsSettings = settingsBuilder.listFeedsSettings().build();
        this.updateFeedSettings = settingsBuilder.updateFeedSettings().build();
        this.deleteFeedSettings = settingsBuilder.deleteFeedSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AssetServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<ExportAssetsRequest, Operation> exportAssetsSettings;
        private final OperationCallSettings.Builder<ExportAssetsRequest, ExportAssetsResponse, ExportAssetsRequest> exportAssetsOperationSettings;
        private final UnaryCallSettings.Builder<BatchGetAssetsHistoryRequest, BatchGetAssetsHistoryResponse> batchGetAssetsHistorySettings;
        private final UnaryCallSettings.Builder<CreateFeedRequest, Feed> createFeedSettings;
        private final UnaryCallSettings.Builder<GetFeedRequest, Feed> getFeedSettings;
        private final UnaryCallSettings.Builder<ListFeedsRequest, ListFeedsResponse> listFeedsSettings;
        private final UnaryCallSettings.Builder<UpdateFeedRequest, Feed> updateFeedSettings;
        private final UnaryCallSettings.Builder<DeleteFeedRequest, Empty> deleteFeedSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.exportAssetsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.exportAssetsOperationSettings = OperationCallSettings.newBuilder();
            this.batchGetAssetsHistorySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createFeedSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getFeedSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listFeedsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateFeedSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteFeedSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.exportAssetsSettings, this.batchGetAssetsHistorySettings, this.createFeedSettings, this.getFeedSettings, this.listFeedsSettings, this.updateFeedSettings, this.deleteFeedSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AssetServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AssetServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AssetServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(AssetServiceStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.exportAssetsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.batchGetAssetsHistorySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createFeedSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getFeedSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listFeedsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateFeedSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteFeedSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.exportAssetsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ExportAssetsResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ExportAssetsRequest.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        protected Builder(AssetServiceStubSettings settings) {
            super((StubSettings)settings);
            this.exportAssetsSettings = settings.exportAssetsSettings.toBuilder();
            this.exportAssetsOperationSettings = settings.exportAssetsOperationSettings.toBuilder();
            this.batchGetAssetsHistorySettings = settings.batchGetAssetsHistorySettings.toBuilder();
            this.createFeedSettings = settings.createFeedSettings.toBuilder();
            this.getFeedSettings = settings.getFeedSettings.toBuilder();
            this.listFeedsSettings = settings.listFeedsSettings.toBuilder();
            this.updateFeedSettings = settings.updateFeedSettings.toBuilder();
            this.deleteFeedSettings = settings.deleteFeedSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.exportAssetsSettings, this.batchGetAssetsHistorySettings, this.createFeedSettings, this.getFeedSettings, this.listFeedsSettings, this.updateFeedSettings, this.deleteFeedSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<ExportAssetsRequest, Operation> exportAssetsSettings() {
            return this.exportAssetsSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ExportAssetsRequest, ExportAssetsResponse, ExportAssetsRequest> exportAssetsOperationSettings() {
            return this.exportAssetsOperationSettings;
        }

        public UnaryCallSettings.Builder<BatchGetAssetsHistoryRequest, BatchGetAssetsHistoryResponse> batchGetAssetsHistorySettings() {
            return this.batchGetAssetsHistorySettings;
        }

        public UnaryCallSettings.Builder<CreateFeedRequest, Feed> createFeedSettings() {
            return this.createFeedSettings;
        }

        public UnaryCallSettings.Builder<GetFeedRequest, Feed> getFeedSettings() {
            return this.getFeedSettings;
        }

        public UnaryCallSettings.Builder<ListFeedsRequest, ListFeedsResponse> listFeedsSettings() {
            return this.listFeedsSettings;
        }

        public UnaryCallSettings.Builder<UpdateFeedRequest, Feed> updateFeedSettings() {
            return this.updateFeedSettings;
        }

        public UnaryCallSettings.Builder<DeleteFeedRequest, Empty> deleteFeedSettings() {
            return this.deleteFeedSettings;
        }

        public AssetServiceStubSettings build() throws IOException {
            return new AssetServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

