/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.artifactregistry.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.devtools.artifactregistry.v1.ArtifactRegistrySettings;
import com.google.devtools.artifactregistry.v1.CreateRepositoryRequest;
import com.google.devtools.artifactregistry.v1.CreateTagRequest;
import com.google.devtools.artifactregistry.v1.DeletePackageRequest;
import com.google.devtools.artifactregistry.v1.DeleteRepositoryRequest;
import com.google.devtools.artifactregistry.v1.DeleteTagRequest;
import com.google.devtools.artifactregistry.v1.DeleteVersionRequest;
import com.google.devtools.artifactregistry.v1.DockerImage;
import com.google.devtools.artifactregistry.v1.DockerImageName;
import com.google.devtools.artifactregistry.v1.File;
import com.google.devtools.artifactregistry.v1.GetDockerImageRequest;
import com.google.devtools.artifactregistry.v1.GetFileRequest;
import com.google.devtools.artifactregistry.v1.GetPackageRequest;
import com.google.devtools.artifactregistry.v1.GetProjectSettingsRequest;
import com.google.devtools.artifactregistry.v1.GetRepositoryRequest;
import com.google.devtools.artifactregistry.v1.GetTagRequest;
import com.google.devtools.artifactregistry.v1.GetVersionRequest;
import com.google.devtools.artifactregistry.v1.ImportAptArtifactsMetadata;
import com.google.devtools.artifactregistry.v1.ImportAptArtifactsRequest;
import com.google.devtools.artifactregistry.v1.ImportAptArtifactsResponse;
import com.google.devtools.artifactregistry.v1.ImportYumArtifactsMetadata;
import com.google.devtools.artifactregistry.v1.ImportYumArtifactsRequest;
import com.google.devtools.artifactregistry.v1.ImportYumArtifactsResponse;
import com.google.devtools.artifactregistry.v1.ListDockerImagesRequest;
import com.google.devtools.artifactregistry.v1.ListDockerImagesResponse;
import com.google.devtools.artifactregistry.v1.ListFilesRequest;
import com.google.devtools.artifactregistry.v1.ListFilesResponse;
import com.google.devtools.artifactregistry.v1.ListPackagesRequest;
import com.google.devtools.artifactregistry.v1.ListPackagesResponse;
import com.google.devtools.artifactregistry.v1.ListRepositoriesRequest;
import com.google.devtools.artifactregistry.v1.ListRepositoriesResponse;
import com.google.devtools.artifactregistry.v1.ListTagsRequest;
import com.google.devtools.artifactregistry.v1.ListTagsResponse;
import com.google.devtools.artifactregistry.v1.ListVersionsRequest;
import com.google.devtools.artifactregistry.v1.ListVersionsResponse;
import com.google.devtools.artifactregistry.v1.LocationName;
import com.google.devtools.artifactregistry.v1.OperationMetadata;
import com.google.devtools.artifactregistry.v1.Package;
import com.google.devtools.artifactregistry.v1.ProjectSettings;
import com.google.devtools.artifactregistry.v1.ProjectSettingsName;
import com.google.devtools.artifactregistry.v1.Repository;
import com.google.devtools.artifactregistry.v1.RepositoryName;
import com.google.devtools.artifactregistry.v1.Tag;
import com.google.devtools.artifactregistry.v1.UpdateProjectSettingsRequest;
import com.google.devtools.artifactregistry.v1.UpdateRepositoryRequest;
import com.google.devtools.artifactregistry.v1.UpdateTagRequest;
import com.google.devtools.artifactregistry.v1.Version;
import com.google.devtools.artifactregistry.v1.stub.ArtifactRegistryStub;
import com.google.devtools.artifactregistry.v1.stub.ArtifactRegistryStubSettings;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ArtifactRegistryClient
implements BackgroundResource {
    private final ArtifactRegistrySettings settings;
    private final ArtifactRegistryStub stub;
    private final OperationsClient operationsClient;

    public static final ArtifactRegistryClient create() throws IOException {
        return ArtifactRegistryClient.create(ArtifactRegistrySettings.newBuilder().build());
    }

    public static final ArtifactRegistryClient create(ArtifactRegistrySettings settings) throws IOException {
        return new ArtifactRegistryClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ArtifactRegistryClient create(ArtifactRegistryStub stub) {
        return new ArtifactRegistryClient(stub);
    }

    protected ArtifactRegistryClient(ArtifactRegistrySettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ArtifactRegistryStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ArtifactRegistryClient(ArtifactRegistryStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final ArtifactRegistrySettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ArtifactRegistryStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListDockerImagesPagedResponse listDockerImages(String parent) {
        ListDockerImagesRequest request = ListDockerImagesRequest.newBuilder().setParent(parent).build();
        return this.listDockerImages(request);
    }

    public final ListDockerImagesPagedResponse listDockerImages(ListDockerImagesRequest request) {
        return (ListDockerImagesPagedResponse)((Object)this.listDockerImagesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDockerImagesRequest, ListDockerImagesPagedResponse> listDockerImagesPagedCallable() {
        return this.stub.listDockerImagesPagedCallable();
    }

    public final UnaryCallable<ListDockerImagesRequest, ListDockerImagesResponse> listDockerImagesCallable() {
        return this.stub.listDockerImagesCallable();
    }

    public final DockerImage getDockerImage(DockerImageName name) {
        GetDockerImageRequest request = GetDockerImageRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDockerImage(request);
    }

    public final DockerImage getDockerImage(String name) {
        GetDockerImageRequest request = GetDockerImageRequest.newBuilder().setName(name).build();
        return this.getDockerImage(request);
    }

    public final DockerImage getDockerImage(GetDockerImageRequest request) {
        return (DockerImage)this.getDockerImageCallable().call((Object)request);
    }

    public final UnaryCallable<GetDockerImageRequest, DockerImage> getDockerImageCallable() {
        return this.stub.getDockerImageCallable();
    }

    public final OperationFuture<ImportAptArtifactsResponse, ImportAptArtifactsMetadata> importAptArtifactsAsync(ImportAptArtifactsRequest request) {
        return this.importAptArtifactsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ImportAptArtifactsRequest, ImportAptArtifactsResponse, ImportAptArtifactsMetadata> importAptArtifactsOperationCallable() {
        return this.stub.importAptArtifactsOperationCallable();
    }

    public final UnaryCallable<ImportAptArtifactsRequest, Operation> importAptArtifactsCallable() {
        return this.stub.importAptArtifactsCallable();
    }

    public final OperationFuture<ImportYumArtifactsResponse, ImportYumArtifactsMetadata> importYumArtifactsAsync(ImportYumArtifactsRequest request) {
        return this.importYumArtifactsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ImportYumArtifactsRequest, ImportYumArtifactsResponse, ImportYumArtifactsMetadata> importYumArtifactsOperationCallable() {
        return this.stub.importYumArtifactsOperationCallable();
    }

    public final UnaryCallable<ImportYumArtifactsRequest, Operation> importYumArtifactsCallable() {
        return this.stub.importYumArtifactsCallable();
    }

    public final ListRepositoriesPagedResponse listRepositories(LocationName parent) {
        ListRepositoriesRequest request = ListRepositoriesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRepositories(request);
    }

    public final ListRepositoriesPagedResponse listRepositories(String parent) {
        ListRepositoriesRequest request = ListRepositoriesRequest.newBuilder().setParent(parent).build();
        return this.listRepositories(request);
    }

    public final ListRepositoriesPagedResponse listRepositories(ListRepositoriesRequest request) {
        return (ListRepositoriesPagedResponse)((Object)this.listRepositoriesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRepositoriesRequest, ListRepositoriesPagedResponse> listRepositoriesPagedCallable() {
        return this.stub.listRepositoriesPagedCallable();
    }

    public final UnaryCallable<ListRepositoriesRequest, ListRepositoriesResponse> listRepositoriesCallable() {
        return this.stub.listRepositoriesCallable();
    }

    public final Repository getRepository(RepositoryName name) {
        GetRepositoryRequest request = GetRepositoryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRepository(request);
    }

    public final Repository getRepository(String name) {
        GetRepositoryRequest request = GetRepositoryRequest.newBuilder().setName(name).build();
        return this.getRepository(request);
    }

    public final Repository getRepository(GetRepositoryRequest request) {
        return (Repository)this.getRepositoryCallable().call((Object)request);
    }

    public final UnaryCallable<GetRepositoryRequest, Repository> getRepositoryCallable() {
        return this.stub.getRepositoryCallable();
    }

    public final OperationFuture<Repository, OperationMetadata> createRepositoryAsync(LocationName parent, Repository repository, String repositoryId) {
        CreateRepositoryRequest request = CreateRepositoryRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setRepository(repository).setRepositoryId(repositoryId).build();
        return this.createRepositoryAsync(request);
    }

    public final OperationFuture<Repository, OperationMetadata> createRepositoryAsync(String parent, Repository repository, String repositoryId) {
        CreateRepositoryRequest request = CreateRepositoryRequest.newBuilder().setParent(parent).setRepository(repository).setRepositoryId(repositoryId).build();
        return this.createRepositoryAsync(request);
    }

    public final OperationFuture<Repository, OperationMetadata> createRepositoryAsync(CreateRepositoryRequest request) {
        return this.createRepositoryOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateRepositoryRequest, Repository, OperationMetadata> createRepositoryOperationCallable() {
        return this.stub.createRepositoryOperationCallable();
    }

    public final UnaryCallable<CreateRepositoryRequest, Operation> createRepositoryCallable() {
        return this.stub.createRepositoryCallable();
    }

    public final Repository updateRepository(Repository repository, FieldMask updateMask) {
        UpdateRepositoryRequest request = UpdateRepositoryRequest.newBuilder().setRepository(repository).setUpdateMask(updateMask).build();
        return this.updateRepository(request);
    }

    public final Repository updateRepository(UpdateRepositoryRequest request) {
        return (Repository)this.updateRepositoryCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateRepositoryRequest, Repository> updateRepositoryCallable() {
        return this.stub.updateRepositoryCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRepositoryAsync(RepositoryName name) {
        DeleteRepositoryRequest request = DeleteRepositoryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteRepositoryAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRepositoryAsync(String name) {
        DeleteRepositoryRequest request = DeleteRepositoryRequest.newBuilder().setName(name).build();
        return this.deleteRepositoryAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRepositoryAsync(DeleteRepositoryRequest request) {
        return this.deleteRepositoryOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteRepositoryRequest, Empty, OperationMetadata> deleteRepositoryOperationCallable() {
        return this.stub.deleteRepositoryOperationCallable();
    }

    public final UnaryCallable<DeleteRepositoryRequest, Operation> deleteRepositoryCallable() {
        return this.stub.deleteRepositoryCallable();
    }

    public final ListPackagesPagedResponse listPackages(String parent) {
        ListPackagesRequest request = ListPackagesRequest.newBuilder().setParent(parent).build();
        return this.listPackages(request);
    }

    public final ListPackagesPagedResponse listPackages(ListPackagesRequest request) {
        return (ListPackagesPagedResponse)((Object)this.listPackagesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPackagesRequest, ListPackagesPagedResponse> listPackagesPagedCallable() {
        return this.stub.listPackagesPagedCallable();
    }

    public final UnaryCallable<ListPackagesRequest, ListPackagesResponse> listPackagesCallable() {
        return this.stub.listPackagesCallable();
    }

    public final Package getPackage(String name) {
        GetPackageRequest request = GetPackageRequest.newBuilder().setName(name).build();
        return this.getPackage(request);
    }

    public final Package getPackage(GetPackageRequest request) {
        return (Package)this.getPackageCallable().call((Object)request);
    }

    public final UnaryCallable<GetPackageRequest, Package> getPackageCallable() {
        return this.stub.getPackageCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deletePackageAsync(String name) {
        DeletePackageRequest request = DeletePackageRequest.newBuilder().setName(name).build();
        return this.deletePackageAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deletePackageAsync(DeletePackageRequest request) {
        return this.deletePackageOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeletePackageRequest, Empty, OperationMetadata> deletePackageOperationCallable() {
        return this.stub.deletePackageOperationCallable();
    }

    public final UnaryCallable<DeletePackageRequest, Operation> deletePackageCallable() {
        return this.stub.deletePackageCallable();
    }

    public final ListVersionsPagedResponse listVersions(String parent) {
        ListVersionsRequest request = ListVersionsRequest.newBuilder().setParent(parent).build();
        return this.listVersions(request);
    }

    public final ListVersionsPagedResponse listVersions(ListVersionsRequest request) {
        return (ListVersionsPagedResponse)((Object)this.listVersionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListVersionsRequest, ListVersionsPagedResponse> listVersionsPagedCallable() {
        return this.stub.listVersionsPagedCallable();
    }

    public final UnaryCallable<ListVersionsRequest, ListVersionsResponse> listVersionsCallable() {
        return this.stub.listVersionsCallable();
    }

    public final Version getVersion(String name) {
        GetVersionRequest request = GetVersionRequest.newBuilder().setName(name).build();
        return this.getVersion(request);
    }

    public final Version getVersion(GetVersionRequest request) {
        return (Version)this.getVersionCallable().call((Object)request);
    }

    public final UnaryCallable<GetVersionRequest, Version> getVersionCallable() {
        return this.stub.getVersionCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteVersionAsync(String name) {
        DeleteVersionRequest request = DeleteVersionRequest.newBuilder().setName(name).build();
        return this.deleteVersionAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteVersionAsync(DeleteVersionRequest request) {
        return this.deleteVersionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteVersionRequest, Empty, OperationMetadata> deleteVersionOperationCallable() {
        return this.stub.deleteVersionOperationCallable();
    }

    public final UnaryCallable<DeleteVersionRequest, Operation> deleteVersionCallable() {
        return this.stub.deleteVersionCallable();
    }

    public final ListFilesPagedResponse listFiles(String parent) {
        ListFilesRequest request = ListFilesRequest.newBuilder().setParent(parent).build();
        return this.listFiles(request);
    }

    public final ListFilesPagedResponse listFiles(ListFilesRequest request) {
        return (ListFilesPagedResponse)((Object)this.listFilesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListFilesRequest, ListFilesPagedResponse> listFilesPagedCallable() {
        return this.stub.listFilesPagedCallable();
    }

    public final UnaryCallable<ListFilesRequest, ListFilesResponse> listFilesCallable() {
        return this.stub.listFilesCallable();
    }

    public final File getFile(String name) {
        GetFileRequest request = GetFileRequest.newBuilder().setName(name).build();
        return this.getFile(request);
    }

    public final File getFile(GetFileRequest request) {
        return (File)this.getFileCallable().call((Object)request);
    }

    public final UnaryCallable<GetFileRequest, File> getFileCallable() {
        return this.stub.getFileCallable();
    }

    public final ListTagsPagedResponse listTags(String parent) {
        ListTagsRequest request = ListTagsRequest.newBuilder().setParent(parent).build();
        return this.listTags(request);
    }

    public final ListTagsPagedResponse listTags(ListTagsRequest request) {
        return (ListTagsPagedResponse)((Object)this.listTagsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTagsRequest, ListTagsPagedResponse> listTagsPagedCallable() {
        return this.stub.listTagsPagedCallable();
    }

    public final UnaryCallable<ListTagsRequest, ListTagsResponse> listTagsCallable() {
        return this.stub.listTagsCallable();
    }

    public final Tag getTag(String name) {
        GetTagRequest request = GetTagRequest.newBuilder().setName(name).build();
        return this.getTag(request);
    }

    public final Tag getTag(GetTagRequest request) {
        return (Tag)this.getTagCallable().call((Object)request);
    }

    public final UnaryCallable<GetTagRequest, Tag> getTagCallable() {
        return this.stub.getTagCallable();
    }

    public final Tag createTag(String parent, Tag tag, String tagId) {
        CreateTagRequest request = CreateTagRequest.newBuilder().setParent(parent).setTag(tag).setTagId(tagId).build();
        return this.createTag(request);
    }

    public final Tag createTag(CreateTagRequest request) {
        return (Tag)this.createTagCallable().call((Object)request);
    }

    public final UnaryCallable<CreateTagRequest, Tag> createTagCallable() {
        return this.stub.createTagCallable();
    }

    public final Tag updateTag(Tag tag, FieldMask updateMask) {
        UpdateTagRequest request = UpdateTagRequest.newBuilder().setTag(tag).setUpdateMask(updateMask).build();
        return this.updateTag(request);
    }

    public final Tag updateTag(UpdateTagRequest request) {
        return (Tag)this.updateTagCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateTagRequest, Tag> updateTagCallable() {
        return this.stub.updateTagCallable();
    }

    public final void deleteTag(String name) {
        DeleteTagRequest request = DeleteTagRequest.newBuilder().setName(name).build();
        this.deleteTag(request);
    }

    public final void deleteTag(DeleteTagRequest request) {
        this.deleteTagCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteTagRequest, Empty> deleteTagCallable() {
        return this.stub.deleteTagCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final ProjectSettings getProjectSettings(ProjectSettingsName name) {
        GetProjectSettingsRequest request = GetProjectSettingsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getProjectSettings(request);
    }

    public final ProjectSettings getProjectSettings(String name) {
        GetProjectSettingsRequest request = GetProjectSettingsRequest.newBuilder().setName(name).build();
        return this.getProjectSettings(request);
    }

    public final ProjectSettings getProjectSettings(GetProjectSettingsRequest request) {
        return (ProjectSettings)this.getProjectSettingsCallable().call((Object)request);
    }

    public final UnaryCallable<GetProjectSettingsRequest, ProjectSettings> getProjectSettingsCallable() {
        return this.stub.getProjectSettingsCallable();
    }

    public final ProjectSettings updateProjectSettings(ProjectSettings projectSettings, FieldMask updateMask) {
        UpdateProjectSettingsRequest request = UpdateProjectSettingsRequest.newBuilder().setProjectSettings(projectSettings).setUpdateMask(updateMask).build();
        return this.updateProjectSettings(request);
    }

    public final ProjectSettings updateProjectSettings(UpdateProjectSettingsRequest request) {
        return (ProjectSettings)this.updateProjectSettingsCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateProjectSettingsRequest, ProjectSettings> updateProjectSettingsCallable() {
        return this.stub.updateProjectSettingsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListTagsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTagsRequest, ListTagsResponse, Tag, ListTagsPage, ListTagsFixedSizeCollection> {
        private ListTagsFixedSizeCollection(List<ListTagsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTagsFixedSizeCollection createEmptyCollection() {
            return new ListTagsFixedSizeCollection(null, 0);
        }

        protected ListTagsFixedSizeCollection createCollection(List<ListTagsPage> pages, int collectionSize) {
            return new ListTagsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTagsPage
    extends AbstractPage<ListTagsRequest, ListTagsResponse, Tag, ListTagsPage> {
        private ListTagsPage(PageContext<ListTagsRequest, ListTagsResponse, Tag> context, ListTagsResponse response) {
            super(context, (Object)response);
        }

        private static ListTagsPage createEmptyPage() {
            return new ListTagsPage(null, null);
        }

        protected ListTagsPage createPage(PageContext<ListTagsRequest, ListTagsResponse, Tag> context, ListTagsResponse response) {
            return new ListTagsPage(context, response);
        }

        public ApiFuture<ListTagsPage> createPageAsync(PageContext<ListTagsRequest, ListTagsResponse, Tag> context, ApiFuture<ListTagsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTagsPagedResponse
    extends AbstractPagedListResponse<ListTagsRequest, ListTagsResponse, Tag, ListTagsPage, ListTagsFixedSizeCollection> {
        public static ApiFuture<ListTagsPagedResponse> createAsync(PageContext<ListTagsRequest, ListTagsResponse, Tag> context, ApiFuture<ListTagsResponse> futureResponse) {
            ApiFuture<ListTagsPage> futurePage = ListTagsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTagsPagedResponse((ListTagsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTagsPagedResponse(ListTagsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTagsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListFilesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListFilesRequest, ListFilesResponse, File, ListFilesPage, ListFilesFixedSizeCollection> {
        private ListFilesFixedSizeCollection(List<ListFilesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFilesFixedSizeCollection createEmptyCollection() {
            return new ListFilesFixedSizeCollection(null, 0);
        }

        protected ListFilesFixedSizeCollection createCollection(List<ListFilesPage> pages, int collectionSize) {
            return new ListFilesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListFilesPage
    extends AbstractPage<ListFilesRequest, ListFilesResponse, File, ListFilesPage> {
        private ListFilesPage(PageContext<ListFilesRequest, ListFilesResponse, File> context, ListFilesResponse response) {
            super(context, (Object)response);
        }

        private static ListFilesPage createEmptyPage() {
            return new ListFilesPage(null, null);
        }

        protected ListFilesPage createPage(PageContext<ListFilesRequest, ListFilesResponse, File> context, ListFilesResponse response) {
            return new ListFilesPage(context, response);
        }

        public ApiFuture<ListFilesPage> createPageAsync(PageContext<ListFilesRequest, ListFilesResponse, File> context, ApiFuture<ListFilesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListFilesPagedResponse
    extends AbstractPagedListResponse<ListFilesRequest, ListFilesResponse, File, ListFilesPage, ListFilesFixedSizeCollection> {
        public static ApiFuture<ListFilesPagedResponse> createAsync(PageContext<ListFilesRequest, ListFilesResponse, File> context, ApiFuture<ListFilesResponse> futureResponse) {
            ApiFuture<ListFilesPage> futurePage = ListFilesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListFilesPagedResponse((ListFilesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListFilesPagedResponse(ListFilesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFilesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListVersionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListVersionsRequest, ListVersionsResponse, Version, ListVersionsPage, ListVersionsFixedSizeCollection> {
        private ListVersionsFixedSizeCollection(List<ListVersionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListVersionsFixedSizeCollection createEmptyCollection() {
            return new ListVersionsFixedSizeCollection(null, 0);
        }

        protected ListVersionsFixedSizeCollection createCollection(List<ListVersionsPage> pages, int collectionSize) {
            return new ListVersionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListVersionsPage
    extends AbstractPage<ListVersionsRequest, ListVersionsResponse, Version, ListVersionsPage> {
        private ListVersionsPage(PageContext<ListVersionsRequest, ListVersionsResponse, Version> context, ListVersionsResponse response) {
            super(context, (Object)response);
        }

        private static ListVersionsPage createEmptyPage() {
            return new ListVersionsPage(null, null);
        }

        protected ListVersionsPage createPage(PageContext<ListVersionsRequest, ListVersionsResponse, Version> context, ListVersionsResponse response) {
            return new ListVersionsPage(context, response);
        }

        public ApiFuture<ListVersionsPage> createPageAsync(PageContext<ListVersionsRequest, ListVersionsResponse, Version> context, ApiFuture<ListVersionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListVersionsPagedResponse
    extends AbstractPagedListResponse<ListVersionsRequest, ListVersionsResponse, Version, ListVersionsPage, ListVersionsFixedSizeCollection> {
        public static ApiFuture<ListVersionsPagedResponse> createAsync(PageContext<ListVersionsRequest, ListVersionsResponse, Version> context, ApiFuture<ListVersionsResponse> futureResponse) {
            ApiFuture<ListVersionsPage> futurePage = ListVersionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListVersionsPagedResponse((ListVersionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListVersionsPagedResponse(ListVersionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListVersionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPackagesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPackagesRequest, ListPackagesResponse, Package, ListPackagesPage, ListPackagesFixedSizeCollection> {
        private ListPackagesFixedSizeCollection(List<ListPackagesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPackagesFixedSizeCollection createEmptyCollection() {
            return new ListPackagesFixedSizeCollection(null, 0);
        }

        protected ListPackagesFixedSizeCollection createCollection(List<ListPackagesPage> pages, int collectionSize) {
            return new ListPackagesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPackagesPage
    extends AbstractPage<ListPackagesRequest, ListPackagesResponse, Package, ListPackagesPage> {
        private ListPackagesPage(PageContext<ListPackagesRequest, ListPackagesResponse, Package> context, ListPackagesResponse response) {
            super(context, (Object)response);
        }

        private static ListPackagesPage createEmptyPage() {
            return new ListPackagesPage(null, null);
        }

        protected ListPackagesPage createPage(PageContext<ListPackagesRequest, ListPackagesResponse, Package> context, ListPackagesResponse response) {
            return new ListPackagesPage(context, response);
        }

        public ApiFuture<ListPackagesPage> createPageAsync(PageContext<ListPackagesRequest, ListPackagesResponse, Package> context, ApiFuture<ListPackagesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPackagesPagedResponse
    extends AbstractPagedListResponse<ListPackagesRequest, ListPackagesResponse, Package, ListPackagesPage, ListPackagesFixedSizeCollection> {
        public static ApiFuture<ListPackagesPagedResponse> createAsync(PageContext<ListPackagesRequest, ListPackagesResponse, Package> context, ApiFuture<ListPackagesResponse> futureResponse) {
            ApiFuture<ListPackagesPage> futurePage = ListPackagesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPackagesPagedResponse((ListPackagesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPackagesPagedResponse(ListPackagesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPackagesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListRepositoriesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRepositoriesRequest, ListRepositoriesResponse, Repository, ListRepositoriesPage, ListRepositoriesFixedSizeCollection> {
        private ListRepositoriesFixedSizeCollection(List<ListRepositoriesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRepositoriesFixedSizeCollection createEmptyCollection() {
            return new ListRepositoriesFixedSizeCollection(null, 0);
        }

        protected ListRepositoriesFixedSizeCollection createCollection(List<ListRepositoriesPage> pages, int collectionSize) {
            return new ListRepositoriesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRepositoriesPage
    extends AbstractPage<ListRepositoriesRequest, ListRepositoriesResponse, Repository, ListRepositoriesPage> {
        private ListRepositoriesPage(PageContext<ListRepositoriesRequest, ListRepositoriesResponse, Repository> context, ListRepositoriesResponse response) {
            super(context, (Object)response);
        }

        private static ListRepositoriesPage createEmptyPage() {
            return new ListRepositoriesPage(null, null);
        }

        protected ListRepositoriesPage createPage(PageContext<ListRepositoriesRequest, ListRepositoriesResponse, Repository> context, ListRepositoriesResponse response) {
            return new ListRepositoriesPage(context, response);
        }

        public ApiFuture<ListRepositoriesPage> createPageAsync(PageContext<ListRepositoriesRequest, ListRepositoriesResponse, Repository> context, ApiFuture<ListRepositoriesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRepositoriesPagedResponse
    extends AbstractPagedListResponse<ListRepositoriesRequest, ListRepositoriesResponse, Repository, ListRepositoriesPage, ListRepositoriesFixedSizeCollection> {
        public static ApiFuture<ListRepositoriesPagedResponse> createAsync(PageContext<ListRepositoriesRequest, ListRepositoriesResponse, Repository> context, ApiFuture<ListRepositoriesResponse> futureResponse) {
            ApiFuture<ListRepositoriesPage> futurePage = ListRepositoriesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRepositoriesPagedResponse((ListRepositoriesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRepositoriesPagedResponse(ListRepositoriesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRepositoriesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDockerImagesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDockerImagesRequest, ListDockerImagesResponse, DockerImage, ListDockerImagesPage, ListDockerImagesFixedSizeCollection> {
        private ListDockerImagesFixedSizeCollection(List<ListDockerImagesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDockerImagesFixedSizeCollection createEmptyCollection() {
            return new ListDockerImagesFixedSizeCollection(null, 0);
        }

        protected ListDockerImagesFixedSizeCollection createCollection(List<ListDockerImagesPage> pages, int collectionSize) {
            return new ListDockerImagesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDockerImagesPage
    extends AbstractPage<ListDockerImagesRequest, ListDockerImagesResponse, DockerImage, ListDockerImagesPage> {
        private ListDockerImagesPage(PageContext<ListDockerImagesRequest, ListDockerImagesResponse, DockerImage> context, ListDockerImagesResponse response) {
            super(context, (Object)response);
        }

        private static ListDockerImagesPage createEmptyPage() {
            return new ListDockerImagesPage(null, null);
        }

        protected ListDockerImagesPage createPage(PageContext<ListDockerImagesRequest, ListDockerImagesResponse, DockerImage> context, ListDockerImagesResponse response) {
            return new ListDockerImagesPage(context, response);
        }

        public ApiFuture<ListDockerImagesPage> createPageAsync(PageContext<ListDockerImagesRequest, ListDockerImagesResponse, DockerImage> context, ApiFuture<ListDockerImagesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDockerImagesPagedResponse
    extends AbstractPagedListResponse<ListDockerImagesRequest, ListDockerImagesResponse, DockerImage, ListDockerImagesPage, ListDockerImagesFixedSizeCollection> {
        public static ApiFuture<ListDockerImagesPagedResponse> createAsync(PageContext<ListDockerImagesRequest, ListDockerImagesResponse, DockerImage> context, ApiFuture<ListDockerImagesResponse> futureResponse) {
            ApiFuture<ListDockerImagesPage> futurePage = ListDockerImagesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDockerImagesPagedResponse((ListDockerImagesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDockerImagesPagedResponse(ListDockerImagesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDockerImagesFixedSizeCollection.createEmptyCollection());
        }
    }
}

