/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.artifactregistry.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.devtools.artifactregistry.v1.ArtifactRegistrySettings;
import com.google.devtools.artifactregistry.v1.DockerImage;
import com.google.devtools.artifactregistry.v1.GetRepositoryRequest;
import com.google.devtools.artifactregistry.v1.ListDockerImagesRequest;
import com.google.devtools.artifactregistry.v1.ListDockerImagesResponse;
import com.google.devtools.artifactregistry.v1.ListRepositoriesRequest;
import com.google.devtools.artifactregistry.v1.ListRepositoriesResponse;
import com.google.devtools.artifactregistry.v1.LocationName;
import com.google.devtools.artifactregistry.v1.Repository;
import com.google.devtools.artifactregistry.v1.RepositoryName;
import com.google.devtools.artifactregistry.v1.stub.ArtifactRegistryStub;
import com.google.devtools.artifactregistry.v1.stub.ArtifactRegistryStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ArtifactRegistryClient
implements BackgroundResource {
    private final ArtifactRegistrySettings settings;
    private final ArtifactRegistryStub stub;

    public static final ArtifactRegistryClient create() throws IOException {
        return ArtifactRegistryClient.create(ArtifactRegistrySettings.newBuilder().build());
    }

    public static final ArtifactRegistryClient create(ArtifactRegistrySettings settings) throws IOException {
        return new ArtifactRegistryClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ArtifactRegistryClient create(ArtifactRegistryStub stub) {
        return new ArtifactRegistryClient(stub);
    }

    protected ArtifactRegistryClient(ArtifactRegistrySettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ArtifactRegistryStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ArtifactRegistryClient(ArtifactRegistryStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ArtifactRegistrySettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ArtifactRegistryStub getStub() {
        return this.stub;
    }

    public final ListDockerImagesPagedResponse listDockerImages(String parent) {
        ListDockerImagesRequest request = ListDockerImagesRequest.newBuilder().setParent(parent).build();
        return this.listDockerImages(request);
    }

    public final ListDockerImagesPagedResponse listDockerImages(ListDockerImagesRequest request) {
        return (ListDockerImagesPagedResponse)((Object)this.listDockerImagesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDockerImagesRequest, ListDockerImagesPagedResponse> listDockerImagesPagedCallable() {
        return this.stub.listDockerImagesPagedCallable();
    }

    public final UnaryCallable<ListDockerImagesRequest, ListDockerImagesResponse> listDockerImagesCallable() {
        return this.stub.listDockerImagesCallable();
    }

    public final ListRepositoriesPagedResponse listRepositories(LocationName parent) {
        ListRepositoriesRequest request = ListRepositoriesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRepositories(request);
    }

    public final ListRepositoriesPagedResponse listRepositories(String parent) {
        ListRepositoriesRequest request = ListRepositoriesRequest.newBuilder().setParent(parent).build();
        return this.listRepositories(request);
    }

    public final ListRepositoriesPagedResponse listRepositories(ListRepositoriesRequest request) {
        return (ListRepositoriesPagedResponse)((Object)this.listRepositoriesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRepositoriesRequest, ListRepositoriesPagedResponse> listRepositoriesPagedCallable() {
        return this.stub.listRepositoriesPagedCallable();
    }

    public final UnaryCallable<ListRepositoriesRequest, ListRepositoriesResponse> listRepositoriesCallable() {
        return this.stub.listRepositoriesCallable();
    }

    public final Repository getRepository(RepositoryName name) {
        GetRepositoryRequest request = GetRepositoryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRepository(request);
    }

    public final Repository getRepository(String name) {
        GetRepositoryRequest request = GetRepositoryRequest.newBuilder().setName(name).build();
        return this.getRepository(request);
    }

    public final Repository getRepository(GetRepositoryRequest request) {
        return (Repository)this.getRepositoryCallable().call((Object)request);
    }

    public final UnaryCallable<GetRepositoryRequest, Repository> getRepositoryCallable() {
        return this.stub.getRepositoryCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListRepositoriesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRepositoriesRequest, ListRepositoriesResponse, Repository, ListRepositoriesPage, ListRepositoriesFixedSizeCollection> {
        private ListRepositoriesFixedSizeCollection(List<ListRepositoriesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRepositoriesFixedSizeCollection createEmptyCollection() {
            return new ListRepositoriesFixedSizeCollection(null, 0);
        }

        protected ListRepositoriesFixedSizeCollection createCollection(List<ListRepositoriesPage> pages, int collectionSize) {
            return new ListRepositoriesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRepositoriesPage
    extends AbstractPage<ListRepositoriesRequest, ListRepositoriesResponse, Repository, ListRepositoriesPage> {
        private ListRepositoriesPage(PageContext<ListRepositoriesRequest, ListRepositoriesResponse, Repository> context, ListRepositoriesResponse response) {
            super(context, (Object)response);
        }

        private static ListRepositoriesPage createEmptyPage() {
            return new ListRepositoriesPage(null, null);
        }

        protected ListRepositoriesPage createPage(PageContext<ListRepositoriesRequest, ListRepositoriesResponse, Repository> context, ListRepositoriesResponse response) {
            return new ListRepositoriesPage(context, response);
        }

        public ApiFuture<ListRepositoriesPage> createPageAsync(PageContext<ListRepositoriesRequest, ListRepositoriesResponse, Repository> context, ApiFuture<ListRepositoriesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRepositoriesPagedResponse
    extends AbstractPagedListResponse<ListRepositoriesRequest, ListRepositoriesResponse, Repository, ListRepositoriesPage, ListRepositoriesFixedSizeCollection> {
        public static ApiFuture<ListRepositoriesPagedResponse> createAsync(PageContext<ListRepositoriesRequest, ListRepositoriesResponse, Repository> context, ApiFuture<ListRepositoriesResponse> futureResponse) {
            ApiFuture<ListRepositoriesPage> futurePage = ListRepositoriesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRepositoriesPagedResponse((ListRepositoriesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRepositoriesPagedResponse(ListRepositoriesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRepositoriesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDockerImagesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDockerImagesRequest, ListDockerImagesResponse, DockerImage, ListDockerImagesPage, ListDockerImagesFixedSizeCollection> {
        private ListDockerImagesFixedSizeCollection(List<ListDockerImagesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDockerImagesFixedSizeCollection createEmptyCollection() {
            return new ListDockerImagesFixedSizeCollection(null, 0);
        }

        protected ListDockerImagesFixedSizeCollection createCollection(List<ListDockerImagesPage> pages, int collectionSize) {
            return new ListDockerImagesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDockerImagesPage
    extends AbstractPage<ListDockerImagesRequest, ListDockerImagesResponse, DockerImage, ListDockerImagesPage> {
        private ListDockerImagesPage(PageContext<ListDockerImagesRequest, ListDockerImagesResponse, DockerImage> context, ListDockerImagesResponse response) {
            super(context, (Object)response);
        }

        private static ListDockerImagesPage createEmptyPage() {
            return new ListDockerImagesPage(null, null);
        }

        protected ListDockerImagesPage createPage(PageContext<ListDockerImagesRequest, ListDockerImagesResponse, DockerImage> context, ListDockerImagesResponse response) {
            return new ListDockerImagesPage(context, response);
        }

        public ApiFuture<ListDockerImagesPage> createPageAsync(PageContext<ListDockerImagesRequest, ListDockerImagesResponse, DockerImage> context, ApiFuture<ListDockerImagesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDockerImagesPagedResponse
    extends AbstractPagedListResponse<ListDockerImagesRequest, ListDockerImagesResponse, DockerImage, ListDockerImagesPage, ListDockerImagesFixedSizeCollection> {
        public static ApiFuture<ListDockerImagesPagedResponse> createAsync(PageContext<ListDockerImagesRequest, ListDockerImagesResponse, DockerImage> context, ApiFuture<ListDockerImagesResponse> futureResponse) {
            ApiFuture<ListDockerImagesPage> futurePage = ListDockerImagesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDockerImagesPagedResponse((ListDockerImagesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDockerImagesPagedResponse(ListDockerImagesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDockerImagesFixedSizeCollection.createEmptyCollection());
        }
    }
}

