/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.appengine.v1.DeleteServiceRequest;
import com.google.appengine.v1.GetServiceRequest;
import com.google.appengine.v1.ListServicesRequest;
import com.google.appengine.v1.ListServicesResponse;
import com.google.appengine.v1.OperationMetadataV1;
import com.google.appengine.v1.Service;
import com.google.appengine.v1.ServicesClient;
import com.google.appengine.v1.UpdateServiceRequest;
import com.google.appengine.v1.stub.GrpcServicesStub;
import com.google.appengine.v1.stub.HttpJsonServicesStub;
import com.google.appengine.v1.stub.ServicesStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class ServicesStubSettings
extends StubSettings<ServicesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/appengine.admin").add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").build();
    private final PagedCallSettings<ListServicesRequest, ListServicesResponse, ServicesClient.ListServicesPagedResponse> listServicesSettings;
    private final UnaryCallSettings<GetServiceRequest, Service> getServiceSettings;
    private final UnaryCallSettings<UpdateServiceRequest, Operation> updateServiceSettings;
    private final OperationCallSettings<UpdateServiceRequest, Service, OperationMetadataV1> updateServiceOperationSettings;
    private final UnaryCallSettings<DeleteServiceRequest, Operation> deleteServiceSettings;
    private final OperationCallSettings<DeleteServiceRequest, Empty, OperationMetadataV1> deleteServiceOperationSettings;
    private static final PagedListDescriptor<ListServicesRequest, ListServicesResponse, Service> LIST_SERVICES_PAGE_STR_DESC = new PagedListDescriptor<ListServicesRequest, ListServicesResponse, Service>(){

        public String emptyToken() {
            return "";
        }

        public ListServicesRequest injectToken(ListServicesRequest payload, String token) {
            return ListServicesRequest.newBuilder((ListServicesRequest)payload).setPageToken(token).build();
        }

        public ListServicesRequest injectPageSize(ListServicesRequest payload, int pageSize) {
            return ListServicesRequest.newBuilder((ListServicesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListServicesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListServicesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Service> extractResources(ListServicesResponse payload) {
            return payload.getServicesList() == null ? ImmutableList.of() : payload.getServicesList();
        }
    };
    private static final PagedListResponseFactory<ListServicesRequest, ListServicesResponse, ServicesClient.ListServicesPagedResponse> LIST_SERVICES_PAGE_STR_FACT = new PagedListResponseFactory<ListServicesRequest, ListServicesResponse, ServicesClient.ListServicesPagedResponse>(){

        public ApiFuture<ServicesClient.ListServicesPagedResponse> getFuturePagedResponse(UnaryCallable<ListServicesRequest, ListServicesResponse> callable, ListServicesRequest request, ApiCallContext context, ApiFuture<ListServicesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SERVICES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ServicesClient.ListServicesPagedResponse.createAsync((PageContext<ListServicesRequest, ListServicesResponse, Service>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListServicesRequest, ListServicesResponse, ServicesClient.ListServicesPagedResponse> listServicesSettings() {
        return this.listServicesSettings;
    }

    public UnaryCallSettings<GetServiceRequest, Service> getServiceSettings() {
        return this.getServiceSettings;
    }

    public UnaryCallSettings<UpdateServiceRequest, Operation> updateServiceSettings() {
        return this.updateServiceSettings;
    }

    public OperationCallSettings<UpdateServiceRequest, Service, OperationMetadataV1> updateServiceOperationSettings() {
        return this.updateServiceOperationSettings;
    }

    public UnaryCallSettings<DeleteServiceRequest, Operation> deleteServiceSettings() {
        return this.deleteServiceSettings;
    }

    public OperationCallSettings<DeleteServiceRequest, Empty, OperationMetadataV1> deleteServiceOperationSettings() {
        return this.deleteServiceOperationSettings;
    }

    public ServicesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcServicesStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonServicesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return ServicesStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "appengine";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "appengine.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "appengine.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ServicesStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ServicesStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ServicesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ServicesStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ServicesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listServicesSettings = settingsBuilder.listServicesSettings().build();
        this.getServiceSettings = settingsBuilder.getServiceSettings().build();
        this.updateServiceSettings = settingsBuilder.updateServiceSettings().build();
        this.updateServiceOperationSettings = settingsBuilder.updateServiceOperationSettings().build();
        this.deleteServiceSettings = settingsBuilder.deleteServiceSettings().build();
        this.deleteServiceOperationSettings = settingsBuilder.deleteServiceOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ServicesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListServicesRequest, ListServicesResponse, ServicesClient.ListServicesPagedResponse> listServicesSettings;
        private final UnaryCallSettings.Builder<GetServiceRequest, Service> getServiceSettings;
        private final UnaryCallSettings.Builder<UpdateServiceRequest, Operation> updateServiceSettings;
        private final OperationCallSettings.Builder<UpdateServiceRequest, Service, OperationMetadataV1> updateServiceOperationSettings;
        private final UnaryCallSettings.Builder<DeleteServiceRequest, Operation> deleteServiceSettings;
        private final OperationCallSettings.Builder<DeleteServiceRequest, Empty, OperationMetadataV1> deleteServiceOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listServicesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SERVICES_PAGE_STR_FACT);
            this.getServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateServiceOperationSettings = OperationCallSettings.newBuilder();
            this.deleteServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteServiceOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listServicesSettings, this.getServiceSettings, this.updateServiceSettings, this.deleteServiceSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ServicesStubSettings settings) {
            super((StubSettings)settings);
            this.listServicesSettings = settings.listServicesSettings.toBuilder();
            this.getServiceSettings = settings.getServiceSettings.toBuilder();
            this.updateServiceSettings = settings.updateServiceSettings.toBuilder();
            this.updateServiceOperationSettings = settings.updateServiceOperationSettings.toBuilder();
            this.deleteServiceSettings = settings.deleteServiceSettings.toBuilder();
            this.deleteServiceOperationSettings = settings.deleteServiceOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listServicesSettings, this.getServiceSettings, this.updateServiceSettings, this.deleteServiceSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ServicesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ServicesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ServicesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ServicesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)ServicesStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)ServicesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ServicesStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ServicesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listServicesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateServiceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Service.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadataV1.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteServiceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadataV1.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListServicesRequest, ListServicesResponse, ServicesClient.ListServicesPagedResponse> listServicesSettings() {
            return this.listServicesSettings;
        }

        public UnaryCallSettings.Builder<GetServiceRequest, Service> getServiceSettings() {
            return this.getServiceSettings;
        }

        public UnaryCallSettings.Builder<UpdateServiceRequest, Operation> updateServiceSettings() {
            return this.updateServiceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateServiceRequest, Service, OperationMetadataV1> updateServiceOperationSettings() {
            return this.updateServiceOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteServiceRequest, Operation> deleteServiceSettings() {
            return this.deleteServiceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteServiceRequest, Empty, OperationMetadataV1> deleteServiceOperationSettings() {
            return this.deleteServiceOperationSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return ServicesStubSettings.getDefaultEndpoint();
        }

        public ServicesStubSettings build() throws IOException {
            return new ServicesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

