/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.appengine.v1.CreateDomainMappingRequest;
import com.google.appengine.v1.DeleteDomainMappingRequest;
import com.google.appengine.v1.DomainMapping;
import com.google.appengine.v1.DomainMappingsClient;
import com.google.appengine.v1.GetDomainMappingRequest;
import com.google.appengine.v1.ListDomainMappingsRequest;
import com.google.appengine.v1.ListDomainMappingsResponse;
import com.google.appengine.v1.OperationMetadataV1;
import com.google.appengine.v1.UpdateDomainMappingRequest;
import com.google.appengine.v1.stub.DomainMappingsStub;
import com.google.appengine.v1.stub.GrpcDomainMappingsStub;
import com.google.appengine.v1.stub.HttpJsonDomainMappingsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class DomainMappingsStubSettings
extends StubSettings<DomainMappingsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/appengine.admin").add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").build();
    private final PagedCallSettings<ListDomainMappingsRequest, ListDomainMappingsResponse, DomainMappingsClient.ListDomainMappingsPagedResponse> listDomainMappingsSettings;
    private final UnaryCallSettings<GetDomainMappingRequest, DomainMapping> getDomainMappingSettings;
    private final UnaryCallSettings<CreateDomainMappingRequest, Operation> createDomainMappingSettings;
    private final OperationCallSettings<CreateDomainMappingRequest, DomainMapping, OperationMetadataV1> createDomainMappingOperationSettings;
    private final UnaryCallSettings<UpdateDomainMappingRequest, Operation> updateDomainMappingSettings;
    private final OperationCallSettings<UpdateDomainMappingRequest, DomainMapping, OperationMetadataV1> updateDomainMappingOperationSettings;
    private final UnaryCallSettings<DeleteDomainMappingRequest, Operation> deleteDomainMappingSettings;
    private final OperationCallSettings<DeleteDomainMappingRequest, Empty, OperationMetadataV1> deleteDomainMappingOperationSettings;
    private static final PagedListDescriptor<ListDomainMappingsRequest, ListDomainMappingsResponse, DomainMapping> LIST_DOMAIN_MAPPINGS_PAGE_STR_DESC = new PagedListDescriptor<ListDomainMappingsRequest, ListDomainMappingsResponse, DomainMapping>(){

        public String emptyToken() {
            return "";
        }

        public ListDomainMappingsRequest injectToken(ListDomainMappingsRequest payload, String token) {
            return ListDomainMappingsRequest.newBuilder((ListDomainMappingsRequest)payload).setPageToken(token).build();
        }

        public ListDomainMappingsRequest injectPageSize(ListDomainMappingsRequest payload, int pageSize) {
            return ListDomainMappingsRequest.newBuilder((ListDomainMappingsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDomainMappingsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDomainMappingsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DomainMapping> extractResources(ListDomainMappingsResponse payload) {
            return payload.getDomainMappingsList() == null ? ImmutableList.of() : payload.getDomainMappingsList();
        }
    };
    private static final PagedListResponseFactory<ListDomainMappingsRequest, ListDomainMappingsResponse, DomainMappingsClient.ListDomainMappingsPagedResponse> LIST_DOMAIN_MAPPINGS_PAGE_STR_FACT = new PagedListResponseFactory<ListDomainMappingsRequest, ListDomainMappingsResponse, DomainMappingsClient.ListDomainMappingsPagedResponse>(){

        public ApiFuture<DomainMappingsClient.ListDomainMappingsPagedResponse> getFuturePagedResponse(UnaryCallable<ListDomainMappingsRequest, ListDomainMappingsResponse> callable, ListDomainMappingsRequest request, ApiCallContext context, ApiFuture<ListDomainMappingsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DOMAIN_MAPPINGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DomainMappingsClient.ListDomainMappingsPagedResponse.createAsync((PageContext<ListDomainMappingsRequest, ListDomainMappingsResponse, DomainMapping>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListDomainMappingsRequest, ListDomainMappingsResponse, DomainMappingsClient.ListDomainMappingsPagedResponse> listDomainMappingsSettings() {
        return this.listDomainMappingsSettings;
    }

    public UnaryCallSettings<GetDomainMappingRequest, DomainMapping> getDomainMappingSettings() {
        return this.getDomainMappingSettings;
    }

    public UnaryCallSettings<CreateDomainMappingRequest, Operation> createDomainMappingSettings() {
        return this.createDomainMappingSettings;
    }

    public OperationCallSettings<CreateDomainMappingRequest, DomainMapping, OperationMetadataV1> createDomainMappingOperationSettings() {
        return this.createDomainMappingOperationSettings;
    }

    public UnaryCallSettings<UpdateDomainMappingRequest, Operation> updateDomainMappingSettings() {
        return this.updateDomainMappingSettings;
    }

    public OperationCallSettings<UpdateDomainMappingRequest, DomainMapping, OperationMetadataV1> updateDomainMappingOperationSettings() {
        return this.updateDomainMappingOperationSettings;
    }

    public UnaryCallSettings<DeleteDomainMappingRequest, Operation> deleteDomainMappingSettings() {
        return this.deleteDomainMappingSettings;
    }

    public OperationCallSettings<DeleteDomainMappingRequest, Empty, OperationMetadataV1> deleteDomainMappingOperationSettings() {
        return this.deleteDomainMappingOperationSettings;
    }

    public DomainMappingsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDomainMappingsStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDomainMappingsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "appengine";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "appengine.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "appengine.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DomainMappingsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DomainMappingsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DomainMappingsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return DomainMappingsStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DomainMappingsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listDomainMappingsSettings = settingsBuilder.listDomainMappingsSettings().build();
        this.getDomainMappingSettings = settingsBuilder.getDomainMappingSettings().build();
        this.createDomainMappingSettings = settingsBuilder.createDomainMappingSettings().build();
        this.createDomainMappingOperationSettings = settingsBuilder.createDomainMappingOperationSettings().build();
        this.updateDomainMappingSettings = settingsBuilder.updateDomainMappingSettings().build();
        this.updateDomainMappingOperationSettings = settingsBuilder.updateDomainMappingOperationSettings().build();
        this.deleteDomainMappingSettings = settingsBuilder.deleteDomainMappingSettings().build();
        this.deleteDomainMappingOperationSettings = settingsBuilder.deleteDomainMappingOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DomainMappingsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListDomainMappingsRequest, ListDomainMappingsResponse, DomainMappingsClient.ListDomainMappingsPagedResponse> listDomainMappingsSettings;
        private final UnaryCallSettings.Builder<GetDomainMappingRequest, DomainMapping> getDomainMappingSettings;
        private final UnaryCallSettings.Builder<CreateDomainMappingRequest, Operation> createDomainMappingSettings;
        private final OperationCallSettings.Builder<CreateDomainMappingRequest, DomainMapping, OperationMetadataV1> createDomainMappingOperationSettings;
        private final UnaryCallSettings.Builder<UpdateDomainMappingRequest, Operation> updateDomainMappingSettings;
        private final OperationCallSettings.Builder<UpdateDomainMappingRequest, DomainMapping, OperationMetadataV1> updateDomainMappingOperationSettings;
        private final UnaryCallSettings.Builder<DeleteDomainMappingRequest, Operation> deleteDomainMappingSettings;
        private final OperationCallSettings.Builder<DeleteDomainMappingRequest, Empty, OperationMetadataV1> deleteDomainMappingOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listDomainMappingsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DOMAIN_MAPPINGS_PAGE_STR_FACT);
            this.getDomainMappingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDomainMappingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDomainMappingOperationSettings = OperationCallSettings.newBuilder();
            this.updateDomainMappingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDomainMappingOperationSettings = OperationCallSettings.newBuilder();
            this.deleteDomainMappingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDomainMappingOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listDomainMappingsSettings, this.getDomainMappingSettings, this.createDomainMappingSettings, this.updateDomainMappingSettings, this.deleteDomainMappingSettings);
            Builder.initDefaults(this);
        }

        protected Builder(DomainMappingsStubSettings settings) {
            super((StubSettings)settings);
            this.listDomainMappingsSettings = settings.listDomainMappingsSettings.toBuilder();
            this.getDomainMappingSettings = settings.getDomainMappingSettings.toBuilder();
            this.createDomainMappingSettings = settings.createDomainMappingSettings.toBuilder();
            this.createDomainMappingOperationSettings = settings.createDomainMappingOperationSettings.toBuilder();
            this.updateDomainMappingSettings = settings.updateDomainMappingSettings.toBuilder();
            this.updateDomainMappingOperationSettings = settings.updateDomainMappingOperationSettings.toBuilder();
            this.deleteDomainMappingSettings = settings.deleteDomainMappingSettings.toBuilder();
            this.deleteDomainMappingOperationSettings = settings.deleteDomainMappingOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listDomainMappingsSettings, this.getDomainMappingSettings, this.createDomainMappingSettings, this.updateDomainMappingSettings, this.deleteDomainMappingSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DomainMappingsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DomainMappingsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DomainMappingsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(DomainMappingsStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(DomainMappingsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)DomainMappingsStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)DomainMappingsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DomainMappingsStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(DomainMappingsStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(DomainMappingsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listDomainMappingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getDomainMappingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createDomainMappingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateDomainMappingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteDomainMappingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createDomainMappingOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(DomainMapping.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadataV1.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateDomainMappingOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(DomainMapping.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadataV1.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteDomainMappingOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadataV1.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListDomainMappingsRequest, ListDomainMappingsResponse, DomainMappingsClient.ListDomainMappingsPagedResponse> listDomainMappingsSettings() {
            return this.listDomainMappingsSettings;
        }

        public UnaryCallSettings.Builder<GetDomainMappingRequest, DomainMapping> getDomainMappingSettings() {
            return this.getDomainMappingSettings;
        }

        public UnaryCallSettings.Builder<CreateDomainMappingRequest, Operation> createDomainMappingSettings() {
            return this.createDomainMappingSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateDomainMappingRequest, DomainMapping, OperationMetadataV1> createDomainMappingOperationSettings() {
            return this.createDomainMappingOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateDomainMappingRequest, Operation> updateDomainMappingSettings() {
            return this.updateDomainMappingSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateDomainMappingRequest, DomainMapping, OperationMetadataV1> updateDomainMappingOperationSettings() {
            return this.updateDomainMappingOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteDomainMappingRequest, Operation> deleteDomainMappingSettings() {
            return this.deleteDomainMappingSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteDomainMappingRequest, Empty, OperationMetadataV1> deleteDomainMappingOperationSettings() {
            return this.deleteDomainMappingOperationSettings;
        }

        public DomainMappingsStubSettings build() throws IOException {
            return new DomainMappingsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

