/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.appengine.v1.Application;
import com.google.appengine.v1.CreateApplicationRequest;
import com.google.appengine.v1.GetApplicationRequest;
import com.google.appengine.v1.OperationMetadataV1;
import com.google.appengine.v1.RepairApplicationRequest;
import com.google.appengine.v1.UpdateApplicationRequest;
import com.google.appengine.v1.stub.ApplicationsStub;
import com.google.appengine.v1.stub.ApplicationsStubSettings;
import com.google.appengine.v1.stub.HttpJsonApplicationsCallableFactory;
import com.google.longrunning.Operation;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonApplicationsStub
extends ApplicationsStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Application.getDescriptor()).add(OperationMetadataV1.getDescriptor()).build();
    private static final ApiMethodDescriptor<GetApplicationRequest, Application> getApplicationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.appengine.v1.Applications/GetApplication").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=apps/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Application.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateApplicationRequest, Operation> createApplicationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.appengine.v1.Applications/CreateApplication").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/apps", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("application", (Message)request.getApplication(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateApplicationRequest, Operation> updateApplicationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.appengine.v1.Applications/UpdateApplication").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=apps/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("application", (Message)request.getApplication(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<RepairApplicationRequest, Operation> repairApplicationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.appengine.v1.Applications/RepairApplication").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=apps/*}:repair", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private final UnaryCallable<GetApplicationRequest, Application> getApplicationCallable;
    private final UnaryCallable<CreateApplicationRequest, Operation> createApplicationCallable;
    private final OperationCallable<CreateApplicationRequest, Application, OperationMetadataV1> createApplicationOperationCallable;
    private final UnaryCallable<UpdateApplicationRequest, Operation> updateApplicationCallable;
    private final OperationCallable<UpdateApplicationRequest, Application, OperationMetadataV1> updateApplicationOperationCallable;
    private final UnaryCallable<RepairApplicationRequest, Operation> repairApplicationCallable;
    private final OperationCallable<RepairApplicationRequest, Application, OperationMetadataV1> repairApplicationOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonApplicationsStub create(ApplicationsStubSettings settings) throws IOException {
        return new HttpJsonApplicationsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonApplicationsStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonApplicationsStub(ApplicationsStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonApplicationsStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonApplicationsStub(ApplicationsStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonApplicationsStub(ApplicationsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonApplicationsCallableFactory());
    }

    protected HttpJsonApplicationsStub(ApplicationsStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry);
        HttpJsonCallSettings getApplicationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getApplicationMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createApplicationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createApplicationMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateApplicationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateApplicationMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings repairApplicationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(repairApplicationMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.getApplicationCallable = callableFactory.createUnaryCallable(getApplicationTransportSettings, settings.getApplicationSettings(), clientContext);
        this.createApplicationCallable = callableFactory.createUnaryCallable(createApplicationTransportSettings, settings.createApplicationSettings(), clientContext);
        this.createApplicationOperationCallable = callableFactory.createOperationCallable(createApplicationTransportSettings, settings.createApplicationOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateApplicationCallable = callableFactory.createUnaryCallable(updateApplicationTransportSettings, settings.updateApplicationSettings(), clientContext);
        this.updateApplicationOperationCallable = callableFactory.createOperationCallable(updateApplicationTransportSettings, settings.updateApplicationOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.repairApplicationCallable = callableFactory.createUnaryCallable(repairApplicationTransportSettings, settings.repairApplicationSettings(), clientContext);
        this.repairApplicationOperationCallable = callableFactory.createOperationCallable(repairApplicationTransportSettings, settings.repairApplicationOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getApplicationMethodDescriptor);
        methodDescriptors.add(createApplicationMethodDescriptor);
        methodDescriptors.add(updateApplicationMethodDescriptor);
        methodDescriptors.add(repairApplicationMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<GetApplicationRequest, Application> getApplicationCallable() {
        return this.getApplicationCallable;
    }

    @Override
    public UnaryCallable<CreateApplicationRequest, Operation> createApplicationCallable() {
        return this.createApplicationCallable;
    }

    @Override
    public OperationCallable<CreateApplicationRequest, Application, OperationMetadataV1> createApplicationOperationCallable() {
        return this.createApplicationOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateApplicationRequest, Operation> updateApplicationCallable() {
        return this.updateApplicationCallable;
    }

    @Override
    public OperationCallable<UpdateApplicationRequest, Application, OperationMetadataV1> updateApplicationOperationCallable() {
        return this.updateApplicationOperationCallable;
    }

    @Override
    public UnaryCallable<RepairApplicationRequest, Operation> repairApplicationCallable() {
        return this.repairApplicationCallable;
    }

    @Override
    public OperationCallable<RepairApplicationRequest, Application, OperationMetadataV1> repairApplicationOperationCallable() {
        return this.repairApplicationOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

