/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.appengine.v1.Application;
import com.google.appengine.v1.ApplicationsSettings;
import com.google.appengine.v1.CreateApplicationRequest;
import com.google.appengine.v1.GetApplicationRequest;
import com.google.appengine.v1.OperationMetadataV1;
import com.google.appengine.v1.RepairApplicationRequest;
import com.google.appengine.v1.UpdateApplicationRequest;
import com.google.appengine.v1.stub.ApplicationsStub;
import com.google.appengine.v1.stub.ApplicationsStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class ApplicationsClient
implements BackgroundResource {
    private final ApplicationsSettings settings;
    private final ApplicationsStub stub;
    private final OperationsClient operationsClient;

    public static final ApplicationsClient create() throws IOException {
        return ApplicationsClient.create(ApplicationsSettings.newBuilder().build());
    }

    public static final ApplicationsClient create(ApplicationsSettings settings) throws IOException {
        return new ApplicationsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ApplicationsClient create(ApplicationsStub stub) {
        return new ApplicationsClient(stub);
    }

    protected ApplicationsClient(ApplicationsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ApplicationsStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ApplicationsClient(ApplicationsStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final ApplicationsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ApplicationsStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final Application getApplication(GetApplicationRequest request) {
        return (Application)this.getApplicationCallable().call((Object)request);
    }

    public final UnaryCallable<GetApplicationRequest, Application> getApplicationCallable() {
        return this.stub.getApplicationCallable();
    }

    public final OperationFuture<Application, OperationMetadataV1> createApplicationAsync(CreateApplicationRequest request) {
        return this.createApplicationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateApplicationRequest, Application, OperationMetadataV1> createApplicationOperationCallable() {
        return this.stub.createApplicationOperationCallable();
    }

    public final UnaryCallable<CreateApplicationRequest, Operation> createApplicationCallable() {
        return this.stub.createApplicationCallable();
    }

    public final OperationFuture<Application, OperationMetadataV1> updateApplicationAsync(UpdateApplicationRequest request) {
        return this.updateApplicationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateApplicationRequest, Application, OperationMetadataV1> updateApplicationOperationCallable() {
        return this.stub.updateApplicationOperationCallable();
    }

    public final UnaryCallable<UpdateApplicationRequest, Operation> updateApplicationCallable() {
        return this.stub.updateApplicationCallable();
    }

    public final OperationFuture<Application, OperationMetadataV1> repairApplicationAsync(RepairApplicationRequest request) {
        return this.repairApplicationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RepairApplicationRequest, Application, OperationMetadataV1> repairApplicationOperationCallable() {
        return this.stub.repairApplicationOperationCallable();
    }

    public final UnaryCallable<RepairApplicationRequest, Operation> repairApplicationCallable() {
        return this.stub.repairApplicationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

