/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.appengine.v1.Application;
import com.google.appengine.v1.CreateApplicationRequest;
import com.google.appengine.v1.GetApplicationRequest;
import com.google.appengine.v1.OperationMetadataV1;
import com.google.appengine.v1.RepairApplicationRequest;
import com.google.appengine.v1.UpdateApplicationRequest;
import com.google.appengine.v1.stub.ApplicationsStub;
import com.google.appengine.v1.stub.ApplicationsStubSettings;
import com.google.appengine.v1.stub.GrpcApplicationsCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcApplicationsStub
extends ApplicationsStub {
    private static final MethodDescriptor<GetApplicationRequest, Application> getApplicationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.appengine.v1.Applications/GetApplication").setRequestMarshaller(ProtoUtils.marshaller((Message)GetApplicationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Application.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateApplicationRequest, Operation> createApplicationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.appengine.v1.Applications/CreateApplication").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateApplicationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateApplicationRequest, Operation> updateApplicationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.appengine.v1.Applications/UpdateApplication").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateApplicationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<RepairApplicationRequest, Operation> repairApplicationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.appengine.v1.Applications/RepairApplication").setRequestMarshaller(ProtoUtils.marshaller((Message)RepairApplicationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<GetApplicationRequest, Application> getApplicationCallable;
    private final UnaryCallable<CreateApplicationRequest, Operation> createApplicationCallable;
    private final OperationCallable<CreateApplicationRequest, Application, OperationMetadataV1> createApplicationOperationCallable;
    private final UnaryCallable<UpdateApplicationRequest, Operation> updateApplicationCallable;
    private final OperationCallable<UpdateApplicationRequest, Application, OperationMetadataV1> updateApplicationOperationCallable;
    private final UnaryCallable<RepairApplicationRequest, Operation> repairApplicationCallable;
    private final OperationCallable<RepairApplicationRequest, Application, OperationMetadataV1> repairApplicationOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcApplicationsStub create(ApplicationsStubSettings settings) throws IOException {
        return new GrpcApplicationsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcApplicationsStub create(ClientContext clientContext) throws IOException {
        return new GrpcApplicationsStub(ApplicationsStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcApplicationsStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcApplicationsStub(ApplicationsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcApplicationsStub(ApplicationsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcApplicationsCallableFactory());
    }

    protected GrpcApplicationsStub(ApplicationsStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getApplicationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getApplicationMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetApplicationRequest>(){

            public Map<String, String> extract(GetApplicationRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings createApplicationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createApplicationMethodDescriptor).build();
        GrpcCallSettings updateApplicationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateApplicationMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<UpdateApplicationRequest>(){

            public Map<String, String> extract(UpdateApplicationRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings repairApplicationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(repairApplicationMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<RepairApplicationRequest>(){

            public Map<String, String> extract(RepairApplicationRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        this.getApplicationCallable = callableFactory.createUnaryCallable(getApplicationTransportSettings, settings.getApplicationSettings(), clientContext);
        this.createApplicationCallable = callableFactory.createUnaryCallable(createApplicationTransportSettings, settings.createApplicationSettings(), clientContext);
        this.createApplicationOperationCallable = callableFactory.createOperationCallable(createApplicationTransportSettings, settings.createApplicationOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateApplicationCallable = callableFactory.createUnaryCallable(updateApplicationTransportSettings, settings.updateApplicationSettings(), clientContext);
        this.updateApplicationOperationCallable = callableFactory.createOperationCallable(updateApplicationTransportSettings, settings.updateApplicationOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.repairApplicationCallable = callableFactory.createUnaryCallable(repairApplicationTransportSettings, settings.repairApplicationSettings(), clientContext);
        this.repairApplicationOperationCallable = callableFactory.createOperationCallable(repairApplicationTransportSettings, settings.repairApplicationOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetApplicationRequest, Application> getApplicationCallable() {
        return this.getApplicationCallable;
    }

    @Override
    public UnaryCallable<CreateApplicationRequest, Operation> createApplicationCallable() {
        return this.createApplicationCallable;
    }

    @Override
    public OperationCallable<CreateApplicationRequest, Application, OperationMetadataV1> createApplicationOperationCallable() {
        return this.createApplicationOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateApplicationRequest, Operation> updateApplicationCallable() {
        return this.updateApplicationCallable;
    }

    @Override
    public OperationCallable<UpdateApplicationRequest, Application, OperationMetadataV1> updateApplicationOperationCallable() {
        return this.updateApplicationOperationCallable;
    }

    @Override
    public UnaryCallable<RepairApplicationRequest, Operation> repairApplicationCallable() {
        return this.repairApplicationCallable;
    }

    @Override
    public OperationCallable<RepairApplicationRequest, Application, OperationMetadataV1> repairApplicationOperationCallable() {
        return this.repairApplicationOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

