/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.appengine.v1.CreateVersionMetadataV1;
import com.google.appengine.v1.CreateVersionRequest;
import com.google.appengine.v1.DeleteVersionRequest;
import com.google.appengine.v1.GetVersionRequest;
import com.google.appengine.v1.ListVersionsRequest;
import com.google.appengine.v1.ListVersionsResponse;
import com.google.appengine.v1.OperationMetadataV1;
import com.google.appengine.v1.UpdateVersionRequest;
import com.google.appengine.v1.Version;
import com.google.appengine.v1.VersionsClient;
import com.google.appengine.v1.stub.GrpcVersionsCallableFactory;
import com.google.appengine.v1.stub.VersionsStub;
import com.google.appengine.v1.stub.VersionsStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcVersionsStub
extends VersionsStub {
    private static final MethodDescriptor<ListVersionsRequest, ListVersionsResponse> listVersionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.appengine.v1.Versions/ListVersions").setRequestMarshaller(ProtoUtils.marshaller((Message)ListVersionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListVersionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetVersionRequest, Version> getVersionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.appengine.v1.Versions/GetVersion").setRequestMarshaller(ProtoUtils.marshaller((Message)GetVersionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Version.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateVersionRequest, Operation> createVersionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.appengine.v1.Versions/CreateVersion").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateVersionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateVersionRequest, Operation> updateVersionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.appengine.v1.Versions/UpdateVersion").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateVersionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteVersionRequest, Operation> deleteVersionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.appengine.v1.Versions/DeleteVersion").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteVersionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<ListVersionsRequest, ListVersionsResponse> listVersionsCallable;
    private final UnaryCallable<ListVersionsRequest, VersionsClient.ListVersionsPagedResponse> listVersionsPagedCallable;
    private final UnaryCallable<GetVersionRequest, Version> getVersionCallable;
    private final UnaryCallable<CreateVersionRequest, Operation> createVersionCallable;
    private final OperationCallable<CreateVersionRequest, Version, CreateVersionMetadataV1> createVersionOperationCallable;
    private final UnaryCallable<UpdateVersionRequest, Operation> updateVersionCallable;
    private final OperationCallable<UpdateVersionRequest, Version, OperationMetadataV1> updateVersionOperationCallable;
    private final UnaryCallable<DeleteVersionRequest, Operation> deleteVersionCallable;
    private final OperationCallable<DeleteVersionRequest, Empty, OperationMetadataV1> deleteVersionOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcVersionsStub create(VersionsStubSettings settings) throws IOException {
        return new GrpcVersionsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcVersionsStub create(ClientContext clientContext) throws IOException {
        return new GrpcVersionsStub(VersionsStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcVersionsStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcVersionsStub(VersionsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcVersionsStub(VersionsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcVersionsCallableFactory());
    }

    protected GrpcVersionsStub(VersionsStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listVersionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listVersionsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListVersionsRequest>(){

            public Map<String, String> extract(ListVersionsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getVersionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getVersionMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetVersionRequest>(){

            public Map<String, String> extract(GetVersionRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings createVersionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createVersionMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CreateVersionRequest>(){

            public Map<String, String> extract(CreateVersionRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings updateVersionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateVersionMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<UpdateVersionRequest>(){

            public Map<String, String> extract(UpdateVersionRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings deleteVersionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteVersionMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DeleteVersionRequest>(){

            public Map<String, String> extract(DeleteVersionRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        this.listVersionsCallable = callableFactory.createUnaryCallable(listVersionsTransportSettings, settings.listVersionsSettings(), clientContext);
        this.listVersionsPagedCallable = callableFactory.createPagedCallable(listVersionsTransportSettings, settings.listVersionsSettings(), clientContext);
        this.getVersionCallable = callableFactory.createUnaryCallable(getVersionTransportSettings, settings.getVersionSettings(), clientContext);
        this.createVersionCallable = callableFactory.createUnaryCallable(createVersionTransportSettings, settings.createVersionSettings(), clientContext);
        this.createVersionOperationCallable = callableFactory.createOperationCallable(createVersionTransportSettings, settings.createVersionOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateVersionCallable = callableFactory.createUnaryCallable(updateVersionTransportSettings, settings.updateVersionSettings(), clientContext);
        this.updateVersionOperationCallable = callableFactory.createOperationCallable(updateVersionTransportSettings, settings.updateVersionOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteVersionCallable = callableFactory.createUnaryCallable(deleteVersionTransportSettings, settings.deleteVersionSettings(), clientContext);
        this.deleteVersionOperationCallable = callableFactory.createOperationCallable(deleteVersionTransportSettings, settings.deleteVersionOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListVersionsRequest, ListVersionsResponse> listVersionsCallable() {
        return this.listVersionsCallable;
    }

    @Override
    public UnaryCallable<ListVersionsRequest, VersionsClient.ListVersionsPagedResponse> listVersionsPagedCallable() {
        return this.listVersionsPagedCallable;
    }

    @Override
    public UnaryCallable<GetVersionRequest, Version> getVersionCallable() {
        return this.getVersionCallable;
    }

    @Override
    public UnaryCallable<CreateVersionRequest, Operation> createVersionCallable() {
        return this.createVersionCallable;
    }

    @Override
    public OperationCallable<CreateVersionRequest, Version, CreateVersionMetadataV1> createVersionOperationCallable() {
        return this.createVersionOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateVersionRequest, Operation> updateVersionCallable() {
        return this.updateVersionCallable;
    }

    @Override
    public OperationCallable<UpdateVersionRequest, Version, OperationMetadataV1> updateVersionOperationCallable() {
        return this.updateVersionOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteVersionRequest, Operation> deleteVersionCallable() {
        return this.deleteVersionCallable;
    }

    @Override
    public OperationCallable<DeleteVersionRequest, Empty, OperationMetadataV1> deleteVersionOperationCallable() {
        return this.deleteVersionOperationCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

