/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.apikeys.v2.stub;

import com.google.api.apikeys.v2.ApiKeysClient;
import com.google.api.apikeys.v2.CreateKeyRequest;
import com.google.api.apikeys.v2.DeleteKeyRequest;
import com.google.api.apikeys.v2.GetKeyRequest;
import com.google.api.apikeys.v2.GetKeyStringRequest;
import com.google.api.apikeys.v2.GetKeyStringResponse;
import com.google.api.apikeys.v2.Key;
import com.google.api.apikeys.v2.ListKeysRequest;
import com.google.api.apikeys.v2.ListKeysResponse;
import com.google.api.apikeys.v2.LookupKeyRequest;
import com.google.api.apikeys.v2.LookupKeyResponse;
import com.google.api.apikeys.v2.UndeleteKeyRequest;
import com.google.api.apikeys.v2.UpdateKeyRequest;
import com.google.api.apikeys.v2.stub.ApiKeysStub;
import com.google.api.apikeys.v2.stub.ApiKeysStubSettings;
import com.google.api.apikeys.v2.stub.GrpcApiKeysCallableFactory;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcApiKeysStub
extends ApiKeysStub {
    private static final MethodDescriptor<CreateKeyRequest, Operation> createKeyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.api.apikeys.v2.ApiKeys/CreateKey").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateKeyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListKeysRequest, ListKeysResponse> listKeysMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.api.apikeys.v2.ApiKeys/ListKeys").setRequestMarshaller(ProtoUtils.marshaller((Message)ListKeysRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListKeysResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetKeyRequest, Key> getKeyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.api.apikeys.v2.ApiKeys/GetKey").setRequestMarshaller(ProtoUtils.marshaller((Message)GetKeyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Key.getDefaultInstance())).build();
    private static final MethodDescriptor<GetKeyStringRequest, GetKeyStringResponse> getKeyStringMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.api.apikeys.v2.ApiKeys/GetKeyString").setRequestMarshaller(ProtoUtils.marshaller((Message)GetKeyStringRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GetKeyStringResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateKeyRequest, Operation> updateKeyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.api.apikeys.v2.ApiKeys/UpdateKey").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateKeyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteKeyRequest, Operation> deleteKeyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.api.apikeys.v2.ApiKeys/DeleteKey").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteKeyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UndeleteKeyRequest, Operation> undeleteKeyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.api.apikeys.v2.ApiKeys/UndeleteKey").setRequestMarshaller(ProtoUtils.marshaller((Message)UndeleteKeyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<LookupKeyRequest, LookupKeyResponse> lookupKeyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.api.apikeys.v2.ApiKeys/LookupKey").setRequestMarshaller(ProtoUtils.marshaller((Message)LookupKeyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)LookupKeyResponse.getDefaultInstance())).build();
    private final UnaryCallable<CreateKeyRequest, Operation> createKeyCallable;
    private final OperationCallable<CreateKeyRequest, Key, Empty> createKeyOperationCallable;
    private final UnaryCallable<ListKeysRequest, ListKeysResponse> listKeysCallable;
    private final UnaryCallable<ListKeysRequest, ApiKeysClient.ListKeysPagedResponse> listKeysPagedCallable;
    private final UnaryCallable<GetKeyRequest, Key> getKeyCallable;
    private final UnaryCallable<GetKeyStringRequest, GetKeyStringResponse> getKeyStringCallable;
    private final UnaryCallable<UpdateKeyRequest, Operation> updateKeyCallable;
    private final OperationCallable<UpdateKeyRequest, Key, Empty> updateKeyOperationCallable;
    private final UnaryCallable<DeleteKeyRequest, Operation> deleteKeyCallable;
    private final OperationCallable<DeleteKeyRequest, Key, Empty> deleteKeyOperationCallable;
    private final UnaryCallable<UndeleteKeyRequest, Operation> undeleteKeyCallable;
    private final OperationCallable<UndeleteKeyRequest, Key, Empty> undeleteKeyOperationCallable;
    private final UnaryCallable<LookupKeyRequest, LookupKeyResponse> lookupKeyCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcApiKeysStub create(ApiKeysStubSettings settings) throws IOException {
        return new GrpcApiKeysStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcApiKeysStub create(ClientContext clientContext) throws IOException {
        return new GrpcApiKeysStub(ApiKeysStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcApiKeysStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcApiKeysStub(ApiKeysStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcApiKeysStub(ApiKeysStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcApiKeysCallableFactory());
    }

    protected GrpcApiKeysStub(ApiKeysStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createKeyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createKeyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listKeysTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listKeysMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getKeyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getKeyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getKeyStringTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getKeyStringMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateKeyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateKeyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("key.name", String.valueOf(request.getKey().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteKeyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteKeyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings undeleteKeyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(undeleteKeyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings lookupKeyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(lookupKeyMethodDescriptor).build();
        this.createKeyCallable = callableFactory.createUnaryCallable(createKeyTransportSettings, settings.createKeySettings(), clientContext);
        this.createKeyOperationCallable = callableFactory.createOperationCallable(createKeyTransportSettings, settings.createKeyOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listKeysCallable = callableFactory.createUnaryCallable(listKeysTransportSettings, settings.listKeysSettings(), clientContext);
        this.listKeysPagedCallable = callableFactory.createPagedCallable(listKeysTransportSettings, settings.listKeysSettings(), clientContext);
        this.getKeyCallable = callableFactory.createUnaryCallable(getKeyTransportSettings, settings.getKeySettings(), clientContext);
        this.getKeyStringCallable = callableFactory.createUnaryCallable(getKeyStringTransportSettings, settings.getKeyStringSettings(), clientContext);
        this.updateKeyCallable = callableFactory.createUnaryCallable(updateKeyTransportSettings, settings.updateKeySettings(), clientContext);
        this.updateKeyOperationCallable = callableFactory.createOperationCallable(updateKeyTransportSettings, settings.updateKeyOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteKeyCallable = callableFactory.createUnaryCallable(deleteKeyTransportSettings, settings.deleteKeySettings(), clientContext);
        this.deleteKeyOperationCallable = callableFactory.createOperationCallable(deleteKeyTransportSettings, settings.deleteKeyOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.undeleteKeyCallable = callableFactory.createUnaryCallable(undeleteKeyTransportSettings, settings.undeleteKeySettings(), clientContext);
        this.undeleteKeyOperationCallable = callableFactory.createOperationCallable(undeleteKeyTransportSettings, settings.undeleteKeyOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.lookupKeyCallable = callableFactory.createUnaryCallable(lookupKeyTransportSettings, settings.lookupKeySettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateKeyRequest, Operation> createKeyCallable() {
        return this.createKeyCallable;
    }

    @Override
    public OperationCallable<CreateKeyRequest, Key, Empty> createKeyOperationCallable() {
        return this.createKeyOperationCallable;
    }

    @Override
    public UnaryCallable<ListKeysRequest, ListKeysResponse> listKeysCallable() {
        return this.listKeysCallable;
    }

    @Override
    public UnaryCallable<ListKeysRequest, ApiKeysClient.ListKeysPagedResponse> listKeysPagedCallable() {
        return this.listKeysPagedCallable;
    }

    @Override
    public UnaryCallable<GetKeyRequest, Key> getKeyCallable() {
        return this.getKeyCallable;
    }

    @Override
    public UnaryCallable<GetKeyStringRequest, GetKeyStringResponse> getKeyStringCallable() {
        return this.getKeyStringCallable;
    }

    @Override
    public UnaryCallable<UpdateKeyRequest, Operation> updateKeyCallable() {
        return this.updateKeyCallable;
    }

    @Override
    public OperationCallable<UpdateKeyRequest, Key, Empty> updateKeyOperationCallable() {
        return this.updateKeyOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteKeyRequest, Operation> deleteKeyCallable() {
        return this.deleteKeyCallable;
    }

    @Override
    public OperationCallable<DeleteKeyRequest, Key, Empty> deleteKeyOperationCallable() {
        return this.deleteKeyOperationCallable;
    }

    @Override
    public UnaryCallable<UndeleteKeyRequest, Operation> undeleteKeyCallable() {
        return this.undeleteKeyCallable;
    }

    @Override
    public OperationCallable<UndeleteKeyRequest, Key, Empty> undeleteKeyOperationCallable() {
        return this.undeleteKeyOperationCallable;
    }

    @Override
    public UnaryCallable<LookupKeyRequest, LookupKeyResponse> lookupKeyCallable() {
        return this.lookupKeyCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

