/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.apikeys.v2;

import com.google.api.apikeys.v2.ApiKeysSettings;
import com.google.api.apikeys.v2.CreateKeyRequest;
import com.google.api.apikeys.v2.DeleteKeyRequest;
import com.google.api.apikeys.v2.GetKeyRequest;
import com.google.api.apikeys.v2.GetKeyStringRequest;
import com.google.api.apikeys.v2.GetKeyStringResponse;
import com.google.api.apikeys.v2.Key;
import com.google.api.apikeys.v2.KeyName;
import com.google.api.apikeys.v2.ListKeysRequest;
import com.google.api.apikeys.v2.ListKeysResponse;
import com.google.api.apikeys.v2.LocationName;
import com.google.api.apikeys.v2.LookupKeyRequest;
import com.google.api.apikeys.v2.LookupKeyResponse;
import com.google.api.apikeys.v2.UndeleteKeyRequest;
import com.google.api.apikeys.v2.UpdateKeyRequest;
import com.google.api.apikeys.v2.stub.ApiKeysStub;
import com.google.api.apikeys.v2.stub.ApiKeysStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ApiKeysClient
implements BackgroundResource {
    private final ApiKeysSettings settings;
    private final ApiKeysStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final ApiKeysClient create() throws IOException {
        return ApiKeysClient.create(ApiKeysSettings.newBuilder().build());
    }

    public static final ApiKeysClient create(ApiKeysSettings settings) throws IOException {
        return new ApiKeysClient(settings);
    }

    public static final ApiKeysClient create(ApiKeysStub stub) {
        return new ApiKeysClient(stub);
    }

    protected ApiKeysClient(ApiKeysSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ApiKeysStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected ApiKeysClient(ApiKeysStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final ApiKeysSettings getSettings() {
        return this.settings;
    }

    public ApiKeysStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<Key, Empty> createKeyAsync(LocationName parent, Key key, String keyId) {
        CreateKeyRequest request = CreateKeyRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setKey(key).setKeyId(keyId).build();
        return this.createKeyAsync(request);
    }

    public final OperationFuture<Key, Empty> createKeyAsync(String parent, Key key, String keyId) {
        CreateKeyRequest request = CreateKeyRequest.newBuilder().setParent(parent).setKey(key).setKeyId(keyId).build();
        return this.createKeyAsync(request);
    }

    public final OperationFuture<Key, Empty> createKeyAsync(CreateKeyRequest request) {
        return this.createKeyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateKeyRequest, Key, Empty> createKeyOperationCallable() {
        return this.stub.createKeyOperationCallable();
    }

    public final UnaryCallable<CreateKeyRequest, Operation> createKeyCallable() {
        return this.stub.createKeyCallable();
    }

    public final ListKeysPagedResponse listKeys(LocationName parent) {
        ListKeysRequest request = ListKeysRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listKeys(request);
    }

    public final ListKeysPagedResponse listKeys(String parent) {
        ListKeysRequest request = ListKeysRequest.newBuilder().setParent(parent).build();
        return this.listKeys(request);
    }

    public final ListKeysPagedResponse listKeys(ListKeysRequest request) {
        return (ListKeysPagedResponse)((Object)this.listKeysPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListKeysRequest, ListKeysPagedResponse> listKeysPagedCallable() {
        return this.stub.listKeysPagedCallable();
    }

    public final UnaryCallable<ListKeysRequest, ListKeysResponse> listKeysCallable() {
        return this.stub.listKeysCallable();
    }

    public final Key getKey(KeyName name) {
        GetKeyRequest request = GetKeyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getKey(request);
    }

    public final Key getKey(String name) {
        GetKeyRequest request = GetKeyRequest.newBuilder().setName(name).build();
        return this.getKey(request);
    }

    public final Key getKey(GetKeyRequest request) {
        return (Key)this.getKeyCallable().call((Object)request);
    }

    public final UnaryCallable<GetKeyRequest, Key> getKeyCallable() {
        return this.stub.getKeyCallable();
    }

    public final GetKeyStringResponse getKeyString(KeyName name) {
        GetKeyStringRequest request = GetKeyStringRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getKeyString(request);
    }

    public final GetKeyStringResponse getKeyString(String name) {
        GetKeyStringRequest request = GetKeyStringRequest.newBuilder().setName(name).build();
        return this.getKeyString(request);
    }

    public final GetKeyStringResponse getKeyString(GetKeyStringRequest request) {
        return (GetKeyStringResponse)this.getKeyStringCallable().call((Object)request);
    }

    public final UnaryCallable<GetKeyStringRequest, GetKeyStringResponse> getKeyStringCallable() {
        return this.stub.getKeyStringCallable();
    }

    public final OperationFuture<Key, Empty> updateKeyAsync(Key key, FieldMask updateMask) {
        UpdateKeyRequest request = UpdateKeyRequest.newBuilder().setKey(key).setUpdateMask(updateMask).build();
        return this.updateKeyAsync(request);
    }

    public final OperationFuture<Key, Empty> updateKeyAsync(UpdateKeyRequest request) {
        return this.updateKeyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateKeyRequest, Key, Empty> updateKeyOperationCallable() {
        return this.stub.updateKeyOperationCallable();
    }

    public final UnaryCallable<UpdateKeyRequest, Operation> updateKeyCallable() {
        return this.stub.updateKeyCallable();
    }

    public final OperationFuture<Key, Empty> deleteKeyAsync(KeyName name) {
        DeleteKeyRequest request = DeleteKeyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteKeyAsync(request);
    }

    public final OperationFuture<Key, Empty> deleteKeyAsync(String name) {
        DeleteKeyRequest request = DeleteKeyRequest.newBuilder().setName(name).build();
        return this.deleteKeyAsync(request);
    }

    public final OperationFuture<Key, Empty> deleteKeyAsync(DeleteKeyRequest request) {
        return this.deleteKeyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteKeyRequest, Key, Empty> deleteKeyOperationCallable() {
        return this.stub.deleteKeyOperationCallable();
    }

    public final UnaryCallable<DeleteKeyRequest, Operation> deleteKeyCallable() {
        return this.stub.deleteKeyCallable();
    }

    public final OperationFuture<Key, Empty> undeleteKeyAsync(UndeleteKeyRequest request) {
        return this.undeleteKeyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UndeleteKeyRequest, Key, Empty> undeleteKeyOperationCallable() {
        return this.stub.undeleteKeyOperationCallable();
    }

    public final UnaryCallable<UndeleteKeyRequest, Operation> undeleteKeyCallable() {
        return this.stub.undeleteKeyCallable();
    }

    public final LookupKeyResponse lookupKey(LookupKeyRequest request) {
        return (LookupKeyResponse)this.lookupKeyCallable().call((Object)request);
    }

    public final UnaryCallable<LookupKeyRequest, LookupKeyResponse> lookupKeyCallable() {
        return this.stub.lookupKeyCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListKeysFixedSizeCollection
    extends AbstractFixedSizeCollection<ListKeysRequest, ListKeysResponse, Key, ListKeysPage, ListKeysFixedSizeCollection> {
        private ListKeysFixedSizeCollection(List<ListKeysPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListKeysFixedSizeCollection createEmptyCollection() {
            return new ListKeysFixedSizeCollection(null, 0);
        }

        protected ListKeysFixedSizeCollection createCollection(List<ListKeysPage> pages, int collectionSize) {
            return new ListKeysFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListKeysPage
    extends AbstractPage<ListKeysRequest, ListKeysResponse, Key, ListKeysPage> {
        private ListKeysPage(PageContext<ListKeysRequest, ListKeysResponse, Key> context, ListKeysResponse response) {
            super(context, (Object)response);
        }

        private static ListKeysPage createEmptyPage() {
            return new ListKeysPage(null, null);
        }

        protected ListKeysPage createPage(PageContext<ListKeysRequest, ListKeysResponse, Key> context, ListKeysResponse response) {
            return new ListKeysPage(context, response);
        }

        public ApiFuture<ListKeysPage> createPageAsync(PageContext<ListKeysRequest, ListKeysResponse, Key> context, ApiFuture<ListKeysResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListKeysPagedResponse
    extends AbstractPagedListResponse<ListKeysRequest, ListKeysResponse, Key, ListKeysPage, ListKeysFixedSizeCollection> {
        public static ApiFuture<ListKeysPagedResponse> createAsync(PageContext<ListKeysRequest, ListKeysResponse, Key> context, ApiFuture<ListKeysResponse> futureResponse) {
            ApiFuture<ListKeysPage> futurePage = ListKeysPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListKeysPagedResponse((ListKeysPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListKeysPagedResponse(ListKeysPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListKeysFixedSizeCollection.createEmptyCollection());
        }
    }
}

