/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apihub.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.OperationsClient;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.apihub.v1.ApiHubInstance;
import com.google.cloud.apihub.v1.ApiHubInstanceName;
import com.google.cloud.apihub.v1.CreateApiHubInstanceRequest;
import com.google.cloud.apihub.v1.DeleteApiHubInstanceRequest;
import com.google.cloud.apihub.v1.GetApiHubInstanceRequest;
import com.google.cloud.apihub.v1.LocationName;
import com.google.cloud.apihub.v1.LookupApiHubInstanceRequest;
import com.google.cloud.apihub.v1.LookupApiHubInstanceResponse;
import com.google.cloud.apihub.v1.OperationMetadata;
import com.google.cloud.apihub.v1.ProvisioningSettings;
import com.google.cloud.apihub.v1.stub.ProvisioningStub;
import com.google.cloud.apihub.v1.stub.ProvisioningStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ProvisioningClient
implements BackgroundResource {
    private final ProvisioningSettings settings;
    private final ProvisioningStub stub;
    private final OperationsClient httpJsonOperationsClient;

    public static final ProvisioningClient create() throws IOException {
        return ProvisioningClient.create(ProvisioningSettings.newBuilder().build());
    }

    public static final ProvisioningClient create(ProvisioningSettings settings) throws IOException {
        return new ProvisioningClient(settings);
    }

    public static final ProvisioningClient create(ProvisioningStub stub) {
        return new ProvisioningClient(stub);
    }

    protected ProvisioningClient(ProvisioningSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ProvisioningStubSettings)settings.getStubSettings()).createStub();
        this.httpJsonOperationsClient = OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected ProvisioningClient(ProvisioningStub stub) {
        this.settings = null;
        this.stub = stub;
        this.httpJsonOperationsClient = OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final ProvisioningSettings getSettings() {
        return this.settings;
    }

    public ProvisioningStub getStub() {
        return this.stub;
    }

    public final OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<ApiHubInstance, OperationMetadata> createApiHubInstanceAsync(LocationName parent, ApiHubInstance apiHubInstance, String apiHubInstanceId) {
        CreateApiHubInstanceRequest request = CreateApiHubInstanceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setApiHubInstance(apiHubInstance).setApiHubInstanceId(apiHubInstanceId).build();
        return this.createApiHubInstanceAsync(request);
    }

    public final OperationFuture<ApiHubInstance, OperationMetadata> createApiHubInstanceAsync(String parent, ApiHubInstance apiHubInstance, String apiHubInstanceId) {
        CreateApiHubInstanceRequest request = CreateApiHubInstanceRequest.newBuilder().setParent(parent).setApiHubInstance(apiHubInstance).setApiHubInstanceId(apiHubInstanceId).build();
        return this.createApiHubInstanceAsync(request);
    }

    public final OperationFuture<ApiHubInstance, OperationMetadata> createApiHubInstanceAsync(CreateApiHubInstanceRequest request) {
        return this.createApiHubInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateApiHubInstanceRequest, ApiHubInstance, OperationMetadata> createApiHubInstanceOperationCallable() {
        return this.stub.createApiHubInstanceOperationCallable();
    }

    public final UnaryCallable<CreateApiHubInstanceRequest, Operation> createApiHubInstanceCallable() {
        return this.stub.createApiHubInstanceCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteApiHubInstanceAsync(ApiHubInstanceName name) {
        DeleteApiHubInstanceRequest request = DeleteApiHubInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteApiHubInstanceAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteApiHubInstanceAsync(String name) {
        DeleteApiHubInstanceRequest request = DeleteApiHubInstanceRequest.newBuilder().setName(name).build();
        return this.deleteApiHubInstanceAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteApiHubInstanceAsync(DeleteApiHubInstanceRequest request) {
        return this.deleteApiHubInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteApiHubInstanceRequest, Empty, OperationMetadata> deleteApiHubInstanceOperationCallable() {
        return this.stub.deleteApiHubInstanceOperationCallable();
    }

    public final UnaryCallable<DeleteApiHubInstanceRequest, Operation> deleteApiHubInstanceCallable() {
        return this.stub.deleteApiHubInstanceCallable();
    }

    public final ApiHubInstance getApiHubInstance(ApiHubInstanceName name) {
        GetApiHubInstanceRequest request = GetApiHubInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getApiHubInstance(request);
    }

    public final ApiHubInstance getApiHubInstance(String name) {
        GetApiHubInstanceRequest request = GetApiHubInstanceRequest.newBuilder().setName(name).build();
        return this.getApiHubInstance(request);
    }

    public final ApiHubInstance getApiHubInstance(GetApiHubInstanceRequest request) {
        return (ApiHubInstance)this.getApiHubInstanceCallable().call((Object)request);
    }

    public final UnaryCallable<GetApiHubInstanceRequest, ApiHubInstance> getApiHubInstanceCallable() {
        return this.stub.getApiHubInstanceCallable();
    }

    public final LookupApiHubInstanceResponse lookupApiHubInstance(LocationName parent) {
        LookupApiHubInstanceRequest request = LookupApiHubInstanceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.lookupApiHubInstance(request);
    }

    public final LookupApiHubInstanceResponse lookupApiHubInstance(String parent) {
        LookupApiHubInstanceRequest request = LookupApiHubInstanceRequest.newBuilder().setParent(parent).build();
        return this.lookupApiHubInstance(request);
    }

    public final LookupApiHubInstanceResponse lookupApiHubInstance(LookupApiHubInstanceRequest request) {
        return (LookupApiHubInstanceResponse)this.lookupApiHubInstanceCallable().call((Object)request);
    }

    public final UnaryCallable<LookupApiHubInstanceRequest, LookupApiHubInstanceResponse> lookupApiHubInstanceCallable() {
        return this.stub.lookupApiHubInstanceCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

