/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apihub.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.apihub.v1.ApiHubCurateSettings;
import com.google.cloud.apihub.v1.CreateCurationRequest;
import com.google.cloud.apihub.v1.Curation;
import com.google.cloud.apihub.v1.CurationName;
import com.google.cloud.apihub.v1.DeleteCurationRequest;
import com.google.cloud.apihub.v1.GetCurationRequest;
import com.google.cloud.apihub.v1.ListCurationsRequest;
import com.google.cloud.apihub.v1.ListCurationsResponse;
import com.google.cloud.apihub.v1.LocationName;
import com.google.cloud.apihub.v1.UpdateCurationRequest;
import com.google.cloud.apihub.v1.stub.ApiHubCurateStub;
import com.google.cloud.apihub.v1.stub.ApiHubCurateStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ApiHubCurateClient
implements BackgroundResource {
    private final ApiHubCurateSettings settings;
    private final ApiHubCurateStub stub;

    public static final ApiHubCurateClient create() throws IOException {
        return ApiHubCurateClient.create(ApiHubCurateSettings.newBuilder().build());
    }

    public static final ApiHubCurateClient create(ApiHubCurateSettings settings) throws IOException {
        return new ApiHubCurateClient(settings);
    }

    public static final ApiHubCurateClient create(ApiHubCurateStub stub) {
        return new ApiHubCurateClient(stub);
    }

    protected ApiHubCurateClient(ApiHubCurateSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ApiHubCurateStubSettings)settings.getStubSettings()).createStub();
    }

    protected ApiHubCurateClient(ApiHubCurateStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ApiHubCurateSettings getSettings() {
        return this.settings;
    }

    public ApiHubCurateStub getStub() {
        return this.stub;
    }

    public final Curation createCuration(LocationName parent, Curation curation, String curationId) {
        CreateCurationRequest request = CreateCurationRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCuration(curation).setCurationId(curationId).build();
        return this.createCuration(request);
    }

    public final Curation createCuration(String parent, Curation curation, String curationId) {
        CreateCurationRequest request = CreateCurationRequest.newBuilder().setParent(parent).setCuration(curation).setCurationId(curationId).build();
        return this.createCuration(request);
    }

    public final Curation createCuration(CreateCurationRequest request) {
        return (Curation)this.createCurationCallable().call((Object)request);
    }

    public final UnaryCallable<CreateCurationRequest, Curation> createCurationCallable() {
        return this.stub.createCurationCallable();
    }

    public final Curation getCuration(CurationName name) {
        GetCurationRequest request = GetCurationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCuration(request);
    }

    public final Curation getCuration(String name) {
        GetCurationRequest request = GetCurationRequest.newBuilder().setName(name).build();
        return this.getCuration(request);
    }

    public final Curation getCuration(GetCurationRequest request) {
        return (Curation)this.getCurationCallable().call((Object)request);
    }

    public final UnaryCallable<GetCurationRequest, Curation> getCurationCallable() {
        return this.stub.getCurationCallable();
    }

    public final ListCurationsPagedResponse listCurations(LocationName parent) {
        ListCurationsRequest request = ListCurationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCurations(request);
    }

    public final ListCurationsPagedResponse listCurations(String parent) {
        ListCurationsRequest request = ListCurationsRequest.newBuilder().setParent(parent).build();
        return this.listCurations(request);
    }

    public final ListCurationsPagedResponse listCurations(ListCurationsRequest request) {
        return (ListCurationsPagedResponse)((Object)this.listCurationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCurationsRequest, ListCurationsPagedResponse> listCurationsPagedCallable() {
        return this.stub.listCurationsPagedCallable();
    }

    public final UnaryCallable<ListCurationsRequest, ListCurationsResponse> listCurationsCallable() {
        return this.stub.listCurationsCallable();
    }

    public final Curation updateCuration(Curation curation, FieldMask updateMask) {
        UpdateCurationRequest request = UpdateCurationRequest.newBuilder().setCuration(curation).setUpdateMask(updateMask).build();
        return this.updateCuration(request);
    }

    public final Curation updateCuration(UpdateCurationRequest request) {
        return (Curation)this.updateCurationCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateCurationRequest, Curation> updateCurationCallable() {
        return this.stub.updateCurationCallable();
    }

    public final void deleteCuration(CurationName name) {
        DeleteCurationRequest request = DeleteCurationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteCuration(request);
    }

    public final void deleteCuration(String name) {
        DeleteCurationRequest request = DeleteCurationRequest.newBuilder().setName(name).build();
        this.deleteCuration(request);
    }

    public final void deleteCuration(DeleteCurationRequest request) {
        this.deleteCurationCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteCurationRequest, Empty> deleteCurationCallable() {
        return this.stub.deleteCurationCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCurationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCurationsRequest, ListCurationsResponse, Curation, ListCurationsPage, ListCurationsFixedSizeCollection> {
        private ListCurationsFixedSizeCollection(List<ListCurationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCurationsFixedSizeCollection createEmptyCollection() {
            return new ListCurationsFixedSizeCollection(null, 0);
        }

        protected ListCurationsFixedSizeCollection createCollection(List<ListCurationsPage> pages, int collectionSize) {
            return new ListCurationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCurationsPage
    extends AbstractPage<ListCurationsRequest, ListCurationsResponse, Curation, ListCurationsPage> {
        private ListCurationsPage(PageContext<ListCurationsRequest, ListCurationsResponse, Curation> context, ListCurationsResponse response) {
            super(context, (Object)response);
        }

        private static ListCurationsPage createEmptyPage() {
            return new ListCurationsPage(null, null);
        }

        protected ListCurationsPage createPage(PageContext<ListCurationsRequest, ListCurationsResponse, Curation> context, ListCurationsResponse response) {
            return new ListCurationsPage(context, response);
        }

        public ApiFuture<ListCurationsPage> createPageAsync(PageContext<ListCurationsRequest, ListCurationsResponse, Curation> context, ApiFuture<ListCurationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCurationsPagedResponse
    extends AbstractPagedListResponse<ListCurationsRequest, ListCurationsResponse, Curation, ListCurationsPage, ListCurationsFixedSizeCollection> {
        public static ApiFuture<ListCurationsPagedResponse> createAsync(PageContext<ListCurationsRequest, ListCurationsResponse, Curation> context, ApiFuture<ListCurationsResponse> futureResponse) {
            ApiFuture<ListCurationsPage> futurePage = ListCurationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCurationsPagedResponse((ListCurationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCurationsPagedResponse(ListCurationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCurationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

