/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apihub.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.apihub.v1.Api;
import com.google.cloud.apihub.v1.ApiHubClient;
import com.google.cloud.apihub.v1.ApiOperation;
import com.google.cloud.apihub.v1.Attribute;
import com.google.cloud.apihub.v1.CreateApiOperationRequest;
import com.google.cloud.apihub.v1.CreateApiRequest;
import com.google.cloud.apihub.v1.CreateAttributeRequest;
import com.google.cloud.apihub.v1.CreateDeploymentRequest;
import com.google.cloud.apihub.v1.CreateExternalApiRequest;
import com.google.cloud.apihub.v1.CreateSpecRequest;
import com.google.cloud.apihub.v1.CreateVersionRequest;
import com.google.cloud.apihub.v1.Definition;
import com.google.cloud.apihub.v1.DeleteApiOperationRequest;
import com.google.cloud.apihub.v1.DeleteApiRequest;
import com.google.cloud.apihub.v1.DeleteAttributeRequest;
import com.google.cloud.apihub.v1.DeleteDeploymentRequest;
import com.google.cloud.apihub.v1.DeleteExternalApiRequest;
import com.google.cloud.apihub.v1.DeleteSpecRequest;
import com.google.cloud.apihub.v1.DeleteVersionRequest;
import com.google.cloud.apihub.v1.Deployment;
import com.google.cloud.apihub.v1.ExternalApi;
import com.google.cloud.apihub.v1.GetApiOperationRequest;
import com.google.cloud.apihub.v1.GetApiRequest;
import com.google.cloud.apihub.v1.GetAttributeRequest;
import com.google.cloud.apihub.v1.GetDefinitionRequest;
import com.google.cloud.apihub.v1.GetDeploymentRequest;
import com.google.cloud.apihub.v1.GetExternalApiRequest;
import com.google.cloud.apihub.v1.GetSpecContentsRequest;
import com.google.cloud.apihub.v1.GetSpecRequest;
import com.google.cloud.apihub.v1.GetVersionRequest;
import com.google.cloud.apihub.v1.ListApiOperationsRequest;
import com.google.cloud.apihub.v1.ListApiOperationsResponse;
import com.google.cloud.apihub.v1.ListApisRequest;
import com.google.cloud.apihub.v1.ListApisResponse;
import com.google.cloud.apihub.v1.ListAttributesRequest;
import com.google.cloud.apihub.v1.ListAttributesResponse;
import com.google.cloud.apihub.v1.ListDeploymentsRequest;
import com.google.cloud.apihub.v1.ListDeploymentsResponse;
import com.google.cloud.apihub.v1.ListExternalApisRequest;
import com.google.cloud.apihub.v1.ListExternalApisResponse;
import com.google.cloud.apihub.v1.ListSpecsRequest;
import com.google.cloud.apihub.v1.ListSpecsResponse;
import com.google.cloud.apihub.v1.ListVersionsRequest;
import com.google.cloud.apihub.v1.ListVersionsResponse;
import com.google.cloud.apihub.v1.SearchResourcesRequest;
import com.google.cloud.apihub.v1.SearchResourcesResponse;
import com.google.cloud.apihub.v1.SearchResult;
import com.google.cloud.apihub.v1.Spec;
import com.google.cloud.apihub.v1.SpecContents;
import com.google.cloud.apihub.v1.UpdateApiOperationRequest;
import com.google.cloud.apihub.v1.UpdateApiRequest;
import com.google.cloud.apihub.v1.UpdateAttributeRequest;
import com.google.cloud.apihub.v1.UpdateDeploymentRequest;
import com.google.cloud.apihub.v1.UpdateExternalApiRequest;
import com.google.cloud.apihub.v1.UpdateSpecRequest;
import com.google.cloud.apihub.v1.UpdateVersionRequest;
import com.google.cloud.apihub.v1.Version;
import com.google.cloud.apihub.v1.stub.ApiHubStub;
import com.google.cloud.apihub.v1.stub.HttpJsonApiHubStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ApiHubStubSettings
extends StubSettings<ApiHubStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateApiRequest, Api> createApiSettings;
    private final UnaryCallSettings<GetApiRequest, Api> getApiSettings;
    private final PagedCallSettings<ListApisRequest, ListApisResponse, ApiHubClient.ListApisPagedResponse> listApisSettings;
    private final UnaryCallSettings<UpdateApiRequest, Api> updateApiSettings;
    private final UnaryCallSettings<DeleteApiRequest, Empty> deleteApiSettings;
    private final UnaryCallSettings<CreateVersionRequest, Version> createVersionSettings;
    private final UnaryCallSettings<GetVersionRequest, Version> getVersionSettings;
    private final PagedCallSettings<ListVersionsRequest, ListVersionsResponse, ApiHubClient.ListVersionsPagedResponse> listVersionsSettings;
    private final UnaryCallSettings<UpdateVersionRequest, Version> updateVersionSettings;
    private final UnaryCallSettings<DeleteVersionRequest, Empty> deleteVersionSettings;
    private final UnaryCallSettings<CreateSpecRequest, Spec> createSpecSettings;
    private final UnaryCallSettings<GetSpecRequest, Spec> getSpecSettings;
    private final UnaryCallSettings<GetSpecContentsRequest, SpecContents> getSpecContentsSettings;
    private final PagedCallSettings<ListSpecsRequest, ListSpecsResponse, ApiHubClient.ListSpecsPagedResponse> listSpecsSettings;
    private final UnaryCallSettings<UpdateSpecRequest, Spec> updateSpecSettings;
    private final UnaryCallSettings<DeleteSpecRequest, Empty> deleteSpecSettings;
    private final UnaryCallSettings<CreateApiOperationRequest, ApiOperation> createApiOperationSettings;
    private final UnaryCallSettings<GetApiOperationRequest, ApiOperation> getApiOperationSettings;
    private final PagedCallSettings<ListApiOperationsRequest, ListApiOperationsResponse, ApiHubClient.ListApiOperationsPagedResponse> listApiOperationsSettings;
    private final UnaryCallSettings<UpdateApiOperationRequest, ApiOperation> updateApiOperationSettings;
    private final UnaryCallSettings<DeleteApiOperationRequest, Empty> deleteApiOperationSettings;
    private final UnaryCallSettings<GetDefinitionRequest, Definition> getDefinitionSettings;
    private final UnaryCallSettings<CreateDeploymentRequest, Deployment> createDeploymentSettings;
    private final UnaryCallSettings<GetDeploymentRequest, Deployment> getDeploymentSettings;
    private final PagedCallSettings<ListDeploymentsRequest, ListDeploymentsResponse, ApiHubClient.ListDeploymentsPagedResponse> listDeploymentsSettings;
    private final UnaryCallSettings<UpdateDeploymentRequest, Deployment> updateDeploymentSettings;
    private final UnaryCallSettings<DeleteDeploymentRequest, Empty> deleteDeploymentSettings;
    private final UnaryCallSettings<CreateAttributeRequest, Attribute> createAttributeSettings;
    private final UnaryCallSettings<GetAttributeRequest, Attribute> getAttributeSettings;
    private final UnaryCallSettings<UpdateAttributeRequest, Attribute> updateAttributeSettings;
    private final UnaryCallSettings<DeleteAttributeRequest, Empty> deleteAttributeSettings;
    private final PagedCallSettings<ListAttributesRequest, ListAttributesResponse, ApiHubClient.ListAttributesPagedResponse> listAttributesSettings;
    private final PagedCallSettings<SearchResourcesRequest, SearchResourcesResponse, ApiHubClient.SearchResourcesPagedResponse> searchResourcesSettings;
    private final UnaryCallSettings<CreateExternalApiRequest, ExternalApi> createExternalApiSettings;
    private final UnaryCallSettings<GetExternalApiRequest, ExternalApi> getExternalApiSettings;
    private final UnaryCallSettings<UpdateExternalApiRequest, ExternalApi> updateExternalApiSettings;
    private final UnaryCallSettings<DeleteExternalApiRequest, Empty> deleteExternalApiSettings;
    private final PagedCallSettings<ListExternalApisRequest, ListExternalApisResponse, ApiHubClient.ListExternalApisPagedResponse> listExternalApisSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ApiHubClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListApisRequest, ListApisResponse, Api> LIST_APIS_PAGE_STR_DESC = new PagedListDescriptor<ListApisRequest, ListApisResponse, Api>(){

        public String emptyToken() {
            return "";
        }

        public ListApisRequest injectToken(ListApisRequest payload, String token) {
            return ListApisRequest.newBuilder((ListApisRequest)payload).setPageToken(token).build();
        }

        public ListApisRequest injectPageSize(ListApisRequest payload, int pageSize) {
            return ListApisRequest.newBuilder((ListApisRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListApisRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListApisResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Api> extractResources(ListApisResponse payload) {
            return payload.getApisList();
        }
    };
    private static final PagedListDescriptor<ListVersionsRequest, ListVersionsResponse, Version> LIST_VERSIONS_PAGE_STR_DESC = new PagedListDescriptor<ListVersionsRequest, ListVersionsResponse, Version>(){

        public String emptyToken() {
            return "";
        }

        public ListVersionsRequest injectToken(ListVersionsRequest payload, String token) {
            return ListVersionsRequest.newBuilder((ListVersionsRequest)payload).setPageToken(token).build();
        }

        public ListVersionsRequest injectPageSize(ListVersionsRequest payload, int pageSize) {
            return ListVersionsRequest.newBuilder((ListVersionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListVersionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListVersionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Version> extractResources(ListVersionsResponse payload) {
            return payload.getVersionsList();
        }
    };
    private static final PagedListDescriptor<ListSpecsRequest, ListSpecsResponse, Spec> LIST_SPECS_PAGE_STR_DESC = new PagedListDescriptor<ListSpecsRequest, ListSpecsResponse, Spec>(){

        public String emptyToken() {
            return "";
        }

        public ListSpecsRequest injectToken(ListSpecsRequest payload, String token) {
            return ListSpecsRequest.newBuilder((ListSpecsRequest)payload).setPageToken(token).build();
        }

        public ListSpecsRequest injectPageSize(ListSpecsRequest payload, int pageSize) {
            return ListSpecsRequest.newBuilder((ListSpecsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSpecsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSpecsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Spec> extractResources(ListSpecsResponse payload) {
            return payload.getSpecsList();
        }
    };
    private static final PagedListDescriptor<ListApiOperationsRequest, ListApiOperationsResponse, ApiOperation> LIST_API_OPERATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListApiOperationsRequest, ListApiOperationsResponse, ApiOperation>(){

        public String emptyToken() {
            return "";
        }

        public ListApiOperationsRequest injectToken(ListApiOperationsRequest payload, String token) {
            return ListApiOperationsRequest.newBuilder((ListApiOperationsRequest)payload).setPageToken(token).build();
        }

        public ListApiOperationsRequest injectPageSize(ListApiOperationsRequest payload, int pageSize) {
            return ListApiOperationsRequest.newBuilder((ListApiOperationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListApiOperationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListApiOperationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ApiOperation> extractResources(ListApiOperationsResponse payload) {
            return payload.getApiOperationsList();
        }
    };
    private static final PagedListDescriptor<ListDeploymentsRequest, ListDeploymentsResponse, Deployment> LIST_DEPLOYMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListDeploymentsRequest, ListDeploymentsResponse, Deployment>(){

        public String emptyToken() {
            return "";
        }

        public ListDeploymentsRequest injectToken(ListDeploymentsRequest payload, String token) {
            return ListDeploymentsRequest.newBuilder((ListDeploymentsRequest)payload).setPageToken(token).build();
        }

        public ListDeploymentsRequest injectPageSize(ListDeploymentsRequest payload, int pageSize) {
            return ListDeploymentsRequest.newBuilder((ListDeploymentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDeploymentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDeploymentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Deployment> extractResources(ListDeploymentsResponse payload) {
            return payload.getDeploymentsList();
        }
    };
    private static final PagedListDescriptor<ListAttributesRequest, ListAttributesResponse, Attribute> LIST_ATTRIBUTES_PAGE_STR_DESC = new PagedListDescriptor<ListAttributesRequest, ListAttributesResponse, Attribute>(){

        public String emptyToken() {
            return "";
        }

        public ListAttributesRequest injectToken(ListAttributesRequest payload, String token) {
            return ListAttributesRequest.newBuilder((ListAttributesRequest)payload).setPageToken(token).build();
        }

        public ListAttributesRequest injectPageSize(ListAttributesRequest payload, int pageSize) {
            return ListAttributesRequest.newBuilder((ListAttributesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAttributesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAttributesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Attribute> extractResources(ListAttributesResponse payload) {
            return payload.getAttributesList();
        }
    };
    private static final PagedListDescriptor<SearchResourcesRequest, SearchResourcesResponse, SearchResult> SEARCH_RESOURCES_PAGE_STR_DESC = new PagedListDescriptor<SearchResourcesRequest, SearchResourcesResponse, SearchResult>(){

        public String emptyToken() {
            return "";
        }

        public SearchResourcesRequest injectToken(SearchResourcesRequest payload, String token) {
            return SearchResourcesRequest.newBuilder((SearchResourcesRequest)payload).setPageToken(token).build();
        }

        public SearchResourcesRequest injectPageSize(SearchResourcesRequest payload, int pageSize) {
            return SearchResourcesRequest.newBuilder((SearchResourcesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(SearchResourcesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(SearchResourcesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<SearchResult> extractResources(SearchResourcesResponse payload) {
            return payload.getSearchResultsList();
        }
    };
    private static final PagedListDescriptor<ListExternalApisRequest, ListExternalApisResponse, ExternalApi> LIST_EXTERNAL_APIS_PAGE_STR_DESC = new PagedListDescriptor<ListExternalApisRequest, ListExternalApisResponse, ExternalApi>(){

        public String emptyToken() {
            return "";
        }

        public ListExternalApisRequest injectToken(ListExternalApisRequest payload, String token) {
            return ListExternalApisRequest.newBuilder((ListExternalApisRequest)payload).setPageToken(token).build();
        }

        public ListExternalApisRequest injectPageSize(ListExternalApisRequest payload, int pageSize) {
            return ListExternalApisRequest.newBuilder((ListExternalApisRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListExternalApisRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListExternalApisResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ExternalApi> extractResources(ListExternalApisResponse payload) {
            return payload.getExternalApisList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListApisRequest, ListApisResponse, ApiHubClient.ListApisPagedResponse> LIST_APIS_PAGE_STR_FACT = new PagedListResponseFactory<ListApisRequest, ListApisResponse, ApiHubClient.ListApisPagedResponse>(){

        public ApiFuture<ApiHubClient.ListApisPagedResponse> getFuturePagedResponse(UnaryCallable<ListApisRequest, ListApisResponse> callable, ListApisRequest request, ApiCallContext context, ApiFuture<ListApisResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_APIS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ApiHubClient.ListApisPagedResponse.createAsync((PageContext<ListApisRequest, ListApisResponse, Api>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListVersionsRequest, ListVersionsResponse, ApiHubClient.ListVersionsPagedResponse> LIST_VERSIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListVersionsRequest, ListVersionsResponse, ApiHubClient.ListVersionsPagedResponse>(){

        public ApiFuture<ApiHubClient.ListVersionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListVersionsRequest, ListVersionsResponse> callable, ListVersionsRequest request, ApiCallContext context, ApiFuture<ListVersionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_VERSIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ApiHubClient.ListVersionsPagedResponse.createAsync((PageContext<ListVersionsRequest, ListVersionsResponse, Version>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListSpecsRequest, ListSpecsResponse, ApiHubClient.ListSpecsPagedResponse> LIST_SPECS_PAGE_STR_FACT = new PagedListResponseFactory<ListSpecsRequest, ListSpecsResponse, ApiHubClient.ListSpecsPagedResponse>(){

        public ApiFuture<ApiHubClient.ListSpecsPagedResponse> getFuturePagedResponse(UnaryCallable<ListSpecsRequest, ListSpecsResponse> callable, ListSpecsRequest request, ApiCallContext context, ApiFuture<ListSpecsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SPECS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ApiHubClient.ListSpecsPagedResponse.createAsync((PageContext<ListSpecsRequest, ListSpecsResponse, Spec>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListApiOperationsRequest, ListApiOperationsResponse, ApiHubClient.ListApiOperationsPagedResponse> LIST_API_OPERATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListApiOperationsRequest, ListApiOperationsResponse, ApiHubClient.ListApiOperationsPagedResponse>(){

        public ApiFuture<ApiHubClient.ListApiOperationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListApiOperationsRequest, ListApiOperationsResponse> callable, ListApiOperationsRequest request, ApiCallContext context, ApiFuture<ListApiOperationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_API_OPERATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ApiHubClient.ListApiOperationsPagedResponse.createAsync((PageContext<ListApiOperationsRequest, ListApiOperationsResponse, ApiOperation>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListDeploymentsRequest, ListDeploymentsResponse, ApiHubClient.ListDeploymentsPagedResponse> LIST_DEPLOYMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListDeploymentsRequest, ListDeploymentsResponse, ApiHubClient.ListDeploymentsPagedResponse>(){

        public ApiFuture<ApiHubClient.ListDeploymentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListDeploymentsRequest, ListDeploymentsResponse> callable, ListDeploymentsRequest request, ApiCallContext context, ApiFuture<ListDeploymentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DEPLOYMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ApiHubClient.ListDeploymentsPagedResponse.createAsync((PageContext<ListDeploymentsRequest, ListDeploymentsResponse, Deployment>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListAttributesRequest, ListAttributesResponse, ApiHubClient.ListAttributesPagedResponse> LIST_ATTRIBUTES_PAGE_STR_FACT = new PagedListResponseFactory<ListAttributesRequest, ListAttributesResponse, ApiHubClient.ListAttributesPagedResponse>(){

        public ApiFuture<ApiHubClient.ListAttributesPagedResponse> getFuturePagedResponse(UnaryCallable<ListAttributesRequest, ListAttributesResponse> callable, ListAttributesRequest request, ApiCallContext context, ApiFuture<ListAttributesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ATTRIBUTES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ApiHubClient.ListAttributesPagedResponse.createAsync((PageContext<ListAttributesRequest, ListAttributesResponse, Attribute>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<SearchResourcesRequest, SearchResourcesResponse, ApiHubClient.SearchResourcesPagedResponse> SEARCH_RESOURCES_PAGE_STR_FACT = new PagedListResponseFactory<SearchResourcesRequest, SearchResourcesResponse, ApiHubClient.SearchResourcesPagedResponse>(){

        public ApiFuture<ApiHubClient.SearchResourcesPagedResponse> getFuturePagedResponse(UnaryCallable<SearchResourcesRequest, SearchResourcesResponse> callable, SearchResourcesRequest request, ApiCallContext context, ApiFuture<SearchResourcesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)SEARCH_RESOURCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ApiHubClient.SearchResourcesPagedResponse.createAsync((PageContext<SearchResourcesRequest, SearchResourcesResponse, SearchResult>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListExternalApisRequest, ListExternalApisResponse, ApiHubClient.ListExternalApisPagedResponse> LIST_EXTERNAL_APIS_PAGE_STR_FACT = new PagedListResponseFactory<ListExternalApisRequest, ListExternalApisResponse, ApiHubClient.ListExternalApisPagedResponse>(){

        public ApiFuture<ApiHubClient.ListExternalApisPagedResponse> getFuturePagedResponse(UnaryCallable<ListExternalApisRequest, ListExternalApisResponse> callable, ListExternalApisRequest request, ApiCallContext context, ApiFuture<ListExternalApisResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_EXTERNAL_APIS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ApiHubClient.ListExternalApisPagedResponse.createAsync((PageContext<ListExternalApisRequest, ListExternalApisResponse, ExternalApi>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ApiHubClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ApiHubClient.ListLocationsPagedResponse>(){

        public ApiFuture<ApiHubClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ApiHubClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateApiRequest, Api> createApiSettings() {
        return this.createApiSettings;
    }

    public UnaryCallSettings<GetApiRequest, Api> getApiSettings() {
        return this.getApiSettings;
    }

    public PagedCallSettings<ListApisRequest, ListApisResponse, ApiHubClient.ListApisPagedResponse> listApisSettings() {
        return this.listApisSettings;
    }

    public UnaryCallSettings<UpdateApiRequest, Api> updateApiSettings() {
        return this.updateApiSettings;
    }

    public UnaryCallSettings<DeleteApiRequest, Empty> deleteApiSettings() {
        return this.deleteApiSettings;
    }

    public UnaryCallSettings<CreateVersionRequest, Version> createVersionSettings() {
        return this.createVersionSettings;
    }

    public UnaryCallSettings<GetVersionRequest, Version> getVersionSettings() {
        return this.getVersionSettings;
    }

    public PagedCallSettings<ListVersionsRequest, ListVersionsResponse, ApiHubClient.ListVersionsPagedResponse> listVersionsSettings() {
        return this.listVersionsSettings;
    }

    public UnaryCallSettings<UpdateVersionRequest, Version> updateVersionSettings() {
        return this.updateVersionSettings;
    }

    public UnaryCallSettings<DeleteVersionRequest, Empty> deleteVersionSettings() {
        return this.deleteVersionSettings;
    }

    public UnaryCallSettings<CreateSpecRequest, Spec> createSpecSettings() {
        return this.createSpecSettings;
    }

    public UnaryCallSettings<GetSpecRequest, Spec> getSpecSettings() {
        return this.getSpecSettings;
    }

    public UnaryCallSettings<GetSpecContentsRequest, SpecContents> getSpecContentsSettings() {
        return this.getSpecContentsSettings;
    }

    public PagedCallSettings<ListSpecsRequest, ListSpecsResponse, ApiHubClient.ListSpecsPagedResponse> listSpecsSettings() {
        return this.listSpecsSettings;
    }

    public UnaryCallSettings<UpdateSpecRequest, Spec> updateSpecSettings() {
        return this.updateSpecSettings;
    }

    public UnaryCallSettings<DeleteSpecRequest, Empty> deleteSpecSettings() {
        return this.deleteSpecSettings;
    }

    public UnaryCallSettings<CreateApiOperationRequest, ApiOperation> createApiOperationSettings() {
        return this.createApiOperationSettings;
    }

    public UnaryCallSettings<GetApiOperationRequest, ApiOperation> getApiOperationSettings() {
        return this.getApiOperationSettings;
    }

    public PagedCallSettings<ListApiOperationsRequest, ListApiOperationsResponse, ApiHubClient.ListApiOperationsPagedResponse> listApiOperationsSettings() {
        return this.listApiOperationsSettings;
    }

    public UnaryCallSettings<UpdateApiOperationRequest, ApiOperation> updateApiOperationSettings() {
        return this.updateApiOperationSettings;
    }

    public UnaryCallSettings<DeleteApiOperationRequest, Empty> deleteApiOperationSettings() {
        return this.deleteApiOperationSettings;
    }

    public UnaryCallSettings<GetDefinitionRequest, Definition> getDefinitionSettings() {
        return this.getDefinitionSettings;
    }

    public UnaryCallSettings<CreateDeploymentRequest, Deployment> createDeploymentSettings() {
        return this.createDeploymentSettings;
    }

    public UnaryCallSettings<GetDeploymentRequest, Deployment> getDeploymentSettings() {
        return this.getDeploymentSettings;
    }

    public PagedCallSettings<ListDeploymentsRequest, ListDeploymentsResponse, ApiHubClient.ListDeploymentsPagedResponse> listDeploymentsSettings() {
        return this.listDeploymentsSettings;
    }

    public UnaryCallSettings<UpdateDeploymentRequest, Deployment> updateDeploymentSettings() {
        return this.updateDeploymentSettings;
    }

    public UnaryCallSettings<DeleteDeploymentRequest, Empty> deleteDeploymentSettings() {
        return this.deleteDeploymentSettings;
    }

    public UnaryCallSettings<CreateAttributeRequest, Attribute> createAttributeSettings() {
        return this.createAttributeSettings;
    }

    public UnaryCallSettings<GetAttributeRequest, Attribute> getAttributeSettings() {
        return this.getAttributeSettings;
    }

    public UnaryCallSettings<UpdateAttributeRequest, Attribute> updateAttributeSettings() {
        return this.updateAttributeSettings;
    }

    public UnaryCallSettings<DeleteAttributeRequest, Empty> deleteAttributeSettings() {
        return this.deleteAttributeSettings;
    }

    public PagedCallSettings<ListAttributesRequest, ListAttributesResponse, ApiHubClient.ListAttributesPagedResponse> listAttributesSettings() {
        return this.listAttributesSettings;
    }

    public PagedCallSettings<SearchResourcesRequest, SearchResourcesResponse, ApiHubClient.SearchResourcesPagedResponse> searchResourcesSettings() {
        return this.searchResourcesSettings;
    }

    public UnaryCallSettings<CreateExternalApiRequest, ExternalApi> createExternalApiSettings() {
        return this.createExternalApiSettings;
    }

    public UnaryCallSettings<GetExternalApiRequest, ExternalApi> getExternalApiSettings() {
        return this.getExternalApiSettings;
    }

    public UnaryCallSettings<UpdateExternalApiRequest, ExternalApi> updateExternalApiSettings() {
        return this.updateExternalApiSettings;
    }

    public UnaryCallSettings<DeleteExternalApiRequest, Empty> deleteExternalApiSettings() {
        return this.deleteExternalApiSettings;
    }

    public PagedCallSettings<ListExternalApisRequest, ListExternalApisResponse, ApiHubClient.ListExternalApisPagedResponse> listExternalApisSettings() {
        return this.listExternalApisSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ApiHubClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public ApiHubStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonApiHubStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "apihub";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "apihub.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "apihub.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ApiHubStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ApiHubStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ApiHubStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createApiSettings = settingsBuilder.createApiSettings().build();
        this.getApiSettings = settingsBuilder.getApiSettings().build();
        this.listApisSettings = settingsBuilder.listApisSettings().build();
        this.updateApiSettings = settingsBuilder.updateApiSettings().build();
        this.deleteApiSettings = settingsBuilder.deleteApiSettings().build();
        this.createVersionSettings = settingsBuilder.createVersionSettings().build();
        this.getVersionSettings = settingsBuilder.getVersionSettings().build();
        this.listVersionsSettings = settingsBuilder.listVersionsSettings().build();
        this.updateVersionSettings = settingsBuilder.updateVersionSettings().build();
        this.deleteVersionSettings = settingsBuilder.deleteVersionSettings().build();
        this.createSpecSettings = settingsBuilder.createSpecSettings().build();
        this.getSpecSettings = settingsBuilder.getSpecSettings().build();
        this.getSpecContentsSettings = settingsBuilder.getSpecContentsSettings().build();
        this.listSpecsSettings = settingsBuilder.listSpecsSettings().build();
        this.updateSpecSettings = settingsBuilder.updateSpecSettings().build();
        this.deleteSpecSettings = settingsBuilder.deleteSpecSettings().build();
        this.createApiOperationSettings = settingsBuilder.createApiOperationSettings().build();
        this.getApiOperationSettings = settingsBuilder.getApiOperationSettings().build();
        this.listApiOperationsSettings = settingsBuilder.listApiOperationsSettings().build();
        this.updateApiOperationSettings = settingsBuilder.updateApiOperationSettings().build();
        this.deleteApiOperationSettings = settingsBuilder.deleteApiOperationSettings().build();
        this.getDefinitionSettings = settingsBuilder.getDefinitionSettings().build();
        this.createDeploymentSettings = settingsBuilder.createDeploymentSettings().build();
        this.getDeploymentSettings = settingsBuilder.getDeploymentSettings().build();
        this.listDeploymentsSettings = settingsBuilder.listDeploymentsSettings().build();
        this.updateDeploymentSettings = settingsBuilder.updateDeploymentSettings().build();
        this.deleteDeploymentSettings = settingsBuilder.deleteDeploymentSettings().build();
        this.createAttributeSettings = settingsBuilder.createAttributeSettings().build();
        this.getAttributeSettings = settingsBuilder.getAttributeSettings().build();
        this.updateAttributeSettings = settingsBuilder.updateAttributeSettings().build();
        this.deleteAttributeSettings = settingsBuilder.deleteAttributeSettings().build();
        this.listAttributesSettings = settingsBuilder.listAttributesSettings().build();
        this.searchResourcesSettings = settingsBuilder.searchResourcesSettings().build();
        this.createExternalApiSettings = settingsBuilder.createExternalApiSettings().build();
        this.getExternalApiSettings = settingsBuilder.getExternalApiSettings().build();
        this.updateExternalApiSettings = settingsBuilder.updateExternalApiSettings().build();
        this.deleteExternalApiSettings = settingsBuilder.deleteExternalApiSettings().build();
        this.listExternalApisSettings = settingsBuilder.listExternalApisSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ApiHubStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateApiRequest, Api> createApiSettings;
        private final UnaryCallSettings.Builder<GetApiRequest, Api> getApiSettings;
        private final PagedCallSettings.Builder<ListApisRequest, ListApisResponse, ApiHubClient.ListApisPagedResponse> listApisSettings;
        private final UnaryCallSettings.Builder<UpdateApiRequest, Api> updateApiSettings;
        private final UnaryCallSettings.Builder<DeleteApiRequest, Empty> deleteApiSettings;
        private final UnaryCallSettings.Builder<CreateVersionRequest, Version> createVersionSettings;
        private final UnaryCallSettings.Builder<GetVersionRequest, Version> getVersionSettings;
        private final PagedCallSettings.Builder<ListVersionsRequest, ListVersionsResponse, ApiHubClient.ListVersionsPagedResponse> listVersionsSettings;
        private final UnaryCallSettings.Builder<UpdateVersionRequest, Version> updateVersionSettings;
        private final UnaryCallSettings.Builder<DeleteVersionRequest, Empty> deleteVersionSettings;
        private final UnaryCallSettings.Builder<CreateSpecRequest, Spec> createSpecSettings;
        private final UnaryCallSettings.Builder<GetSpecRequest, Spec> getSpecSettings;
        private final UnaryCallSettings.Builder<GetSpecContentsRequest, SpecContents> getSpecContentsSettings;
        private final PagedCallSettings.Builder<ListSpecsRequest, ListSpecsResponse, ApiHubClient.ListSpecsPagedResponse> listSpecsSettings;
        private final UnaryCallSettings.Builder<UpdateSpecRequest, Spec> updateSpecSettings;
        private final UnaryCallSettings.Builder<DeleteSpecRequest, Empty> deleteSpecSettings;
        private final UnaryCallSettings.Builder<CreateApiOperationRequest, ApiOperation> createApiOperationSettings;
        private final UnaryCallSettings.Builder<GetApiOperationRequest, ApiOperation> getApiOperationSettings;
        private final PagedCallSettings.Builder<ListApiOperationsRequest, ListApiOperationsResponse, ApiHubClient.ListApiOperationsPagedResponse> listApiOperationsSettings;
        private final UnaryCallSettings.Builder<UpdateApiOperationRequest, ApiOperation> updateApiOperationSettings;
        private final UnaryCallSettings.Builder<DeleteApiOperationRequest, Empty> deleteApiOperationSettings;
        private final UnaryCallSettings.Builder<GetDefinitionRequest, Definition> getDefinitionSettings;
        private final UnaryCallSettings.Builder<CreateDeploymentRequest, Deployment> createDeploymentSettings;
        private final UnaryCallSettings.Builder<GetDeploymentRequest, Deployment> getDeploymentSettings;
        private final PagedCallSettings.Builder<ListDeploymentsRequest, ListDeploymentsResponse, ApiHubClient.ListDeploymentsPagedResponse> listDeploymentsSettings;
        private final UnaryCallSettings.Builder<UpdateDeploymentRequest, Deployment> updateDeploymentSettings;
        private final UnaryCallSettings.Builder<DeleteDeploymentRequest, Empty> deleteDeploymentSettings;
        private final UnaryCallSettings.Builder<CreateAttributeRequest, Attribute> createAttributeSettings;
        private final UnaryCallSettings.Builder<GetAttributeRequest, Attribute> getAttributeSettings;
        private final UnaryCallSettings.Builder<UpdateAttributeRequest, Attribute> updateAttributeSettings;
        private final UnaryCallSettings.Builder<DeleteAttributeRequest, Empty> deleteAttributeSettings;
        private final PagedCallSettings.Builder<ListAttributesRequest, ListAttributesResponse, ApiHubClient.ListAttributesPagedResponse> listAttributesSettings;
        private final PagedCallSettings.Builder<SearchResourcesRequest, SearchResourcesResponse, ApiHubClient.SearchResourcesPagedResponse> searchResourcesSettings;
        private final UnaryCallSettings.Builder<CreateExternalApiRequest, ExternalApi> createExternalApiSettings;
        private final UnaryCallSettings.Builder<GetExternalApiRequest, ExternalApi> getExternalApiSettings;
        private final UnaryCallSettings.Builder<UpdateExternalApiRequest, ExternalApi> updateExternalApiSettings;
        private final UnaryCallSettings.Builder<DeleteExternalApiRequest, Empty> deleteExternalApiSettings;
        private final PagedCallSettings.Builder<ListExternalApisRequest, ListExternalApisResponse, ApiHubClient.ListExternalApisPagedResponse> listExternalApisSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ApiHubClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createApiSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getApiSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listApisSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_APIS_PAGE_STR_FACT);
            this.updateApiSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteApiSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listVersionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_VERSIONS_PAGE_STR_FACT);
            this.updateVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createSpecSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSpecSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSpecContentsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSpecsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SPECS_PAGE_STR_FACT);
            this.updateSpecSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSpecSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createApiOperationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getApiOperationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listApiOperationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_API_OPERATIONS_PAGE_STR_FACT);
            this.updateApiOperationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteApiOperationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getDefinitionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDeploymentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DEPLOYMENTS_PAGE_STR_FACT);
            this.updateDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAttributeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getAttributeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateAttributeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteAttributeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listAttributesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ATTRIBUTES_PAGE_STR_FACT);
            this.searchResourcesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)SEARCH_RESOURCES_PAGE_STR_FACT);
            this.createExternalApiSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getExternalApiSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateExternalApiSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteExternalApiSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listExternalApisSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_EXTERNAL_APIS_PAGE_STR_FACT);
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createApiSettings, this.getApiSettings, this.listApisSettings, this.updateApiSettings, this.deleteApiSettings, this.createVersionSettings, this.getVersionSettings, this.listVersionsSettings, this.updateVersionSettings, this.deleteVersionSettings, this.createSpecSettings, this.getSpecSettings, (Object[])new UnaryCallSettings.Builder[]{this.getSpecContentsSettings, this.listSpecsSettings, this.updateSpecSettings, this.deleteSpecSettings, this.createApiOperationSettings, this.getApiOperationSettings, this.listApiOperationsSettings, this.updateApiOperationSettings, this.deleteApiOperationSettings, this.getDefinitionSettings, this.createDeploymentSettings, this.getDeploymentSettings, this.listDeploymentsSettings, this.updateDeploymentSettings, this.deleteDeploymentSettings, this.createAttributeSettings, this.getAttributeSettings, this.updateAttributeSettings, this.deleteAttributeSettings, this.listAttributesSettings, this.searchResourcesSettings, this.createExternalApiSettings, this.getExternalApiSettings, this.updateExternalApiSettings, this.deleteExternalApiSettings, this.listExternalApisSettings, this.listLocationsSettings, this.getLocationSettings});
            Builder.initDefaults(this);
        }

        protected Builder(ApiHubStubSettings settings) {
            super((StubSettings)settings);
            this.createApiSettings = settings.createApiSettings.toBuilder();
            this.getApiSettings = settings.getApiSettings.toBuilder();
            this.listApisSettings = settings.listApisSettings.toBuilder();
            this.updateApiSettings = settings.updateApiSettings.toBuilder();
            this.deleteApiSettings = settings.deleteApiSettings.toBuilder();
            this.createVersionSettings = settings.createVersionSettings.toBuilder();
            this.getVersionSettings = settings.getVersionSettings.toBuilder();
            this.listVersionsSettings = settings.listVersionsSettings.toBuilder();
            this.updateVersionSettings = settings.updateVersionSettings.toBuilder();
            this.deleteVersionSettings = settings.deleteVersionSettings.toBuilder();
            this.createSpecSettings = settings.createSpecSettings.toBuilder();
            this.getSpecSettings = settings.getSpecSettings.toBuilder();
            this.getSpecContentsSettings = settings.getSpecContentsSettings.toBuilder();
            this.listSpecsSettings = settings.listSpecsSettings.toBuilder();
            this.updateSpecSettings = settings.updateSpecSettings.toBuilder();
            this.deleteSpecSettings = settings.deleteSpecSettings.toBuilder();
            this.createApiOperationSettings = settings.createApiOperationSettings.toBuilder();
            this.getApiOperationSettings = settings.getApiOperationSettings.toBuilder();
            this.listApiOperationsSettings = settings.listApiOperationsSettings.toBuilder();
            this.updateApiOperationSettings = settings.updateApiOperationSettings.toBuilder();
            this.deleteApiOperationSettings = settings.deleteApiOperationSettings.toBuilder();
            this.getDefinitionSettings = settings.getDefinitionSettings.toBuilder();
            this.createDeploymentSettings = settings.createDeploymentSettings.toBuilder();
            this.getDeploymentSettings = settings.getDeploymentSettings.toBuilder();
            this.listDeploymentsSettings = settings.listDeploymentsSettings.toBuilder();
            this.updateDeploymentSettings = settings.updateDeploymentSettings.toBuilder();
            this.deleteDeploymentSettings = settings.deleteDeploymentSettings.toBuilder();
            this.createAttributeSettings = settings.createAttributeSettings.toBuilder();
            this.getAttributeSettings = settings.getAttributeSettings.toBuilder();
            this.updateAttributeSettings = settings.updateAttributeSettings.toBuilder();
            this.deleteAttributeSettings = settings.deleteAttributeSettings.toBuilder();
            this.listAttributesSettings = settings.listAttributesSettings.toBuilder();
            this.searchResourcesSettings = settings.searchResourcesSettings.toBuilder();
            this.createExternalApiSettings = settings.createExternalApiSettings.toBuilder();
            this.getExternalApiSettings = settings.getExternalApiSettings.toBuilder();
            this.updateExternalApiSettings = settings.updateExternalApiSettings.toBuilder();
            this.deleteExternalApiSettings = settings.deleteExternalApiSettings.toBuilder();
            this.listExternalApisSettings = settings.listExternalApisSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createApiSettings, this.getApiSettings, this.listApisSettings, this.updateApiSettings, this.deleteApiSettings, this.createVersionSettings, this.getVersionSettings, this.listVersionsSettings, this.updateVersionSettings, this.deleteVersionSettings, this.createSpecSettings, this.getSpecSettings, (Object[])new UnaryCallSettings.Builder[]{this.getSpecContentsSettings, this.listSpecsSettings, this.updateSpecSettings, this.deleteSpecSettings, this.createApiOperationSettings, this.getApiOperationSettings, this.listApiOperationsSettings, this.updateApiOperationSettings, this.deleteApiOperationSettings, this.getDefinitionSettings, this.createDeploymentSettings, this.getDeploymentSettings, this.listDeploymentsSettings, this.updateDeploymentSettings, this.deleteDeploymentSettings, this.createAttributeSettings, this.getAttributeSettings, this.updateAttributeSettings, this.deleteAttributeSettings, this.listAttributesSettings, this.searchResourcesSettings, this.createExternalApiSettings, this.getExternalApiSettings, this.updateExternalApiSettings, this.deleteExternalApiSettings, this.listExternalApisSettings, this.listLocationsSettings, this.getLocationSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ApiHubStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ApiHubStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ApiHubStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ApiHubStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createApiSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getApiSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listApisSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateApiSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteApiSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.createVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listVersionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.createSpecSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSpecSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getSpecContentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listSpecsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateSpecSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteSpecSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.createApiOperationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getApiOperationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listApiOperationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateApiOperationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteApiOperationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getDefinitionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listDeploymentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createAttributeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getAttributeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateAttributeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteAttributeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listAttributesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.searchResourcesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createExternalApiSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getExternalApiSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateExternalApiSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteExternalApiSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listExternalApisSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateApiRequest, Api> createApiSettings() {
            return this.createApiSettings;
        }

        public UnaryCallSettings.Builder<GetApiRequest, Api> getApiSettings() {
            return this.getApiSettings;
        }

        public PagedCallSettings.Builder<ListApisRequest, ListApisResponse, ApiHubClient.ListApisPagedResponse> listApisSettings() {
            return this.listApisSettings;
        }

        public UnaryCallSettings.Builder<UpdateApiRequest, Api> updateApiSettings() {
            return this.updateApiSettings;
        }

        public UnaryCallSettings.Builder<DeleteApiRequest, Empty> deleteApiSettings() {
            return this.deleteApiSettings;
        }

        public UnaryCallSettings.Builder<CreateVersionRequest, Version> createVersionSettings() {
            return this.createVersionSettings;
        }

        public UnaryCallSettings.Builder<GetVersionRequest, Version> getVersionSettings() {
            return this.getVersionSettings;
        }

        public PagedCallSettings.Builder<ListVersionsRequest, ListVersionsResponse, ApiHubClient.ListVersionsPagedResponse> listVersionsSettings() {
            return this.listVersionsSettings;
        }

        public UnaryCallSettings.Builder<UpdateVersionRequest, Version> updateVersionSettings() {
            return this.updateVersionSettings;
        }

        public UnaryCallSettings.Builder<DeleteVersionRequest, Empty> deleteVersionSettings() {
            return this.deleteVersionSettings;
        }

        public UnaryCallSettings.Builder<CreateSpecRequest, Spec> createSpecSettings() {
            return this.createSpecSettings;
        }

        public UnaryCallSettings.Builder<GetSpecRequest, Spec> getSpecSettings() {
            return this.getSpecSettings;
        }

        public UnaryCallSettings.Builder<GetSpecContentsRequest, SpecContents> getSpecContentsSettings() {
            return this.getSpecContentsSettings;
        }

        public PagedCallSettings.Builder<ListSpecsRequest, ListSpecsResponse, ApiHubClient.ListSpecsPagedResponse> listSpecsSettings() {
            return this.listSpecsSettings;
        }

        public UnaryCallSettings.Builder<UpdateSpecRequest, Spec> updateSpecSettings() {
            return this.updateSpecSettings;
        }

        public UnaryCallSettings.Builder<DeleteSpecRequest, Empty> deleteSpecSettings() {
            return this.deleteSpecSettings;
        }

        public UnaryCallSettings.Builder<CreateApiOperationRequest, ApiOperation> createApiOperationSettings() {
            return this.createApiOperationSettings;
        }

        public UnaryCallSettings.Builder<GetApiOperationRequest, ApiOperation> getApiOperationSettings() {
            return this.getApiOperationSettings;
        }

        public PagedCallSettings.Builder<ListApiOperationsRequest, ListApiOperationsResponse, ApiHubClient.ListApiOperationsPagedResponse> listApiOperationsSettings() {
            return this.listApiOperationsSettings;
        }

        public UnaryCallSettings.Builder<UpdateApiOperationRequest, ApiOperation> updateApiOperationSettings() {
            return this.updateApiOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteApiOperationRequest, Empty> deleteApiOperationSettings() {
            return this.deleteApiOperationSettings;
        }

        public UnaryCallSettings.Builder<GetDefinitionRequest, Definition> getDefinitionSettings() {
            return this.getDefinitionSettings;
        }

        public UnaryCallSettings.Builder<CreateDeploymentRequest, Deployment> createDeploymentSettings() {
            return this.createDeploymentSettings;
        }

        public UnaryCallSettings.Builder<GetDeploymentRequest, Deployment> getDeploymentSettings() {
            return this.getDeploymentSettings;
        }

        public PagedCallSettings.Builder<ListDeploymentsRequest, ListDeploymentsResponse, ApiHubClient.ListDeploymentsPagedResponse> listDeploymentsSettings() {
            return this.listDeploymentsSettings;
        }

        public UnaryCallSettings.Builder<UpdateDeploymentRequest, Deployment> updateDeploymentSettings() {
            return this.updateDeploymentSettings;
        }

        public UnaryCallSettings.Builder<DeleteDeploymentRequest, Empty> deleteDeploymentSettings() {
            return this.deleteDeploymentSettings;
        }

        public UnaryCallSettings.Builder<CreateAttributeRequest, Attribute> createAttributeSettings() {
            return this.createAttributeSettings;
        }

        public UnaryCallSettings.Builder<GetAttributeRequest, Attribute> getAttributeSettings() {
            return this.getAttributeSettings;
        }

        public UnaryCallSettings.Builder<UpdateAttributeRequest, Attribute> updateAttributeSettings() {
            return this.updateAttributeSettings;
        }

        public UnaryCallSettings.Builder<DeleteAttributeRequest, Empty> deleteAttributeSettings() {
            return this.deleteAttributeSettings;
        }

        public PagedCallSettings.Builder<ListAttributesRequest, ListAttributesResponse, ApiHubClient.ListAttributesPagedResponse> listAttributesSettings() {
            return this.listAttributesSettings;
        }

        public PagedCallSettings.Builder<SearchResourcesRequest, SearchResourcesResponse, ApiHubClient.SearchResourcesPagedResponse> searchResourcesSettings() {
            return this.searchResourcesSettings;
        }

        public UnaryCallSettings.Builder<CreateExternalApiRequest, ExternalApi> createExternalApiSettings() {
            return this.createExternalApiSettings;
        }

        public UnaryCallSettings.Builder<GetExternalApiRequest, ExternalApi> getExternalApiSettings() {
            return this.getExternalApiSettings;
        }

        public UnaryCallSettings.Builder<UpdateExternalApiRequest, ExternalApi> updateExternalApiSettings() {
            return this.updateExternalApiSettings;
        }

        public UnaryCallSettings.Builder<DeleteExternalApiRequest, Empty> deleteExternalApiSettings() {
            return this.deleteExternalApiSettings;
        }

        public PagedCallSettings.Builder<ListExternalApisRequest, ListExternalApisResponse, ApiHubClient.ListExternalApisPagedResponse> listExternalApisSettings() {
            return this.listExternalApisSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ApiHubClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public ApiHubStubSettings build() throws IOException {
            return new ApiHubStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_2_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(300000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(300000L)).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build();
            definitions.put((Object)"no_retry_2_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

