/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apihub.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.OperationsClient;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.apihub.v1.ApiData;
import com.google.cloud.apihub.v1.ApiHubCollectSettings;
import com.google.cloud.apihub.v1.CollectApiDataRequest;
import com.google.cloud.apihub.v1.CollectApiDataResponse;
import com.google.cloud.apihub.v1.CollectionType;
import com.google.cloud.apihub.v1.LocationName;
import com.google.cloud.apihub.v1.OperationMetadata;
import com.google.cloud.apihub.v1.stub.ApiHubCollectStub;
import com.google.cloud.apihub.v1.stub.ApiHubCollectStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ApiHubCollectClient
implements BackgroundResource {
    private final ApiHubCollectSettings settings;
    private final ApiHubCollectStub stub;
    private final OperationsClient httpJsonOperationsClient;

    public static final ApiHubCollectClient create() throws IOException {
        return ApiHubCollectClient.create(ApiHubCollectSettings.newBuilder().build());
    }

    public static final ApiHubCollectClient create(ApiHubCollectSettings settings) throws IOException {
        return new ApiHubCollectClient(settings);
    }

    public static final ApiHubCollectClient create(ApiHubCollectStub stub) {
        return new ApiHubCollectClient(stub);
    }

    protected ApiHubCollectClient(ApiHubCollectSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ApiHubCollectStubSettings)settings.getStubSettings()).createStub();
        this.httpJsonOperationsClient = OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected ApiHubCollectClient(ApiHubCollectStub stub) {
        this.settings = null;
        this.stub = stub;
        this.httpJsonOperationsClient = OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final ApiHubCollectSettings getSettings() {
        return this.settings;
    }

    public ApiHubCollectStub getStub() {
        return this.stub;
    }

    public final OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<CollectApiDataResponse, OperationMetadata> collectApiDataAsync(LocationName location, CollectionType collectionType, ApiData apiData) {
        CollectApiDataRequest request = CollectApiDataRequest.newBuilder().setLocation(location == null ? null : location.toString()).setCollectionType(collectionType).setApiData(apiData).build();
        return this.collectApiDataAsync(request);
    }

    public final OperationFuture<CollectApiDataResponse, OperationMetadata> collectApiDataAsync(String location, CollectionType collectionType, ApiData apiData) {
        CollectApiDataRequest request = CollectApiDataRequest.newBuilder().setLocation(location).setCollectionType(collectionType).setApiData(apiData).build();
        return this.collectApiDataAsync(request);
    }

    public final OperationFuture<CollectApiDataResponse, OperationMetadata> collectApiDataAsync(CollectApiDataRequest request) {
        return this.collectApiDataOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CollectApiDataRequest, CollectApiDataResponse, OperationMetadata> collectApiDataOperationCallable() {
        return this.stub.collectApiDataOperationCallable();
    }

    public final UnaryCallable<CollectApiDataRequest, Operation> collectApiDataCallable() {
        return this.stub.collectApiDataCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

