/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apihub.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.apihub.v1.CreateRuntimeProjectAttachmentRequest;
import com.google.cloud.apihub.v1.DeleteRuntimeProjectAttachmentRequest;
import com.google.cloud.apihub.v1.GetRuntimeProjectAttachmentRequest;
import com.google.cloud.apihub.v1.ListRuntimeProjectAttachmentsRequest;
import com.google.cloud.apihub.v1.ListRuntimeProjectAttachmentsResponse;
import com.google.cloud.apihub.v1.LookupRuntimeProjectAttachmentRequest;
import com.google.cloud.apihub.v1.LookupRuntimeProjectAttachmentResponse;
import com.google.cloud.apihub.v1.RuntimeProjectAttachment;
import com.google.cloud.apihub.v1.RuntimeProjectAttachmentServiceClient;
import com.google.cloud.apihub.v1.stub.GrpcRuntimeProjectAttachmentServiceStub;
import com.google.cloud.apihub.v1.stub.HttpJsonRuntimeProjectAttachmentServiceStub;
import com.google.cloud.apihub.v1.stub.RuntimeProjectAttachmentServiceStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class RuntimeProjectAttachmentServiceStubSettings
extends StubSettings<RuntimeProjectAttachmentServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateRuntimeProjectAttachmentRequest, RuntimeProjectAttachment> createRuntimeProjectAttachmentSettings;
    private final UnaryCallSettings<GetRuntimeProjectAttachmentRequest, RuntimeProjectAttachment> getRuntimeProjectAttachmentSettings;
    private final PagedCallSettings<ListRuntimeProjectAttachmentsRequest, ListRuntimeProjectAttachmentsResponse, RuntimeProjectAttachmentServiceClient.ListRuntimeProjectAttachmentsPagedResponse> listRuntimeProjectAttachmentsSettings;
    private final UnaryCallSettings<DeleteRuntimeProjectAttachmentRequest, Empty> deleteRuntimeProjectAttachmentSettings;
    private final UnaryCallSettings<LookupRuntimeProjectAttachmentRequest, LookupRuntimeProjectAttachmentResponse> lookupRuntimeProjectAttachmentSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, RuntimeProjectAttachmentServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListRuntimeProjectAttachmentsRequest, ListRuntimeProjectAttachmentsResponse, RuntimeProjectAttachment> LIST_RUNTIME_PROJECT_ATTACHMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListRuntimeProjectAttachmentsRequest, ListRuntimeProjectAttachmentsResponse, RuntimeProjectAttachment>(){

        public String emptyToken() {
            return "";
        }

        public ListRuntimeProjectAttachmentsRequest injectToken(ListRuntimeProjectAttachmentsRequest payload, String token) {
            return ListRuntimeProjectAttachmentsRequest.newBuilder((ListRuntimeProjectAttachmentsRequest)payload).setPageToken(token).build();
        }

        public ListRuntimeProjectAttachmentsRequest injectPageSize(ListRuntimeProjectAttachmentsRequest payload, int pageSize) {
            return ListRuntimeProjectAttachmentsRequest.newBuilder((ListRuntimeProjectAttachmentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListRuntimeProjectAttachmentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListRuntimeProjectAttachmentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<RuntimeProjectAttachment> extractResources(ListRuntimeProjectAttachmentsResponse payload) {
            return payload.getRuntimeProjectAttachmentsList() == null ? ImmutableList.of() : payload.getRuntimeProjectAttachmentsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListRuntimeProjectAttachmentsRequest, ListRuntimeProjectAttachmentsResponse, RuntimeProjectAttachmentServiceClient.ListRuntimeProjectAttachmentsPagedResponse> LIST_RUNTIME_PROJECT_ATTACHMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListRuntimeProjectAttachmentsRequest, ListRuntimeProjectAttachmentsResponse, RuntimeProjectAttachmentServiceClient.ListRuntimeProjectAttachmentsPagedResponse>(){

        public ApiFuture<RuntimeProjectAttachmentServiceClient.ListRuntimeProjectAttachmentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListRuntimeProjectAttachmentsRequest, ListRuntimeProjectAttachmentsResponse> callable, ListRuntimeProjectAttachmentsRequest request, ApiCallContext context, ApiFuture<ListRuntimeProjectAttachmentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_RUNTIME_PROJECT_ATTACHMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RuntimeProjectAttachmentServiceClient.ListRuntimeProjectAttachmentsPagedResponse.createAsync((PageContext<ListRuntimeProjectAttachmentsRequest, ListRuntimeProjectAttachmentsResponse, RuntimeProjectAttachment>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, RuntimeProjectAttachmentServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, RuntimeProjectAttachmentServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<RuntimeProjectAttachmentServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RuntimeProjectAttachmentServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateRuntimeProjectAttachmentRequest, RuntimeProjectAttachment> createRuntimeProjectAttachmentSettings() {
        return this.createRuntimeProjectAttachmentSettings;
    }

    public UnaryCallSettings<GetRuntimeProjectAttachmentRequest, RuntimeProjectAttachment> getRuntimeProjectAttachmentSettings() {
        return this.getRuntimeProjectAttachmentSettings;
    }

    public PagedCallSettings<ListRuntimeProjectAttachmentsRequest, ListRuntimeProjectAttachmentsResponse, RuntimeProjectAttachmentServiceClient.ListRuntimeProjectAttachmentsPagedResponse> listRuntimeProjectAttachmentsSettings() {
        return this.listRuntimeProjectAttachmentsSettings;
    }

    public UnaryCallSettings<DeleteRuntimeProjectAttachmentRequest, Empty> deleteRuntimeProjectAttachmentSettings() {
        return this.deleteRuntimeProjectAttachmentSettings;
    }

    public UnaryCallSettings<LookupRuntimeProjectAttachmentRequest, LookupRuntimeProjectAttachmentResponse> lookupRuntimeProjectAttachmentSettings() {
        return this.lookupRuntimeProjectAttachmentSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, RuntimeProjectAttachmentServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public RuntimeProjectAttachmentServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcRuntimeProjectAttachmentServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRuntimeProjectAttachmentServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "apihub";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "apihub.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "apihub.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RuntimeProjectAttachmentServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RuntimeProjectAttachmentServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RuntimeProjectAttachmentServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return RuntimeProjectAttachmentServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RuntimeProjectAttachmentServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createRuntimeProjectAttachmentSettings = settingsBuilder.createRuntimeProjectAttachmentSettings().build();
        this.getRuntimeProjectAttachmentSettings = settingsBuilder.getRuntimeProjectAttachmentSettings().build();
        this.listRuntimeProjectAttachmentsSettings = settingsBuilder.listRuntimeProjectAttachmentsSettings().build();
        this.deleteRuntimeProjectAttachmentSettings = settingsBuilder.deleteRuntimeProjectAttachmentSettings().build();
        this.lookupRuntimeProjectAttachmentSettings = settingsBuilder.lookupRuntimeProjectAttachmentSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RuntimeProjectAttachmentServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateRuntimeProjectAttachmentRequest, RuntimeProjectAttachment> createRuntimeProjectAttachmentSettings;
        private final UnaryCallSettings.Builder<GetRuntimeProjectAttachmentRequest, RuntimeProjectAttachment> getRuntimeProjectAttachmentSettings;
        private final PagedCallSettings.Builder<ListRuntimeProjectAttachmentsRequest, ListRuntimeProjectAttachmentsResponse, RuntimeProjectAttachmentServiceClient.ListRuntimeProjectAttachmentsPagedResponse> listRuntimeProjectAttachmentsSettings;
        private final UnaryCallSettings.Builder<DeleteRuntimeProjectAttachmentRequest, Empty> deleteRuntimeProjectAttachmentSettings;
        private final UnaryCallSettings.Builder<LookupRuntimeProjectAttachmentRequest, LookupRuntimeProjectAttachmentResponse> lookupRuntimeProjectAttachmentSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, RuntimeProjectAttachmentServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createRuntimeProjectAttachmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getRuntimeProjectAttachmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRuntimeProjectAttachmentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_RUNTIME_PROJECT_ATTACHMENTS_PAGE_STR_FACT);
            this.deleteRuntimeProjectAttachmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.lookupRuntimeProjectAttachmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createRuntimeProjectAttachmentSettings, this.getRuntimeProjectAttachmentSettings, this.listRuntimeProjectAttachmentsSettings, this.deleteRuntimeProjectAttachmentSettings, this.lookupRuntimeProjectAttachmentSettings, this.listLocationsSettings, this.getLocationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(RuntimeProjectAttachmentServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createRuntimeProjectAttachmentSettings = settings.createRuntimeProjectAttachmentSettings.toBuilder();
            this.getRuntimeProjectAttachmentSettings = settings.getRuntimeProjectAttachmentSettings.toBuilder();
            this.listRuntimeProjectAttachmentsSettings = settings.listRuntimeProjectAttachmentsSettings.toBuilder();
            this.deleteRuntimeProjectAttachmentSettings = settings.deleteRuntimeProjectAttachmentSettings.toBuilder();
            this.lookupRuntimeProjectAttachmentSettings = settings.lookupRuntimeProjectAttachmentSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createRuntimeProjectAttachmentSettings, this.getRuntimeProjectAttachmentSettings, this.listRuntimeProjectAttachmentsSettings, this.deleteRuntimeProjectAttachmentSettings, this.lookupRuntimeProjectAttachmentSettings, this.listLocationsSettings, this.getLocationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RuntimeProjectAttachmentServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RuntimeProjectAttachmentServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RuntimeProjectAttachmentServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(RuntimeProjectAttachmentServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)RuntimeProjectAttachmentServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)RuntimeProjectAttachmentServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RuntimeProjectAttachmentServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(RuntimeProjectAttachmentServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createRuntimeProjectAttachmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getRuntimeProjectAttachmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listRuntimeProjectAttachmentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteRuntimeProjectAttachmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.lookupRuntimeProjectAttachmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateRuntimeProjectAttachmentRequest, RuntimeProjectAttachment> createRuntimeProjectAttachmentSettings() {
            return this.createRuntimeProjectAttachmentSettings;
        }

        public UnaryCallSettings.Builder<GetRuntimeProjectAttachmentRequest, RuntimeProjectAttachment> getRuntimeProjectAttachmentSettings() {
            return this.getRuntimeProjectAttachmentSettings;
        }

        public PagedCallSettings.Builder<ListRuntimeProjectAttachmentsRequest, ListRuntimeProjectAttachmentsResponse, RuntimeProjectAttachmentServiceClient.ListRuntimeProjectAttachmentsPagedResponse> listRuntimeProjectAttachmentsSettings() {
            return this.listRuntimeProjectAttachmentsSettings;
        }

        public UnaryCallSettings.Builder<DeleteRuntimeProjectAttachmentRequest, Empty> deleteRuntimeProjectAttachmentSettings() {
            return this.deleteRuntimeProjectAttachmentSettings;
        }

        public UnaryCallSettings.Builder<LookupRuntimeProjectAttachmentRequest, LookupRuntimeProjectAttachmentResponse> lookupRuntimeProjectAttachmentSettings() {
            return this.lookupRuntimeProjectAttachmentSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, RuntimeProjectAttachmentServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public RuntimeProjectAttachmentServiceStubSettings build() throws IOException {
            return new RuntimeProjectAttachmentServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

