/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apihub.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.apihub.v1.GetStyleGuideContentsRequest;
import com.google.cloud.apihub.v1.GetStyleGuideRequest;
import com.google.cloud.apihub.v1.LintSpecRequest;
import com.google.cloud.apihub.v1.LintingServiceSettings;
import com.google.cloud.apihub.v1.StyleGuide;
import com.google.cloud.apihub.v1.StyleGuideContents;
import com.google.cloud.apihub.v1.StyleGuideName;
import com.google.cloud.apihub.v1.UpdateStyleGuideRequest;
import com.google.cloud.apihub.v1.stub.LintingServiceStub;
import com.google.cloud.apihub.v1.stub.LintingServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class LintingServiceClient
implements BackgroundResource {
    private final LintingServiceSettings settings;
    private final LintingServiceStub stub;

    public static final LintingServiceClient create() throws IOException {
        return LintingServiceClient.create(LintingServiceSettings.newBuilder().build());
    }

    public static final LintingServiceClient create(LintingServiceSettings settings) throws IOException {
        return new LintingServiceClient(settings);
    }

    public static final LintingServiceClient create(LintingServiceStub stub) {
        return new LintingServiceClient(stub);
    }

    protected LintingServiceClient(LintingServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((LintingServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected LintingServiceClient(LintingServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final LintingServiceSettings getSettings() {
        return this.settings;
    }

    public LintingServiceStub getStub() {
        return this.stub;
    }

    public final StyleGuide getStyleGuide(StyleGuideName name) {
        GetStyleGuideRequest request = GetStyleGuideRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getStyleGuide(request);
    }

    public final StyleGuide getStyleGuide(String name) {
        GetStyleGuideRequest request = GetStyleGuideRequest.newBuilder().setName(name).build();
        return this.getStyleGuide(request);
    }

    public final StyleGuide getStyleGuide(GetStyleGuideRequest request) {
        return (StyleGuide)this.getStyleGuideCallable().call((Object)request);
    }

    public final UnaryCallable<GetStyleGuideRequest, StyleGuide> getStyleGuideCallable() {
        return this.stub.getStyleGuideCallable();
    }

    public final StyleGuide updateStyleGuide(StyleGuide styleGuide, FieldMask updateMask) {
        UpdateStyleGuideRequest request = UpdateStyleGuideRequest.newBuilder().setStyleGuide(styleGuide).setUpdateMask(updateMask).build();
        return this.updateStyleGuide(request);
    }

    public final StyleGuide updateStyleGuide(UpdateStyleGuideRequest request) {
        return (StyleGuide)this.updateStyleGuideCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateStyleGuideRequest, StyleGuide> updateStyleGuideCallable() {
        return this.stub.updateStyleGuideCallable();
    }

    public final StyleGuideContents getStyleGuideContents(StyleGuideName name) {
        GetStyleGuideContentsRequest request = GetStyleGuideContentsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getStyleGuideContents(request);
    }

    public final StyleGuideContents getStyleGuideContents(String name) {
        GetStyleGuideContentsRequest request = GetStyleGuideContentsRequest.newBuilder().setName(name).build();
        return this.getStyleGuideContents(request);
    }

    public final StyleGuideContents getStyleGuideContents(GetStyleGuideContentsRequest request) {
        return (StyleGuideContents)this.getStyleGuideContentsCallable().call((Object)request);
    }

    public final UnaryCallable<GetStyleGuideContentsRequest, StyleGuideContents> getStyleGuideContentsCallable() {
        return this.stub.getStyleGuideContentsCallable();
    }

    public final void lintSpec(LintSpecRequest request) {
        this.lintSpecCallable().call((Object)request);
    }

    public final UnaryCallable<LintSpecRequest, Empty> lintSpecCallable() {
        return this.stub.lintSpecCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

