/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apihub.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.apihub.v1.ApiHubDependenciesSettings;
import com.google.cloud.apihub.v1.CreateDependencyRequest;
import com.google.cloud.apihub.v1.DeleteDependencyRequest;
import com.google.cloud.apihub.v1.Dependency;
import com.google.cloud.apihub.v1.DependencyName;
import com.google.cloud.apihub.v1.GetDependencyRequest;
import com.google.cloud.apihub.v1.ListDependenciesRequest;
import com.google.cloud.apihub.v1.ListDependenciesResponse;
import com.google.cloud.apihub.v1.LocationName;
import com.google.cloud.apihub.v1.UpdateDependencyRequest;
import com.google.cloud.apihub.v1.stub.ApiHubDependenciesStub;
import com.google.cloud.apihub.v1.stub.ApiHubDependenciesStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ApiHubDependenciesClient
implements BackgroundResource {
    private final ApiHubDependenciesSettings settings;
    private final ApiHubDependenciesStub stub;

    public static final ApiHubDependenciesClient create() throws IOException {
        return ApiHubDependenciesClient.create(ApiHubDependenciesSettings.newBuilder().build());
    }

    public static final ApiHubDependenciesClient create(ApiHubDependenciesSettings settings) throws IOException {
        return new ApiHubDependenciesClient(settings);
    }

    public static final ApiHubDependenciesClient create(ApiHubDependenciesStub stub) {
        return new ApiHubDependenciesClient(stub);
    }

    protected ApiHubDependenciesClient(ApiHubDependenciesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ApiHubDependenciesStubSettings)settings.getStubSettings()).createStub();
    }

    protected ApiHubDependenciesClient(ApiHubDependenciesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ApiHubDependenciesSettings getSettings() {
        return this.settings;
    }

    public ApiHubDependenciesStub getStub() {
        return this.stub;
    }

    public final Dependency createDependency(LocationName parent, Dependency dependency, String dependencyId) {
        CreateDependencyRequest request = CreateDependencyRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDependency(dependency).setDependencyId(dependencyId).build();
        return this.createDependency(request);
    }

    public final Dependency createDependency(String parent, Dependency dependency, String dependencyId) {
        CreateDependencyRequest request = CreateDependencyRequest.newBuilder().setParent(parent).setDependency(dependency).setDependencyId(dependencyId).build();
        return this.createDependency(request);
    }

    public final Dependency createDependency(CreateDependencyRequest request) {
        return (Dependency)this.createDependencyCallable().call((Object)request);
    }

    public final UnaryCallable<CreateDependencyRequest, Dependency> createDependencyCallable() {
        return this.stub.createDependencyCallable();
    }

    public final Dependency getDependency(DependencyName name) {
        GetDependencyRequest request = GetDependencyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDependency(request);
    }

    public final Dependency getDependency(String name) {
        GetDependencyRequest request = GetDependencyRequest.newBuilder().setName(name).build();
        return this.getDependency(request);
    }

    public final Dependency getDependency(GetDependencyRequest request) {
        return (Dependency)this.getDependencyCallable().call((Object)request);
    }

    public final UnaryCallable<GetDependencyRequest, Dependency> getDependencyCallable() {
        return this.stub.getDependencyCallable();
    }

    public final Dependency updateDependency(Dependency dependency, FieldMask updateMask) {
        UpdateDependencyRequest request = UpdateDependencyRequest.newBuilder().setDependency(dependency).setUpdateMask(updateMask).build();
        return this.updateDependency(request);
    }

    public final Dependency updateDependency(UpdateDependencyRequest request) {
        return (Dependency)this.updateDependencyCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateDependencyRequest, Dependency> updateDependencyCallable() {
        return this.stub.updateDependencyCallable();
    }

    public final void deleteDependency(DependencyName name) {
        DeleteDependencyRequest request = DeleteDependencyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteDependency(request);
    }

    public final void deleteDependency(String name) {
        DeleteDependencyRequest request = DeleteDependencyRequest.newBuilder().setName(name).build();
        this.deleteDependency(request);
    }

    public final void deleteDependency(DeleteDependencyRequest request) {
        this.deleteDependencyCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteDependencyRequest, Empty> deleteDependencyCallable() {
        return this.stub.deleteDependencyCallable();
    }

    public final ListDependenciesPagedResponse listDependencies(LocationName parent) {
        ListDependenciesRequest request = ListDependenciesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDependencies(request);
    }

    public final ListDependenciesPagedResponse listDependencies(String parent) {
        ListDependenciesRequest request = ListDependenciesRequest.newBuilder().setParent(parent).build();
        return this.listDependencies(request);
    }

    public final ListDependenciesPagedResponse listDependencies(ListDependenciesRequest request) {
        return (ListDependenciesPagedResponse)((Object)this.listDependenciesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDependenciesRequest, ListDependenciesPagedResponse> listDependenciesPagedCallable() {
        return this.stub.listDependenciesPagedCallable();
    }

    public final UnaryCallable<ListDependenciesRequest, ListDependenciesResponse> listDependenciesCallable() {
        return this.stub.listDependenciesCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDependenciesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDependenciesRequest, ListDependenciesResponse, Dependency, ListDependenciesPage, ListDependenciesFixedSizeCollection> {
        private ListDependenciesFixedSizeCollection(List<ListDependenciesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDependenciesFixedSizeCollection createEmptyCollection() {
            return new ListDependenciesFixedSizeCollection(null, 0);
        }

        protected ListDependenciesFixedSizeCollection createCollection(List<ListDependenciesPage> pages, int collectionSize) {
            return new ListDependenciesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDependenciesPage
    extends AbstractPage<ListDependenciesRequest, ListDependenciesResponse, Dependency, ListDependenciesPage> {
        private ListDependenciesPage(PageContext<ListDependenciesRequest, ListDependenciesResponse, Dependency> context, ListDependenciesResponse response) {
            super(context, (Object)response);
        }

        private static ListDependenciesPage createEmptyPage() {
            return new ListDependenciesPage(null, null);
        }

        protected ListDependenciesPage createPage(PageContext<ListDependenciesRequest, ListDependenciesResponse, Dependency> context, ListDependenciesResponse response) {
            return new ListDependenciesPage(context, response);
        }

        public ApiFuture<ListDependenciesPage> createPageAsync(PageContext<ListDependenciesRequest, ListDependenciesResponse, Dependency> context, ApiFuture<ListDependenciesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDependenciesPagedResponse
    extends AbstractPagedListResponse<ListDependenciesRequest, ListDependenciesResponse, Dependency, ListDependenciesPage, ListDependenciesFixedSizeCollection> {
        public static ApiFuture<ListDependenciesPagedResponse> createAsync(PageContext<ListDependenciesRequest, ListDependenciesResponse, Dependency> context, ApiFuture<ListDependenciesResponse> futureResponse) {
            ApiFuture<ListDependenciesPage> futurePage = ListDependenciesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDependenciesPagedResponse((ListDependenciesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDependenciesPagedResponse(ListDependenciesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDependenciesFixedSizeCollection.createEmptyCollection());
        }
    }
}

