/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apihub.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.apihub.v1.CreateHostProjectRegistrationRequest;
import com.google.cloud.apihub.v1.GetHostProjectRegistrationRequest;
import com.google.cloud.apihub.v1.HostProjectRegistration;
import com.google.cloud.apihub.v1.HostProjectRegistrationServiceClient;
import com.google.cloud.apihub.v1.ListHostProjectRegistrationsRequest;
import com.google.cloud.apihub.v1.ListHostProjectRegistrationsResponse;
import com.google.cloud.apihub.v1.stub.GrpcHostProjectRegistrationServiceStub;
import com.google.cloud.apihub.v1.stub.HostProjectRegistrationServiceStub;
import com.google.cloud.apihub.v1.stub.HttpJsonHostProjectRegistrationServiceStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class HostProjectRegistrationServiceStubSettings
extends StubSettings<HostProjectRegistrationServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateHostProjectRegistrationRequest, HostProjectRegistration> createHostProjectRegistrationSettings;
    private final UnaryCallSettings<GetHostProjectRegistrationRequest, HostProjectRegistration> getHostProjectRegistrationSettings;
    private final PagedCallSettings<ListHostProjectRegistrationsRequest, ListHostProjectRegistrationsResponse, HostProjectRegistrationServiceClient.ListHostProjectRegistrationsPagedResponse> listHostProjectRegistrationsSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, HostProjectRegistrationServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListHostProjectRegistrationsRequest, ListHostProjectRegistrationsResponse, HostProjectRegistration> LIST_HOST_PROJECT_REGISTRATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListHostProjectRegistrationsRequest, ListHostProjectRegistrationsResponse, HostProjectRegistration>(){

        public String emptyToken() {
            return "";
        }

        public ListHostProjectRegistrationsRequest injectToken(ListHostProjectRegistrationsRequest payload, String token) {
            return ListHostProjectRegistrationsRequest.newBuilder((ListHostProjectRegistrationsRequest)payload).setPageToken(token).build();
        }

        public ListHostProjectRegistrationsRequest injectPageSize(ListHostProjectRegistrationsRequest payload, int pageSize) {
            return ListHostProjectRegistrationsRequest.newBuilder((ListHostProjectRegistrationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListHostProjectRegistrationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListHostProjectRegistrationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<HostProjectRegistration> extractResources(ListHostProjectRegistrationsResponse payload) {
            return payload.getHostProjectRegistrationsList() == null ? ImmutableList.of() : payload.getHostProjectRegistrationsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListHostProjectRegistrationsRequest, ListHostProjectRegistrationsResponse, HostProjectRegistrationServiceClient.ListHostProjectRegistrationsPagedResponse> LIST_HOST_PROJECT_REGISTRATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListHostProjectRegistrationsRequest, ListHostProjectRegistrationsResponse, HostProjectRegistrationServiceClient.ListHostProjectRegistrationsPagedResponse>(){

        public ApiFuture<HostProjectRegistrationServiceClient.ListHostProjectRegistrationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListHostProjectRegistrationsRequest, ListHostProjectRegistrationsResponse> callable, ListHostProjectRegistrationsRequest request, ApiCallContext context, ApiFuture<ListHostProjectRegistrationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_HOST_PROJECT_REGISTRATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return HostProjectRegistrationServiceClient.ListHostProjectRegistrationsPagedResponse.createAsync((PageContext<ListHostProjectRegistrationsRequest, ListHostProjectRegistrationsResponse, HostProjectRegistration>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, HostProjectRegistrationServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, HostProjectRegistrationServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<HostProjectRegistrationServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return HostProjectRegistrationServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateHostProjectRegistrationRequest, HostProjectRegistration> createHostProjectRegistrationSettings() {
        return this.createHostProjectRegistrationSettings;
    }

    public UnaryCallSettings<GetHostProjectRegistrationRequest, HostProjectRegistration> getHostProjectRegistrationSettings() {
        return this.getHostProjectRegistrationSettings;
    }

    public PagedCallSettings<ListHostProjectRegistrationsRequest, ListHostProjectRegistrationsResponse, HostProjectRegistrationServiceClient.ListHostProjectRegistrationsPagedResponse> listHostProjectRegistrationsSettings() {
        return this.listHostProjectRegistrationsSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, HostProjectRegistrationServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public HostProjectRegistrationServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcHostProjectRegistrationServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonHostProjectRegistrationServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "apihub";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "apihub.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "apihub.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return HostProjectRegistrationServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(HostProjectRegistrationServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(HostProjectRegistrationServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return HostProjectRegistrationServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected HostProjectRegistrationServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createHostProjectRegistrationSettings = settingsBuilder.createHostProjectRegistrationSettings().build();
        this.getHostProjectRegistrationSettings = settingsBuilder.getHostProjectRegistrationSettings().build();
        this.listHostProjectRegistrationsSettings = settingsBuilder.listHostProjectRegistrationsSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<HostProjectRegistrationServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateHostProjectRegistrationRequest, HostProjectRegistration> createHostProjectRegistrationSettings;
        private final UnaryCallSettings.Builder<GetHostProjectRegistrationRequest, HostProjectRegistration> getHostProjectRegistrationSettings;
        private final PagedCallSettings.Builder<ListHostProjectRegistrationsRequest, ListHostProjectRegistrationsResponse, HostProjectRegistrationServiceClient.ListHostProjectRegistrationsPagedResponse> listHostProjectRegistrationsSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, HostProjectRegistrationServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createHostProjectRegistrationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getHostProjectRegistrationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listHostProjectRegistrationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_HOST_PROJECT_REGISTRATIONS_PAGE_STR_FACT);
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createHostProjectRegistrationSettings, this.getHostProjectRegistrationSettings, this.listHostProjectRegistrationsSettings, this.listLocationsSettings, this.getLocationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(HostProjectRegistrationServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createHostProjectRegistrationSettings = settings.createHostProjectRegistrationSettings.toBuilder();
            this.getHostProjectRegistrationSettings = settings.getHostProjectRegistrationSettings.toBuilder();
            this.listHostProjectRegistrationsSettings = settings.listHostProjectRegistrationsSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createHostProjectRegistrationSettings, this.getHostProjectRegistrationSettings, this.listHostProjectRegistrationsSettings, this.listLocationsSettings, this.getLocationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(HostProjectRegistrationServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)HostProjectRegistrationServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)HostProjectRegistrationServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(HostProjectRegistrationServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)HostProjectRegistrationServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)HostProjectRegistrationServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)HostProjectRegistrationServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(HostProjectRegistrationServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createHostProjectRegistrationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getHostProjectRegistrationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listHostProjectRegistrationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateHostProjectRegistrationRequest, HostProjectRegistration> createHostProjectRegistrationSettings() {
            return this.createHostProjectRegistrationSettings;
        }

        public UnaryCallSettings.Builder<GetHostProjectRegistrationRequest, HostProjectRegistration> getHostProjectRegistrationSettings() {
            return this.getHostProjectRegistrationSettings;
        }

        public PagedCallSettings.Builder<ListHostProjectRegistrationsRequest, ListHostProjectRegistrationsResponse, HostProjectRegistrationServiceClient.ListHostProjectRegistrationsPagedResponse> listHostProjectRegistrationsSettings() {
            return this.listHostProjectRegistrationsSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, HostProjectRegistrationServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public HostProjectRegistrationServiceStubSettings build() throws IOException {
            return new HostProjectRegistrationServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

