/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apihub.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.apihub.v1.ApiHubDependenciesClient;
import com.google.cloud.apihub.v1.CreateDependencyRequest;
import com.google.cloud.apihub.v1.DeleteDependencyRequest;
import com.google.cloud.apihub.v1.Dependency;
import com.google.cloud.apihub.v1.GetDependencyRequest;
import com.google.cloud.apihub.v1.ListDependenciesRequest;
import com.google.cloud.apihub.v1.ListDependenciesResponse;
import com.google.cloud.apihub.v1.UpdateDependencyRequest;
import com.google.cloud.apihub.v1.stub.ApiHubDependenciesStub;
import com.google.cloud.apihub.v1.stub.ApiHubDependenciesStubSettings;
import com.google.cloud.apihub.v1.stub.GrpcApiHubDependenciesCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcApiHubDependenciesStub
extends ApiHubDependenciesStub {
    private static final MethodDescriptor<CreateDependencyRequest, Dependency> createDependencyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.apihub.v1.ApiHubDependencies/CreateDependency").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateDependencyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Dependency.getDefaultInstance())).build();
    private static final MethodDescriptor<GetDependencyRequest, Dependency> getDependencyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.apihub.v1.ApiHubDependencies/GetDependency").setRequestMarshaller(ProtoUtils.marshaller((Message)GetDependencyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Dependency.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateDependencyRequest, Dependency> updateDependencyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.apihub.v1.ApiHubDependencies/UpdateDependency").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateDependencyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Dependency.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteDependencyRequest, Empty> deleteDependencyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.apihub.v1.ApiHubDependencies/DeleteDependency").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteDependencyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<ListDependenciesRequest, ListDependenciesResponse> listDependenciesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.apihub.v1.ApiHubDependencies/ListDependencies").setRequestMarshaller(ProtoUtils.marshaller((Message)ListDependenciesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListDependenciesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private final UnaryCallable<CreateDependencyRequest, Dependency> createDependencyCallable;
    private final UnaryCallable<GetDependencyRequest, Dependency> getDependencyCallable;
    private final UnaryCallable<UpdateDependencyRequest, Dependency> updateDependencyCallable;
    private final UnaryCallable<DeleteDependencyRequest, Empty> deleteDependencyCallable;
    private final UnaryCallable<ListDependenciesRequest, ListDependenciesResponse> listDependenciesCallable;
    private final UnaryCallable<ListDependenciesRequest, ApiHubDependenciesClient.ListDependenciesPagedResponse> listDependenciesPagedCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, ApiHubDependenciesClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcApiHubDependenciesStub create(ApiHubDependenciesStubSettings settings) throws IOException {
        return new GrpcApiHubDependenciesStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcApiHubDependenciesStub create(ClientContext clientContext) throws IOException {
        return new GrpcApiHubDependenciesStub(ApiHubDependenciesStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcApiHubDependenciesStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcApiHubDependenciesStub(ApiHubDependenciesStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcApiHubDependenciesStub(ApiHubDependenciesStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcApiHubDependenciesCallableFactory());
    }

    protected GrpcApiHubDependenciesStub(ApiHubDependenciesStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createDependencyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createDependencyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getDependencyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getDependencyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateDependencyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateDependencyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("dependency.name", String.valueOf(request.getDependency().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteDependencyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteDependencyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listDependenciesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listDependenciesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.createDependencyCallable = callableFactory.createUnaryCallable(createDependencyTransportSettings, settings.createDependencySettings(), clientContext);
        this.getDependencyCallable = callableFactory.createUnaryCallable(getDependencyTransportSettings, settings.getDependencySettings(), clientContext);
        this.updateDependencyCallable = callableFactory.createUnaryCallable(updateDependencyTransportSettings, settings.updateDependencySettings(), clientContext);
        this.deleteDependencyCallable = callableFactory.createUnaryCallable(deleteDependencyTransportSettings, settings.deleteDependencySettings(), clientContext);
        this.listDependenciesCallable = callableFactory.createUnaryCallable(listDependenciesTransportSettings, settings.listDependenciesSettings(), clientContext);
        this.listDependenciesPagedCallable = callableFactory.createPagedCallable(listDependenciesTransportSettings, settings.listDependenciesSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateDependencyRequest, Dependency> createDependencyCallable() {
        return this.createDependencyCallable;
    }

    @Override
    public UnaryCallable<GetDependencyRequest, Dependency> getDependencyCallable() {
        return this.getDependencyCallable;
    }

    @Override
    public UnaryCallable<UpdateDependencyRequest, Dependency> updateDependencyCallable() {
        return this.updateDependencyCallable;
    }

    @Override
    public UnaryCallable<DeleteDependencyRequest, Empty> deleteDependencyCallable() {
        return this.deleteDependencyCallable;
    }

    @Override
    public UnaryCallable<ListDependenciesRequest, ListDependenciesResponse> listDependenciesCallable() {
        return this.listDependenciesCallable;
    }

    @Override
    public UnaryCallable<ListDependenciesRequest, ApiHubDependenciesClient.ListDependenciesPagedResponse> listDependenciesPagedCallable() {
        return this.listDependenciesPagedCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ApiHubDependenciesClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

