/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apigeeconnect.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.apigeeconnect.v1.Connection;
import com.google.cloud.apigeeconnect.v1.ConnectionServiceClient;
import com.google.cloud.apigeeconnect.v1.ListConnectionsRequest;
import com.google.cloud.apigeeconnect.v1.ListConnectionsResponse;
import com.google.cloud.apigeeconnect.v1.stub.ConnectionServiceStub;
import com.google.cloud.apigeeconnect.v1.stub.GrpcConnectionServiceStub;
import com.google.cloud.apigeeconnect.v1.stub.HttpJsonConnectionServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ConnectionServiceStubSettings
extends StubSettings<ConnectionServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListConnectionsRequest, ListConnectionsResponse, ConnectionServiceClient.ListConnectionsPagedResponse> listConnectionsSettings;
    private static final PagedListDescriptor<ListConnectionsRequest, ListConnectionsResponse, Connection> LIST_CONNECTIONS_PAGE_STR_DESC = new PagedListDescriptor<ListConnectionsRequest, ListConnectionsResponse, Connection>(){

        public String emptyToken() {
            return "";
        }

        public ListConnectionsRequest injectToken(ListConnectionsRequest payload, String token) {
            return ListConnectionsRequest.newBuilder((ListConnectionsRequest)payload).setPageToken(token).build();
        }

        public ListConnectionsRequest injectPageSize(ListConnectionsRequest payload, int pageSize) {
            return ListConnectionsRequest.newBuilder((ListConnectionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListConnectionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListConnectionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Connection> extractResources(ListConnectionsResponse payload) {
            return payload.getConnectionsList();
        }
    };
    private static final PagedListResponseFactory<ListConnectionsRequest, ListConnectionsResponse, ConnectionServiceClient.ListConnectionsPagedResponse> LIST_CONNECTIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListConnectionsRequest, ListConnectionsResponse, ConnectionServiceClient.ListConnectionsPagedResponse>(){

        public ApiFuture<ConnectionServiceClient.ListConnectionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListConnectionsRequest, ListConnectionsResponse> callable, ListConnectionsRequest request, ApiCallContext context, ApiFuture<ListConnectionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CONNECTIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ConnectionServiceClient.ListConnectionsPagedResponse.createAsync((PageContext<ListConnectionsRequest, ListConnectionsResponse, Connection>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListConnectionsRequest, ListConnectionsResponse, ConnectionServiceClient.ListConnectionsPagedResponse> listConnectionsSettings() {
        return this.listConnectionsSettings;
    }

    public ConnectionServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcConnectionServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonConnectionServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "apigeeconnect";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "apigeeconnect.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "apigeeconnect.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ConnectionServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ConnectionServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ConnectionServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ConnectionServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ConnectionServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listConnectionsSettings = settingsBuilder.listConnectionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ConnectionServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListConnectionsRequest, ListConnectionsResponse, ConnectionServiceClient.ListConnectionsPagedResponse> listConnectionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listConnectionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CONNECTIONS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listConnectionsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ConnectionServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listConnectionsSettings = settings.listConnectionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listConnectionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ConnectionServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ConnectionServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ConnectionServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ConnectionServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)ConnectionServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)ConnectionServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ConnectionServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ConnectionServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listConnectionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListConnectionsRequest, ListConnectionsResponse, ConnectionServiceClient.ListConnectionsPagedResponse> listConnectionsSettings() {
            return this.listConnectionsSettings;
        }

        public ConnectionServiceStubSettings build() throws IOException {
            return new ConnectionServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.UNKNOWN})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

