/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apigeeconnect.v1;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.cloud.apigeeconnect.v1.EgressRequest;
import com.google.cloud.apigeeconnect.v1.EgressResponse;
import com.google.cloud.apigeeconnect.v1.TetherSettings;
import com.google.cloud.apigeeconnect.v1.stub.TetherStub;
import com.google.cloud.apigeeconnect.v1.stub.TetherStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class TetherClient
implements BackgroundResource {
    private final TetherSettings settings;
    private final TetherStub stub;

    public static final TetherClient create() throws IOException {
        return TetherClient.create(TetherSettings.newBuilder().build());
    }

    public static final TetherClient create(TetherSettings settings) throws IOException {
        return new TetherClient(settings);
    }

    public static final TetherClient create(TetherStub stub) {
        return new TetherClient(stub);
    }

    protected TetherClient(TetherSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TetherStubSettings)settings.getStubSettings()).createStub();
    }

    protected TetherClient(TetherStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final TetherSettings getSettings() {
        return this.settings;
    }

    public TetherStub getStub() {
        return this.stub;
    }

    public final BidiStreamingCallable<EgressResponse, EgressRequest> egressCallable() {
        return this.stub.egressCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

