/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apigateway.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.apigateway.v1.Api;
import com.google.cloud.apigateway.v1.ApiConfig;
import com.google.cloud.apigateway.v1.ApiGatewayServiceClient;
import com.google.cloud.apigateway.v1.CreateApiConfigRequest;
import com.google.cloud.apigateway.v1.CreateApiRequest;
import com.google.cloud.apigateway.v1.CreateGatewayRequest;
import com.google.cloud.apigateway.v1.DeleteApiConfigRequest;
import com.google.cloud.apigateway.v1.DeleteApiRequest;
import com.google.cloud.apigateway.v1.DeleteGatewayRequest;
import com.google.cloud.apigateway.v1.Gateway;
import com.google.cloud.apigateway.v1.GetApiConfigRequest;
import com.google.cloud.apigateway.v1.GetApiRequest;
import com.google.cloud.apigateway.v1.GetGatewayRequest;
import com.google.cloud.apigateway.v1.ListApiConfigsRequest;
import com.google.cloud.apigateway.v1.ListApiConfigsResponse;
import com.google.cloud.apigateway.v1.ListApisRequest;
import com.google.cloud.apigateway.v1.ListApisResponse;
import com.google.cloud.apigateway.v1.ListGatewaysRequest;
import com.google.cloud.apigateway.v1.ListGatewaysResponse;
import com.google.cloud.apigateway.v1.OperationMetadata;
import com.google.cloud.apigateway.v1.UpdateApiConfigRequest;
import com.google.cloud.apigateway.v1.UpdateApiRequest;
import com.google.cloud.apigateway.v1.UpdateGatewayRequest;
import com.google.cloud.apigateway.v1.stub.ApiGatewayServiceStub;
import com.google.cloud.apigateway.v1.stub.ApiGatewayServiceStubSettings;
import com.google.cloud.apigateway.v1.stub.GrpcApiGatewayServiceCallableFactory;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcApiGatewayServiceStub
extends ApiGatewayServiceStub {
    private static final MethodDescriptor<ListGatewaysRequest, ListGatewaysResponse> listGatewaysMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.apigateway.v1.ApiGatewayService/ListGateways").setRequestMarshaller(ProtoUtils.marshaller((Message)ListGatewaysRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListGatewaysResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetGatewayRequest, Gateway> getGatewayMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.apigateway.v1.ApiGatewayService/GetGateway").setRequestMarshaller(ProtoUtils.marshaller((Message)GetGatewayRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Gateway.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateGatewayRequest, Operation> createGatewayMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.apigateway.v1.ApiGatewayService/CreateGateway").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateGatewayRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateGatewayRequest, Operation> updateGatewayMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.apigateway.v1.ApiGatewayService/UpdateGateway").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateGatewayRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteGatewayRequest, Operation> deleteGatewayMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.apigateway.v1.ApiGatewayService/DeleteGateway").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteGatewayRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListApisRequest, ListApisResponse> listApisMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.apigateway.v1.ApiGatewayService/ListApis").setRequestMarshaller(ProtoUtils.marshaller((Message)ListApisRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListApisResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetApiRequest, Api> getApiMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.apigateway.v1.ApiGatewayService/GetApi").setRequestMarshaller(ProtoUtils.marshaller((Message)GetApiRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Api.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateApiRequest, Operation> createApiMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.apigateway.v1.ApiGatewayService/CreateApi").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateApiRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateApiRequest, Operation> updateApiMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.apigateway.v1.ApiGatewayService/UpdateApi").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateApiRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteApiRequest, Operation> deleteApiMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.apigateway.v1.ApiGatewayService/DeleteApi").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteApiRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListApiConfigsRequest, ListApiConfigsResponse> listApiConfigsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.apigateway.v1.ApiGatewayService/ListApiConfigs").setRequestMarshaller(ProtoUtils.marshaller((Message)ListApiConfigsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListApiConfigsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetApiConfigRequest, ApiConfig> getApiConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.apigateway.v1.ApiGatewayService/GetApiConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)GetApiConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ApiConfig.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateApiConfigRequest, Operation> createApiConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.apigateway.v1.ApiGatewayService/CreateApiConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateApiConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateApiConfigRequest, Operation> updateApiConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.apigateway.v1.ApiGatewayService/UpdateApiConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateApiConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteApiConfigRequest, Operation> deleteApiConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.apigateway.v1.ApiGatewayService/DeleteApiConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteApiConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<ListGatewaysRequest, ListGatewaysResponse> listGatewaysCallable;
    private final UnaryCallable<ListGatewaysRequest, ApiGatewayServiceClient.ListGatewaysPagedResponse> listGatewaysPagedCallable;
    private final UnaryCallable<GetGatewayRequest, Gateway> getGatewayCallable;
    private final UnaryCallable<CreateGatewayRequest, Operation> createGatewayCallable;
    private final OperationCallable<CreateGatewayRequest, Gateway, OperationMetadata> createGatewayOperationCallable;
    private final UnaryCallable<UpdateGatewayRequest, Operation> updateGatewayCallable;
    private final OperationCallable<UpdateGatewayRequest, Gateway, OperationMetadata> updateGatewayOperationCallable;
    private final UnaryCallable<DeleteGatewayRequest, Operation> deleteGatewayCallable;
    private final OperationCallable<DeleteGatewayRequest, Empty, OperationMetadata> deleteGatewayOperationCallable;
    private final UnaryCallable<ListApisRequest, ListApisResponse> listApisCallable;
    private final UnaryCallable<ListApisRequest, ApiGatewayServiceClient.ListApisPagedResponse> listApisPagedCallable;
    private final UnaryCallable<GetApiRequest, Api> getApiCallable;
    private final UnaryCallable<CreateApiRequest, Operation> createApiCallable;
    private final OperationCallable<CreateApiRequest, Api, OperationMetadata> createApiOperationCallable;
    private final UnaryCallable<UpdateApiRequest, Operation> updateApiCallable;
    private final OperationCallable<UpdateApiRequest, Api, OperationMetadata> updateApiOperationCallable;
    private final UnaryCallable<DeleteApiRequest, Operation> deleteApiCallable;
    private final OperationCallable<DeleteApiRequest, Empty, OperationMetadata> deleteApiOperationCallable;
    private final UnaryCallable<ListApiConfigsRequest, ListApiConfigsResponse> listApiConfigsCallable;
    private final UnaryCallable<ListApiConfigsRequest, ApiGatewayServiceClient.ListApiConfigsPagedResponse> listApiConfigsPagedCallable;
    private final UnaryCallable<GetApiConfigRequest, ApiConfig> getApiConfigCallable;
    private final UnaryCallable<CreateApiConfigRequest, Operation> createApiConfigCallable;
    private final OperationCallable<CreateApiConfigRequest, ApiConfig, OperationMetadata> createApiConfigOperationCallable;
    private final UnaryCallable<UpdateApiConfigRequest, Operation> updateApiConfigCallable;
    private final OperationCallable<UpdateApiConfigRequest, ApiConfig, OperationMetadata> updateApiConfigOperationCallable;
    private final UnaryCallable<DeleteApiConfigRequest, Operation> deleteApiConfigCallable;
    private final OperationCallable<DeleteApiConfigRequest, Empty, OperationMetadata> deleteApiConfigOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcApiGatewayServiceStub create(ApiGatewayServiceStubSettings settings) throws IOException {
        return new GrpcApiGatewayServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcApiGatewayServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcApiGatewayServiceStub(ApiGatewayServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcApiGatewayServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcApiGatewayServiceStub(ApiGatewayServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcApiGatewayServiceStub(ApiGatewayServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcApiGatewayServiceCallableFactory());
    }

    protected GrpcApiGatewayServiceStub(ApiGatewayServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listGatewaysTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listGatewaysMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getGatewayTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getGatewayMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createGatewayTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createGatewayMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateGatewayTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateGatewayMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("gateway.name", String.valueOf(request.getGateway().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteGatewayTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteGatewayMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listApisTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listApisMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getApiTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getApiMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createApiTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createApiMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateApiTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateApiMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("api.name", String.valueOf(request.getApi().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteApiTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteApiMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listApiConfigsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listApiConfigsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getApiConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getApiConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createApiConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createApiConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateApiConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateApiConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("api_config.name", String.valueOf(request.getApiConfig().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteApiConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteApiConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listGatewaysCallable = callableFactory.createUnaryCallable(listGatewaysTransportSettings, settings.listGatewaysSettings(), clientContext);
        this.listGatewaysPagedCallable = callableFactory.createPagedCallable(listGatewaysTransportSettings, settings.listGatewaysSettings(), clientContext);
        this.getGatewayCallable = callableFactory.createUnaryCallable(getGatewayTransportSettings, settings.getGatewaySettings(), clientContext);
        this.createGatewayCallable = callableFactory.createUnaryCallable(createGatewayTransportSettings, settings.createGatewaySettings(), clientContext);
        this.createGatewayOperationCallable = callableFactory.createOperationCallable(createGatewayTransportSettings, settings.createGatewayOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateGatewayCallable = callableFactory.createUnaryCallable(updateGatewayTransportSettings, settings.updateGatewaySettings(), clientContext);
        this.updateGatewayOperationCallable = callableFactory.createOperationCallable(updateGatewayTransportSettings, settings.updateGatewayOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteGatewayCallable = callableFactory.createUnaryCallable(deleteGatewayTransportSettings, settings.deleteGatewaySettings(), clientContext);
        this.deleteGatewayOperationCallable = callableFactory.createOperationCallable(deleteGatewayTransportSettings, settings.deleteGatewayOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listApisCallable = callableFactory.createUnaryCallable(listApisTransportSettings, settings.listApisSettings(), clientContext);
        this.listApisPagedCallable = callableFactory.createPagedCallable(listApisTransportSettings, settings.listApisSettings(), clientContext);
        this.getApiCallable = callableFactory.createUnaryCallable(getApiTransportSettings, settings.getApiSettings(), clientContext);
        this.createApiCallable = callableFactory.createUnaryCallable(createApiTransportSettings, settings.createApiSettings(), clientContext);
        this.createApiOperationCallable = callableFactory.createOperationCallable(createApiTransportSettings, settings.createApiOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateApiCallable = callableFactory.createUnaryCallable(updateApiTransportSettings, settings.updateApiSettings(), clientContext);
        this.updateApiOperationCallable = callableFactory.createOperationCallable(updateApiTransportSettings, settings.updateApiOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteApiCallable = callableFactory.createUnaryCallable(deleteApiTransportSettings, settings.deleteApiSettings(), clientContext);
        this.deleteApiOperationCallable = callableFactory.createOperationCallable(deleteApiTransportSettings, settings.deleteApiOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listApiConfigsCallable = callableFactory.createUnaryCallable(listApiConfigsTransportSettings, settings.listApiConfigsSettings(), clientContext);
        this.listApiConfigsPagedCallable = callableFactory.createPagedCallable(listApiConfigsTransportSettings, settings.listApiConfigsSettings(), clientContext);
        this.getApiConfigCallable = callableFactory.createUnaryCallable(getApiConfigTransportSettings, settings.getApiConfigSettings(), clientContext);
        this.createApiConfigCallable = callableFactory.createUnaryCallable(createApiConfigTransportSettings, settings.createApiConfigSettings(), clientContext);
        this.createApiConfigOperationCallable = callableFactory.createOperationCallable(createApiConfigTransportSettings, settings.createApiConfigOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateApiConfigCallable = callableFactory.createUnaryCallable(updateApiConfigTransportSettings, settings.updateApiConfigSettings(), clientContext);
        this.updateApiConfigOperationCallable = callableFactory.createOperationCallable(updateApiConfigTransportSettings, settings.updateApiConfigOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteApiConfigCallable = callableFactory.createUnaryCallable(deleteApiConfigTransportSettings, settings.deleteApiConfigSettings(), clientContext);
        this.deleteApiConfigOperationCallable = callableFactory.createOperationCallable(deleteApiConfigTransportSettings, settings.deleteApiConfigOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListGatewaysRequest, ListGatewaysResponse> listGatewaysCallable() {
        return this.listGatewaysCallable;
    }

    @Override
    public UnaryCallable<ListGatewaysRequest, ApiGatewayServiceClient.ListGatewaysPagedResponse> listGatewaysPagedCallable() {
        return this.listGatewaysPagedCallable;
    }

    @Override
    public UnaryCallable<GetGatewayRequest, Gateway> getGatewayCallable() {
        return this.getGatewayCallable;
    }

    @Override
    public UnaryCallable<CreateGatewayRequest, Operation> createGatewayCallable() {
        return this.createGatewayCallable;
    }

    @Override
    public OperationCallable<CreateGatewayRequest, Gateway, OperationMetadata> createGatewayOperationCallable() {
        return this.createGatewayOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateGatewayRequest, Operation> updateGatewayCallable() {
        return this.updateGatewayCallable;
    }

    @Override
    public OperationCallable<UpdateGatewayRequest, Gateway, OperationMetadata> updateGatewayOperationCallable() {
        return this.updateGatewayOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteGatewayRequest, Operation> deleteGatewayCallable() {
        return this.deleteGatewayCallable;
    }

    @Override
    public OperationCallable<DeleteGatewayRequest, Empty, OperationMetadata> deleteGatewayOperationCallable() {
        return this.deleteGatewayOperationCallable;
    }

    @Override
    public UnaryCallable<ListApisRequest, ListApisResponse> listApisCallable() {
        return this.listApisCallable;
    }

    @Override
    public UnaryCallable<ListApisRequest, ApiGatewayServiceClient.ListApisPagedResponse> listApisPagedCallable() {
        return this.listApisPagedCallable;
    }

    @Override
    public UnaryCallable<GetApiRequest, Api> getApiCallable() {
        return this.getApiCallable;
    }

    @Override
    public UnaryCallable<CreateApiRequest, Operation> createApiCallable() {
        return this.createApiCallable;
    }

    @Override
    public OperationCallable<CreateApiRequest, Api, OperationMetadata> createApiOperationCallable() {
        return this.createApiOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateApiRequest, Operation> updateApiCallable() {
        return this.updateApiCallable;
    }

    @Override
    public OperationCallable<UpdateApiRequest, Api, OperationMetadata> updateApiOperationCallable() {
        return this.updateApiOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteApiRequest, Operation> deleteApiCallable() {
        return this.deleteApiCallable;
    }

    @Override
    public OperationCallable<DeleteApiRequest, Empty, OperationMetadata> deleteApiOperationCallable() {
        return this.deleteApiOperationCallable;
    }

    @Override
    public UnaryCallable<ListApiConfigsRequest, ListApiConfigsResponse> listApiConfigsCallable() {
        return this.listApiConfigsCallable;
    }

    @Override
    public UnaryCallable<ListApiConfigsRequest, ApiGatewayServiceClient.ListApiConfigsPagedResponse> listApiConfigsPagedCallable() {
        return this.listApiConfigsPagedCallable;
    }

    @Override
    public UnaryCallable<GetApiConfigRequest, ApiConfig> getApiConfigCallable() {
        return this.getApiConfigCallable;
    }

    @Override
    public UnaryCallable<CreateApiConfigRequest, Operation> createApiConfigCallable() {
        return this.createApiConfigCallable;
    }

    @Override
    public OperationCallable<CreateApiConfigRequest, ApiConfig, OperationMetadata> createApiConfigOperationCallable() {
        return this.createApiConfigOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateApiConfigRequest, Operation> updateApiConfigCallable() {
        return this.updateApiConfigCallable;
    }

    @Override
    public OperationCallable<UpdateApiConfigRequest, ApiConfig, OperationMetadata> updateApiConfigOperationCallable() {
        return this.updateApiConfigOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteApiConfigRequest, Operation> deleteApiConfigCallable() {
        return this.deleteApiConfigCallable;
    }

    @Override
    public OperationCallable<DeleteApiConfigRequest, Empty, OperationMetadata> deleteApiConfigOperationCallable() {
        return this.deleteApiConfigOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

