/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apigateway.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.apigateway.v1.Api;
import com.google.cloud.apigateway.v1.ApiConfig;
import com.google.cloud.apigateway.v1.ApiGatewayServiceClient;
import com.google.cloud.apigateway.v1.CreateApiConfigRequest;
import com.google.cloud.apigateway.v1.CreateApiRequest;
import com.google.cloud.apigateway.v1.CreateGatewayRequest;
import com.google.cloud.apigateway.v1.DeleteApiConfigRequest;
import com.google.cloud.apigateway.v1.DeleteApiRequest;
import com.google.cloud.apigateway.v1.DeleteGatewayRequest;
import com.google.cloud.apigateway.v1.Gateway;
import com.google.cloud.apigateway.v1.GetApiConfigRequest;
import com.google.cloud.apigateway.v1.GetApiRequest;
import com.google.cloud.apigateway.v1.GetGatewayRequest;
import com.google.cloud.apigateway.v1.ListApiConfigsRequest;
import com.google.cloud.apigateway.v1.ListApiConfigsResponse;
import com.google.cloud.apigateway.v1.ListApisRequest;
import com.google.cloud.apigateway.v1.ListApisResponse;
import com.google.cloud.apigateway.v1.ListGatewaysRequest;
import com.google.cloud.apigateway.v1.ListGatewaysResponse;
import com.google.cloud.apigateway.v1.OperationMetadata;
import com.google.cloud.apigateway.v1.UpdateApiConfigRequest;
import com.google.cloud.apigateway.v1.UpdateApiRequest;
import com.google.cloud.apigateway.v1.UpdateGatewayRequest;
import com.google.cloud.apigateway.v1.stub.ApiGatewayServiceStub;
import com.google.cloud.apigateway.v1.stub.GrpcApiGatewayServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class ApiGatewayServiceStubSettings
extends StubSettings<ApiGatewayServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListGatewaysRequest, ListGatewaysResponse, ApiGatewayServiceClient.ListGatewaysPagedResponse> listGatewaysSettings;
    private final UnaryCallSettings<GetGatewayRequest, Gateway> getGatewaySettings;
    private final UnaryCallSettings<CreateGatewayRequest, Operation> createGatewaySettings;
    private final OperationCallSettings<CreateGatewayRequest, Gateway, OperationMetadata> createGatewayOperationSettings;
    private final UnaryCallSettings<UpdateGatewayRequest, Operation> updateGatewaySettings;
    private final OperationCallSettings<UpdateGatewayRequest, Gateway, OperationMetadata> updateGatewayOperationSettings;
    private final UnaryCallSettings<DeleteGatewayRequest, Operation> deleteGatewaySettings;
    private final OperationCallSettings<DeleteGatewayRequest, Empty, OperationMetadata> deleteGatewayOperationSettings;
    private final PagedCallSettings<ListApisRequest, ListApisResponse, ApiGatewayServiceClient.ListApisPagedResponse> listApisSettings;
    private final UnaryCallSettings<GetApiRequest, Api> getApiSettings;
    private final UnaryCallSettings<CreateApiRequest, Operation> createApiSettings;
    private final OperationCallSettings<CreateApiRequest, Api, OperationMetadata> createApiOperationSettings;
    private final UnaryCallSettings<UpdateApiRequest, Operation> updateApiSettings;
    private final OperationCallSettings<UpdateApiRequest, Api, OperationMetadata> updateApiOperationSettings;
    private final UnaryCallSettings<DeleteApiRequest, Operation> deleteApiSettings;
    private final OperationCallSettings<DeleteApiRequest, Empty, OperationMetadata> deleteApiOperationSettings;
    private final PagedCallSettings<ListApiConfigsRequest, ListApiConfigsResponse, ApiGatewayServiceClient.ListApiConfigsPagedResponse> listApiConfigsSettings;
    private final UnaryCallSettings<GetApiConfigRequest, ApiConfig> getApiConfigSettings;
    private final UnaryCallSettings<CreateApiConfigRequest, Operation> createApiConfigSettings;
    private final OperationCallSettings<CreateApiConfigRequest, ApiConfig, OperationMetadata> createApiConfigOperationSettings;
    private final UnaryCallSettings<UpdateApiConfigRequest, Operation> updateApiConfigSettings;
    private final OperationCallSettings<UpdateApiConfigRequest, ApiConfig, OperationMetadata> updateApiConfigOperationSettings;
    private final UnaryCallSettings<DeleteApiConfigRequest, Operation> deleteApiConfigSettings;
    private final OperationCallSettings<DeleteApiConfigRequest, Empty, OperationMetadata> deleteApiConfigOperationSettings;
    private static final PagedListDescriptor<ListGatewaysRequest, ListGatewaysResponse, Gateway> LIST_GATEWAYS_PAGE_STR_DESC = new PagedListDescriptor<ListGatewaysRequest, ListGatewaysResponse, Gateway>(){

        public String emptyToken() {
            return "";
        }

        public ListGatewaysRequest injectToken(ListGatewaysRequest payload, String token) {
            return ListGatewaysRequest.newBuilder((ListGatewaysRequest)payload).setPageToken(token).build();
        }

        public ListGatewaysRequest injectPageSize(ListGatewaysRequest payload, int pageSize) {
            return ListGatewaysRequest.newBuilder((ListGatewaysRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListGatewaysRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListGatewaysResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Gateway> extractResources(ListGatewaysResponse payload) {
            return payload.getGatewaysList() == null ? ImmutableList.of() : payload.getGatewaysList();
        }
    };
    private static final PagedListDescriptor<ListApisRequest, ListApisResponse, Api> LIST_APIS_PAGE_STR_DESC = new PagedListDescriptor<ListApisRequest, ListApisResponse, Api>(){

        public String emptyToken() {
            return "";
        }

        public ListApisRequest injectToken(ListApisRequest payload, String token) {
            return ListApisRequest.newBuilder((ListApisRequest)payload).setPageToken(token).build();
        }

        public ListApisRequest injectPageSize(ListApisRequest payload, int pageSize) {
            return ListApisRequest.newBuilder((ListApisRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListApisRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListApisResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Api> extractResources(ListApisResponse payload) {
            return payload.getApisList() == null ? ImmutableList.of() : payload.getApisList();
        }
    };
    private static final PagedListDescriptor<ListApiConfigsRequest, ListApiConfigsResponse, ApiConfig> LIST_API_CONFIGS_PAGE_STR_DESC = new PagedListDescriptor<ListApiConfigsRequest, ListApiConfigsResponse, ApiConfig>(){

        public String emptyToken() {
            return "";
        }

        public ListApiConfigsRequest injectToken(ListApiConfigsRequest payload, String token) {
            return ListApiConfigsRequest.newBuilder((ListApiConfigsRequest)payload).setPageToken(token).build();
        }

        public ListApiConfigsRequest injectPageSize(ListApiConfigsRequest payload, int pageSize) {
            return ListApiConfigsRequest.newBuilder((ListApiConfigsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListApiConfigsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListApiConfigsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ApiConfig> extractResources(ListApiConfigsResponse payload) {
            return payload.getApiConfigsList() == null ? ImmutableList.of() : payload.getApiConfigsList();
        }
    };
    private static final PagedListResponseFactory<ListGatewaysRequest, ListGatewaysResponse, ApiGatewayServiceClient.ListGatewaysPagedResponse> LIST_GATEWAYS_PAGE_STR_FACT = new PagedListResponseFactory<ListGatewaysRequest, ListGatewaysResponse, ApiGatewayServiceClient.ListGatewaysPagedResponse>(){

        public ApiFuture<ApiGatewayServiceClient.ListGatewaysPagedResponse> getFuturePagedResponse(UnaryCallable<ListGatewaysRequest, ListGatewaysResponse> callable, ListGatewaysRequest request, ApiCallContext context, ApiFuture<ListGatewaysResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_GATEWAYS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ApiGatewayServiceClient.ListGatewaysPagedResponse.createAsync((PageContext<ListGatewaysRequest, ListGatewaysResponse, Gateway>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListApisRequest, ListApisResponse, ApiGatewayServiceClient.ListApisPagedResponse> LIST_APIS_PAGE_STR_FACT = new PagedListResponseFactory<ListApisRequest, ListApisResponse, ApiGatewayServiceClient.ListApisPagedResponse>(){

        public ApiFuture<ApiGatewayServiceClient.ListApisPagedResponse> getFuturePagedResponse(UnaryCallable<ListApisRequest, ListApisResponse> callable, ListApisRequest request, ApiCallContext context, ApiFuture<ListApisResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_APIS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ApiGatewayServiceClient.ListApisPagedResponse.createAsync((PageContext<ListApisRequest, ListApisResponse, Api>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListApiConfigsRequest, ListApiConfigsResponse, ApiGatewayServiceClient.ListApiConfigsPagedResponse> LIST_API_CONFIGS_PAGE_STR_FACT = new PagedListResponseFactory<ListApiConfigsRequest, ListApiConfigsResponse, ApiGatewayServiceClient.ListApiConfigsPagedResponse>(){

        public ApiFuture<ApiGatewayServiceClient.ListApiConfigsPagedResponse> getFuturePagedResponse(UnaryCallable<ListApiConfigsRequest, ListApiConfigsResponse> callable, ListApiConfigsRequest request, ApiCallContext context, ApiFuture<ListApiConfigsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_API_CONFIGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ApiGatewayServiceClient.ListApiConfigsPagedResponse.createAsync((PageContext<ListApiConfigsRequest, ListApiConfigsResponse, ApiConfig>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListGatewaysRequest, ListGatewaysResponse, ApiGatewayServiceClient.ListGatewaysPagedResponse> listGatewaysSettings() {
        return this.listGatewaysSettings;
    }

    public UnaryCallSettings<GetGatewayRequest, Gateway> getGatewaySettings() {
        return this.getGatewaySettings;
    }

    public UnaryCallSettings<CreateGatewayRequest, Operation> createGatewaySettings() {
        return this.createGatewaySettings;
    }

    public OperationCallSettings<CreateGatewayRequest, Gateway, OperationMetadata> createGatewayOperationSettings() {
        return this.createGatewayOperationSettings;
    }

    public UnaryCallSettings<UpdateGatewayRequest, Operation> updateGatewaySettings() {
        return this.updateGatewaySettings;
    }

    public OperationCallSettings<UpdateGatewayRequest, Gateway, OperationMetadata> updateGatewayOperationSettings() {
        return this.updateGatewayOperationSettings;
    }

    public UnaryCallSettings<DeleteGatewayRequest, Operation> deleteGatewaySettings() {
        return this.deleteGatewaySettings;
    }

    public OperationCallSettings<DeleteGatewayRequest, Empty, OperationMetadata> deleteGatewayOperationSettings() {
        return this.deleteGatewayOperationSettings;
    }

    public PagedCallSettings<ListApisRequest, ListApisResponse, ApiGatewayServiceClient.ListApisPagedResponse> listApisSettings() {
        return this.listApisSettings;
    }

    public UnaryCallSettings<GetApiRequest, Api> getApiSettings() {
        return this.getApiSettings;
    }

    public UnaryCallSettings<CreateApiRequest, Operation> createApiSettings() {
        return this.createApiSettings;
    }

    public OperationCallSettings<CreateApiRequest, Api, OperationMetadata> createApiOperationSettings() {
        return this.createApiOperationSettings;
    }

    public UnaryCallSettings<UpdateApiRequest, Operation> updateApiSettings() {
        return this.updateApiSettings;
    }

    public OperationCallSettings<UpdateApiRequest, Api, OperationMetadata> updateApiOperationSettings() {
        return this.updateApiOperationSettings;
    }

    public UnaryCallSettings<DeleteApiRequest, Operation> deleteApiSettings() {
        return this.deleteApiSettings;
    }

    public OperationCallSettings<DeleteApiRequest, Empty, OperationMetadata> deleteApiOperationSettings() {
        return this.deleteApiOperationSettings;
    }

    public PagedCallSettings<ListApiConfigsRequest, ListApiConfigsResponse, ApiGatewayServiceClient.ListApiConfigsPagedResponse> listApiConfigsSettings() {
        return this.listApiConfigsSettings;
    }

    public UnaryCallSettings<GetApiConfigRequest, ApiConfig> getApiConfigSettings() {
        return this.getApiConfigSettings;
    }

    public UnaryCallSettings<CreateApiConfigRequest, Operation> createApiConfigSettings() {
        return this.createApiConfigSettings;
    }

    public OperationCallSettings<CreateApiConfigRequest, ApiConfig, OperationMetadata> createApiConfigOperationSettings() {
        return this.createApiConfigOperationSettings;
    }

    public UnaryCallSettings<UpdateApiConfigRequest, Operation> updateApiConfigSettings() {
        return this.updateApiConfigSettings;
    }

    public OperationCallSettings<UpdateApiConfigRequest, ApiConfig, OperationMetadata> updateApiConfigOperationSettings() {
        return this.updateApiConfigOperationSettings;
    }

    public UnaryCallSettings<DeleteApiConfigRequest, Operation> deleteApiConfigSettings() {
        return this.deleteApiConfigSettings;
    }

    public OperationCallSettings<DeleteApiConfigRequest, Empty, OperationMetadata> deleteApiConfigOperationSettings() {
        return this.deleteApiConfigOperationSettings;
    }

    public ApiGatewayServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcApiGatewayServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "apigateway.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "apigateway.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ApiGatewayServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ApiGatewayServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ApiGatewayServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listGatewaysSettings = settingsBuilder.listGatewaysSettings().build();
        this.getGatewaySettings = settingsBuilder.getGatewaySettings().build();
        this.createGatewaySettings = settingsBuilder.createGatewaySettings().build();
        this.createGatewayOperationSettings = settingsBuilder.createGatewayOperationSettings().build();
        this.updateGatewaySettings = settingsBuilder.updateGatewaySettings().build();
        this.updateGatewayOperationSettings = settingsBuilder.updateGatewayOperationSettings().build();
        this.deleteGatewaySettings = settingsBuilder.deleteGatewaySettings().build();
        this.deleteGatewayOperationSettings = settingsBuilder.deleteGatewayOperationSettings().build();
        this.listApisSettings = settingsBuilder.listApisSettings().build();
        this.getApiSettings = settingsBuilder.getApiSettings().build();
        this.createApiSettings = settingsBuilder.createApiSettings().build();
        this.createApiOperationSettings = settingsBuilder.createApiOperationSettings().build();
        this.updateApiSettings = settingsBuilder.updateApiSettings().build();
        this.updateApiOperationSettings = settingsBuilder.updateApiOperationSettings().build();
        this.deleteApiSettings = settingsBuilder.deleteApiSettings().build();
        this.deleteApiOperationSettings = settingsBuilder.deleteApiOperationSettings().build();
        this.listApiConfigsSettings = settingsBuilder.listApiConfigsSettings().build();
        this.getApiConfigSettings = settingsBuilder.getApiConfigSettings().build();
        this.createApiConfigSettings = settingsBuilder.createApiConfigSettings().build();
        this.createApiConfigOperationSettings = settingsBuilder.createApiConfigOperationSettings().build();
        this.updateApiConfigSettings = settingsBuilder.updateApiConfigSettings().build();
        this.updateApiConfigOperationSettings = settingsBuilder.updateApiConfigOperationSettings().build();
        this.deleteApiConfigSettings = settingsBuilder.deleteApiConfigSettings().build();
        this.deleteApiConfigOperationSettings = settingsBuilder.deleteApiConfigOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ApiGatewayServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListGatewaysRequest, ListGatewaysResponse, ApiGatewayServiceClient.ListGatewaysPagedResponse> listGatewaysSettings;
        private final UnaryCallSettings.Builder<GetGatewayRequest, Gateway> getGatewaySettings;
        private final UnaryCallSettings.Builder<CreateGatewayRequest, Operation> createGatewaySettings;
        private final OperationCallSettings.Builder<CreateGatewayRequest, Gateway, OperationMetadata> createGatewayOperationSettings;
        private final UnaryCallSettings.Builder<UpdateGatewayRequest, Operation> updateGatewaySettings;
        private final OperationCallSettings.Builder<UpdateGatewayRequest, Gateway, OperationMetadata> updateGatewayOperationSettings;
        private final UnaryCallSettings.Builder<DeleteGatewayRequest, Operation> deleteGatewaySettings;
        private final OperationCallSettings.Builder<DeleteGatewayRequest, Empty, OperationMetadata> deleteGatewayOperationSettings;
        private final PagedCallSettings.Builder<ListApisRequest, ListApisResponse, ApiGatewayServiceClient.ListApisPagedResponse> listApisSettings;
        private final UnaryCallSettings.Builder<GetApiRequest, Api> getApiSettings;
        private final UnaryCallSettings.Builder<CreateApiRequest, Operation> createApiSettings;
        private final OperationCallSettings.Builder<CreateApiRequest, Api, OperationMetadata> createApiOperationSettings;
        private final UnaryCallSettings.Builder<UpdateApiRequest, Operation> updateApiSettings;
        private final OperationCallSettings.Builder<UpdateApiRequest, Api, OperationMetadata> updateApiOperationSettings;
        private final UnaryCallSettings.Builder<DeleteApiRequest, Operation> deleteApiSettings;
        private final OperationCallSettings.Builder<DeleteApiRequest, Empty, OperationMetadata> deleteApiOperationSettings;
        private final PagedCallSettings.Builder<ListApiConfigsRequest, ListApiConfigsResponse, ApiGatewayServiceClient.ListApiConfigsPagedResponse> listApiConfigsSettings;
        private final UnaryCallSettings.Builder<GetApiConfigRequest, ApiConfig> getApiConfigSettings;
        private final UnaryCallSettings.Builder<CreateApiConfigRequest, Operation> createApiConfigSettings;
        private final OperationCallSettings.Builder<CreateApiConfigRequest, ApiConfig, OperationMetadata> createApiConfigOperationSettings;
        private final UnaryCallSettings.Builder<UpdateApiConfigRequest, Operation> updateApiConfigSettings;
        private final OperationCallSettings.Builder<UpdateApiConfigRequest, ApiConfig, OperationMetadata> updateApiConfigOperationSettings;
        private final UnaryCallSettings.Builder<DeleteApiConfigRequest, Operation> deleteApiConfigSettings;
        private final OperationCallSettings.Builder<DeleteApiConfigRequest, Empty, OperationMetadata> deleteApiConfigOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listGatewaysSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_GATEWAYS_PAGE_STR_FACT);
            this.getGatewaySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createGatewaySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createGatewayOperationSettings = OperationCallSettings.newBuilder();
            this.updateGatewaySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateGatewayOperationSettings = OperationCallSettings.newBuilder();
            this.deleteGatewaySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteGatewayOperationSettings = OperationCallSettings.newBuilder();
            this.listApisSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_APIS_PAGE_STR_FACT);
            this.getApiSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createApiSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createApiOperationSettings = OperationCallSettings.newBuilder();
            this.updateApiSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateApiOperationSettings = OperationCallSettings.newBuilder();
            this.deleteApiSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteApiOperationSettings = OperationCallSettings.newBuilder();
            this.listApiConfigsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_API_CONFIGS_PAGE_STR_FACT);
            this.getApiConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createApiConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createApiConfigOperationSettings = OperationCallSettings.newBuilder();
            this.updateApiConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateApiConfigOperationSettings = OperationCallSettings.newBuilder();
            this.deleteApiConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteApiConfigOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listGatewaysSettings, this.getGatewaySettings, this.createGatewaySettings, this.updateGatewaySettings, this.deleteGatewaySettings, this.listApisSettings, this.getApiSettings, this.createApiSettings, this.updateApiSettings, this.deleteApiSettings, this.listApiConfigsSettings, this.getApiConfigSettings, (Object[])new UnaryCallSettings.Builder[]{this.createApiConfigSettings, this.updateApiConfigSettings, this.deleteApiConfigSettings});
            Builder.initDefaults(this);
        }

        protected Builder(ApiGatewayServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listGatewaysSettings = settings.listGatewaysSettings.toBuilder();
            this.getGatewaySettings = settings.getGatewaySettings.toBuilder();
            this.createGatewaySettings = settings.createGatewaySettings.toBuilder();
            this.createGatewayOperationSettings = settings.createGatewayOperationSettings.toBuilder();
            this.updateGatewaySettings = settings.updateGatewaySettings.toBuilder();
            this.updateGatewayOperationSettings = settings.updateGatewayOperationSettings.toBuilder();
            this.deleteGatewaySettings = settings.deleteGatewaySettings.toBuilder();
            this.deleteGatewayOperationSettings = settings.deleteGatewayOperationSettings.toBuilder();
            this.listApisSettings = settings.listApisSettings.toBuilder();
            this.getApiSettings = settings.getApiSettings.toBuilder();
            this.createApiSettings = settings.createApiSettings.toBuilder();
            this.createApiOperationSettings = settings.createApiOperationSettings.toBuilder();
            this.updateApiSettings = settings.updateApiSettings.toBuilder();
            this.updateApiOperationSettings = settings.updateApiOperationSettings.toBuilder();
            this.deleteApiSettings = settings.deleteApiSettings.toBuilder();
            this.deleteApiOperationSettings = settings.deleteApiOperationSettings.toBuilder();
            this.listApiConfigsSettings = settings.listApiConfigsSettings.toBuilder();
            this.getApiConfigSettings = settings.getApiConfigSettings.toBuilder();
            this.createApiConfigSettings = settings.createApiConfigSettings.toBuilder();
            this.createApiConfigOperationSettings = settings.createApiConfigOperationSettings.toBuilder();
            this.updateApiConfigSettings = settings.updateApiConfigSettings.toBuilder();
            this.updateApiConfigOperationSettings = settings.updateApiConfigOperationSettings.toBuilder();
            this.deleteApiConfigSettings = settings.deleteApiConfigSettings.toBuilder();
            this.deleteApiConfigOperationSettings = settings.deleteApiConfigOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listGatewaysSettings, this.getGatewaySettings, this.createGatewaySettings, this.updateGatewaySettings, this.deleteGatewaySettings, this.listApisSettings, this.getApiSettings, this.createApiSettings, this.updateApiSettings, this.deleteApiSettings, this.listApiConfigsSettings, this.getApiConfigSettings, (Object[])new UnaryCallSettings.Builder[]{this.createApiConfigSettings, this.updateApiConfigSettings, this.deleteApiConfigSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ApiGatewayServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ApiGatewayServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ApiGatewayServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ApiGatewayServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(ApiGatewayServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listGatewaysSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getGatewaySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createGatewaySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateGatewaySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteGatewaySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listApisSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getApiSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createApiSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateApiSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteApiSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listApiConfigsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getApiConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createApiConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateApiConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteApiConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createGatewayOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Gateway.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateGatewayOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Gateway.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteGatewayOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createApiOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Api.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateApiOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Api.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteApiOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createApiConfigOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ApiConfig.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateApiConfigOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ApiConfig.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteApiConfigOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListGatewaysRequest, ListGatewaysResponse, ApiGatewayServiceClient.ListGatewaysPagedResponse> listGatewaysSettings() {
            return this.listGatewaysSettings;
        }

        public UnaryCallSettings.Builder<GetGatewayRequest, Gateway> getGatewaySettings() {
            return this.getGatewaySettings;
        }

        public UnaryCallSettings.Builder<CreateGatewayRequest, Operation> createGatewaySettings() {
            return this.createGatewaySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateGatewayRequest, Gateway, OperationMetadata> createGatewayOperationSettings() {
            return this.createGatewayOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateGatewayRequest, Operation> updateGatewaySettings() {
            return this.updateGatewaySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateGatewayRequest, Gateway, OperationMetadata> updateGatewayOperationSettings() {
            return this.updateGatewayOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteGatewayRequest, Operation> deleteGatewaySettings() {
            return this.deleteGatewaySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteGatewayRequest, Empty, OperationMetadata> deleteGatewayOperationSettings() {
            return this.deleteGatewayOperationSettings;
        }

        public PagedCallSettings.Builder<ListApisRequest, ListApisResponse, ApiGatewayServiceClient.ListApisPagedResponse> listApisSettings() {
            return this.listApisSettings;
        }

        public UnaryCallSettings.Builder<GetApiRequest, Api> getApiSettings() {
            return this.getApiSettings;
        }

        public UnaryCallSettings.Builder<CreateApiRequest, Operation> createApiSettings() {
            return this.createApiSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateApiRequest, Api, OperationMetadata> createApiOperationSettings() {
            return this.createApiOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateApiRequest, Operation> updateApiSettings() {
            return this.updateApiSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateApiRequest, Api, OperationMetadata> updateApiOperationSettings() {
            return this.updateApiOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteApiRequest, Operation> deleteApiSettings() {
            return this.deleteApiSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteApiRequest, Empty, OperationMetadata> deleteApiOperationSettings() {
            return this.deleteApiOperationSettings;
        }

        public PagedCallSettings.Builder<ListApiConfigsRequest, ListApiConfigsResponse, ApiGatewayServiceClient.ListApiConfigsPagedResponse> listApiConfigsSettings() {
            return this.listApiConfigsSettings;
        }

        public UnaryCallSettings.Builder<GetApiConfigRequest, ApiConfig> getApiConfigSettings() {
            return this.getApiConfigSettings;
        }

        public UnaryCallSettings.Builder<CreateApiConfigRequest, Operation> createApiConfigSettings() {
            return this.createApiConfigSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateApiConfigRequest, ApiConfig, OperationMetadata> createApiConfigOperationSettings() {
            return this.createApiConfigOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateApiConfigRequest, Operation> updateApiConfigSettings() {
            return this.updateApiConfigSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateApiConfigRequest, ApiConfig, OperationMetadata> updateApiConfigOperationSettings() {
            return this.updateApiConfigOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteApiConfigRequest, Operation> deleteApiConfigSettings() {
            return this.deleteApiConfigSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteApiConfigRequest, Empty, OperationMetadata> deleteApiConfigOperationSettings() {
            return this.deleteApiConfigOperationSettings;
        }

        public ApiGatewayServiceStubSettings build() throws IOException {
            return new ApiGatewayServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNKNOWN, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

