/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.analyticshub.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubServiceClient;
import com.google.cloud.bigquery.analyticshub.v1.CreateDataExchangeRequest;
import com.google.cloud.bigquery.analyticshub.v1.CreateListingRequest;
import com.google.cloud.bigquery.analyticshub.v1.DataExchange;
import com.google.cloud.bigquery.analyticshub.v1.DeleteDataExchangeRequest;
import com.google.cloud.bigquery.analyticshub.v1.DeleteListingRequest;
import com.google.cloud.bigquery.analyticshub.v1.DeleteSubscriptionRequest;
import com.google.cloud.bigquery.analyticshub.v1.GetDataExchangeRequest;
import com.google.cloud.bigquery.analyticshub.v1.GetListingRequest;
import com.google.cloud.bigquery.analyticshub.v1.GetSubscriptionRequest;
import com.google.cloud.bigquery.analyticshub.v1.ListDataExchangesRequest;
import com.google.cloud.bigquery.analyticshub.v1.ListDataExchangesResponse;
import com.google.cloud.bigquery.analyticshub.v1.ListListingsRequest;
import com.google.cloud.bigquery.analyticshub.v1.ListListingsResponse;
import com.google.cloud.bigquery.analyticshub.v1.ListOrgDataExchangesRequest;
import com.google.cloud.bigquery.analyticshub.v1.ListOrgDataExchangesResponse;
import com.google.cloud.bigquery.analyticshub.v1.ListSharedResourceSubscriptionsRequest;
import com.google.cloud.bigquery.analyticshub.v1.ListSharedResourceSubscriptionsResponse;
import com.google.cloud.bigquery.analyticshub.v1.ListSubscriptionsRequest;
import com.google.cloud.bigquery.analyticshub.v1.ListSubscriptionsResponse;
import com.google.cloud.bigquery.analyticshub.v1.Listing;
import com.google.cloud.bigquery.analyticshub.v1.OperationMetadata;
import com.google.cloud.bigquery.analyticshub.v1.RefreshSubscriptionRequest;
import com.google.cloud.bigquery.analyticshub.v1.RefreshSubscriptionResponse;
import com.google.cloud.bigquery.analyticshub.v1.RevokeSubscriptionRequest;
import com.google.cloud.bigquery.analyticshub.v1.RevokeSubscriptionResponse;
import com.google.cloud.bigquery.analyticshub.v1.SubscribeDataExchangeRequest;
import com.google.cloud.bigquery.analyticshub.v1.SubscribeDataExchangeResponse;
import com.google.cloud.bigquery.analyticshub.v1.SubscribeListingRequest;
import com.google.cloud.bigquery.analyticshub.v1.SubscribeListingResponse;
import com.google.cloud.bigquery.analyticshub.v1.Subscription;
import com.google.cloud.bigquery.analyticshub.v1.UpdateDataExchangeRequest;
import com.google.cloud.bigquery.analyticshub.v1.UpdateListingRequest;
import com.google.cloud.bigquery.analyticshub.v1.stub.AnalyticsHubServiceStub;
import com.google.cloud.bigquery.analyticshub.v1.stub.GrpcAnalyticsHubServiceStub;
import com.google.cloud.bigquery.analyticshub.v1.stub.HttpJsonAnalyticsHubServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class AnalyticsHubServiceStubSettings
extends StubSettings<AnalyticsHubServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/bigquery").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListDataExchangesRequest, ListDataExchangesResponse, AnalyticsHubServiceClient.ListDataExchangesPagedResponse> listDataExchangesSettings;
    private final PagedCallSettings<ListOrgDataExchangesRequest, ListOrgDataExchangesResponse, AnalyticsHubServiceClient.ListOrgDataExchangesPagedResponse> listOrgDataExchangesSettings;
    private final UnaryCallSettings<GetDataExchangeRequest, DataExchange> getDataExchangeSettings;
    private final UnaryCallSettings<CreateDataExchangeRequest, DataExchange> createDataExchangeSettings;
    private final UnaryCallSettings<UpdateDataExchangeRequest, DataExchange> updateDataExchangeSettings;
    private final UnaryCallSettings<DeleteDataExchangeRequest, Empty> deleteDataExchangeSettings;
    private final PagedCallSettings<ListListingsRequest, ListListingsResponse, AnalyticsHubServiceClient.ListListingsPagedResponse> listListingsSettings;
    private final UnaryCallSettings<GetListingRequest, Listing> getListingSettings;
    private final UnaryCallSettings<CreateListingRequest, Listing> createListingSettings;
    private final UnaryCallSettings<UpdateListingRequest, Listing> updateListingSettings;
    private final UnaryCallSettings<DeleteListingRequest, Empty> deleteListingSettings;
    private final UnaryCallSettings<SubscribeListingRequest, SubscribeListingResponse> subscribeListingSettings;
    private final UnaryCallSettings<SubscribeDataExchangeRequest, Operation> subscribeDataExchangeSettings;
    private final OperationCallSettings<SubscribeDataExchangeRequest, SubscribeDataExchangeResponse, OperationMetadata> subscribeDataExchangeOperationSettings;
    private final UnaryCallSettings<RefreshSubscriptionRequest, Operation> refreshSubscriptionSettings;
    private final OperationCallSettings<RefreshSubscriptionRequest, RefreshSubscriptionResponse, OperationMetadata> refreshSubscriptionOperationSettings;
    private final UnaryCallSettings<GetSubscriptionRequest, Subscription> getSubscriptionSettings;
    private final PagedCallSettings<ListSubscriptionsRequest, ListSubscriptionsResponse, AnalyticsHubServiceClient.ListSubscriptionsPagedResponse> listSubscriptionsSettings;
    private final PagedCallSettings<ListSharedResourceSubscriptionsRequest, ListSharedResourceSubscriptionsResponse, AnalyticsHubServiceClient.ListSharedResourceSubscriptionsPagedResponse> listSharedResourceSubscriptionsSettings;
    private final UnaryCallSettings<RevokeSubscriptionRequest, RevokeSubscriptionResponse> revokeSubscriptionSettings;
    private final UnaryCallSettings<DeleteSubscriptionRequest, Operation> deleteSubscriptionSettings;
    private final OperationCallSettings<DeleteSubscriptionRequest, Empty, OperationMetadata> deleteSubscriptionOperationSettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListDataExchangesRequest, ListDataExchangesResponse, DataExchange> LIST_DATA_EXCHANGES_PAGE_STR_DESC = new PagedListDescriptor<ListDataExchangesRequest, ListDataExchangesResponse, DataExchange>(){

        public String emptyToken() {
            return "";
        }

        public ListDataExchangesRequest injectToken(ListDataExchangesRequest payload, String token) {
            return ListDataExchangesRequest.newBuilder((ListDataExchangesRequest)payload).setPageToken(token).build();
        }

        public ListDataExchangesRequest injectPageSize(ListDataExchangesRequest payload, int pageSize) {
            return ListDataExchangesRequest.newBuilder((ListDataExchangesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDataExchangesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDataExchangesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DataExchange> extractResources(ListDataExchangesResponse payload) {
            return payload.getDataExchangesList() == null ? ImmutableList.of() : payload.getDataExchangesList();
        }
    };
    private static final PagedListDescriptor<ListOrgDataExchangesRequest, ListOrgDataExchangesResponse, DataExchange> LIST_ORG_DATA_EXCHANGES_PAGE_STR_DESC = new PagedListDescriptor<ListOrgDataExchangesRequest, ListOrgDataExchangesResponse, DataExchange>(){

        public String emptyToken() {
            return "";
        }

        public ListOrgDataExchangesRequest injectToken(ListOrgDataExchangesRequest payload, String token) {
            return ListOrgDataExchangesRequest.newBuilder((ListOrgDataExchangesRequest)payload).setPageToken(token).build();
        }

        public ListOrgDataExchangesRequest injectPageSize(ListOrgDataExchangesRequest payload, int pageSize) {
            return ListOrgDataExchangesRequest.newBuilder((ListOrgDataExchangesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListOrgDataExchangesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListOrgDataExchangesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DataExchange> extractResources(ListOrgDataExchangesResponse payload) {
            return payload.getDataExchangesList() == null ? ImmutableList.of() : payload.getDataExchangesList();
        }
    };
    private static final PagedListDescriptor<ListListingsRequest, ListListingsResponse, Listing> LIST_LISTINGS_PAGE_STR_DESC = new PagedListDescriptor<ListListingsRequest, ListListingsResponse, Listing>(){

        public String emptyToken() {
            return "";
        }

        public ListListingsRequest injectToken(ListListingsRequest payload, String token) {
            return ListListingsRequest.newBuilder((ListListingsRequest)payload).setPageToken(token).build();
        }

        public ListListingsRequest injectPageSize(ListListingsRequest payload, int pageSize) {
            return ListListingsRequest.newBuilder((ListListingsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListListingsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListListingsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Listing> extractResources(ListListingsResponse payload) {
            return payload.getListingsList() == null ? ImmutableList.of() : payload.getListingsList();
        }
    };
    private static final PagedListDescriptor<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription> LIST_SUBSCRIPTIONS_PAGE_STR_DESC = new PagedListDescriptor<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription>(){

        public String emptyToken() {
            return "";
        }

        public ListSubscriptionsRequest injectToken(ListSubscriptionsRequest payload, String token) {
            return ListSubscriptionsRequest.newBuilder((ListSubscriptionsRequest)payload).setPageToken(token).build();
        }

        public ListSubscriptionsRequest injectPageSize(ListSubscriptionsRequest payload, int pageSize) {
            return ListSubscriptionsRequest.newBuilder((ListSubscriptionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSubscriptionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSubscriptionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Subscription> extractResources(ListSubscriptionsResponse payload) {
            return payload.getSubscriptionsList() == null ? ImmutableList.of() : payload.getSubscriptionsList();
        }
    };
    private static final PagedListDescriptor<ListSharedResourceSubscriptionsRequest, ListSharedResourceSubscriptionsResponse, Subscription> LIST_SHARED_RESOURCE_SUBSCRIPTIONS_PAGE_STR_DESC = new PagedListDescriptor<ListSharedResourceSubscriptionsRequest, ListSharedResourceSubscriptionsResponse, Subscription>(){

        public String emptyToken() {
            return "";
        }

        public ListSharedResourceSubscriptionsRequest injectToken(ListSharedResourceSubscriptionsRequest payload, String token) {
            return ListSharedResourceSubscriptionsRequest.newBuilder((ListSharedResourceSubscriptionsRequest)payload).setPageToken(token).build();
        }

        public ListSharedResourceSubscriptionsRequest injectPageSize(ListSharedResourceSubscriptionsRequest payload, int pageSize) {
            return ListSharedResourceSubscriptionsRequest.newBuilder((ListSharedResourceSubscriptionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSharedResourceSubscriptionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSharedResourceSubscriptionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Subscription> extractResources(ListSharedResourceSubscriptionsResponse payload) {
            return payload.getSharedResourceSubscriptionsList() == null ? ImmutableList.of() : payload.getSharedResourceSubscriptionsList();
        }
    };
    private static final PagedListResponseFactory<ListDataExchangesRequest, ListDataExchangesResponse, AnalyticsHubServiceClient.ListDataExchangesPagedResponse> LIST_DATA_EXCHANGES_PAGE_STR_FACT = new PagedListResponseFactory<ListDataExchangesRequest, ListDataExchangesResponse, AnalyticsHubServiceClient.ListDataExchangesPagedResponse>(){

        public ApiFuture<AnalyticsHubServiceClient.ListDataExchangesPagedResponse> getFuturePagedResponse(UnaryCallable<ListDataExchangesRequest, ListDataExchangesResponse> callable, ListDataExchangesRequest request, ApiCallContext context, ApiFuture<ListDataExchangesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DATA_EXCHANGES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AnalyticsHubServiceClient.ListDataExchangesPagedResponse.createAsync((PageContext<ListDataExchangesRequest, ListDataExchangesResponse, DataExchange>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListOrgDataExchangesRequest, ListOrgDataExchangesResponse, AnalyticsHubServiceClient.ListOrgDataExchangesPagedResponse> LIST_ORG_DATA_EXCHANGES_PAGE_STR_FACT = new PagedListResponseFactory<ListOrgDataExchangesRequest, ListOrgDataExchangesResponse, AnalyticsHubServiceClient.ListOrgDataExchangesPagedResponse>(){

        public ApiFuture<AnalyticsHubServiceClient.ListOrgDataExchangesPagedResponse> getFuturePagedResponse(UnaryCallable<ListOrgDataExchangesRequest, ListOrgDataExchangesResponse> callable, ListOrgDataExchangesRequest request, ApiCallContext context, ApiFuture<ListOrgDataExchangesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ORG_DATA_EXCHANGES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AnalyticsHubServiceClient.ListOrgDataExchangesPagedResponse.createAsync((PageContext<ListOrgDataExchangesRequest, ListOrgDataExchangesResponse, DataExchange>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListListingsRequest, ListListingsResponse, AnalyticsHubServiceClient.ListListingsPagedResponse> LIST_LISTINGS_PAGE_STR_FACT = new PagedListResponseFactory<ListListingsRequest, ListListingsResponse, AnalyticsHubServiceClient.ListListingsPagedResponse>(){

        public ApiFuture<AnalyticsHubServiceClient.ListListingsPagedResponse> getFuturePagedResponse(UnaryCallable<ListListingsRequest, ListListingsResponse> callable, ListListingsRequest request, ApiCallContext context, ApiFuture<ListListingsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LISTINGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AnalyticsHubServiceClient.ListListingsPagedResponse.createAsync((PageContext<ListListingsRequest, ListListingsResponse, Listing>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListSubscriptionsRequest, ListSubscriptionsResponse, AnalyticsHubServiceClient.ListSubscriptionsPagedResponse> LIST_SUBSCRIPTIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListSubscriptionsRequest, ListSubscriptionsResponse, AnalyticsHubServiceClient.ListSubscriptionsPagedResponse>(){

        public ApiFuture<AnalyticsHubServiceClient.ListSubscriptionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListSubscriptionsRequest, ListSubscriptionsResponse> callable, ListSubscriptionsRequest request, ApiCallContext context, ApiFuture<ListSubscriptionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SUBSCRIPTIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AnalyticsHubServiceClient.ListSubscriptionsPagedResponse.createAsync((PageContext<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListSharedResourceSubscriptionsRequest, ListSharedResourceSubscriptionsResponse, AnalyticsHubServiceClient.ListSharedResourceSubscriptionsPagedResponse> LIST_SHARED_RESOURCE_SUBSCRIPTIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListSharedResourceSubscriptionsRequest, ListSharedResourceSubscriptionsResponse, AnalyticsHubServiceClient.ListSharedResourceSubscriptionsPagedResponse>(){

        public ApiFuture<AnalyticsHubServiceClient.ListSharedResourceSubscriptionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListSharedResourceSubscriptionsRequest, ListSharedResourceSubscriptionsResponse> callable, ListSharedResourceSubscriptionsRequest request, ApiCallContext context, ApiFuture<ListSharedResourceSubscriptionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SHARED_RESOURCE_SUBSCRIPTIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AnalyticsHubServiceClient.ListSharedResourceSubscriptionsPagedResponse.createAsync((PageContext<ListSharedResourceSubscriptionsRequest, ListSharedResourceSubscriptionsResponse, Subscription>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListDataExchangesRequest, ListDataExchangesResponse, AnalyticsHubServiceClient.ListDataExchangesPagedResponse> listDataExchangesSettings() {
        return this.listDataExchangesSettings;
    }

    public PagedCallSettings<ListOrgDataExchangesRequest, ListOrgDataExchangesResponse, AnalyticsHubServiceClient.ListOrgDataExchangesPagedResponse> listOrgDataExchangesSettings() {
        return this.listOrgDataExchangesSettings;
    }

    public UnaryCallSettings<GetDataExchangeRequest, DataExchange> getDataExchangeSettings() {
        return this.getDataExchangeSettings;
    }

    public UnaryCallSettings<CreateDataExchangeRequest, DataExchange> createDataExchangeSettings() {
        return this.createDataExchangeSettings;
    }

    public UnaryCallSettings<UpdateDataExchangeRequest, DataExchange> updateDataExchangeSettings() {
        return this.updateDataExchangeSettings;
    }

    public UnaryCallSettings<DeleteDataExchangeRequest, Empty> deleteDataExchangeSettings() {
        return this.deleteDataExchangeSettings;
    }

    public PagedCallSettings<ListListingsRequest, ListListingsResponse, AnalyticsHubServiceClient.ListListingsPagedResponse> listListingsSettings() {
        return this.listListingsSettings;
    }

    public UnaryCallSettings<GetListingRequest, Listing> getListingSettings() {
        return this.getListingSettings;
    }

    public UnaryCallSettings<CreateListingRequest, Listing> createListingSettings() {
        return this.createListingSettings;
    }

    public UnaryCallSettings<UpdateListingRequest, Listing> updateListingSettings() {
        return this.updateListingSettings;
    }

    public UnaryCallSettings<DeleteListingRequest, Empty> deleteListingSettings() {
        return this.deleteListingSettings;
    }

    public UnaryCallSettings<SubscribeListingRequest, SubscribeListingResponse> subscribeListingSettings() {
        return this.subscribeListingSettings;
    }

    public UnaryCallSettings<SubscribeDataExchangeRequest, Operation> subscribeDataExchangeSettings() {
        return this.subscribeDataExchangeSettings;
    }

    public OperationCallSettings<SubscribeDataExchangeRequest, SubscribeDataExchangeResponse, OperationMetadata> subscribeDataExchangeOperationSettings() {
        return this.subscribeDataExchangeOperationSettings;
    }

    public UnaryCallSettings<RefreshSubscriptionRequest, Operation> refreshSubscriptionSettings() {
        return this.refreshSubscriptionSettings;
    }

    public OperationCallSettings<RefreshSubscriptionRequest, RefreshSubscriptionResponse, OperationMetadata> refreshSubscriptionOperationSettings() {
        return this.refreshSubscriptionOperationSettings;
    }

    public UnaryCallSettings<GetSubscriptionRequest, Subscription> getSubscriptionSettings() {
        return this.getSubscriptionSettings;
    }

    public PagedCallSettings<ListSubscriptionsRequest, ListSubscriptionsResponse, AnalyticsHubServiceClient.ListSubscriptionsPagedResponse> listSubscriptionsSettings() {
        return this.listSubscriptionsSettings;
    }

    public PagedCallSettings<ListSharedResourceSubscriptionsRequest, ListSharedResourceSubscriptionsResponse, AnalyticsHubServiceClient.ListSharedResourceSubscriptionsPagedResponse> listSharedResourceSubscriptionsSettings() {
        return this.listSharedResourceSubscriptionsSettings;
    }

    public UnaryCallSettings<RevokeSubscriptionRequest, RevokeSubscriptionResponse> revokeSubscriptionSettings() {
        return this.revokeSubscriptionSettings;
    }

    public UnaryCallSettings<DeleteSubscriptionRequest, Operation> deleteSubscriptionSettings() {
        return this.deleteSubscriptionSettings;
    }

    public OperationCallSettings<DeleteSubscriptionRequest, Empty, OperationMetadata> deleteSubscriptionOperationSettings() {
        return this.deleteSubscriptionOperationSettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public AnalyticsHubServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAnalyticsHubServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonAnalyticsHubServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return AnalyticsHubServiceStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "analyticshub";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "analyticshub.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "analyticshub.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AnalyticsHubServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AnalyticsHubServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AnalyticsHubServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return AnalyticsHubServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AnalyticsHubServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listDataExchangesSettings = settingsBuilder.listDataExchangesSettings().build();
        this.listOrgDataExchangesSettings = settingsBuilder.listOrgDataExchangesSettings().build();
        this.getDataExchangeSettings = settingsBuilder.getDataExchangeSettings().build();
        this.createDataExchangeSettings = settingsBuilder.createDataExchangeSettings().build();
        this.updateDataExchangeSettings = settingsBuilder.updateDataExchangeSettings().build();
        this.deleteDataExchangeSettings = settingsBuilder.deleteDataExchangeSettings().build();
        this.listListingsSettings = settingsBuilder.listListingsSettings().build();
        this.getListingSettings = settingsBuilder.getListingSettings().build();
        this.createListingSettings = settingsBuilder.createListingSettings().build();
        this.updateListingSettings = settingsBuilder.updateListingSettings().build();
        this.deleteListingSettings = settingsBuilder.deleteListingSettings().build();
        this.subscribeListingSettings = settingsBuilder.subscribeListingSettings().build();
        this.subscribeDataExchangeSettings = settingsBuilder.subscribeDataExchangeSettings().build();
        this.subscribeDataExchangeOperationSettings = settingsBuilder.subscribeDataExchangeOperationSettings().build();
        this.refreshSubscriptionSettings = settingsBuilder.refreshSubscriptionSettings().build();
        this.refreshSubscriptionOperationSettings = settingsBuilder.refreshSubscriptionOperationSettings().build();
        this.getSubscriptionSettings = settingsBuilder.getSubscriptionSettings().build();
        this.listSubscriptionsSettings = settingsBuilder.listSubscriptionsSettings().build();
        this.listSharedResourceSubscriptionsSettings = settingsBuilder.listSharedResourceSubscriptionsSettings().build();
        this.revokeSubscriptionSettings = settingsBuilder.revokeSubscriptionSettings().build();
        this.deleteSubscriptionSettings = settingsBuilder.deleteSubscriptionSettings().build();
        this.deleteSubscriptionOperationSettings = settingsBuilder.deleteSubscriptionOperationSettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AnalyticsHubServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListDataExchangesRequest, ListDataExchangesResponse, AnalyticsHubServiceClient.ListDataExchangesPagedResponse> listDataExchangesSettings;
        private final PagedCallSettings.Builder<ListOrgDataExchangesRequest, ListOrgDataExchangesResponse, AnalyticsHubServiceClient.ListOrgDataExchangesPagedResponse> listOrgDataExchangesSettings;
        private final UnaryCallSettings.Builder<GetDataExchangeRequest, DataExchange> getDataExchangeSettings;
        private final UnaryCallSettings.Builder<CreateDataExchangeRequest, DataExchange> createDataExchangeSettings;
        private final UnaryCallSettings.Builder<UpdateDataExchangeRequest, DataExchange> updateDataExchangeSettings;
        private final UnaryCallSettings.Builder<DeleteDataExchangeRequest, Empty> deleteDataExchangeSettings;
        private final PagedCallSettings.Builder<ListListingsRequest, ListListingsResponse, AnalyticsHubServiceClient.ListListingsPagedResponse> listListingsSettings;
        private final UnaryCallSettings.Builder<GetListingRequest, Listing> getListingSettings;
        private final UnaryCallSettings.Builder<CreateListingRequest, Listing> createListingSettings;
        private final UnaryCallSettings.Builder<UpdateListingRequest, Listing> updateListingSettings;
        private final UnaryCallSettings.Builder<DeleteListingRequest, Empty> deleteListingSettings;
        private final UnaryCallSettings.Builder<SubscribeListingRequest, SubscribeListingResponse> subscribeListingSettings;
        private final UnaryCallSettings.Builder<SubscribeDataExchangeRequest, Operation> subscribeDataExchangeSettings;
        private final OperationCallSettings.Builder<SubscribeDataExchangeRequest, SubscribeDataExchangeResponse, OperationMetadata> subscribeDataExchangeOperationSettings;
        private final UnaryCallSettings.Builder<RefreshSubscriptionRequest, Operation> refreshSubscriptionSettings;
        private final OperationCallSettings.Builder<RefreshSubscriptionRequest, RefreshSubscriptionResponse, OperationMetadata> refreshSubscriptionOperationSettings;
        private final UnaryCallSettings.Builder<GetSubscriptionRequest, Subscription> getSubscriptionSettings;
        private final PagedCallSettings.Builder<ListSubscriptionsRequest, ListSubscriptionsResponse, AnalyticsHubServiceClient.ListSubscriptionsPagedResponse> listSubscriptionsSettings;
        private final PagedCallSettings.Builder<ListSharedResourceSubscriptionsRequest, ListSharedResourceSubscriptionsResponse, AnalyticsHubServiceClient.ListSharedResourceSubscriptionsPagedResponse> listSharedResourceSubscriptionsSettings;
        private final UnaryCallSettings.Builder<RevokeSubscriptionRequest, RevokeSubscriptionResponse> revokeSubscriptionSettings;
        private final UnaryCallSettings.Builder<DeleteSubscriptionRequest, Operation> deleteSubscriptionSettings;
        private final OperationCallSettings.Builder<DeleteSubscriptionRequest, Empty, OperationMetadata> deleteSubscriptionOperationSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listDataExchangesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DATA_EXCHANGES_PAGE_STR_FACT);
            this.listOrgDataExchangesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ORG_DATA_EXCHANGES_PAGE_STR_FACT);
            this.getDataExchangeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDataExchangeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDataExchangeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDataExchangeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listListingsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LISTINGS_PAGE_STR_FACT);
            this.getListingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createListingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateListingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteListingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.subscribeListingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.subscribeDataExchangeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.subscribeDataExchangeOperationSettings = OperationCallSettings.newBuilder();
            this.refreshSubscriptionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.refreshSubscriptionOperationSettings = OperationCallSettings.newBuilder();
            this.getSubscriptionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSubscriptionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SUBSCRIPTIONS_PAGE_STR_FACT);
            this.listSharedResourceSubscriptionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SHARED_RESOURCE_SUBSCRIPTIONS_PAGE_STR_FACT);
            this.revokeSubscriptionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSubscriptionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSubscriptionOperationSettings = OperationCallSettings.newBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listDataExchangesSettings, this.listOrgDataExchangesSettings, this.getDataExchangeSettings, this.createDataExchangeSettings, this.updateDataExchangeSettings, this.deleteDataExchangeSettings, this.listListingsSettings, this.getListingSettings, this.createListingSettings, this.updateListingSettings, this.deleteListingSettings, this.subscribeListingSettings, (Object[])new UnaryCallSettings.Builder[]{this.subscribeDataExchangeSettings, this.refreshSubscriptionSettings, this.getSubscriptionSettings, this.listSubscriptionsSettings, this.listSharedResourceSubscriptionsSettings, this.revokeSubscriptionSettings, this.deleteSubscriptionSettings, this.getIamPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(AnalyticsHubServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listDataExchangesSettings = settings.listDataExchangesSettings.toBuilder();
            this.listOrgDataExchangesSettings = settings.listOrgDataExchangesSettings.toBuilder();
            this.getDataExchangeSettings = settings.getDataExchangeSettings.toBuilder();
            this.createDataExchangeSettings = settings.createDataExchangeSettings.toBuilder();
            this.updateDataExchangeSettings = settings.updateDataExchangeSettings.toBuilder();
            this.deleteDataExchangeSettings = settings.deleteDataExchangeSettings.toBuilder();
            this.listListingsSettings = settings.listListingsSettings.toBuilder();
            this.getListingSettings = settings.getListingSettings.toBuilder();
            this.createListingSettings = settings.createListingSettings.toBuilder();
            this.updateListingSettings = settings.updateListingSettings.toBuilder();
            this.deleteListingSettings = settings.deleteListingSettings.toBuilder();
            this.subscribeListingSettings = settings.subscribeListingSettings.toBuilder();
            this.subscribeDataExchangeSettings = settings.subscribeDataExchangeSettings.toBuilder();
            this.subscribeDataExchangeOperationSettings = settings.subscribeDataExchangeOperationSettings.toBuilder();
            this.refreshSubscriptionSettings = settings.refreshSubscriptionSettings.toBuilder();
            this.refreshSubscriptionOperationSettings = settings.refreshSubscriptionOperationSettings.toBuilder();
            this.getSubscriptionSettings = settings.getSubscriptionSettings.toBuilder();
            this.listSubscriptionsSettings = settings.listSubscriptionsSettings.toBuilder();
            this.listSharedResourceSubscriptionsSettings = settings.listSharedResourceSubscriptionsSettings.toBuilder();
            this.revokeSubscriptionSettings = settings.revokeSubscriptionSettings.toBuilder();
            this.deleteSubscriptionSettings = settings.deleteSubscriptionSettings.toBuilder();
            this.deleteSubscriptionOperationSettings = settings.deleteSubscriptionOperationSettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listDataExchangesSettings, this.listOrgDataExchangesSettings, this.getDataExchangeSettings, this.createDataExchangeSettings, this.updateDataExchangeSettings, this.deleteDataExchangeSettings, this.listListingsSettings, this.getListingSettings, this.createListingSettings, this.updateListingSettings, this.deleteListingSettings, this.subscribeListingSettings, (Object[])new UnaryCallSettings.Builder[]{this.subscribeDataExchangeSettings, this.refreshSubscriptionSettings, this.getSubscriptionSettings, this.listSubscriptionsSettings, this.listSharedResourceSubscriptionsSettings, this.revokeSubscriptionSettings, this.deleteSubscriptionSettings, this.getIamPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AnalyticsHubServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AnalyticsHubServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AnalyticsHubServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AnalyticsHubServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)AnalyticsHubServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)AnalyticsHubServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AnalyticsHubServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AnalyticsHubServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listDataExchangesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listOrgDataExchangesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getDataExchangeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createDataExchangeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateDataExchangeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteDataExchangeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listListingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getListingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createListingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateListingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteListingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.subscribeListingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.subscribeDataExchangeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.refreshSubscriptionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getSubscriptionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listSubscriptionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listSharedResourceSubscriptionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.revokeSubscriptionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteSubscriptionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.subscribeDataExchangeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(SubscribeDataExchangeResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.refreshSubscriptionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(RefreshSubscriptionResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteSubscriptionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListDataExchangesRequest, ListDataExchangesResponse, AnalyticsHubServiceClient.ListDataExchangesPagedResponse> listDataExchangesSettings() {
            return this.listDataExchangesSettings;
        }

        public PagedCallSettings.Builder<ListOrgDataExchangesRequest, ListOrgDataExchangesResponse, AnalyticsHubServiceClient.ListOrgDataExchangesPagedResponse> listOrgDataExchangesSettings() {
            return this.listOrgDataExchangesSettings;
        }

        public UnaryCallSettings.Builder<GetDataExchangeRequest, DataExchange> getDataExchangeSettings() {
            return this.getDataExchangeSettings;
        }

        public UnaryCallSettings.Builder<CreateDataExchangeRequest, DataExchange> createDataExchangeSettings() {
            return this.createDataExchangeSettings;
        }

        public UnaryCallSettings.Builder<UpdateDataExchangeRequest, DataExchange> updateDataExchangeSettings() {
            return this.updateDataExchangeSettings;
        }

        public UnaryCallSettings.Builder<DeleteDataExchangeRequest, Empty> deleteDataExchangeSettings() {
            return this.deleteDataExchangeSettings;
        }

        public PagedCallSettings.Builder<ListListingsRequest, ListListingsResponse, AnalyticsHubServiceClient.ListListingsPagedResponse> listListingsSettings() {
            return this.listListingsSettings;
        }

        public UnaryCallSettings.Builder<GetListingRequest, Listing> getListingSettings() {
            return this.getListingSettings;
        }

        public UnaryCallSettings.Builder<CreateListingRequest, Listing> createListingSettings() {
            return this.createListingSettings;
        }

        public UnaryCallSettings.Builder<UpdateListingRequest, Listing> updateListingSettings() {
            return this.updateListingSettings;
        }

        public UnaryCallSettings.Builder<DeleteListingRequest, Empty> deleteListingSettings() {
            return this.deleteListingSettings;
        }

        public UnaryCallSettings.Builder<SubscribeListingRequest, SubscribeListingResponse> subscribeListingSettings() {
            return this.subscribeListingSettings;
        }

        public UnaryCallSettings.Builder<SubscribeDataExchangeRequest, Operation> subscribeDataExchangeSettings() {
            return this.subscribeDataExchangeSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<SubscribeDataExchangeRequest, SubscribeDataExchangeResponse, OperationMetadata> subscribeDataExchangeOperationSettings() {
            return this.subscribeDataExchangeOperationSettings;
        }

        public UnaryCallSettings.Builder<RefreshSubscriptionRequest, Operation> refreshSubscriptionSettings() {
            return this.refreshSubscriptionSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<RefreshSubscriptionRequest, RefreshSubscriptionResponse, OperationMetadata> refreshSubscriptionOperationSettings() {
            return this.refreshSubscriptionOperationSettings;
        }

        public UnaryCallSettings.Builder<GetSubscriptionRequest, Subscription> getSubscriptionSettings() {
            return this.getSubscriptionSettings;
        }

        public PagedCallSettings.Builder<ListSubscriptionsRequest, ListSubscriptionsResponse, AnalyticsHubServiceClient.ListSubscriptionsPagedResponse> listSubscriptionsSettings() {
            return this.listSubscriptionsSettings;
        }

        public PagedCallSettings.Builder<ListSharedResourceSubscriptionsRequest, ListSharedResourceSubscriptionsResponse, AnalyticsHubServiceClient.ListSharedResourceSubscriptionsPagedResponse> listSharedResourceSubscriptionsSettings() {
            return this.listSharedResourceSubscriptionsSettings;
        }

        public UnaryCallSettings.Builder<RevokeSubscriptionRequest, RevokeSubscriptionResponse> revokeSubscriptionSettings() {
            return this.revokeSubscriptionSettings;
        }

        public UnaryCallSettings.Builder<DeleteSubscriptionRequest, Operation> deleteSubscriptionSettings() {
            return this.deleteSubscriptionSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteSubscriptionRequest, Empty, OperationMetadata> deleteSubscriptionOperationSettings() {
            return this.deleteSubscriptionOperationSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return AnalyticsHubServiceStubSettings.getDefaultEndpoint();
        }

        public AnalyticsHubServiceStubSettings build() throws IOException {
            return new AnalyticsHubServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

