/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.analyticshub.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubServiceClient;
import com.google.cloud.bigquery.analyticshub.v1.CreateDataExchangeRequest;
import com.google.cloud.bigquery.analyticshub.v1.CreateListingRequest;
import com.google.cloud.bigquery.analyticshub.v1.DataExchange;
import com.google.cloud.bigquery.analyticshub.v1.DeleteDataExchangeRequest;
import com.google.cloud.bigquery.analyticshub.v1.DeleteListingRequest;
import com.google.cloud.bigquery.analyticshub.v1.GetDataExchangeRequest;
import com.google.cloud.bigquery.analyticshub.v1.GetListingRequest;
import com.google.cloud.bigquery.analyticshub.v1.ListDataExchangesRequest;
import com.google.cloud.bigquery.analyticshub.v1.ListDataExchangesResponse;
import com.google.cloud.bigquery.analyticshub.v1.ListListingsRequest;
import com.google.cloud.bigquery.analyticshub.v1.ListListingsResponse;
import com.google.cloud.bigquery.analyticshub.v1.ListOrgDataExchangesRequest;
import com.google.cloud.bigquery.analyticshub.v1.ListOrgDataExchangesResponse;
import com.google.cloud.bigquery.analyticshub.v1.Listing;
import com.google.cloud.bigquery.analyticshub.v1.SubscribeListingRequest;
import com.google.cloud.bigquery.analyticshub.v1.SubscribeListingResponse;
import com.google.cloud.bigquery.analyticshub.v1.UpdateDataExchangeRequest;
import com.google.cloud.bigquery.analyticshub.v1.UpdateListingRequest;
import com.google.cloud.bigquery.analyticshub.v1.stub.AnalyticsHubServiceStub;
import com.google.cloud.bigquery.analyticshub.v1.stub.GrpcAnalyticsHubServiceStub;
import com.google.cloud.bigquery.analyticshub.v1.stub.HttpJsonAnalyticsHubServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class AnalyticsHubServiceStubSettings
extends StubSettings<AnalyticsHubServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/bigquery").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListDataExchangesRequest, ListDataExchangesResponse, AnalyticsHubServiceClient.ListDataExchangesPagedResponse> listDataExchangesSettings;
    private final PagedCallSettings<ListOrgDataExchangesRequest, ListOrgDataExchangesResponse, AnalyticsHubServiceClient.ListOrgDataExchangesPagedResponse> listOrgDataExchangesSettings;
    private final UnaryCallSettings<GetDataExchangeRequest, DataExchange> getDataExchangeSettings;
    private final UnaryCallSettings<CreateDataExchangeRequest, DataExchange> createDataExchangeSettings;
    private final UnaryCallSettings<UpdateDataExchangeRequest, DataExchange> updateDataExchangeSettings;
    private final UnaryCallSettings<DeleteDataExchangeRequest, Empty> deleteDataExchangeSettings;
    private final PagedCallSettings<ListListingsRequest, ListListingsResponse, AnalyticsHubServiceClient.ListListingsPagedResponse> listListingsSettings;
    private final UnaryCallSettings<GetListingRequest, Listing> getListingSettings;
    private final UnaryCallSettings<CreateListingRequest, Listing> createListingSettings;
    private final UnaryCallSettings<UpdateListingRequest, Listing> updateListingSettings;
    private final UnaryCallSettings<DeleteListingRequest, Empty> deleteListingSettings;
    private final UnaryCallSettings<SubscribeListingRequest, SubscribeListingResponse> subscribeListingSettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListDataExchangesRequest, ListDataExchangesResponse, DataExchange> LIST_DATA_EXCHANGES_PAGE_STR_DESC = new PagedListDescriptor<ListDataExchangesRequest, ListDataExchangesResponse, DataExchange>(){

        public String emptyToken() {
            return "";
        }

        public ListDataExchangesRequest injectToken(ListDataExchangesRequest payload, String token) {
            return ListDataExchangesRequest.newBuilder((ListDataExchangesRequest)payload).setPageToken(token).build();
        }

        public ListDataExchangesRequest injectPageSize(ListDataExchangesRequest payload, int pageSize) {
            return ListDataExchangesRequest.newBuilder((ListDataExchangesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDataExchangesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDataExchangesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DataExchange> extractResources(ListDataExchangesResponse payload) {
            return payload.getDataExchangesList() == null ? ImmutableList.of() : payload.getDataExchangesList();
        }
    };
    private static final PagedListDescriptor<ListOrgDataExchangesRequest, ListOrgDataExchangesResponse, DataExchange> LIST_ORG_DATA_EXCHANGES_PAGE_STR_DESC = new PagedListDescriptor<ListOrgDataExchangesRequest, ListOrgDataExchangesResponse, DataExchange>(){

        public String emptyToken() {
            return "";
        }

        public ListOrgDataExchangesRequest injectToken(ListOrgDataExchangesRequest payload, String token) {
            return ListOrgDataExchangesRequest.newBuilder((ListOrgDataExchangesRequest)payload).setPageToken(token).build();
        }

        public ListOrgDataExchangesRequest injectPageSize(ListOrgDataExchangesRequest payload, int pageSize) {
            return ListOrgDataExchangesRequest.newBuilder((ListOrgDataExchangesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListOrgDataExchangesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListOrgDataExchangesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DataExchange> extractResources(ListOrgDataExchangesResponse payload) {
            return payload.getDataExchangesList() == null ? ImmutableList.of() : payload.getDataExchangesList();
        }
    };
    private static final PagedListDescriptor<ListListingsRequest, ListListingsResponse, Listing> LIST_LISTINGS_PAGE_STR_DESC = new PagedListDescriptor<ListListingsRequest, ListListingsResponse, Listing>(){

        public String emptyToken() {
            return "";
        }

        public ListListingsRequest injectToken(ListListingsRequest payload, String token) {
            return ListListingsRequest.newBuilder((ListListingsRequest)payload).setPageToken(token).build();
        }

        public ListListingsRequest injectPageSize(ListListingsRequest payload, int pageSize) {
            return ListListingsRequest.newBuilder((ListListingsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListListingsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListListingsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Listing> extractResources(ListListingsResponse payload) {
            return payload.getListingsList() == null ? ImmutableList.of() : payload.getListingsList();
        }
    };
    private static final PagedListResponseFactory<ListDataExchangesRequest, ListDataExchangesResponse, AnalyticsHubServiceClient.ListDataExchangesPagedResponse> LIST_DATA_EXCHANGES_PAGE_STR_FACT = new PagedListResponseFactory<ListDataExchangesRequest, ListDataExchangesResponse, AnalyticsHubServiceClient.ListDataExchangesPagedResponse>(){

        public ApiFuture<AnalyticsHubServiceClient.ListDataExchangesPagedResponse> getFuturePagedResponse(UnaryCallable<ListDataExchangesRequest, ListDataExchangesResponse> callable, ListDataExchangesRequest request, ApiCallContext context, ApiFuture<ListDataExchangesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DATA_EXCHANGES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AnalyticsHubServiceClient.ListDataExchangesPagedResponse.createAsync((PageContext<ListDataExchangesRequest, ListDataExchangesResponse, DataExchange>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListOrgDataExchangesRequest, ListOrgDataExchangesResponse, AnalyticsHubServiceClient.ListOrgDataExchangesPagedResponse> LIST_ORG_DATA_EXCHANGES_PAGE_STR_FACT = new PagedListResponseFactory<ListOrgDataExchangesRequest, ListOrgDataExchangesResponse, AnalyticsHubServiceClient.ListOrgDataExchangesPagedResponse>(){

        public ApiFuture<AnalyticsHubServiceClient.ListOrgDataExchangesPagedResponse> getFuturePagedResponse(UnaryCallable<ListOrgDataExchangesRequest, ListOrgDataExchangesResponse> callable, ListOrgDataExchangesRequest request, ApiCallContext context, ApiFuture<ListOrgDataExchangesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ORG_DATA_EXCHANGES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AnalyticsHubServiceClient.ListOrgDataExchangesPagedResponse.createAsync((PageContext<ListOrgDataExchangesRequest, ListOrgDataExchangesResponse, DataExchange>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListListingsRequest, ListListingsResponse, AnalyticsHubServiceClient.ListListingsPagedResponse> LIST_LISTINGS_PAGE_STR_FACT = new PagedListResponseFactory<ListListingsRequest, ListListingsResponse, AnalyticsHubServiceClient.ListListingsPagedResponse>(){

        public ApiFuture<AnalyticsHubServiceClient.ListListingsPagedResponse> getFuturePagedResponse(UnaryCallable<ListListingsRequest, ListListingsResponse> callable, ListListingsRequest request, ApiCallContext context, ApiFuture<ListListingsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LISTINGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AnalyticsHubServiceClient.ListListingsPagedResponse.createAsync((PageContext<ListListingsRequest, ListListingsResponse, Listing>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListDataExchangesRequest, ListDataExchangesResponse, AnalyticsHubServiceClient.ListDataExchangesPagedResponse> listDataExchangesSettings() {
        return this.listDataExchangesSettings;
    }

    public PagedCallSettings<ListOrgDataExchangesRequest, ListOrgDataExchangesResponse, AnalyticsHubServiceClient.ListOrgDataExchangesPagedResponse> listOrgDataExchangesSettings() {
        return this.listOrgDataExchangesSettings;
    }

    public UnaryCallSettings<GetDataExchangeRequest, DataExchange> getDataExchangeSettings() {
        return this.getDataExchangeSettings;
    }

    public UnaryCallSettings<CreateDataExchangeRequest, DataExchange> createDataExchangeSettings() {
        return this.createDataExchangeSettings;
    }

    public UnaryCallSettings<UpdateDataExchangeRequest, DataExchange> updateDataExchangeSettings() {
        return this.updateDataExchangeSettings;
    }

    public UnaryCallSettings<DeleteDataExchangeRequest, Empty> deleteDataExchangeSettings() {
        return this.deleteDataExchangeSettings;
    }

    public PagedCallSettings<ListListingsRequest, ListListingsResponse, AnalyticsHubServiceClient.ListListingsPagedResponse> listListingsSettings() {
        return this.listListingsSettings;
    }

    public UnaryCallSettings<GetListingRequest, Listing> getListingSettings() {
        return this.getListingSettings;
    }

    public UnaryCallSettings<CreateListingRequest, Listing> createListingSettings() {
        return this.createListingSettings;
    }

    public UnaryCallSettings<UpdateListingRequest, Listing> updateListingSettings() {
        return this.updateListingSettings;
    }

    public UnaryCallSettings<DeleteListingRequest, Empty> deleteListingSettings() {
        return this.deleteListingSettings;
    }

    public UnaryCallSettings<SubscribeListingRequest, SubscribeListingResponse> subscribeListingSettings() {
        return this.subscribeListingSettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public AnalyticsHubServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAnalyticsHubServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonAnalyticsHubServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "analyticshub.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "analyticshub.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AnalyticsHubServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AnalyticsHubServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AnalyticsHubServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return AnalyticsHubServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AnalyticsHubServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listDataExchangesSettings = settingsBuilder.listDataExchangesSettings().build();
        this.listOrgDataExchangesSettings = settingsBuilder.listOrgDataExchangesSettings().build();
        this.getDataExchangeSettings = settingsBuilder.getDataExchangeSettings().build();
        this.createDataExchangeSettings = settingsBuilder.createDataExchangeSettings().build();
        this.updateDataExchangeSettings = settingsBuilder.updateDataExchangeSettings().build();
        this.deleteDataExchangeSettings = settingsBuilder.deleteDataExchangeSettings().build();
        this.listListingsSettings = settingsBuilder.listListingsSettings().build();
        this.getListingSettings = settingsBuilder.getListingSettings().build();
        this.createListingSettings = settingsBuilder.createListingSettings().build();
        this.updateListingSettings = settingsBuilder.updateListingSettings().build();
        this.deleteListingSettings = settingsBuilder.deleteListingSettings().build();
        this.subscribeListingSettings = settingsBuilder.subscribeListingSettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AnalyticsHubServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListDataExchangesRequest, ListDataExchangesResponse, AnalyticsHubServiceClient.ListDataExchangesPagedResponse> listDataExchangesSettings;
        private final PagedCallSettings.Builder<ListOrgDataExchangesRequest, ListOrgDataExchangesResponse, AnalyticsHubServiceClient.ListOrgDataExchangesPagedResponse> listOrgDataExchangesSettings;
        private final UnaryCallSettings.Builder<GetDataExchangeRequest, DataExchange> getDataExchangeSettings;
        private final UnaryCallSettings.Builder<CreateDataExchangeRequest, DataExchange> createDataExchangeSettings;
        private final UnaryCallSettings.Builder<UpdateDataExchangeRequest, DataExchange> updateDataExchangeSettings;
        private final UnaryCallSettings.Builder<DeleteDataExchangeRequest, Empty> deleteDataExchangeSettings;
        private final PagedCallSettings.Builder<ListListingsRequest, ListListingsResponse, AnalyticsHubServiceClient.ListListingsPagedResponse> listListingsSettings;
        private final UnaryCallSettings.Builder<GetListingRequest, Listing> getListingSettings;
        private final UnaryCallSettings.Builder<CreateListingRequest, Listing> createListingSettings;
        private final UnaryCallSettings.Builder<UpdateListingRequest, Listing> updateListingSettings;
        private final UnaryCallSettings.Builder<DeleteListingRequest, Empty> deleteListingSettings;
        private final UnaryCallSettings.Builder<SubscribeListingRequest, SubscribeListingResponse> subscribeListingSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listDataExchangesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DATA_EXCHANGES_PAGE_STR_FACT);
            this.listOrgDataExchangesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ORG_DATA_EXCHANGES_PAGE_STR_FACT);
            this.getDataExchangeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDataExchangeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDataExchangeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDataExchangeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listListingsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LISTINGS_PAGE_STR_FACT);
            this.getListingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createListingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateListingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteListingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.subscribeListingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listDataExchangesSettings, this.listOrgDataExchangesSettings, this.getDataExchangeSettings, this.createDataExchangeSettings, this.updateDataExchangeSettings, this.deleteDataExchangeSettings, this.listListingsSettings, this.getListingSettings, this.createListingSettings, this.updateListingSettings, this.deleteListingSettings, this.subscribeListingSettings, (Object[])new UnaryCallSettings.Builder[]{this.getIamPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(AnalyticsHubServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listDataExchangesSettings = settings.listDataExchangesSettings.toBuilder();
            this.listOrgDataExchangesSettings = settings.listOrgDataExchangesSettings.toBuilder();
            this.getDataExchangeSettings = settings.getDataExchangeSettings.toBuilder();
            this.createDataExchangeSettings = settings.createDataExchangeSettings.toBuilder();
            this.updateDataExchangeSettings = settings.updateDataExchangeSettings.toBuilder();
            this.deleteDataExchangeSettings = settings.deleteDataExchangeSettings.toBuilder();
            this.listListingsSettings = settings.listListingsSettings.toBuilder();
            this.getListingSettings = settings.getListingSettings.toBuilder();
            this.createListingSettings = settings.createListingSettings.toBuilder();
            this.updateListingSettings = settings.updateListingSettings.toBuilder();
            this.deleteListingSettings = settings.deleteListingSettings.toBuilder();
            this.subscribeListingSettings = settings.subscribeListingSettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listDataExchangesSettings, this.listOrgDataExchangesSettings, this.getDataExchangeSettings, this.createDataExchangeSettings, this.updateDataExchangeSettings, this.deleteDataExchangeSettings, this.listListingsSettings, this.getListingSettings, this.createListingSettings, this.updateListingSettings, this.deleteListingSettings, this.subscribeListingSettings, (Object[])new UnaryCallSettings.Builder[]{this.getIamPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AnalyticsHubServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AnalyticsHubServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AnalyticsHubServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(AnalyticsHubServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(AnalyticsHubServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)AnalyticsHubServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)AnalyticsHubServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AnalyticsHubServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(AnalyticsHubServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(AnalyticsHubServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listDataExchangesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listOrgDataExchangesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getDataExchangeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createDataExchangeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateDataExchangeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteDataExchangeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listListingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getListingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createListingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateListingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteListingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.subscribeListingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListDataExchangesRequest, ListDataExchangesResponse, AnalyticsHubServiceClient.ListDataExchangesPagedResponse> listDataExchangesSettings() {
            return this.listDataExchangesSettings;
        }

        public PagedCallSettings.Builder<ListOrgDataExchangesRequest, ListOrgDataExchangesResponse, AnalyticsHubServiceClient.ListOrgDataExchangesPagedResponse> listOrgDataExchangesSettings() {
            return this.listOrgDataExchangesSettings;
        }

        public UnaryCallSettings.Builder<GetDataExchangeRequest, DataExchange> getDataExchangeSettings() {
            return this.getDataExchangeSettings;
        }

        public UnaryCallSettings.Builder<CreateDataExchangeRequest, DataExchange> createDataExchangeSettings() {
            return this.createDataExchangeSettings;
        }

        public UnaryCallSettings.Builder<UpdateDataExchangeRequest, DataExchange> updateDataExchangeSettings() {
            return this.updateDataExchangeSettings;
        }

        public UnaryCallSettings.Builder<DeleteDataExchangeRequest, Empty> deleteDataExchangeSettings() {
            return this.deleteDataExchangeSettings;
        }

        public PagedCallSettings.Builder<ListListingsRequest, ListListingsResponse, AnalyticsHubServiceClient.ListListingsPagedResponse> listListingsSettings() {
            return this.listListingsSettings;
        }

        public UnaryCallSettings.Builder<GetListingRequest, Listing> getListingSettings() {
            return this.getListingSettings;
        }

        public UnaryCallSettings.Builder<CreateListingRequest, Listing> createListingSettings() {
            return this.createListingSettings;
        }

        public UnaryCallSettings.Builder<UpdateListingRequest, Listing> updateListingSettings() {
            return this.updateListingSettings;
        }

        public UnaryCallSettings.Builder<DeleteListingRequest, Empty> deleteListingSettings() {
            return this.deleteListingSettings;
        }

        public UnaryCallSettings.Builder<SubscribeListingRequest, SubscribeListingResponse> subscribeListingSettings() {
            return this.subscribeListingSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public AnalyticsHubServiceStubSettings build() throws IOException {
            return new AnalyticsHubServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

